/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.servlet.ReadListener;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.MockConnector;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.thread.Scheduler;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class HttpInputAsyncStateTest {
    private static final Queue<String> __history = new LinkedBlockingQueue<String>();
    private ByteBuffer _expected = BufferUtil.allocate((int)16384);
    private boolean _eof;
    private boolean _noReadInDataAvailable;
    private boolean _completeInOnDataAvailable;
    private final ReadListener _listener = new ReadListener(){

        public void onError(Throwable t) {
            __history.add("onError:" + t);
        }

        public void onDataAvailable() throws IOException {
            __history.add("onDataAvailable");
            if (!HttpInputAsyncStateTest.this._noReadInDataAvailable && HttpInputAsyncStateTest.this.readAvailable() && HttpInputAsyncStateTest.this._completeInOnDataAvailable) {
                __history.add("complete");
                HttpInputAsyncStateTest.this._state.complete();
            }
        }

        public void onAllDataRead() throws IOException {
            __history.add("onAllDataRead");
        }
    };
    private HttpInput _in;
    HttpChannelState _state;

    @BeforeEach
    public void before() {
        this._noReadInDataAvailable = false;
        this._in = new HttpInput(new HttpChannelState(new HttpChannel((Connector)new MockConnector(), new HttpConfiguration(), null, null){

            public void onAsyncWaitForContent() {
                __history.add("onAsyncWaitForContent");
            }

            public Scheduler getScheduler() {
                return null;
            }
        }){

            public void onReadUnready() {
                super.onReadUnready();
                __history.add("onReadUnready");
            }

            public boolean onContentAdded() {
                boolean wake = super.onContentAdded();
                __history.add("onReadPossible " + wake);
                return wake;
            }

            public boolean onReadReady() {
                boolean wake = super.onReadReady();
                __history.add("onReadReady " + wake);
                return wake;
            }
        }){

            public void wake() {
                __history.add("wake");
            }
        };
        this._state = this._in.getHttpChannelState();
        __history.clear();
    }

    private void check(String ... history) {
        if (history == null || history.length == 0) {
            MatcherAssert.assertThat(__history, (Matcher)Matchers.empty());
        } else {
            MatcherAssert.assertThat((Object)__history.toArray(new String[__history.size()]), (Matcher)Matchers.arrayContaining((Object[])history));
        }
        __history.clear();
    }

    private void wake() {
        this.handle(null);
    }

    private void handle() {
        this.handle(null);
    }

    private void handle(Runnable run) {
        HttpChannelState.Action action = this._state.handling();
        block7: while (true) {
            switch (action) {
                case DISPATCH: {
                    if (run == null) {
                        Assertions.fail((String)"Run is null during DISPATCH");
                    }
                    run.run();
                    break;
                }
                case READ_CALLBACK: {
                    this._in.run();
                    break;
                }
                case TERMINATED: 
                case WAIT: {
                    break block7;
                }
                case COMPLETE: {
                    __history.add("COMPLETE");
                    break;
                }
                case READ_REGISTER: {
                    this._state.getHttpChannel().onAsyncWaitForContent();
                    break;
                }
                default: {
                    Assertions.fail((String)("Bad Action: " + action));
                }
            }
            action = this._state.unhandle();
        }
    }

    private void deliver(HttpInput.Content ... content) {
        if (content != null) {
            for (HttpInput.Content c : content) {
                if (c == HttpInput.EOF_CONTENT) {
                    this._in.eof();
                    this._eof = true;
                    continue;
                }
                if (c == HttpInput.EARLY_EOF_CONTENT) {
                    this._in.earlyEOF();
                    this._eof = true;
                    continue;
                }
                this._in.addContent(c);
                BufferUtil.append((ByteBuffer)this._expected, (ByteBuffer)c.getByteBuffer().slice());
            }
        }
    }

    boolean readAvailable() throws IOException {
        int len = 0;
        try {
            while (this._in.isReady()) {
                int b = this._in.read();
                if (b < 0) {
                    if (len > 0) {
                        __history.add("read " + len);
                    }
                    __history.add("read -1");
                    Assertions.assertTrue((boolean)BufferUtil.isEmpty((ByteBuffer)this._expected));
                    Assertions.assertTrue((boolean)this._eof);
                    return true;
                }
                ++len;
                Assertions.assertFalse((boolean)BufferUtil.isEmpty((ByteBuffer)this._expected));
                int a = 0xFF & this._expected.get();
                MatcherAssert.assertThat((Object)b, (Matcher)Matchers.equalTo((Object)a));
            }
            __history.add("read " + len);
            Assertions.assertTrue((boolean)BufferUtil.isEmpty((ByteBuffer)this._expected));
        }
        catch (IOException e) {
            if (len > 0) {
                __history.add("read " + len);
            }
            __history.add("read " + e);
            throw e;
        }
        return false;
    }

    @AfterEach
    public void after() {
        MatcherAssert.assertThat((Object)__history.poll(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testInitialEmptyListenInHandle() throws Exception {
        this.deliver(HttpInput.EOF_CONTENT);
        this.check(new String[0]);
        this.handle(() -> {
            this._state.startAsync(null);
            this._in.setReadListener(this._listener);
            this.check("onReadReady false");
        });
        this.check("onAllDataRead");
    }

    @Test
    public void testInitialEmptyListenAfterHandle() throws Exception {
        this.deliver(HttpInput.EOF_CONTENT);
        this.handle(() -> {
            this._state.startAsync(null);
            this.check(new String[0]);
        });
        this._in.setReadListener(this._listener);
        this.check("onReadReady true", "wake");
        this.wake();
        this.check("onAllDataRead");
    }

    @Test
    public void testListenInHandleEmpty() throws Exception {
        this.handle(() -> {
            this._state.startAsync(null);
            this._in.setReadListener(this._listener);
            this.check("onReadUnready");
        });
        this.check("onAsyncWaitForContent");
        this.deliver(HttpInput.EOF_CONTENT);
        this.check("onReadPossible true");
        this.handle();
        this.check("onAllDataRead");
    }

    @Test
    public void testEmptyListenAfterHandle() throws Exception {
        this.handle(() -> {
            this._state.startAsync(null);
            this.check(new String[0]);
        });
        this.deliver(HttpInput.EOF_CONTENT);
        this.check(new String[0]);
        this._in.setReadListener(this._listener);
        this.check("onReadReady true", "wake");
        this.wake();
        this.check("onAllDataRead");
    }

    @Test
    public void testListenAfterHandleEmpty() throws Exception {
        this.handle(() -> {
            this._state.startAsync(null);
            this.check(new String[0]);
        });
        this._in.setReadListener(this._listener);
        this.check("onAsyncWaitForContent", "onReadUnready");
        this.deliver(HttpInput.EOF_CONTENT);
        this.check("onReadPossible true");
        this.handle();
        this.check("onAllDataRead");
    }

    @Test
    public void testInitialEarlyEOFListenInHandle() throws Exception {
        this.deliver(HttpInput.EARLY_EOF_CONTENT);
        this.check(new String[0]);
        this.handle(() -> {
            this._state.startAsync(null);
            this._in.setReadListener(this._listener);
            this.check("onReadReady false");
        });
        this.check("onError:org.eclipse.jetty.io.EofException: Early EOF");
    }

    @Test
    public void testInitialEarlyEOFListenAfterHandle() throws Exception {
        this.deliver(HttpInput.EARLY_EOF_CONTENT);
        this.handle(() -> {
            this._state.startAsync(null);
            this.check(new String[0]);
        });
        this._in.setReadListener(this._listener);
        this.check("onReadReady true", "wake");
        this.wake();
        this.check("onError:org.eclipse.jetty.io.EofException: Early EOF");
    }

    @Test
    public void testListenInHandleEarlyEOF() throws Exception {
        this.handle(() -> {
            this._state.startAsync(null);
            this._in.setReadListener(this._listener);
            this.check("onReadUnready");
        });
        this.check("onAsyncWaitForContent");
        this.deliver(HttpInput.EARLY_EOF_CONTENT);
        this.check("onReadPossible true");
        this.handle();
        this.check("onError:org.eclipse.jetty.io.EofException: Early EOF");
    }

    @Test
    public void testEarlyEOFListenAfterHandle() throws Exception {
        this.handle(() -> {
            this._state.startAsync(null);
            this.check(new String[0]);
        });
        this.deliver(HttpInput.EARLY_EOF_CONTENT);
        this.check(new String[0]);
        this._in.setReadListener(this._listener);
        this.check("onReadReady true", "wake");
        this.wake();
        this.check("onError:org.eclipse.jetty.io.EofException: Early EOF");
    }

    @Test
    public void testListenAfterHandleEarlyEOF() throws Exception {
        this.handle(() -> {
            this._state.startAsync(null);
            this.check(new String[0]);
        });
        this._in.setReadListener(this._listener);
        this.check("onAsyncWaitForContent", "onReadUnready");
        this.deliver(HttpInput.EARLY_EOF_CONTENT);
        this.check("onReadPossible true");
        this.handle();
        this.check("onError:org.eclipse.jetty.io.EofException: Early EOF");
    }

    @Test
    public void testInitialAllContentListenInHandle() throws Exception {
        this.deliver(new TContent("Hello"), HttpInput.EOF_CONTENT);
        this.check(new String[0]);
        this.handle(() -> {
            this._state.startAsync(null);
            this._in.setReadListener(this._listener);
            this.check("onReadReady false");
        });
        this.check("onDataAvailable", "read 5", "read -1", "onAllDataRead");
    }

    @Test
    public void testInitialAllContentListenAfterHandle() throws Exception {
        this.deliver(new TContent("Hello"), HttpInput.EOF_CONTENT);
        this.handle(() -> {
            this._state.startAsync(null);
            this.check(new String[0]);
        });
        this._in.setReadListener(this._listener);
        this.check("onReadReady true", "wake");
        this.wake();
        this.check("onDataAvailable", "read 5", "read -1", "onAllDataRead");
    }

    @Test
    public void testListenInHandleAllContent() throws Exception {
        this.handle(() -> {
            this._state.startAsync(null);
            this._in.setReadListener(this._listener);
            this.check("onReadUnready");
        });
        this.check("onAsyncWaitForContent");
        this.deliver(new TContent("Hello"), HttpInput.EOF_CONTENT);
        this.check("onReadPossible true", "onReadPossible false");
        this.handle();
        this.check("onDataAvailable", "read 5", "read -1", "onAllDataRead");
    }

    @Test
    public void testAllContentListenAfterHandle() throws Exception {
        this.handle(() -> {
            this._state.startAsync(null);
            this.check(new String[0]);
        });
        this.deliver(new TContent("Hello"), HttpInput.EOF_CONTENT);
        this.check(new String[0]);
        this._in.setReadListener(this._listener);
        this.check("onReadReady true", "wake");
        this.wake();
        this.check("onDataAvailable", "read 5", "read -1", "onAllDataRead");
    }

    @Test
    public void testListenAfterHandleAllContent() throws Exception {
        this.handle(() -> {
            this._state.startAsync(null);
            this.check(new String[0]);
        });
        this._in.setReadListener(this._listener);
        this.check("onAsyncWaitForContent", "onReadUnready");
        this.deliver(new TContent("Hello"), HttpInput.EOF_CONTENT);
        this.check("onReadPossible true", "onReadPossible false");
        this.handle();
        this.check("onDataAvailable", "read 5", "read -1", "onAllDataRead");
    }

    @Test
    public void testInitialIncompleteContentListenInHandle() throws Exception {
        this.deliver(new TContent("Hello"), HttpInput.EARLY_EOF_CONTENT);
        this.check(new String[0]);
        this.handle(() -> {
            this._state.startAsync(null);
            this._in.setReadListener(this._listener);
            this.check("onReadReady false");
        });
        this.check("onDataAvailable", "read 5", "read org.eclipse.jetty.io.EofException: Early EOF", "onError:org.eclipse.jetty.io.EofException: Early EOF");
    }

    @Test
    public void testInitialPartialContentListenAfterHandle() throws Exception {
        this.deliver(new TContent("Hello"), HttpInput.EARLY_EOF_CONTENT);
        this.handle(() -> {
            this._state.startAsync(null);
            this.check(new String[0]);
        });
        this._in.setReadListener(this._listener);
        this.check("onReadReady true", "wake");
        this.wake();
        this.check("onDataAvailable", "read 5", "read org.eclipse.jetty.io.EofException: Early EOF", "onError:org.eclipse.jetty.io.EofException: Early EOF");
    }

    @Test
    public void testListenInHandlePartialContent() throws Exception {
        this.handle(() -> {
            this._state.startAsync(null);
            this._in.setReadListener(this._listener);
            this.check("onReadUnready");
        });
        this.check("onAsyncWaitForContent");
        this.deliver(new TContent("Hello"), HttpInput.EARLY_EOF_CONTENT);
        this.check("onReadPossible true", "onReadPossible false");
        this.handle();
        this.check("onDataAvailable", "read 5", "read org.eclipse.jetty.io.EofException: Early EOF", "onError:org.eclipse.jetty.io.EofException: Early EOF");
    }

    @Test
    public void testPartialContentListenAfterHandle() throws Exception {
        this.handle(() -> {
            this._state.startAsync(null);
            this.check(new String[0]);
        });
        this.deliver(new TContent("Hello"), HttpInput.EARLY_EOF_CONTENT);
        this.check(new String[0]);
        this._in.setReadListener(this._listener);
        this.check("onReadReady true", "wake");
        this.wake();
        this.check("onDataAvailable", "read 5", "read org.eclipse.jetty.io.EofException: Early EOF", "onError:org.eclipse.jetty.io.EofException: Early EOF");
    }

    @Test
    public void testListenAfterHandlePartialContent() throws Exception {
        this.handle(() -> {
            this._state.startAsync(null);
            this.check(new String[0]);
        });
        this._in.setReadListener(this._listener);
        this.check("onAsyncWaitForContent", "onReadUnready");
        this.deliver(new TContent("Hello"), HttpInput.EARLY_EOF_CONTENT);
        this.check("onReadPossible true", "onReadPossible false");
        this.handle();
        this.check("onDataAvailable", "read 5", "read org.eclipse.jetty.io.EofException: Early EOF", "onError:org.eclipse.jetty.io.EofException: Early EOF");
    }

    @Test
    public void testReadAfterOnDataAvailable() throws Exception {
        this._noReadInDataAvailable = true;
        this.handle(() -> {
            this._state.startAsync(null);
            this._in.setReadListener(this._listener);
            this.check("onReadUnready");
        });
        this.check("onAsyncWaitForContent");
        this.deliver(new TContent("Hello"), HttpInput.EOF_CONTENT);
        this.check("onReadPossible true", "onReadPossible false");
        this.handle();
        this.check("onDataAvailable");
        this.readAvailable();
        this.check("wake", "read 5", "read -1");
        this.wake();
        this.check("onAllDataRead");
    }

    @Test
    public void testReadOnlyExpectedAfterOnDataAvailable() throws Exception {
        this._noReadInDataAvailable = true;
        this.handle(() -> {
            this._state.startAsync(null);
            this._in.setReadListener(this._listener);
            this.check("onReadUnready");
        });
        this.check("onAsyncWaitForContent");
        this.deliver(new TContent("Hello"), HttpInput.EOF_CONTENT);
        this.check("onReadPossible true", "onReadPossible false");
        this.handle();
        this.check("onDataAvailable");
        byte[] buffer = new byte[this._expected.remaining()];
        MatcherAssert.assertThat((Object)this._in.read(buffer), (Matcher)Matchers.equalTo((Object)buffer.length));
        MatcherAssert.assertThat((Object)new String(buffer), (Matcher)Matchers.equalTo((Object)BufferUtil.toString((ByteBuffer)this._expected)));
        BufferUtil.clear((ByteBuffer)this._expected);
        this.check(new String[0]);
        Assertions.assertTrue((boolean)this._in.isReady());
        this.check(new String[0]);
        MatcherAssert.assertThat((Object)this._in.read(), (Matcher)Matchers.equalTo((Object)-1));
        this.check("wake");
        this.wake();
        this.check("onAllDataRead");
    }

    @Test
    public void testReadAndCompleteInOnDataAvailable() throws Exception {
        this._completeInOnDataAvailable = true;
        this.handle(() -> {
            this._state.startAsync(null);
            this._in.setReadListener(this._listener);
            this.check("onReadUnready");
        });
        this.check("onAsyncWaitForContent");
        this.deliver(new TContent("Hello"), HttpInput.EOF_CONTENT);
        this.check("onReadPossible true", "onReadPossible false");
        this.handle(() -> __history.add(this._state.getState().toString()));
        System.err.println(__history);
        this.check("onDataAvailable", "read 5", "read -1", "complete", "COMPLETE");
    }

    public static class TContent
    extends HttpInput.Content {
        public TContent(String content) {
            super(BufferUtil.toBuffer((String)content));
        }
    }
}

