/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.stream.Stream;
import javax.servlet.http.Cookie;
import org.eclipse.jetty.http.CookieCompliance;
import org.eclipse.jetty.server.CookieCutter;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class CookieCutterLenientTest {
    public static Stream<Arguments> data() {
        return Stream.of(Arguments.of((Object[])new Object[]{"key=value", "key", "value"}), Arguments.of((Object[])new Object[]{"abc=xyz", "abc", "xyz"}), Arguments.of((Object[])new Object[]{"abc=!bar", "abc", "!bar"}), Arguments.of((Object[])new Object[]{"abc=#hash", "abc", "#hash"}), Arguments.of((Object[])new Object[]{"abc=#hash", "abc", "#hash"}), Arguments.of((Object[])new Object[]{"\"a\"=bcd", null, null}), Arguments.of((Object[])new Object[]{"\"a\"=\"b c d\"", null, null}), Arguments.of((Object[])new Object[]{"abc=", "abc", ""}), Arguments.of((Object[])new Object[]{"abc = ", "abc", ""}), Arguments.of((Object[])new Object[]{"abc = ;", "abc", ""}), Arguments.of((Object[])new Object[]{"abc = ; ", "abc", ""}), Arguments.of((Object[])new Object[]{"abc = x ", "abc", "x"}), Arguments.of((Object[])new Object[]{"abc = e f g ", "abc", "e f g"}), Arguments.of((Object[])new Object[]{"abc=\"\"", "abc", ""}), Arguments.of((Object[])new Object[]{"abc= \"\" ", "abc", ""}), Arguments.of((Object[])new Object[]{"abc= \"x\" ", "abc", "x"}), Arguments.of((Object[])new Object[]{"abc= \"x\" ;", "abc", "x"}), Arguments.of((Object[])new Object[]{"abc= \"x\" ; ", "abc", "x"}), Arguments.of((Object[])new Object[]{"abc=\"xyz\"", "abc", "xyz"}), Arguments.of((Object[])new Object[]{"abc=\"!bar\"", "abc", "!bar"}), Arguments.of((Object[])new Object[]{"abc=\"#hash\"", "abc", "#hash"}), Arguments.of((Object[])new Object[]{"!f!o!o!=wat", "!f!o!o!", "wat"}), Arguments.of((Object[])new Object[]{"__MyHost=Foo", "__MyHost", "Foo"}), Arguments.of((Object[])new Object[]{"some-thing-else=to-parse", "some-thing-else", "to-parse"}), Arguments.of((Object[])new Object[]{"$foo=bar", null, null}), Arguments.of((Object[])new Object[]{"abc=foobar!", "abc", "foobar!"}), Arguments.of((Object[])new Object[]{"abc=\"foobar!\"", "abc", "foobar!"}), Arguments.of((Object[])new Object[]{"foo=bar\"baz", "foo", "bar\"baz"}), Arguments.of((Object[])new Object[]{"foo=\"bar\"baz\"", "foo", "bar\"baz"}), Arguments.of((Object[])new Object[]{"foo=\"bar\"-\"baz\"", "foo", "bar\"-\"baz"}), Arguments.of((Object[])new Object[]{"foo=\"bar'-\"baz\"", "foo", "bar'-\"baz"}), Arguments.of((Object[])new Object[]{"foo=\"bar''-\"baz\"", "foo", "bar''-\"baz"}), Arguments.of((Object[])new Object[]{"foo=\"bar\"=\"baz\"", "foo", "bar\"=\"baz"}), Arguments.of((Object[])new Object[]{"query=\"?b=c\"&\"d=e\"", "query", "?b=c\"&\"d=e"}), Arguments.of((Object[])new Object[]{"foo=\"bar\\\"=\\\"baz\"", "foo", "bar\"=\"baz"}), Arguments.of((Object[])new Object[]{"x=\"abc", "x", "\"abc"}), Arguments.of((Object[])new Object[]{"x=\"abc $Path=/", "x", "\"abc $Path=/"}), Arguments.of((Object[])new Object[]{"x=\"abc\\", "x", "\"abc\\"}), Arguments.of((Object[])new Object[]{"2sides=\u262f", null, null}), Arguments.of((Object[])new Object[]{"currency=\"\u20ac\"", "currency", "\u20ac"}), Arguments.of((Object[])new Object[]{"gothic=\"\ud800\udf48\"", "gothic", "\ud800\udf48"}), Arguments.of((Object[])new Object[]{"foo=bar baz", "foo", "bar baz"}), Arguments.of((Object[])new Object[]{"foo=\"bar baz\"", "foo", "bar baz"}), Arguments.of((Object[])new Object[]{"z=a b c d e f g", "z", "a b c d e f g"}), Arguments.of((Object[])new Object[]{"foo=bar;baz", "foo", "bar"}), Arguments.of((Object[])new Object[]{"foo=\"bar;baz\"", "foo", "bar;baz"}), Arguments.of((Object[])new Object[]{"z=a;b,c:d;e/f[g]", "z", "a"}), Arguments.of((Object[])new Object[]{"z=\"a;b,c:d;e/f[g]\"", "z", "a;b,c:d;e/f[g]"}), Arguments.of((Object[])new Object[]{"name=quoted=\"\\\"badly\\\"\"", "name", "quoted=\"\\\"badly\\\"\""}), Arguments.of((Object[])new Object[]{"x=\"$Version=0\"", "x", "$Version=0"}), Arguments.of((Object[])new Object[]{"x=\"$Path=/\"", "x", "$Path=/"}), Arguments.of((Object[])new Object[]{"x=\"$Path=/ $Domain=.foo.com\"", "x", "$Path=/ $Domain=.foo.com"}), Arguments.of((Object[])new Object[]{"x=\" $Path=/ $Domain=.foo.com \"", "x", " $Path=/ $Domain=.foo.com "}), Arguments.of((Object[])new Object[]{"a=\"b; $Path=/a; c=d; $PATH=/c; e=f\"; $Path=/e/", "a", "b; $Path=/a; c=d; $PATH=/c; e=f"}), Arguments.of((Object[])new Object[]{"query=b=c&d=e", "query", "b=c&d=e"}), Arguments.of((Object[])new Object[]{"query=%7B%22sessionCount%22%3A5%2C%22sessionTime%22%3A14151%7D", "query", "%7B%22sessionCount%22%3A5%2C%22sessionTime%22%3A14151%7D"}), Arguments.of((Object[])new Object[]{"GAPS=1:A1aaaAaAA1aaAAAaa1a11a:aAaaAa-aaA1-", "GAPS", "1:A1aaaAaAA1aaAAAaa1a11a:aAaaAa-aaA1-"}), Arguments.of((Object[])new Object[]{"$Version=0; rToken=F_TOKEN''!--\"</a>=&{()}", "rToken", "F_TOKEN''!--\"</a>=&{()}"}), Arguments.of((Object[])new Object[]{"name=foo,bar", "name", "foo,bar"}), Arguments.of((Object[])new Object[]{"name=foo , bar", "name", "foo , bar"}), Arguments.of((Object[])new Object[]{"name=foo , bar, bob", "name", "foo , bar, bob"}));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLenientBehavior(String rawHeader, String expectedName, String expectedValue) {
        CookieCutter cutter = new CookieCutter(CookieCompliance.RFC6265_LEGACY);
        cutter.addCookieField(rawHeader);
        Cookie[] cookies = cutter.getCookies();
        if (expectedName == null) {
            MatcherAssert.assertThat((String)"Cookies.length", (Object)cookies.length, (Matcher)Matchers.is((Object)0));
        } else {
            MatcherAssert.assertThat((String)"Cookies.length", (Object)cookies.length, (Matcher)Matchers.is((Object)1));
            MatcherAssert.assertThat((String)"Cookie.name", (Object)cookies[0].getName(), (Matcher)Matchers.is((Object)expectedName));
            MatcherAssert.assertThat((String)"Cookie.value", (Object)cookies[0].getValue(), (Matcher)Matchers.is((Object)expectedValue));
        }
    }
}

