/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.compression.NBitIntegerDecoder;
import org.eclipse.jetty.http.compression.NBitIntegerEncoder;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NBitIntegerTest {
    private final NBitIntegerDecoder _decoder = new NBitIntegerDecoder();

    @Test
    public void testOctetsNeeded() {
        Assertions.assertEquals((int)1, (int)NBitIntegerEncoder.octetsNeeded((int)5, (long)10L));
        Assertions.assertEquals((int)3, (int)NBitIntegerEncoder.octetsNeeded((int)5, (long)1337L));
        Assertions.assertEquals((int)1, (int)NBitIntegerEncoder.octetsNeeded((int)8, (long)42L));
        Assertions.assertEquals((int)3, (int)NBitIntegerEncoder.octetsNeeded((int)8, (long)1337L));
        Assertions.assertEquals((int)1, (int)NBitIntegerEncoder.octetsNeeded((int)6, (long)62L));
        Assertions.assertEquals((int)2, (int)NBitIntegerEncoder.octetsNeeded((int)6, (long)63L));
        Assertions.assertEquals((int)2, (int)NBitIntegerEncoder.octetsNeeded((int)6, (long)64L));
        Assertions.assertEquals((int)3, (int)NBitIntegerEncoder.octetsNeeded((int)6, (long)191L));
        Assertions.assertEquals((int)4, (int)NBitIntegerEncoder.octetsNeeded((int)6, (long)16447L));
        Assertions.assertEquals((int)5, (int)NBitIntegerEncoder.octetsNeeded((int)6, (long)2097215L));
    }

    @Test
    public void testEncode() {
        this.testEncode(6, 0, "00");
        this.testEncode(6, 1, "01");
        this.testEncode(6, 62, "3e");
        this.testEncode(6, 63, "3f00");
        this.testEncode(6, 64, "3f01");
        this.testEncode(6, 189, "3f7e");
        this.testEncode(6, 190, "3f7f");
        this.testEncode(6, 191, "3f8001");
        this.testEncode(6, 192, "3f8101");
        this.testEncode(6, 318, "3fFf01");
        this.testEncode(6, 319, "3f8002");
        this.testEncode(6, 320, "3f8102");
        this.testEncode(6, 16446, "3fFf7f");
        this.testEncode(6, 16447, "3f808001");
        this.testEncode(6, 2080958, "3fFf807f");
        this.testEncode(6, 2097215, "3f80808001");
        this.testEncode(8, 0, "00");
        this.testEncode(8, 1, "01");
        this.testEncode(8, 128, "80");
        this.testEncode(8, 254, "Fe");
        this.testEncode(8, 255, "Ff00");
        this.testEncode(8, 256, "Ff01");
        this.testEncode(8, 381, "Ff7e");
        this.testEncode(8, 382, "Ff7f");
        this.testEncode(8, 383, "Ff8001");
        this.testEncode(8, 16639, "Ff808001");
    }

    public void testEncode(int n, int i, String expected) {
        ByteBuffer buf = BufferUtil.allocate((int)16);
        int p = BufferUtil.flipToFill((ByteBuffer)buf);
        if (n < 8) {
            buf.put((byte)0);
        }
        NBitIntegerEncoder.encode((ByteBuffer)buf, (int)n, (long)i);
        BufferUtil.flipToFlush((ByteBuffer)buf, (int)p);
        String r = TypeUtil.toHexString((byte[])BufferUtil.toArray((ByteBuffer)buf));
        Assertions.assertEquals((Object)expected, (Object)r);
        Assertions.assertEquals((int)(expected.length() / 2), (int)NBitIntegerEncoder.octetsNeeded((int)n, (long)i));
    }

    @Test
    public void testDecode() {
        this.testDecode(6, 0, "00");
        this.testDecode(6, 1, "01");
        this.testDecode(6, 62, "3e");
        this.testDecode(6, 63, "3f00");
        this.testDecode(6, 64, "3f01");
        this.testDecode(6, 189, "3f7e");
        this.testDecode(6, 190, "3f7f");
        this.testDecode(6, 191, "3f8001");
        this.testDecode(6, 192, "3f8101");
        this.testDecode(6, 318, "3fFf01");
        this.testDecode(6, 319, "3f8002");
        this.testDecode(6, 320, "3f8102");
        this.testDecode(6, 16446, "3fFf7f");
        this.testDecode(6, 16447, "3f808001");
        this.testDecode(6, 2080958, "3fFf807f");
        this.testDecode(6, 2097215, "3f80808001");
        this.testDecode(8, 0, "00");
        this.testDecode(8, 1, "01");
        this.testDecode(8, 128, "80");
        this.testDecode(8, 254, "Fe");
        this.testDecode(8, 255, "Ff00");
        this.testDecode(8, 256, "Ff01");
        this.testDecode(8, 381, "Ff7e");
        this.testDecode(8, 382, "Ff7f");
        this.testDecode(8, 383, "Ff8001");
        this.testDecode(8, 16639, "Ff808001");
    }

    public void testDecode(int n, int expected, String encoded) {
        ByteBuffer buf = ByteBuffer.wrap(TypeUtil.fromHexString((String)encoded));
        this._decoder.setPrefix(n);
        Assertions.assertEquals((int)expected, (int)this._decoder.decodeInt(buf));
    }

    @Test
    public void testEncodeExampleD11() {
        ByteBuffer buf = BufferUtil.allocate((int)16);
        int p = BufferUtil.flipToFill((ByteBuffer)buf);
        buf.put((byte)119);
        buf.put((byte)-1);
        NBitIntegerEncoder.encode((ByteBuffer)buf, (int)5, (long)10L);
        BufferUtil.flipToFlush((ByteBuffer)buf, (int)p);
        String r = TypeUtil.toHexString((byte[])BufferUtil.toArray((ByteBuffer)buf));
        Assertions.assertEquals((Object)"77Ea", (Object)r);
    }

    @Test
    public void testDecodeExampleD11() {
        ByteBuffer buf = ByteBuffer.wrap(TypeUtil.fromHexString((String)"77EaFF"));
        buf.position(1);
        this._decoder.setPrefix(5);
        Assertions.assertEquals((int)10, (int)this._decoder.decodeInt(buf));
    }

    @Test
    public void testEncodeExampleD12() {
        ByteBuffer buf = BufferUtil.allocate((int)16);
        int p = BufferUtil.flipToFill((ByteBuffer)buf);
        buf.put((byte)-120);
        buf.put((byte)0);
        NBitIntegerEncoder.encode((ByteBuffer)buf, (int)5, (long)1337L);
        BufferUtil.flipToFlush((ByteBuffer)buf, (int)p);
        String r = TypeUtil.toHexString((byte[])BufferUtil.toArray((ByteBuffer)buf));
        Assertions.assertEquals((Object)"881f9a0a", (Object)r);
    }

    @Test
    public void testDecodeExampleD12() {
        ByteBuffer buf = ByteBuffer.wrap(TypeUtil.fromHexString((String)"881f9a0aff"));
        buf.position(1);
        this._decoder.setPrefix(5);
        Assertions.assertEquals((int)1337, (int)this._decoder.decodeInt(buf));
    }

    @Test
    public void testEncodeExampleD13() {
        ByteBuffer buf = BufferUtil.allocate((int)16);
        int p = BufferUtil.flipToFill((ByteBuffer)buf);
        buf.put((byte)-120);
        buf.put((byte)-1);
        NBitIntegerEncoder.encode((ByteBuffer)buf, (int)8, (long)42L);
        BufferUtil.flipToFlush((ByteBuffer)buf, (int)p);
        String r = TypeUtil.toHexString((byte[])BufferUtil.toArray((ByteBuffer)buf));
        Assertions.assertEquals((Object)"88Ff2a", (Object)r);
    }

    @Test
    public void testDecodeExampleD13() {
        ByteBuffer buf = ByteBuffer.wrap(TypeUtil.fromHexString((String)"882aFf"));
        buf.position(1);
        this._decoder.setPrefix(8);
        Assertions.assertEquals((int)42, (int)this._decoder.decodeInt(buf));
    }
}

