/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.Iterator;
import java.util.List;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;

public class InExpression
extends BooleanExpression {
    boolean negated = false;
    SQLExpression expr;
    SQLExpression[] exprs;

    public InExpression(SQLExpression expr, SQLExpression[] exprs) {
        super(expr.getSQLStatement(), expr.getSQLStatement().getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false));
        this.expr = expr;
        this.exprs = exprs;
        this.setStatement();
    }

    public InExpression(SQLExpression expr, List<SQLExpression> exprList) {
        super(expr.getSQLStatement(), expr.getSQLStatement().getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false));
        this.expr = expr;
        this.exprs = new SQLExpression[exprList.size()];
        Iterator<SQLExpression> exprListIter = exprList.iterator();
        int i = 0;
        while (exprListIter.hasNext()) {
            this.exprs[i++] = exprListIter.next();
        }
        this.setStatement();
    }

    @Override
    public BooleanExpression not() {
        this.negated = !this.negated;
        this.setStatement();
        return this;
    }

    protected void setStatement() {
        this.st.clearStatement();
        this.st.append(this.expr);
        if (this.negated) {
            this.st.append(" NOT");
        }
        this.st.append(" IN(");
        for (int i = 0; i < this.exprs.length; ++i) {
            if (i > 0) {
                this.st.append(",");
            }
            this.st.append(this.exprs[i]);
        }
        this.st.append(")");
    }
}

