/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.autostart;

import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.DatastoreInitialisationException;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.autostart.AbstractAutoStartMechanism;
import org.datanucleus.util.Localiser;

public class ClassesAutoStarter
extends AbstractAutoStartMechanism {
    protected String classNames;

    public ClassesAutoStarter(StoreManager storeMgr, ClassLoaderResolver clr) {
        this.classNames = storeMgr.getStringProperty("datanucleus.autoStartClassNames");
    }

    @Override
    public Collection<StoreData> getAllClassData() throws DatastoreInitialisationException {
        HashSet<StoreData> classes = new HashSet<StoreData>();
        if (this.classNames == null) {
            return classes;
        }
        StringTokenizer tokeniser = new StringTokenizer(this.classNames, ",");
        while (tokeniser.hasMoreTokens()) {
            classes.add(new StoreData(tokeniser.nextToken().trim(), null, StoreData.Type.FCO, null));
        }
        return classes;
    }

    @Override
    public void addClass(StoreData data) {
    }

    @Override
    public void deleteClass(String className) {
    }

    @Override
    public void deleteAllClasses() {
    }

    @Override
    public String getStorageDescription() {
        return Localiser.msg("034100");
    }
}

