/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.schema.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.schema.table.BasicColumn;
import org.datanucleus.store.schema.table.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompleteClassTable
implements Table {
    StoreManager storeMgr;
    AbstractClassMetaData cmd;
    String identifier;
    Map<AbstractMemberMetaData, BasicColumn> columnByMember = new HashMap<AbstractMemberMetaData, BasicColumn>();
    Map<Integer, BasicColumn> columnByPosition = new HashMap<Integer, BasicColumn>();

    public CompleteClassTable(StoreManager storeMgr, AbstractClassMetaData cmd) {
        BasicColumn col;
        ColumnMetaData colmd;
        BasicColumn col2;
        this.storeMgr = storeMgr;
        this.cmd = cmd;
        this.identifier = cmd.getTable() != null ? cmd.getTable() : storeMgr.getNamingFactory().getTableName(cmd);
        ArrayList<BasicColumn> columns = new ArrayList<BasicColumn>();
        ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        int numMembers = cmd.getAllMemberPositions().length;
        for (int i = 0; i < numMembers; ++i) {
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(i);
            RelationType relationType = mmd.getRelationType(clr);
            if (relationType == RelationType.NONE) {
                this.processBasicMember(columns, mmd);
                continue;
            }
            if (mmd.isEmbedded()) {
                this.processEmbeddedMember(columns, mmd, clr);
                continue;
            }
            this.processBasicMember(columns, mmd);
        }
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            ColumnMetaData colmd2 = cmd.getIdentityMetaData().getColumnMetaData();
            if (colmd2 == null || colmd2.getName() == null) {
                colmd2 = colmd2 != null ? new ColumnMetaData(colmd2) : new ColumnMetaData();
                colmd2.setName(storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DATASTOREID_COLUMN));
            }
            col2 = new BasicColumn(this, storeMgr, colmd2);
            columns.add(col2);
        }
        if (cmd.isVersioned()) {
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            colmd = vermd.getColumnMetaData();
            if (colmd == null || colmd.getName() == null) {
                colmd = colmd != null ? new ColumnMetaData(colmd) : new ColumnMetaData();
                colmd.setName(storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.VERSION_COLUMN));
            }
            col = new BasicColumn(this, storeMgr, colmd);
            columns.add(col);
        }
        if (cmd.hasDiscriminatorStrategy()) {
            DiscriminatorMetaData dismd = cmd.getDiscriminatorMetaDataRoot();
            colmd = dismd.getColumnMetaData();
            if (colmd == null || cmd.getDiscriminatorColumnName() == null) {
                colmd = colmd != null ? new ColumnMetaData(colmd) : new ColumnMetaData();
                colmd.setName(storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DISCRIMINATOR_COLUMN));
            }
            col = new BasicColumn(this, storeMgr, colmd);
            columns.add(col);
        }
        if (storeMgr.getStringProperty("datanucleus.TenantID") != null && !"true".equalsIgnoreCase(cmd.getValueForExtension("multitenancy-disable"))) {
            ColumnMetaData colmd3 = new ColumnMetaData();
            colmd3.setName(storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.MULTITENANCY_COLUMN));
            col2 = new BasicColumn(this, storeMgr, colmd3);
            columns.add(col2);
        }
        int numCols = columns.size();
        Iterator colIter = columns.iterator();
        while (colIter.hasNext()) {
            col = (BasicColumn)colIter.next();
            ColumnMetaData colmd4 = col.getColumnMetaData();
            Integer pos = colmd4.getPosition();
            if (pos == null) continue;
            if (this.columnByPosition.containsKey(pos)) {
                BasicColumn col22 = this.columnByPosition.get(pos);
                throw new NucleusUserException("Table " + this.identifier + " has column " + col.getIdentifier() + " specified to have column position " + pos + " yet that position is also defined for column " + col22.identifier);
            }
            if (pos >= numCols) {
                throw new NucleusUserException("Table " + this.identifier + " has column " + col.getIdentifier() + " specified to have position " + pos + " yet the number of columns is " + numCols + "." + " Column positions should be from 0 and have no gaps");
            }
            this.columnByPosition.put(colmd4.getPosition(), col);
            colIter.remove();
        }
        if (!columns.isEmpty()) {
            int pos = 0;
            for (BasicColumn col3 : columns) {
                while (this.columnByPosition.containsKey(pos)) {
                    ++pos;
                }
                this.columnByPosition.put(pos, col3);
            }
        }
    }

    protected void processBasicMember(List<BasicColumn> cols, AbstractMemberMetaData mmd) {
        ColumnMetaData colmd = null;
        ColumnMetaData[] colmds = mmd.getColumnMetaData();
        if (colmds == null || colmds.length == 0) {
            colmd = new ColumnMetaData();
        } else {
            if (colmds.length > 1) {
                throw new NucleusUserException("Dont currently support member having more than 1 column");
            }
            colmd = colmds[0];
        }
        if (colmd.getName() == null) {
            colmd.setName(this.storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN, 0));
        }
        BasicColumn col = new BasicColumn(this, this.storeMgr, colmd);
        col.setMemberMetaData(mmd);
        cols.add(col);
        this.columnByMember.put(mmd, col);
    }

    protected void processEmbeddedMember(List<BasicColumn> cols, AbstractMemberMetaData ownerMmd, ClassLoaderResolver clr) {
        EmbeddedMetaData emd = ownerMmd.getEmbeddedMetaData();
        AbstractClassMetaData embCmd = this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(ownerMmd.getType(), clr);
        AbstractMemberMetaData[] embMmds = emd.getMemberMetaData();
        for (int i = 0; i < embMmds.length; ++i) {
            AbstractMemberMetaData mmd = embCmd.getMetaDataForMember(embMmds[i].getName());
            if (embMmds[i].getEmbeddedMetaData() == null) {
                this.processBasicMember(cols, embMmds[i]);
                continue;
            }
            RelationType relationType = mmd.getRelationType(clr);
            if (RelationType.isRelationSingleValued(relationType)) {
                this.processEmbeddedMember(cols, mmd, clr);
                continue;
            }
            throw new NucleusUserException("Dont currently support embedded collections for this datastore");
        }
    }

    @Override
    public AbstractClassMetaData getClassMetaData() {
        return this.cmd;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public int getNumberOfColumns() {
        return this.columnByPosition.size();
    }

    @Override
    public BasicColumn getColumnForPosition(int pos) {
        return this.columnByPosition.get(pos);
    }

    @Override
    public BasicColumn getColumnForMember(AbstractMemberMetaData mmd) {
        return this.columnByMember.get(mmd);
    }
}

