/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.mingw;

import java.io.File;
import org.codehaus.mojo.natives.EnvFactory;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.compiler.AbstractResourceCompiler;
import org.codehaus.mojo.natives.compiler.ResourceCompiler;
import org.codehaus.mojo.natives.compiler.ResourceCompilerConfiguration;
import org.codehaus.mojo.natives.util.EnvUtil;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.cli.Commandline;

@Component(role=ResourceCompiler.class, hint="mingw", instantiationStrategy="per-lookup")
public final class WindresResourceCompiler
extends AbstractResourceCompiler {
    protected Commandline getCommandLine(ResourceCompilerConfiguration config, File source) throws NativeBuildException {
        String includePath;
        int i;
        Commandline cl = new Commandline();
        EnvUtil.setupCommandlineEnv((Commandline)cl, (EnvFactory)config.getEnvFactory());
        if (config.getWorkingDirectory() != null) {
            cl.setWorkingDirectory(config.getWorkingDirectory().getPath());
        }
        if (config.getExecutable() == null || config.getExecutable().trim().length() == 0) {
            config.setExecutable("windres.exe");
        }
        cl.setExecutable(config.getExecutable().trim());
        cl.addArguments(config.getOptions());
        for (i = 0; i < config.getIncludePaths().length; ++i) {
            includePath = config.getIncludePaths()[i].getPath();
            cl.createArg().setValue("-I");
            cl.createArg().setValue(includePath);
        }
        for (i = 0; i < config.getSystemIncludePaths().length; ++i) {
            includePath = config.getSystemIncludePaths()[i].getPath();
            cl.createArg().setValue("-I");
            cl.createArg().setValue(includePath);
        }
        cl.createArg().setValue("-O");
        cl.createArg().setValue("coff");
        cl.createArg().setValue("-o");
        cl.createArg().setValue(config.getOutputFile(source).getPath());
        cl.createArg().setValue(source.getPath());
        return cl;
    }
}

