/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.mingw;

import java.io.File;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.compiler.AbstractCompiler;
import org.codehaus.mojo.natives.compiler.CompilerConfiguration;
import org.codehaus.mojo.natives.parser.CParser;
import org.codehaus.mojo.natives.parser.Parser;
import org.codehaus.plexus.util.cli.Commandline;

public abstract class AbstractGccCompiler
extends AbstractCompiler {
    private Parser parser = new CParser();

    protected abstract String getOutputFileOption();

    protected Parser getParser() {
        return this.parser;
    }

    protected Commandline getCommandLine(File srcFile, File destFile, CompilerConfiguration config) throws NativeBuildException {
        if (config.getExecutable() == null) {
            config.setExecutable("gcc");
        }
        Commandline cl = new Commandline();
        cl.setExecutable(config.getExecutable());
        if (config.getWorkingDirectory() != null) {
            cl.setWorkingDirectory(config.getWorkingDirectory().getPath());
        }
        this.setStartOptions(cl, config);
        this.setIncludePaths(cl, config.getIncludePaths());
        this.setIncludePaths(cl, config.getSystemIncludePaths());
        this.setMiddleOptions(cl, config);
        this.setOutputArgs(cl, destFile);
        this.setSourceArgs(cl, srcFile);
        this.setEndOptions(cl, config);
        return cl;
    }

    private void setOptions(Commandline cl, String[] options) {
        if (options != null) {
            for (int i = 0; i < options.length; ++i) {
                cl.createArg().setValue(options[i]);
            }
        }
    }

    private void setStartOptions(Commandline cl, CompilerConfiguration config) {
        this.setOptions(cl, config.getStartOptions());
    }

    private void setMiddleOptions(Commandline cl, CompilerConfiguration config) {
        this.setOptions(cl, config.getMiddleOptions());
    }

    private void setEndOptions(Commandline cl, CompilerConfiguration config) {
        this.setOptions(cl, config.getEndOptions());
    }

    private void setIncludePaths(Commandline cl, File[] includePaths) {
        if (includePaths != null) {
            for (int i = 0; i < includePaths.length; ++i) {
                cl.createArg().setValue("-I" + includePaths[i].getPath());
            }
        }
    }

    private void setOutputArgs(Commandline cl, File outputFile) {
        String outputFileOption = this.getOutputFileOption();
        if (outputFileOption.endsWith(" ")) {
            cl.createArg().setValue(outputFileOption.trim());
            cl.createArg().setValue(outputFile.getPath());
        } else {
            cl.createArg().setValue(outputFileOption + outputFile.getPath());
        }
    }

    private void setSourceArgs(Commandline cl, File srcFile) {
        cl.createArg().setValue("-c");
        cl.createArg().setValue(srcFile.getPath());
    }
}

