/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.sparql;

import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.sparql.JenaInterpreter;
import org.apache.zeppelin.sparql.SparqlEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparqlInterpreter
extends Interpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SparqlInterpreter.class);
    public static final String SPARQL_ENGINE_TYPE = "sparql.engine";
    public static final String SPARQL_SERVICE_ENDPOINT = "sparql.endpoint";
    public static final String SPARQL_REPLACE_URIS = "sparql.replaceURIs";
    public static final String SPARQL_REMOVE_DATATYPES = "sparql.removeDatatypes";
    public static final String ENGINE_TYPE_JENA = "jena";
    public SparqlEngine engine;

    public SparqlInterpreter(Properties properties) {
        super(properties);
    }

    public void open() {
        LOGGER.info("Properties: {}", (Object)this.getProperties());
        String serviceEndpoint = this.getProperty(SPARQL_SERVICE_ENDPOINT);
        boolean replaceURIs = this.getProperty(SPARQL_REPLACE_URIS) != null && this.getProperty(SPARQL_REPLACE_URIS).equals("true");
        boolean removeDatatypes = this.getProperty(SPARQL_REMOVE_DATATYPES) != null && this.getProperty(SPARQL_REMOVE_DATATYPES).equals("true");
        String engineType = this.getProperty(SPARQL_ENGINE_TYPE);
        if (SparqlEngineType.JENA.toString().equals(engineType)) {
            this.engine = new JenaInterpreter(serviceEndpoint, replaceURIs, removeDatatypes);
        }
    }

    public void close() {
        this.engine.close();
    }

    public InterpreterResult interpret(String query, InterpreterContext context) {
        if (StringUtils.isEmpty((CharSequence)query) || StringUtils.isEmpty((CharSequence)query.trim())) {
            return new InterpreterResult(InterpreterResult.Code.SUCCESS);
        }
        return this.engine.query(query);
    }

    public void cancel(InterpreterContext context) {
        this.engine.cancel();
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.SIMPLE;
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }

    public static enum SparqlEngineType {
        JENA{

            public String toString() {
                return SparqlInterpreter.ENGINE_TYPE_JENA;
            }
        };

    }
}

