/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.python;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jodah.concurrentunit.Waiter;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.LazyOpenInterpreter;
import org.apache.zeppelin.python.BasePythonInterpreterTest;
import org.apache.zeppelin.python.PythonInterpreter;
import org.junit.Assert;
import org.junit.Test;

public class PythonInterpreterTest
extends BasePythonInterpreterTest {
    @Override
    public void setUp() throws InterpreterException {
        this.intpGroup = new InterpreterGroup();
        Properties properties = new Properties();
        properties.setProperty("zeppelin.python.maxResult", "3");
        properties.setProperty("zeppelin.python.useIPython", "false");
        properties.setProperty("zeppelin.python.gatewayserver_address", "127.0.0.1");
        this.interpreter = new LazyOpenInterpreter((Interpreter)new PythonInterpreter(properties));
        this.intpGroup.put("note", new LinkedList());
        this.intpGroup.get("note").add(this.interpreter);
        this.interpreter.setInterpreterGroup(this.intpGroup);
        InterpreterContext.set((InterpreterContext)this.getInterpreterContext());
        this.interpreter.open();
    }

    @Override
    public void tearDown() throws InterpreterException {
        this.intpGroup.close();
    }

    @Override
    public void testCodeCompletion() throws InterpreterException, IOException, InterruptedException {
        super.testCodeCompletion();
    }

    public void testCancelIntp() throws InterruptedException, InterpreterException {
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)this.interpreter.interpret("a = 1\n", this.getInterpreterContext()).code());
        Thread t = new Thread(new infinityPythonJob());
        t.start();
        Thread.sleep(5000L);
        this.interpreter.cancel(this.getInterpreterContext());
        Assert.assertTrue((boolean)t.isAlive());
        t.join(2000L);
        Assert.assertFalse((boolean)t.isAlive());
    }

    @Test
    public void testPythonProcessKilled() throws InterruptedException, TimeoutException {
        final Waiter waiter = new Waiter();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    InterpreterResult result = PythonInterpreterTest.this.interpreter.interpret("import time\ntime.sleep(1000)", PythonInterpreterTest.this.getInterpreterContext());
                    waiter.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)result.code());
                    waiter.assertEquals((Object)"Python process is abnormally exited, please check your code and log.", (Object)((InterpreterResultMessage)result.message().get(0)).getData());
                }
                catch (InterpreterException e) {
                    waiter.fail("Should not throw exception\n" + ExceptionUtils.getStackTrace((Throwable)e));
                }
                waiter.resume();
            }
        };
        thread.start();
        Thread.sleep(3000L);
        PythonInterpreter pythonInterpreter = (PythonInterpreter)((LazyOpenInterpreter)this.interpreter).getInnerInterpreter();
        pythonInterpreter.getPythonProcessLauncher().stop();
        waiter.await(3000L);
    }

    @Test
    public void testFailtoLaunchPythonProcess() throws InterpreterException {
        this.tearDown();
        this.intpGroup = new InterpreterGroup();
        Properties properties = new Properties();
        properties.setProperty("zeppelin.python", "invalid_python");
        properties.setProperty("zeppelin.python.useIPython", "false");
        properties.setProperty("zeppelin.python.gatewayserver_address", "127.0.0.1");
        this.interpreter = new LazyOpenInterpreter((Interpreter)new PythonInterpreter(properties));
        this.intpGroup.put("note", new LinkedList());
        this.intpGroup.get("note").add(this.interpreter);
        this.interpreter.setInterpreterGroup(this.intpGroup);
        InterpreterContext.set((InterpreterContext)this.getInterpreterContext());
        try {
            this.interpreter.interpret("1+1", this.getInterpreterContext());
            Assert.fail((String)"Should fail to open PythonInterpreter");
        }
        catch (InterpreterException e) {
            String stacktrace = ExceptionUtils.getStackTrace((Throwable)e);
            Assert.assertTrue((String)stacktrace, (boolean)stacktrace.contains("No such file or directory"));
        }
    }

    private class infinityPythonJob
    implements Runnable {
        private infinityPythonJob() {
        }

        @Override
        public void run() {
            String code = "import time\nwhile True:\n  time.sleep(1)";
            InterpreterResult ret = null;
            try {
                ret = PythonInterpreterTest.this.interpreter.interpret(code, PythonInterpreterTest.this.getInterpreterContext());
            }
            catch (InterpreterException e) {
                e.printStackTrace();
            }
            Assert.assertNotNull(ret);
            Pattern expectedMessage = Pattern.compile("KeyboardInterrupt");
            Matcher m = expectedMessage.matcher(ret.message().toString());
            Assert.assertTrue((boolean)m.find());
        }
    }
}

