/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.python;

import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import net.jodah.concurrentunit.ConcurrentTestCase;
import org.apache.zeppelin.display.ui.CheckBox;
import org.apache.zeppelin.display.ui.Password;
import org.apache.zeppelin.display.ui.Select;
import org.apache.zeppelin.display.ui.TextBox;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterEventClient;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.python.IPythonInterpreter;
import org.apache.zeppelin.python.PythonInterpreter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;

public abstract class BasePythonInterpreterTest
extends ConcurrentTestCase {
    protected InterpreterGroup intpGroup;
    protected Interpreter interpreter;
    protected boolean isPython2;

    @Before
    public abstract void setUp() throws InterpreterException;

    @After
    public abstract void tearDown() throws InterpreterException;

    @Test
    public void testPythonBasics() throws InterpreterException, InterruptedException, IOException {
        InterpreterContext context = this.getInterpreterContext();
        InterpreterResult result = this.interpreter.interpret("import sys\nprint(sys.version[0])", context);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        Thread.sleep(100L);
        List interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)1L, (long)interpreterResultMessages.size());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("'hello world'", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)1L, (long)interpreterResultMessages.size());
        Assert.assertEquals((Object)"'hello world'", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData().trim());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("print(u'\u4f60\u597d')", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)1L, (long)interpreterResultMessages.size());
        Assert.assertEquals((Object)"\u4f60\u597d\n", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("'hello world'\n'hello world2'", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)1L, (long)interpreterResultMessages.size());
        Assert.assertEquals((Object)"'hello world2'", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData().trim());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("print('hello world')", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)1L, (long)interpreterResultMessages.size());
        Assert.assertEquals((Object)"hello world\n", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("print('hello world')\nprint('hello world2')", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)1L, (long)interpreterResultMessages.size());
        Assert.assertEquals((Object)"hello world\nhello world2\n", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("abc=1", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)0L, (long)interpreterResultMessages.size());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("if abc > 0:\n\tprint('True')\nelse:\n\tprint('False')", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)1L, (long)interpreterResultMessages.size());
        Assert.assertEquals((Object)"True\n", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("for i in range(3):\n\tprint(i)", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)1L, (long)interpreterResultMessages.size());
        Assert.assertEquals((Object)"0\n1\n2\n", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("print(unknown)", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)result.code());
        if (this.interpreter instanceof IPythonInterpreter) {
            interpreterResultMessages = context.out.toInterpreterResultMessage();
            Assert.assertEquals((long)1L, (long)interpreterResultMessages.size());
            TestCase.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData().contains("name 'unknown' is not defined"));
        } else if (this.interpreter instanceof PythonInterpreter) {
            TestCase.assertTrue((boolean)((InterpreterResultMessage)result.message().get(0)).getData().contains("name 'unknown' is not defined"));
        }
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("1/0", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)result.code());
        if (this.interpreter instanceof IPythonInterpreter) {
            interpreterResultMessages = context.out.toInterpreterResultMessage();
            Assert.assertEquals((long)1L, (long)interpreterResultMessages.size());
            TestCase.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData().contains("ZeroDivisionError"));
        } else if (this.interpreter instanceof PythonInterpreter) {
            TestCase.assertTrue((boolean)((InterpreterResultMessage)result.message().get(0)).getData().contains("ZeroDivisionError"));
        }
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("from __future__ import print_function\ndef greet(name):\n    print('Hello', name)\ngreet('Jack')", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)1L, (long)interpreterResultMessages.size());
        Assert.assertEquals((Object)"Hello Jack\n", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("print('there is no Error: ok')", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)1L, (long)interpreterResultMessages.size());
        Assert.assertEquals((Object)"there is no Error: ok\n", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("# print('Hello')", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)0L, (long)interpreterResultMessages.size());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("# print('Hello')\n# print('How are u?')\n# time.sleep(1)", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)0L, (long)interpreterResultMessages.size());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("for i in range(1,4):\n\tprint(i)", context);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)1L, (long)interpreterResultMessages.size());
        Assert.assertEquals((Object)"1\n2\n3\n", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData());
    }

    @Test
    public void testCodeCompletion() throws InterpreterException, IOException, InterruptedException {
        InterpreterContext context = this.getInterpreterContext();
        String st = "a='hello'";
        InterpreterResult result = this.interpreter.interpret(st, context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        context = this.getInterpreterContext();
        st = "a.";
        List completions = this.interpreter.completion(st, st.length(), context);
        TestCase.assertTrue((completions.size() > 20 ? 1 : 0) != 0);
        context = this.getInterpreterContext();
        st = "a.co";
        completions = this.interpreter.completion(st, st.length(), context);
        Assert.assertEquals((long)1L, (long)completions.size());
        Assert.assertEquals((Object)"count", (Object)((InterpreterCompletion)completions.get(0)).getValue());
        context = this.getInterpreterContext();
        st = "a.co\b='hello";
        completions = this.interpreter.completion(st, 4, context);
        Assert.assertEquals((long)1L, (long)completions.size());
        Assert.assertEquals((Object)"count", (Object)((InterpreterCompletion)completions.get(0)).getValue());
    }

    @Test
    public void testZeppelinContext() throws InterpreterException, InterruptedException, IOException {
        InterpreterContext context = this.getInterpreterContext();
        InterpreterResult result = this.interpreter.interpret("z.input(name='text_1', defaultValue='value_1')", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        List interpreterResultMessages = context.out.toInterpreterResultMessage();
        TestCase.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData().contains("'value_1'"));
        Assert.assertEquals((long)1L, (long)context.getGui().getForms().size());
        TestCase.assertTrue((boolean)(context.getGui().getForms().get("text_1") instanceof TextBox));
        TextBox textbox = (TextBox)context.getGui().getForms().get("text_1");
        Assert.assertEquals((Object)"text_1", (Object)textbox.getName());
        Assert.assertEquals((Object)"value_1", (Object)textbox.getDefaultValue());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("z.password(name='pwd_1')", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        TestCase.assertTrue((boolean)(context.getGui().getForms().get("pwd_1") instanceof Password));
        Password password = (Password)context.getGui().getForms().get("pwd_1");
        Assert.assertEquals((Object)"pwd_1", (Object)password.getName());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("z.select(name='select_1', options=[('value_1', 'name_1'), ('value_2', 'name_2')])", context);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        Assert.assertEquals((long)1L, (long)context.getGui().getForms().size());
        TestCase.assertTrue((boolean)(context.getGui().getForms().get("select_1") instanceof Select));
        Select select = (Select)context.getGui().getForms().get("select_1");
        Assert.assertEquals((Object)"select_1", (Object)select.getName());
        Assert.assertEquals((long)2L, (long)select.getOptions().length);
        Assert.assertEquals((Object)"name_1", (Object)select.getOptions()[0].getDisplayName());
        Assert.assertEquals((Object)"value_1", (Object)select.getOptions()[0].getValue());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("z.checkbox(name='checkbox_1',options=[('value_1', 'name_1'), ('value_2', 'name_2')])", context);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        Assert.assertEquals((long)1L, (long)context.getGui().getForms().size());
        TestCase.assertTrue((boolean)(context.getGui().getForms().get("checkbox_1") instanceof CheckBox));
        CheckBox checkbox = (CheckBox)context.getGui().getForms().get("checkbox_1");
        Assert.assertEquals((Object)"checkbox_1", (Object)checkbox.getName());
        Assert.assertEquals((long)2L, (long)checkbox.getOptions().length);
        Assert.assertEquals((Object)"name_1", (Object)checkbox.getOptions()[0].getDisplayName());
        Assert.assertEquals((Object)"value_1", (Object)checkbox.getOptions()[0].getValue());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("import pandas as pd\ndf = pd.DataFrame({'id':[1,2,3], 'name':['a\ta','b\\nb','c\\r\\nc']})\nz.show(df)", context);
        Assert.assertEquals((String)context.out.toInterpreterResultMessage().toString(), (Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)1L, (long)interpreterResultMessages.size());
        Assert.assertEquals((Object)InterpreterResult.Type.TABLE, (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getType());
        Assert.assertEquals((Object)"id\tname\n1\ta a\n2\tb b\n3\tc c\n", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("import pandas as pd\ndf = pd.DataFrame({'id':[1,2,3,4], 'name':['a','b','c', 'd']})\nz.show(df)", context);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)2L, (long)interpreterResultMessages.size());
        Assert.assertEquals((Object)InterpreterResult.Type.TABLE, (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getType());
        Assert.assertEquals((Object)"id\tname\n1\ta\n2\tb\n3\tc\n", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData());
        Assert.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)interpreterResultMessages.get(1)).getType());
        Assert.assertEquals((Object)"<font color=red>Results are limited by 3.</font>\n", (Object)((InterpreterResultMessage)interpreterResultMessages.get(1)).getData());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("import pandas as pd\ndf = pd.DataFrame({'id':[1,2,3], 'name':['a','b','c']})\nz.show(df, show_index=True)", context);
        Assert.assertEquals((String)context.out.toInterpreterResultMessage().toString(), (Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)1L, (long)interpreterResultMessages.size());
        Assert.assertEquals((Object)InterpreterResult.Type.TABLE, (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getType());
        Assert.assertEquals((Object)"\tid\tname\n%html <strong>0</strong>\t1\ta\n%html <strong>1</strong>\t2\tb\n%html <strong>2</strong>\t3\tc\n", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("import matplotlib.pyplot as plt\ndata=[1,1,2,3,4]\nplt.figure()\nplt.plot(data)\nz.show(plt)", context);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)1L, (long)interpreterResultMessages.size());
        Assert.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getType());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("import time\nprint(\"Hello\")\ntime.sleep(0.5)\nz.getInterpreterContext().out().clear()\nprint(\"world\")\n", context);
        Assert.assertEquals((Object)"%text world\n", (Object)context.out.getCurrentOutput().toString());
    }

    @Ignore(value="Flaky test, need to investigate why it fails")
    public void testRedefinitionZeppelinContext() throws InterpreterException {
        String redefinitionCode = "z = 1\n";
        String restoreCode = "z = __zeppelin__\n";
        String validCode = "z.input(\"test\")\n";
        InterpreterContext context = this.getInterpreterContext();
        InterpreterResult result = this.interpreter.interpret(validCode, context);
        Assert.assertEquals((String)(context.out.toString() + ", " + result.toString()), (Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret(redefinitionCode, context);
        Assert.assertEquals((String)(context.out.toString() + ", " + result.toString()), (Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret(validCode, context);
        Assert.assertEquals((String)(context.out.toString() + ", " + result.toString()), (Object)InterpreterResult.Code.ERROR, (Object)result.code());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret(restoreCode, context);
        Assert.assertEquals((String)(context.out.toString() + ", " + result.toString()), (Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("type(__zeppelin__)", context);
        System.out.println("result: " + context.out.toString() + ", " + result.toString());
        Assert.assertEquals((String)(context.out.toString() + ", " + result.toString()), (Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("type(z)", context);
        System.out.println("result2: " + context.out.toString() + ", " + result.toString());
        Assert.assertEquals((String)(context.out.toString() + ", " + result.toString()), (Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret(validCode, context);
        Assert.assertEquals((String)(context.out.toString() + ", " + result.toString()), (Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
    }

    protected InterpreterContext getInterpreterContext() {
        return InterpreterContext.builder().setNoteId("noteId").setParagraphId("paragraphId").setInterpreterOut(new InterpreterOutput()).setIntpEventClient((RemoteInterpreterEventClient)Mockito.mock(RemoteInterpreterEventClient.class)).build();
    }
}

