/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.lens;

import java.util.Map;
import org.apache.zeppelin.lens.LensSimpleExecutionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.shell.CommandLine;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.ExecutionStrategy;
import org.springframework.shell.core.JLineShell;
import org.springframework.shell.core.Parser;
import org.springframework.shell.core.SimpleParser;
import org.springframework.shell.plugin.BannerProvider;
import org.springframework.shell.plugin.HistoryFileNameProvider;
import org.springframework.shell.plugin.PluginUtils;
import org.springframework.shell.plugin.PromptProvider;

public class LensJLineShellComponent
extends JLineShell
implements SmartLifecycle,
ApplicationContextAware,
InitializingBean {
    @Autowired
    private CommandLine commandLine;
    private volatile boolean running = false;
    private Thread shellThread;
    private ApplicationContext applicationContext;
    private boolean printBanner = true;
    private String historyFileName;
    private String promptText;
    private String productName;
    private String banner;
    private String version;
    private String welcomeMessage;
    private ExecutionStrategy executionStrategy = new LensSimpleExecutionStrategy();
    private SimpleParser parser = new SimpleParser();
    private static final Logger LOGGER = LoggerFactory.getLogger(LensJLineShellComponent.class);

    public SimpleParser getSimpleParser() {
        return this.parser;
    }

    public boolean isAutoStartup() {
        return false;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public int getPhase() {
        return 1;
    }

    public void start() {
        this.customizePlugin();
        this.shellThread = new Thread((Runnable)((Object)this), "Spring Shell");
        this.shellThread.start();
        this.running = true;
    }

    public void stop() {
        if (this.running) {
            this.closeShell();
            this.running = false;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void afterPropertiesSet() {
        Map commands = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, CommandMarker.class);
        for (CommandMarker command : commands.values()) {
            this.getSimpleParser().add(command);
        }
        Map converters = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, Converter.class);
        for (Converter converter : converters.values()) {
            this.getSimpleParser().add(converter);
        }
        this.setHistorySize(this.commandLine.getHistorySize());
        if (this.commandLine.getShellCommandsToExecute() != null) {
            this.setPrintBanner(false);
        }
    }

    public void waitForComplete() {
        try {
            this.shellThread.join();
        }
        catch (InterruptedException e) {
            LOGGER.error(e.toString(), (Throwable)e);
        }
    }

    protected ExecutionStrategy getExecutionStrategy() {
        return this.executionStrategy;
    }

    protected Parser getParser() {
        return this.parser;
    }

    public String getStartupNotifications() {
        return null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void customizePlugin() {
        this.historyFileName = this.getHistoryFileName();
        this.promptText = this.getPromptText();
        String[] banner = this.getBannerText();
        this.banner = banner[0];
        this.welcomeMessage = banner[1];
        this.version = banner[2];
        this.productName = banner[3];
    }

    protected String getHistoryFileName() {
        HistoryFileNameProvider historyFileNameProvider = (HistoryFileNameProvider)PluginUtils.getHighestPriorityProvider((ApplicationContext)this.applicationContext, HistoryFileNameProvider.class);
        String providerHistoryFileName = historyFileNameProvider.getHistoryFileName();
        if (providerHistoryFileName != null) {
            return providerHistoryFileName;
        }
        return this.historyFileName;
    }

    protected String getPromptText() {
        PromptProvider promptProvider = (PromptProvider)PluginUtils.getHighestPriorityProvider((ApplicationContext)this.applicationContext, PromptProvider.class);
        String providerPromptText = promptProvider.getPrompt();
        if (providerPromptText != null) {
            return providerPromptText;
        }
        return this.promptText;
    }

    private String[] getBannerText() {
        String[] bannerText = new String[4];
        BannerProvider provider = (BannerProvider)PluginUtils.getHighestPriorityProvider((ApplicationContext)this.applicationContext, BannerProvider.class);
        bannerText[0] = provider.getBanner();
        bannerText[1] = provider.getWelcomeMessage();
        bannerText[2] = provider.getVersion();
        bannerText[3] = provider.getProviderName();
        return bannerText;
    }

    public void printBannerAndWelcome() {
        if (this.printBanner) {
            this.logger.info(this.banner);
            this.logger.info(this.getWelcomeMessage());
        }
    }

    public String getWelcomeMessage() {
        return this.welcomeMessage;
    }

    public void setPrintBanner(boolean printBanner) {
        this.printBanner = printBanner;
    }

    protected String getProductName() {
        return this.productName;
    }

    protected String getVersion() {
        return this.version;
    }
}

