/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.lens;

import java.io.ByteArrayOutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lens.cli.commands.BaseLensCommand;
import org.apache.lens.client.LensClient;
import org.apache.lens.client.LensClientConfig;
import org.apache.lens.client.LensClientSingletonWrapper;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.lens.ExecutionDetail;
import org.apache.zeppelin.lens.LensBootstrap;
import org.apache.zeppelin.lens.LensJLineShellComponent;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.shell.Bootstrap;
import org.springframework.shell.core.CommandResult;
import org.springframework.shell.core.JLineShell;
import org.springframework.shell.core.JLineShellComponent;
import org.springframework.shell.core.SimpleParser;
import org.springframework.shell.support.logging.HandlerUtils;

public class LensInterpreter
extends Interpreter {
    static final Logger LOGGER = LoggerFactory.getLogger(LensInterpreter.class);
    static final String LENS_CLIENT_DBNAME = "lens.client.dbname";
    static final String LENS_SERVER_URL = "lens.server.base.url";
    static final String LENS_SESSION_CLUSTER_USER = "lens.session.cluster.user";
    static final String LENS_PERSIST_RESULTSET = "lens.query.enable.persistent.resultset";
    static final String ZEPPELIN_LENS_RUN_CONCURRENT_SESSION = "zeppelin.lens.run.concurrent";
    static final String ZEPPELIN_LENS_CONCURRENT_SESSIONS = "zeppelin.lens.maxThreads";
    static final String ZEPPELIN_MAX_ROWS = "zeppelin.lens.maxResults";
    static final Map<String, Pattern> LENS_TABLE_FORMAT_REGEX = new LinkedHashMap<String, Pattern>(){
        {
            this.put("cubes", Pattern.compile(".*show\\s+cube.*"));
            this.put("nativetables", Pattern.compile(".*show\\s+nativetable.*"));
            this.put("storages", Pattern.compile(".*show\\s+storage.*"));
            this.put("facts", Pattern.compile(".*show\\s+fact.*"));
            this.put("dimensions", Pattern.compile(".*show\\s+dimension.*"));
            this.put("params", Pattern.compile(".*show\\s+param.*"));
            this.put("databases", Pattern.compile(".*show\\s+database.*"));
            this.put("query results", Pattern.compile(".*query\\s+results.*"));
        }
    };
    private static Pattern queryExecutePattern = Pattern.compile(".*query\\s+execute\\s+(.*)");
    private static Map<String, ExecutionDetail> paraToQH = new ConcurrentHashMap<String, ExecutionDetail>();
    private static Map<LensClient, Boolean> clientMap = new ConcurrentHashMap<LensClient, Boolean>();
    private int maxResults;
    private int maxThreads;
    private JLineShell jLineShell;
    private LensClientConfig lensClientConfig;
    private Bootstrap bootstrap;
    private LensClient lensClient;

    public LensInterpreter(Properties property) {
        super(property);
        try {
            this.lensClientConfig = new LensClientConfig();
            this.lensClientConfig.set(LENS_SERVER_URL, property.get(LENS_SERVER_URL).toString());
            this.lensClientConfig.set(LENS_CLIENT_DBNAME, property.get(LENS_CLIENT_DBNAME).toString());
            this.lensClientConfig.set(LENS_SESSION_CLUSTER_USER, property.get(LENS_SESSION_CLUSTER_USER).toString());
            this.lensClientConfig.set(LENS_PERSIST_RESULTSET, property.get(LENS_PERSIST_RESULTSET).toString());
            try {
                this.maxResults = Integer.parseInt(property.get(ZEPPELIN_MAX_ROWS).toString());
            }
            catch (NullPointerException | NumberFormatException e) {
                this.maxResults = 1000;
                LOGGER.error("unable to parse zeppelin.lens.maxResults :" + property.get(ZEPPELIN_MAX_ROWS), (Throwable)e);
            }
            try {
                this.maxThreads = Integer.parseInt(property.get(ZEPPELIN_LENS_CONCURRENT_SESSIONS).toString());
            }
            catch (NullPointerException | NumberFormatException e) {
                this.maxThreads = 10;
                LOGGER.error("unable to parse zeppelin.lens.maxThreads :" + property.get(ZEPPELIN_LENS_CONCURRENT_SESSIONS), (Throwable)e);
            }
            LOGGER.info("LensInterpreter created");
        }
        catch (Exception e) {
            LOGGER.error(e.toString(), (Throwable)e);
            LOGGER.error("unable to create lens interpreter", (Throwable)e);
        }
    }

    private Bootstrap createBootstrap() {
        return new LensBootstrap();
    }

    private JLineShell getJLineShell(Bootstrap bs) {
        if (bs instanceof LensBootstrap) {
            return ((LensBootstrap)bs).getLensJLineShellComponent();
        }
        return bs.getJLineShellComponent();
    }

    protected void init() {
        try {
            this.bootstrap = this.createBootstrap();
            this.jLineShell = this.getJLineShell(this.bootstrap);
        }
        catch (Exception ex) {
            LOGGER.error("could not initialize commandLine", (Throwable)ex);
        }
    }

    public void open() {
        LOGGER.info("LensInterpreter opening");
        this.lensClient = new LensClient(this.lensClientConfig);
        LensClientSingletonWrapper.instance().setClient(this.lensClient);
        this.init();
        LOGGER.info("LensInterpreter opened");
    }

    public void close() {
        LensInterpreter.closeConnections();
        LOGGER.info("LensInterpreter closed");
    }

    private static void closeConnections() {
        for (LensClient cl : clientMap.keySet()) {
            if (!cl.isConnectionOpen()) continue;
            LensInterpreter.closeLensClient(cl);
        }
    }

    private static void closeLensClient(LensClient lensClient) {
        try {
            lensClient.closeConnection();
        }
        catch (Exception e) {
            LOGGER.error("unable to close lensClient", (Throwable)e);
        }
    }

    private LensClient createAndSetLensClient(Bootstrap bs) {
        LensClient lensClient;
        try {
            lensClient = new LensClient(this.lensClientConfig);
            for (String beanName : bs.getApplicationContext().getBeanDefinitionNames()) {
                if (!(bs.getApplicationContext().getBean(beanName) instanceof BaseLensCommand)) continue;
                ((BaseLensCommand)bs.getApplicationContext().getBean(beanName)).setClient(lensClient);
            }
        }
        catch (Exception e) {
            LOGGER.error("unable to create lens client", (Throwable)e);
            throw e;
        }
        return lensClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InterpreterResult handleHelp(JLineShell shell, String st) {
        StreamHandler sh = null;
        java.util.logging.Logger springLogger = null;
        Formatter formatter = new Formatter(){

            @Override
            public String format(LogRecord record) {
                return record.getMessage();
            }
        };
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            sh = new StreamHandler(baos, formatter);
            springLogger = HandlerUtils.getLogger(SimpleParser.class);
            springLogger.addHandler(sh);
            shell.executeCommand(st);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            InterpreterResult interpreterResult = new InterpreterResult(InterpreterResult.Code.ERROR, e.getMessage());
            return interpreterResult;
        }
        finally {
            sh.flush();
            springLogger.removeHandler(sh);
            sh.close();
        }
        return new InterpreterResult(InterpreterResult.Code.SUCCESS, baos.toString());
    }

    private String modifyQueryStatement(String st) {
        Matcher matcher = queryExecutePattern.matcher(st.toLowerCase());
        if (!matcher.find()) {
            return st;
        }
        StringBuilder sb = new StringBuilder("query execute ");
        if (!st.toLowerCase().matches(".*--async\\s+true")) {
            sb.append("--async true ");
        }
        sb.append(matcher.group(1));
        if (!st.toLowerCase().matches(".*limit\\s+\\d+.*")) {
            sb.append(" limit ");
            sb.append(this.maxResults);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterpreterResult interpret(String input, InterpreterContext context) {
        CommandResult res;
        if (input == null || input.length() == 0) {
            return new InterpreterResult(InterpreterResult.Code.ERROR, "no command submitted");
        }
        String st = input.replaceAll("\\n", " ");
        LOGGER.info("LensInterpreter command: " + st);
        Bootstrap bs = this.createBootstrap();
        JLineShell shell = this.getJLineShell(bs);
        LensClient lensClient = null;
        String qh = null;
        if (st.trim().startsWith("help")) {
            return this.handleHelp(shell, st);
        }
        try {
            lensClient = this.createAndSetLensClient(bs);
            clientMap.put(lensClient, true);
            String lensCommand = this.modifyQueryStatement(st);
            LOGGER.info("executing command : " + lensCommand);
            res = shell.executeCommand(lensCommand);
            if (!lensCommand.equals(st) && res != null && res.getResult() != null && res.getResult().toString().trim().matches("[a-z0-9-]+")) {
                qh = res.getResult().toString();
                paraToQH.put(context.getParagraphId(), new ExecutionDetail(qh, lensClient, shell));
                String getResultsCmd = "query results --async false " + qh;
                LOGGER.info("executing query results command : " + context.getParagraphId() + " : " + getResultsCmd);
                res = shell.executeCommand(getResultsCmd);
                paraToQH.remove(context.getParagraphId());
            }
        }
        catch (Exception ex) {
            LOGGER.error("error in interpret", (Throwable)ex);
            InterpreterResult interpreterResult = new InterpreterResult(InterpreterResult.Code.ERROR, ex.getMessage());
            return interpreterResult;
        }
        finally {
            if (shell != null) {
                this.closeShell(shell);
            }
            if (lensClient != null) {
                LensInterpreter.closeLensClient(lensClient);
                clientMap.remove(lensClient);
            }
            if (qh != null) {
                paraToQH.remove(context.getParagraphId());
            }
        }
        return new InterpreterResult(InterpreterResult.Code.SUCCESS, this.formatResult(st, res));
    }

    private void closeShell(JLineShell shell) {
        if (shell instanceof LensJLineShellComponent) {
            ((LensJLineShellComponent)shell).stop();
        } else {
            ((JLineShellComponent)shell).stop();
        }
    }

    private String formatResult(String st, CommandResult result) {
        if (result == null) {
            return "error in interpret, no result object returned";
        }
        if (!result.isSuccess() || result.getResult() == null) {
            if (result.getException() != null) {
                return result.getException().getMessage();
            }
            return "error in interpret, unable to execute command";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Pattern> entry : LENS_TABLE_FORMAT_REGEX.entrySet()) {
            if (!entry.getValue().matcher(st.toLowerCase()).find()) continue;
            sb.append("%table " + entry.getKey() + " \n");
            break;
        }
        if (queryExecutePattern.matcher(st.toLowerCase()).find() && result.getResult().toString().contains(" rows process in (")) {
            sb.append("%table ");
        }
        if (sb.length() > 0) {
            return sb.append(result.getResult().toString()).toString();
        }
        return result.getResult().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(InterpreterContext context) {
        if (!paraToQH.containsKey(context.getParagraphId())) {
            LOGGER.error("ignoring cancel from " + context.getParagraphId());
            return;
        }
        String qh = paraToQH.get(context.getParagraphId()).getQueryHandle();
        LOGGER.info("preparing to cancel : (" + context.getParagraphId() + ") :" + qh);
        Bootstrap bs = this.createBootstrap();
        JLineShell shell = this.getJLineShell(bs);
        LensClient lensClient = null;
        try {
            lensClient = this.createAndSetLensClient(bs);
            clientMap.put(lensClient, true);
            LOGGER.info("invoke query kill (" + context.getParagraphId() + ") " + qh);
            CommandResult res = shell.executeCommand("query kill " + qh);
            LOGGER.info("query kill returned (" + context.getParagraphId() + ") " + qh + " with: " + res.getResult());
        }
        catch (Exception e) {
            LOGGER.error("unable to kill query (" + context.getParagraphId() + ") " + qh, (Throwable)e);
        }
        finally {
            try {
                if (lensClient != null) {
                    LensInterpreter.closeLensClient(lensClient);
                    clientMap.remove(lensClient);
                }
                LensInterpreter.closeLensClient(paraToQH.get(context.getParagraphId()).getLensClient());
                this.closeShell(paraToQH.get(context.getParagraphId()).getShell());
            }
            catch (Exception e) {
                LOGGER.info("Exception in LensInterpreter while cancel finally, ignore", (Throwable)e);
            }
            paraToQH.remove(context.getParagraphId());
            this.closeShell(shell);
        }
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.SIMPLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getProgress(InterpreterContext context) {
        if (paraToQH.containsKey(context.getParagraphId())) {
            int n;
            JLineShell shell;
            block14: {
                String qh;
                LensClient lensClient;
                block12: {
                    int n2;
                    block13: {
                        LOGGER.info("number of items for which progress can be reported :" + paraToQH.size());
                        LOGGER.info("number of open lensclient :" + clientMap.size());
                        Bootstrap bs = this.createBootstrap();
                        shell = this.getJLineShell(bs);
                        lensClient = null;
                        qh = paraToQH.get(context.getParagraphId()).getQueryHandle();
                        LOGGER.info("fetch query status for : (" + context.getParagraphId() + ") :" + qh);
                        lensClient = this.createAndSetLensClient(bs);
                        clientMap.put(lensClient, true);
                        CommandResult res = shell.executeCommand("query status " + qh);
                        LOGGER.info(context.getParagraphId() + " --> " + res.getResult().toString());
                        Pattern pattern = Pattern.compile(".*(Progress : (\\d\\.\\d)).*");
                        Matcher matcher = pattern.matcher(res.getResult().toString().replaceAll("\\n", " "));
                        if (!matcher.find(2)) break block12;
                        Double d = Double.parseDouble(matcher.group(2)) * 100.0;
                        if (d.intValue() == 100) {
                            paraToQH.remove(context.getParagraphId());
                        }
                        n2 = d.intValue();
                        if (lensClient == null) break block13;
                        LensInterpreter.closeLensClient(lensClient);
                        clientMap.remove(lensClient);
                    }
                    if (shell != null) {
                        this.closeShell(shell);
                    }
                    return n2;
                }
                try {
                    n = 1;
                    if (lensClient == null) break block14;
                }
                catch (Exception e) {
                    int n3;
                    block15: {
                        try {
                            LOGGER.error("unable to get progress for (" + context.getParagraphId() + ") :" + qh, (Throwable)e);
                            paraToQH.remove(context.getParagraphId());
                            n3 = 0;
                            if (lensClient == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (lensClient != null) {
                                LensInterpreter.closeLensClient(lensClient);
                                clientMap.remove(lensClient);
                            }
                            if (shell != null) {
                                this.closeShell(shell);
                            }
                            throw throwable;
                        }
                        LensInterpreter.closeLensClient(lensClient);
                        clientMap.remove(lensClient);
                    }
                    if (shell != null) {
                        this.closeShell(shell);
                    }
                    return n3;
                }
                LensInterpreter.closeLensClient(lensClient);
                clientMap.remove(lensClient);
            }
            if (shell != null) {
                this.closeShell(shell);
            }
            return n;
        }
        return 0;
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) {
        return null;
    }

    public boolean concurrentRequests() {
        return Boolean.parseBoolean(this.getProperty(ZEPPELIN_LENS_RUN_CONCURRENT_SESSION));
    }

    public Scheduler getScheduler() {
        if (this.concurrentRequests()) {
            return SchedulerFactory.singleton().createOrGetParallelScheduler(LensInterpreter.class.getName() + ((Object)((Object)this)).hashCode(), this.maxThreads);
        }
        return super.getScheduler();
    }
}

