/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.kylin;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.kylin.KylinErrorResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KylinInterpreter
extends Interpreter {
    Logger logger = LoggerFactory.getLogger(KylinInterpreter.class);
    static final String KYLIN_QUERY_API_URL = "kylin.api.url";
    static final String KYLIN_USERNAME = "kylin.api.user";
    static final String KYLIN_PASSWORD = "kylin.api.password";
    static final String KYLIN_QUERY_PROJECT = "kylin.query.project";
    static final String KYLIN_QUERY_OFFSET = "kylin.query.offset";
    static final String KYLIN_QUERY_LIMIT = "kylin.query.limit";
    static final String KYLIN_QUERY_ACCEPT_PARTIAL = "kylin.query.ispartial";
    static final Pattern KYLIN_TABLE_FORMAT_REGEX_LABEL = Pattern.compile("\"label\":\"(.*?)\"");
    static final Pattern KYLIN_TABLE_FORMAT_REGEX_RESULTS = Pattern.compile("\"results\":\\[\\[(.*?)]]");

    public KylinInterpreter(Properties property) {
        super(property);
    }

    public void open() {
    }

    public void close() {
    }

    public InterpreterResult interpret(String st, InterpreterContext context) {
        try {
            return this.executeQuery(st);
        }
        catch (IOException e) {
            this.logger.error("failed to query data in kylin ", (Throwable)e);
            return new InterpreterResult(InterpreterResult.Code.ERROR, e.getMessage());
        }
    }

    public void cancel(InterpreterContext context) {
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.SIMPLE;
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) {
        return null;
    }

    public HttpResponse prepareRequest(String sql) throws IOException {
        String kylinProject = this.getProject(sql);
        String kylinSql = this.getSQL(sql);
        this.logger.info("project:" + kylinProject);
        this.logger.info("sql:" + kylinSql);
        this.logger.info("acceptPartial:" + this.getProperty(KYLIN_QUERY_ACCEPT_PARTIAL));
        this.logger.info("limit:" + this.getProperty(KYLIN_QUERY_LIMIT));
        this.logger.info("offset:" + this.getProperty(KYLIN_QUERY_OFFSET));
        byte[] encodeBytes = Base64.encodeBase64((byte[])new String(this.getProperty(KYLIN_USERNAME) + ":" + this.getProperty(KYLIN_PASSWORD)).getBytes("UTF-8"));
        String postContent = new String("{\"project\":\"" + kylinProject + "\",\"sql\":\"" + kylinSql + "\",\"acceptPartial\":\"" + this.getProperty(KYLIN_QUERY_ACCEPT_PARTIAL) + "\",\"offset\":\"" + this.getProperty(KYLIN_QUERY_OFFSET) + "\",\"limit\":\"" + this.getProperty(KYLIN_QUERY_LIMIT) + "\"}");
        this.logger.info("post:" + postContent);
        postContent = postContent.replaceAll("[\u0000-\u001f]", " ");
        StringEntity entity = new StringEntity(postContent, "UTF-8");
        entity.setContentType("application/json; charset=UTF-8");
        this.logger.info("post url:" + this.getProperty(KYLIN_QUERY_API_URL));
        HttpPost postRequest = new HttpPost(this.getProperty(KYLIN_QUERY_API_URL));
        postRequest.setEntity((HttpEntity)entity);
        postRequest.addHeader("Authorization", "Basic " + new String(encodeBytes));
        postRequest.addHeader("Accept-Encoding", "UTF-8");
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        return httpClient.execute((HttpUriRequest)postRequest);
    }

    public String getProject(String cmd) {
        boolean isFirstLineProject = cmd.startsWith("(");
        if (isFirstLineProject) {
            int projectStartIndex = cmd.indexOf("(");
            int projectEndIndex = cmd.indexOf(")");
            if (projectStartIndex != -1 && projectEndIndex != -1) {
                return cmd.substring(projectStartIndex + 1, projectEndIndex);
            }
            return this.getProperty(KYLIN_QUERY_PROJECT);
        }
        return this.getProperty(KYLIN_QUERY_PROJECT);
    }

    public String getSQL(String cmd) {
        boolean isFirstLineProject = cmd.startsWith("(");
        if (isFirstLineProject) {
            int projectStartIndex = cmd.indexOf("(");
            int projectEndIndex = cmd.indexOf(")");
            if (projectStartIndex != -1 && projectEndIndex != -1) {
                return cmd.substring(projectEndIndex + 1);
            }
            return cmd;
        }
        return cmd;
    }

    private InterpreterResult executeQuery(String sql) throws IOException {
        String result;
        HttpResponse response = this.prepareRequest(sql);
        try {
            int code = response.getStatusLine().getStatusCode();
            result = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8");
            if (code != 200) {
                StringBuilder errorMessage = new StringBuilder("Failed : HTTP error code " + code + " .");
                this.logger.error("Failed to execute query: " + result);
                KylinErrorResponse kylinErrorResponse = KylinErrorResponse.fromJson(result);
                if (kylinErrorResponse == null) {
                    this.logger.error("Cannot get json from string: " + result);
                    if (code == 401) {
                        errorMessage.append(" Error message: Unauthorized. This request requires HTTP authentication. Please make sure your have set your credentials correctly.");
                    } else {
                        errorMessage.append(" Error message: " + result + " .");
                    }
                } else {
                    String exception = kylinErrorResponse.getException();
                    this.logger.error("The exception is " + exception);
                    errorMessage.append(" Error message: " + exception + " .");
                }
                return new InterpreterResult(InterpreterResult.Code.ERROR, errorMessage.toString());
            }
        }
        catch (IOException | NullPointerException e) {
            throw new IOException(e);
        }
        return new InterpreterResult(InterpreterResult.Code.SUCCESS, this.formatResult(result));
    }

    String formatResult(String msg) {
        StringBuilder res = new StringBuilder("%table ");
        Matcher ml = KYLIN_TABLE_FORMAT_REGEX_LABEL.matcher(msg);
        while (!ml.hitEnd() && ml.find()) {
            res.append(ml.group(1) + " \t");
        }
        res.append(" \n");
        Matcher mr = KYLIN_TABLE_FORMAT_REGEX_RESULTS.matcher(msg);
        String table = null;
        while (!mr.hitEnd() && mr.find()) {
            table = mr.group(1);
        }
        if (table != null && !table.isEmpty()) {
            String[] row = table.split("],\\[");
            for (int i = 0; i < row.length; ++i) {
                String[] col = row[i].split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)", -1);
                for (int j = 0; j < col.length; ++j) {
                    if (col[j] != null) {
                        col[j] = col[j].replaceAll("^\"|\"$", "");
                    }
                    res.append(col[j] + " \t");
                }
                res.append(" \n");
            }
        }
        return res.toString();
    }
}

