/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.kotlin.repl.building;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import kotlin.Unit;
import kotlin.script.experimental.api.KotlinType;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptCompilationConfigurationKeys;
import kotlin.script.experimental.api.ScriptCompilationKt;
import kotlin.script.experimental.api.ScriptEvaluationConfiguration;
import kotlin.script.experimental.api.ScriptEvaluationConfigurationKeys;
import kotlin.script.experimental.api.ScriptEvaluationKt;
import kotlin.script.experimental.api.ScriptEvaluator;
import kotlin.script.experimental.host.ScriptingHostConfiguration;
import kotlin.script.experimental.jvm.BasicJvmScriptEvaluator;
import kotlin.script.experimental.jvm.JvmScriptCompilationConfigurationBuilder;
import kotlin.script.experimental.jvm.JvmScriptCompilationKt;
import kotlin.script.experimental.jvmhost.impl.JvmHostUtilKt;
import kotlin.script.experimental.jvmhost.repl.JvmReplCompiler;
import kotlin.script.experimental.jvmhost.repl.JvmReplEvaluator;
import org.apache.zeppelin.kotlin.context.KotlinReceiver;
import org.apache.zeppelin.kotlin.repl.building.KotlinReplProperties;
import org.jetbrains.kotlin.scripting.compiler.plugin.impl.KJvmReplCompilerImpl;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.KJvmReplCompilerProxy;

public class ReplBuilding {
    public static JvmReplCompiler buildCompiler(KotlinReplProperties properties) {
        String receiverClassPath = properties.getReceiver().getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        properties.classPath(receiverClassPath);
        KJvmReplCompilerImpl compilerImpl = new KJvmReplCompilerImpl(JvmHostUtilKt.withDefaults((ScriptingHostConfiguration)properties.getHostConf()));
        return new JvmReplCompiler(ReplBuilding.buildCompilationConfiguration(properties), properties.getHostConf(), (KJvmReplCompilerProxy)compilerImpl);
    }

    public static JvmReplEvaluator buildEvaluator(KotlinReplProperties properties) {
        return new JvmReplEvaluator(ReplBuilding.buildEvaluationConfiguration(properties), (ScriptEvaluator)new BasicJvmScriptEvaluator());
    }

    private static String buildClassPath(KotlinReplProperties p) {
        StringJoiner joiner = new StringJoiner(File.pathSeparator);
        for (String path : p.getClasspath()) {
            if (path == null || path.equals("")) continue;
            joiner.add(path);
        }
        return joiner.toString();
    }

    private static ScriptCompilationConfiguration buildCompilationConfiguration(KotlinReplProperties p) {
        return new ScriptCompilationConfiguration(b -> {
            b.invoke(ScriptCompilationKt.getHostConfiguration((ScriptCompilationConfigurationKeys)b), (Object)p.getHostConf());
            JvmScriptCompilationConfigurationBuilder jvmBuilder = JvmScriptCompilationKt.getJvm((ScriptCompilationConfigurationKeys)b);
            JvmScriptCompilationKt.dependenciesFromCurrentContext((JvmScriptCompilationConfigurationBuilder)jvmBuilder, (String[])new String[0], (boolean)true, (boolean)false);
            List<String> compilerOptions = Arrays.asList("-classpath", ReplBuilding.buildClassPath(p));
            b.invoke(ScriptCompilationKt.getCompilerOptions((ScriptCompilationConfigurationKeys)b), compilerOptions);
            KotlinType kt = new KotlinType(p.getReceiver().getClass().getCanonicalName());
            List<KotlinType> receivers = Collections.singletonList(kt);
            b.invoke(ScriptCompilationKt.getImplicitReceivers((ScriptCompilationConfigurationKeys)b), receivers);
            return Unit.INSTANCE;
        });
    }

    private static ScriptEvaluationConfiguration buildEvaluationConfiguration(KotlinReplProperties p) {
        return new ScriptEvaluationConfiguration(b -> {
            b.invoke(ScriptEvaluationKt.getHostConfiguration((ScriptEvaluationConfigurationKeys)b), (Object)p.getHostConf());
            List<KotlinReceiver> receivers = Collections.singletonList(p.getReceiver());
            b.invoke(ScriptEvaluationKt.getImplicitReceivers((ScriptEvaluationConfigurationKeys)b), receivers);
            return Unit.INSTANCE;
        });
    }
}

