/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.kotlin.repl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import kotlin.script.experimental.jvm.impl.KJvmCompiledScript;
import org.jetbrains.kotlin.cli.common.repl.CompiledClassData;
import org.jetbrains.kotlin.cli.common.repl.ReplCompileResult;
import org.jetbrains.kotlin.scripting.compiler.plugin.impl.KJvmCompiledModuleInMemory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassWriter {
    private static Logger logger = LoggerFactory.getLogger(ClassWriter.class);
    private String outputDir;

    public ClassWriter(String outputDir) {
        this.outputDir = outputDir;
    }

    public void writeClasses(ReplCompileResult.CompiledClasses classes) {
        if (this.outputDir == null) {
            return;
        }
        for (CompiledClassData compiledClass : classes.getClasses()) {
            String filePath = compiledClass.getPath();
            if (filePath.contains(File.separator)) continue;
            String classWritePath = this.outputDir + File.separator + filePath;
            this.writeClass(compiledClass.getBytes(), classWritePath);
        }
        this.writeModuleInMemory(classes);
    }

    private void writeModuleInMemory(ReplCompileResult.CompiledClasses classes) {
        try {
            KJvmCompiledScript compiledScript = Objects.requireNonNull((KJvmCompiledScript)classes.getData());
            KJvmCompiledModuleInMemory moduleInMemory = Objects.requireNonNull((KJvmCompiledModuleInMemory)compiledScript.getCompiledModule());
            moduleInMemory.getCompilerOutputFiles().forEach((name, bytes) -> {
                if (name.contains("class")) {
                    this.writeClass((byte[])bytes, this.outputDir + File.separator + name);
                }
            });
        }
        catch (ClassCastException | NullPointerException e) {
            logger.info("Compiled line #" + classes.getLineId().getNo() + "has no in-memory modules");
        }
    }

    private void writeClass(byte[] classBytes, String path) {
        try (FileOutputStream fos = new FileOutputStream(path);
             BufferedOutputStream out = new BufferedOutputStream(fos);){
            ((OutputStream)out).write(classBytes);
            ((OutputStream)out).flush();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
    }
}

