/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.kotlin.reflect;

import kotlin.reflect.KProperty;
import org.apache.zeppelin.kotlin.reflect.KotlinReflectUtil;

public class KotlinVariableInfo {
    private final Object value;
    private final KProperty<?> descriptor;

    public KotlinVariableInfo(Object value, KProperty<?> descriptor) {
        this.value = value;
        this.descriptor = descriptor;
    }

    public Object getValue() {
        return this.value;
    }

    public KProperty<?> getDescriptor() {
        return this.descriptor;
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public String getType() {
        return this.descriptor.getReturnType().toString();
    }

    public String toString(boolean shortenTypes) {
        String type = this.getType();
        if (shortenTypes) {
            type = KotlinReflectUtil.shorten(type);
        }
        return this.getName() + ": " + type + " = " + this.getValue();
    }

    public String toString() {
        return this.toString(false);
    }
}

