/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.kotlin.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Pair;
import kotlin.reflect.KFunction;
import kotlin.reflect.KProperty;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.apache.zeppelin.kotlin.reflect.KotlinFunctionInfo;
import org.apache.zeppelin.kotlin.reflect.KotlinVariableInfo;
import org.jetbrains.kotlin.cli.common.repl.AggregatedReplStageState;
import org.jetbrains.kotlin.cli.common.repl.ReplHistoryRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextUpdater {
    private static final Logger logger = LoggerFactory.getLogger(ContextUpdater.class);
    private static final Set<Method> objectMethods = new HashSet<Method>(Arrays.asList(Object.class.getMethods()));
    private AggregatedReplStageState<?, ?> state;
    private Map<String, KotlinVariableInfo> vars;
    private Set<KotlinFunctionInfo> functions;

    public ContextUpdater(AggregatedReplStageState<?, ?> state, Map<String, KotlinVariableInfo> vars, Set<KotlinFunctionInfo> functions) {
        this.state = state;
        this.vars = vars;
        this.functions = functions;
    }

    public void update() {
        try {
            List<Object> lines = this.getLines();
            this.refreshVariables(lines);
            this.refreshMethods(lines);
        }
        catch (NullPointerException | ReflectiveOperationException e) {
            logger.error("Exception updating current variables", (Throwable)e);
        }
    }

    private void refreshMethods(List<Object> lines) {
        this.functions.clear();
        for (Object line : lines) {
            Method[] methods;
            for (Method method : methods = line.getClass().getMethods()) {
                KFunction function;
                if (objectMethods.contains(method) || method.getName().equals("main") || (function = ReflectJvmMapping.getKotlinFunction((Method)method)) == null) continue;
                this.functions.add(new KotlinFunctionInfo(function));
            }
        }
    }

    private List<Object> getLines() {
        List<Object> lines = this.state.getHistory().stream().map(this::getLineFromRecord).collect(Collectors.toList());
        Collections.reverse(lines);
        return lines;
    }

    private Object getLineFromRecord(ReplHistoryRecord<? extends Pair<?, ?>> record) {
        Object statePair = ((Pair)record.getItem()).getSecond();
        return ((Pair)statePair).getSecond();
    }

    private Object getImplicitReceiver(Object script) throws ReflectiveOperationException {
        Field receiverField = script.getClass().getDeclaredField("$$implicitReceiver0");
        return receiverField.get(script);
    }

    private void refreshVariables(List<Object> lines) throws ReflectiveOperationException {
        this.vars.clear();
        if (!lines.isEmpty()) {
            Object receiver = this.getImplicitReceiver(lines.get(0));
            this.findReceiverVariables(receiver);
        }
        for (Object line : lines) {
            this.findLineVariables(line);
        }
    }

    private void findLineVariables(Object line) throws IllegalAccessException {
        Field[] fields = line.getClass().getDeclaredFields();
        this.findVariables(fields, line);
    }

    private void findReceiverVariables(Object receiver) throws IllegalAccessException {
        ArrayList<Field> fieldsList = new ArrayList<Field>();
        for (Class<?> cl = receiver.getClass(); cl != null; cl = cl.getSuperclass()) {
            fieldsList.addAll(Arrays.asList(cl.getDeclaredFields()));
        }
        this.findVariables(fieldsList.toArray(new Field[0]), receiver);
    }

    private void findVariables(Field[] fields, Object o) throws IllegalAccessException {
        for (Field field : fields) {
            KProperty descriptor;
            String fieldName = field.getName();
            if (fieldName.contains("$$implicitReceiver")) continue;
            field.setAccessible(true);
            Object value = field.get(o);
            if (fieldName.contains("script$") || (descriptor = ReflectJvmMapping.getKotlinProperty((Field)field)) == null) continue;
            this.vars.putIfAbsent(fieldName, new KotlinVariableInfo(value, descriptor));
        }
    }
}

