/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.flink.cmd;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(YarnUtils.class);

    public static void buildFlinkUIInfo(String log, InterpreterContext context) {
        int pos = log.lastIndexOf(" ");
        if (pos != -1) {
            String appId = log.substring(pos + 1);
            try {
                YarnClient yarnClient = YarnClient.createYarnClient();
                yarnClient.init((Configuration)new YarnConfiguration());
                yarnClient.start();
                ApplicationReport applicationReport = yarnClient.getApplicationReport(ConverterUtils.toApplicationId((String)appId));
                HashMap<String, String> infos = new HashMap<String, String>();
                infos.put("jobUrl", applicationReport.getTrackingUrl());
                infos.put("label", "Flink UI");
                infos.put("tooltip", "View in Flink web UI");
                infos.put("noteId", context.getNoteId());
                infos.put("paraId", context.getParagraphId());
                context.getIntpEventClient().onParaInfosReceived(infos);
            }
            catch (Exception e) {
                LOGGER.error("Fail to extract flink url", (Throwable)e);
            }
        } else {
            LOGGER.error("Unable to extract flink url from this log: " + log);
        }
    }
}

