/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.flink.cmd;

import java.util.Properties;
import org.apache.zeppelin.flink.cmd.YarnUtils;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.InterpreterOutputListener;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessageOutput;
import org.apache.zeppelin.shell.ShellInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkCmdInterpreter
extends ShellInterpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlinkCmdInterpreter.class);
    private String flinkHome;

    public FlinkCmdInterpreter(Properties property) {
        super(property);
        this.setProperty("shell.command.timeout.millisecs", "2147483647");
        this.flinkHome = this.properties.getProperty("FLINK_HOME");
        LOGGER.info("FLINK_HOME: " + this.flinkHome);
    }

    public InterpreterResult internalInterpret(String cmd, InterpreterContext context) {
        String flinkCommand = this.flinkHome + "/bin/flink " + cmd.trim();
        LOGGER.info("Flink command: " + flinkCommand);
        context.out.addInterpreterOutListener((InterpreterOutputListener)new FlinkCmdOutputListener(context));
        return super.internalInterpret(flinkCommand, context);
    }

    private static class FlinkCmdOutputListener
    implements InterpreterOutputListener {
        private InterpreterContext context;
        private boolean isFlinkUrlSent = false;

        public FlinkCmdOutputListener(InterpreterContext context) {
            this.context = context;
        }

        public void onUpdateAll(InterpreterOutput out) {
        }

        public void onAppend(int index, InterpreterResultMessageOutput out, byte[] line) {
            String text = new String(line);
            if (this.isFlinkUrlSent) {
                return;
            }
            if (text.contains("Submitted application")) {
                YarnUtils.buildFlinkUIInfo(text, this.context);
                this.isFlinkUrlSent = true;
            }
        }

        public void onUpdate(int index, InterpreterResultMessageOutput out) {
        }
    }
}

