/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.flink;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.client.cli.CliFrontend;
import org.apache.flink.client.cli.CustomCommandLine;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.python.PythonOptions;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironmentFactory;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.PlannerType;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.bridge.java.internal.StreamTableEnvironmentImpl;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.ExecutorFactory;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.PlannerFactoryUtil;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableAggregateFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.operations.DescribeTableOperation;
import org.apache.flink.table.operations.ExplainOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.ShowCatalogsOperation;
import org.apache.flink.table.operations.ShowDatabasesOperation;
import org.apache.flink.table.operations.ShowFunctionsOperation;
import org.apache.flink.table.operations.ShowTablesOperation;
import org.apache.flink.table.operations.UseCatalogOperation;
import org.apache.flink.table.operations.UseDatabaseOperation;
import org.apache.flink.table.operations.ddl.AlterCatalogFunctionOperation;
import org.apache.flink.table.operations.ddl.AlterDatabaseOperation;
import org.apache.flink.table.operations.ddl.AlterTableOperation;
import org.apache.flink.table.operations.ddl.CreateCatalogFunctionOperation;
import org.apache.flink.table.operations.ddl.CreateCatalogOperation;
import org.apache.flink.table.operations.ddl.CreateDatabaseOperation;
import org.apache.flink.table.operations.ddl.CreateTableOperation;
import org.apache.flink.table.operations.ddl.CreateTempSystemFunctionOperation;
import org.apache.flink.table.operations.ddl.CreateViewOperation;
import org.apache.flink.table.operations.ddl.DropCatalogFunctionOperation;
import org.apache.flink.table.operations.ddl.DropCatalogOperation;
import org.apache.flink.table.operations.ddl.DropDatabaseOperation;
import org.apache.flink.table.operations.ddl.DropTableOperation;
import org.apache.flink.table.operations.ddl.DropTempSystemFunctionOperation;
import org.apache.flink.table.operations.ddl.DropViewOperation;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.utils.PrintUtils;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.FlinkException;
import org.apache.zeppelin.flink.FlinkShims;
import org.apache.zeppelin.flink.FlinkVersion;
import org.apache.zeppelin.flink.shims114.CollectStreamTableSink;
import org.apache.zeppelin.flink.sql.SqlCommandParser;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Flink114Shims
extends FlinkShims {
    private static final Logger LOGGER = LoggerFactory.getLogger(Flink114Shims.class);
    public static final AttributedString MESSAGE_HELP = new AttributedStringBuilder().append((CharSequence)"The following commands are available:\n\n").append(Flink114Shims.formatCommand((SqlCommandParser.SqlCommand)SqlCommandParser.SqlCommand.CREATE_TABLE, (String)"Create table under current catalog and database.")).append(Flink114Shims.formatCommand((SqlCommandParser.SqlCommand)SqlCommandParser.SqlCommand.DROP_TABLE, (String)"Drop table with optional catalog and database. Syntax: 'DROP TABLE [IF EXISTS] <name>;'")).append(Flink114Shims.formatCommand((SqlCommandParser.SqlCommand)SqlCommandParser.SqlCommand.CREATE_VIEW, (String)"Creates a virtual table from a SQL query. Syntax: 'CREATE VIEW <name> AS <query>;'")).append(Flink114Shims.formatCommand((SqlCommandParser.SqlCommand)SqlCommandParser.SqlCommand.DESCRIBE, (String)"Describes the schema of a table with the given name.")).append(Flink114Shims.formatCommand((SqlCommandParser.SqlCommand)SqlCommandParser.SqlCommand.DROP_VIEW, (String)"Deletes a previously created virtual table. Syntax: 'DROP VIEW <name>;'")).append(Flink114Shims.formatCommand((SqlCommandParser.SqlCommand)SqlCommandParser.SqlCommand.EXPLAIN, (String)"Describes the execution plan of a query or table with the given name.")).append(Flink114Shims.formatCommand((SqlCommandParser.SqlCommand)SqlCommandParser.SqlCommand.HELP, (String)"Prints the available commands.")).append(Flink114Shims.formatCommand((SqlCommandParser.SqlCommand)SqlCommandParser.SqlCommand.INSERT_INTO, (String)"Inserts the results of a SQL SELECT query into a declared table sink.")).append(Flink114Shims.formatCommand((SqlCommandParser.SqlCommand)SqlCommandParser.SqlCommand.INSERT_OVERWRITE, (String)"Inserts the results of a SQL SELECT query into a declared table sink and overwrite existing data.")).append(Flink114Shims.formatCommand((SqlCommandParser.SqlCommand)SqlCommandParser.SqlCommand.SELECT, (String)"Executes a SQL SELECT query on the Flink cluster.")).append(Flink114Shims.formatCommand((SqlCommandParser.SqlCommand)SqlCommandParser.SqlCommand.SET, (String)"Sets a session configuration property. Syntax: 'SET <key>=<value>;'. Use 'SET;' for listing all properties.")).append(Flink114Shims.formatCommand((SqlCommandParser.SqlCommand)SqlCommandParser.SqlCommand.SHOW_FUNCTIONS, (String)"Shows all user-defined and built-in functions.")).append(Flink114Shims.formatCommand((SqlCommandParser.SqlCommand)SqlCommandParser.SqlCommand.SHOW_TABLES, (String)"Shows all registered tables.")).append(Flink114Shims.formatCommand((SqlCommandParser.SqlCommand)SqlCommandParser.SqlCommand.SOURCE, (String)"Reads a SQL SELECT query from a file and executes it on the Flink cluster.")).append(Flink114Shims.formatCommand((SqlCommandParser.SqlCommand)SqlCommandParser.SqlCommand.USE_CATALOG, (String)"Sets the current catalog. The current database is set to the catalog's default one. Experimental! Syntax: 'USE CATALOG <name>;'")).append(Flink114Shims.formatCommand((SqlCommandParser.SqlCommand)SqlCommandParser.SqlCommand.USE, (String)"Sets the current default database. Experimental! Syntax: 'USE <name>;'")).style(AttributedStyle.DEFAULT.underline()).append((CharSequence)"\nHint").style(AttributedStyle.DEFAULT).append((CharSequence)": Make sure that a statement ends with ';' for finalizing (multi-line) statements.").toAttributedString();
    private Map<String, StatementSet> statementSetMap = new ConcurrentHashMap<String, StatementSet>();

    public Flink114Shims(FlinkVersion flinkVersion, Properties properties) {
        super(flinkVersion, properties);
    }

    public void disableSysoutLogging(Object batchConfig, Object streamConfig) {
    }

    public Object createStreamExecutionEnvironmentFactory(final Object streamExecutionEnvironment) {
        return new StreamExecutionEnvironmentFactory(){

            public StreamExecutionEnvironment createExecutionEnvironment(Configuration configuration) {
                return (StreamExecutionEnvironment)streamExecutionEnvironment;
            }
        };
    }

    public Object createCatalogManager(Object config) {
        return CatalogManager.newBuilder().classLoader(Thread.currentThread().getContextClassLoader()).config((ReadableConfig)config).defaultCatalog("default_catalog", (Catalog)new GenericInMemoryCatalog("default_catalog", "default_database")).build();
    }

    public String getPyFlinkPythonPath(Properties properties) throws IOException {
        String mode = properties.getProperty("flink.execution.mode");
        if ("yarn-application".equalsIgnoreCase(mode)) {
            String flinkHome = new File(".").getAbsolutePath();
            return this.getPyFlinkPythonPath(flinkHome + "/lib/python");
        }
        String flinkHome = System.getenv("FLINK_HOME");
        if (StringUtils.isNotBlank((CharSequence)flinkHome)) {
            return this.getPyFlinkPythonPath(flinkHome + "/opt/python");
        }
        throw new IOException("No FLINK_HOME is specified");
    }

    private String getPyFlinkPythonPath(String pyFlinkFolder) {
        LOGGER.info("Getting pyflink lib from {}", (Object)pyFlinkFolder);
        List<File> depFiles = Arrays.asList(new File(pyFlinkFolder).listFiles());
        StringBuilder builder = new StringBuilder();
        for (File file : depFiles) {
            LOGGER.info("Adding extracted file {} to PYTHONPATH", (Object)file.getAbsolutePath());
            builder.append(file.getAbsolutePath() + ":");
        }
        return builder.toString();
    }

    public Object getCollectStreamTableSink(InetAddress targetAddress, int targetPort, Object serializer) {
        return new CollectStreamTableSink(targetAddress, targetPort, (TypeSerializer<Tuple2<Boolean, Row>>)((TypeSerializer)serializer));
    }

    public List collectToList(Object table) throws Exception {
        return Lists.newArrayList((Iterator)((Table)table).execute().collect());
    }

    public void startMultipleInsert(Object tblEnv, InterpreterContext context) throws Exception {
        StatementSet statementSet = ((TableEnvironment)tblEnv).createStatementSet();
        this.statementSetMap.put(context.getParagraphId(), statementSet);
    }

    public void addInsertStatement(String sql, Object tblEnv, InterpreterContext context) throws Exception {
        this.statementSetMap.get(context.getParagraphId()).addInsertSql(sql);
    }

    public boolean executeMultipleInsertInto(String jobName, Object tblEnv, InterpreterContext context) throws Exception {
        JobClient jobClient = (JobClient)this.statementSetMap.get(context.getParagraphId()).execute().getJobClient().get();
        while (!((JobStatus)jobClient.getJobStatus().get()).isTerminalState()) {
            LOGGER.debug("Wait for job to finish");
            Thread.sleep(5000L);
        }
        if (jobClient.getJobStatus().get() == JobStatus.CANCELED) {
            context.out.write("Job is cancelled.\n");
            return false;
        }
        return true;
    }

    public boolean rowEquals(Object row1, Object row2) {
        Row r1 = (Row)row1;
        Row r2 = (Row)row2;
        r1.setKind(RowKind.INSERT);
        r2.setKind(RowKind.INSERT);
        return r1.equals((Object)r2);
    }

    public Object fromDataSet(Object btenv, Object ds) {
        return null;
    }

    public Object toDataSet(Object btenv, Object table) {
        return null;
    }

    public void registerTableSink(Object stenv, String tableName, Object collectTableSink) {
        ((TableEnvironmentInternal)stenv).registerTableSinkInternal(tableName, (TableSink)collectTableSink);
    }

    public void registerScalarFunction(Object btenv, String name, Object scalarFunction) {
        ((StreamTableEnvironmentImpl)btenv).createTemporarySystemFunction(name, (UserDefinedFunction)((ScalarFunction)scalarFunction));
    }

    public void registerTableFunction(Object btenv, String name, Object tableFunction) {
        ((StreamTableEnvironmentImpl)btenv).registerFunction(name, (TableFunction)tableFunction);
    }

    public void registerAggregateFunction(Object btenv, String name, Object aggregateFunction) {
        ((StreamTableEnvironmentImpl)btenv).registerFunction(name, (AggregateFunction)aggregateFunction);
    }

    public void registerTableAggregateFunction(Object btenv, String name, Object tableAggregateFunction) {
        ((StreamTableEnvironmentImpl)btenv).registerFunction(name, (TableAggregateFunction)tableAggregateFunction);
    }

    public Optional<SqlCommandParser.SqlCommandCall> parseSql(Object tableEnv, String stmt) {
        Parser sqlParser = ((TableEnvironmentInternal)tableEnv).getParser();
        SqlCommandParser.SqlCommandCall sqlCommandCall = null;
        try {
            Optional<SqlCommandParser.SqlCommandCall> callOpt = Flink114Shims.parseByRegexMatching(stmt);
            sqlCommandCall = callOpt.isPresent() ? callOpt.get() : this.parseBySqlParser(sqlParser, stmt);
        }
        catch (Exception e) {
            return Optional.empty();
        }
        return Optional.of(sqlCommandCall);
    }

    private SqlCommandParser.SqlCommandCall parseBySqlParser(Parser sqlParser, String stmt) throws Exception {
        SqlCommandParser.SqlCommand cmd;
        List operations;
        try {
            operations = sqlParser.parse(stmt);
        }
        catch (Throwable e) {
            throw new Exception("Invalidate SQL statement.", e);
        }
        if (operations.size() != 1) {
            throw new Exception("Only single statement is supported now.");
        }
        String[] operands = new String[]{stmt};
        Operation operation = (Operation)operations.get(0);
        if (operation instanceof CatalogSinkModifyOperation) {
            boolean overwrite = ((CatalogSinkModifyOperation)operation).isOverwrite();
            cmd = overwrite ? SqlCommandParser.SqlCommand.INSERT_OVERWRITE : SqlCommandParser.SqlCommand.INSERT_INTO;
        } else if (operation instanceof CreateTableOperation) {
            cmd = SqlCommandParser.SqlCommand.CREATE_TABLE;
        } else if (operation instanceof DropTableOperation) {
            cmd = SqlCommandParser.SqlCommand.DROP_TABLE;
        } else if (operation instanceof AlterTableOperation) {
            cmd = SqlCommandParser.SqlCommand.ALTER_TABLE;
        } else if (operation instanceof CreateViewOperation) {
            cmd = SqlCommandParser.SqlCommand.CREATE_VIEW;
        } else if (operation instanceof DropViewOperation) {
            cmd = SqlCommandParser.SqlCommand.DROP_VIEW;
        } else if (operation instanceof CreateDatabaseOperation) {
            cmd = SqlCommandParser.SqlCommand.CREATE_DATABASE;
        } else if (operation instanceof DropDatabaseOperation) {
            cmd = SqlCommandParser.SqlCommand.DROP_DATABASE;
        } else if (operation instanceof AlterDatabaseOperation) {
            cmd = SqlCommandParser.SqlCommand.ALTER_DATABASE;
        } else if (operation instanceof CreateCatalogOperation) {
            cmd = SqlCommandParser.SqlCommand.CREATE_CATALOG;
        } else if (operation instanceof DropCatalogOperation) {
            cmd = SqlCommandParser.SqlCommand.DROP_CATALOG;
        } else if (operation instanceof UseCatalogOperation) {
            cmd = SqlCommandParser.SqlCommand.USE_CATALOG;
            operands = new String[]{((UseCatalogOperation)operation).getCatalogName()};
        } else if (operation instanceof UseDatabaseOperation) {
            cmd = SqlCommandParser.SqlCommand.USE;
            operands = new String[]{((UseDatabaseOperation)operation).getDatabaseName()};
        } else if (operation instanceof ShowCatalogsOperation) {
            cmd = SqlCommandParser.SqlCommand.SHOW_CATALOGS;
            operands = new String[]{};
        } else if (operation instanceof ShowDatabasesOperation) {
            cmd = SqlCommandParser.SqlCommand.SHOW_DATABASES;
            operands = new String[]{};
        } else if (operation instanceof ShowTablesOperation) {
            cmd = SqlCommandParser.SqlCommand.SHOW_TABLES;
            operands = new String[]{};
        } else if (operation instanceof ShowFunctionsOperation) {
            cmd = SqlCommandParser.SqlCommand.SHOW_FUNCTIONS;
            operands = new String[]{};
        } else if (operation instanceof CreateCatalogFunctionOperation || operation instanceof CreateTempSystemFunctionOperation) {
            cmd = SqlCommandParser.SqlCommand.CREATE_FUNCTION;
        } else if (operation instanceof DropCatalogFunctionOperation || operation instanceof DropTempSystemFunctionOperation) {
            cmd = SqlCommandParser.SqlCommand.DROP_FUNCTION;
        } else if (operation instanceof AlterCatalogFunctionOperation) {
            cmd = SqlCommandParser.SqlCommand.ALTER_FUNCTION;
        } else if (operation instanceof ExplainOperation) {
            cmd = SqlCommandParser.SqlCommand.EXPLAIN;
        } else if (operation instanceof DescribeTableOperation) {
            cmd = SqlCommandParser.SqlCommand.DESCRIBE;
            operands = new String[]{((DescribeTableOperation)operation).getSqlIdentifier().asSerializableString()};
        } else if (operation instanceof QueryOperation) {
            cmd = SqlCommandParser.SqlCommand.SELECT;
        } else {
            throw new Exception("Unknown operation: " + operation.asSummaryString());
        }
        return new SqlCommandParser.SqlCommandCall(cmd, operands, stmt);
    }

    private static Optional<SqlCommandParser.SqlCommandCall> parseByRegexMatching(String stmt) {
        for (SqlCommandParser.SqlCommand cmd : SqlCommandParser.SqlCommand.values()) {
            Matcher matcher;
            if (cmd.pattern == null || !(matcher = cmd.pattern.matcher(stmt)).matches()) continue;
            String[] groups = new String[matcher.groupCount()];
            for (int i = 0; i < groups.length; ++i) {
                groups[i] = matcher.group(i + 1);
            }
            return ((Optional)cmd.operandConverter.apply(groups)).map(operands -> {
                String[] newOperands = operands;
                if (cmd == SqlCommandParser.SqlCommand.EXPLAIN) {
                    newOperands = new String[]{"EXPLAIN PLAN FOR " + operands[0] + " " + operands[1]};
                }
                return new SqlCommandParser.SqlCommandCall(cmd, newOperands, stmt);
            });
        }
        return Optional.empty();
    }

    public void executeSql(Object tableEnv, String sql) {
        ((TableEnvironment)tableEnv).executeSql(sql);
    }

    public String explain(Object tableEnv, String sql) {
        TableResult tableResult = ((TableEnvironment)tableEnv).executeSql(sql);
        return ((Row)tableResult.collect().next()).getField(0).toString();
    }

    public String sqlHelp() {
        return MESSAGE_HELP.toString();
    }

    public void setCatalogManagerSchemaResolver(Object catalogManager, Object parserObject, Object environmentSetting) {
    }

    public Object updateEffectiveConfig(Object cliFrontend, Object commandLine, Object effectiveConfig) {
        CustomCommandLine customCommandLine = ((CliFrontend)cliFrontend).validateAndGetActiveCommandLine((CommandLine)commandLine);
        try {
            ((Configuration)effectiveConfig).addAll(customCommandLine.toConfiguration((CommandLine)commandLine));
            return effectiveConfig;
        }
        catch (FlinkException e) {
            throw new RuntimeException("Fail to call addAll", e);
        }
    }

    public Map extractTableConfigOptions() {
        HashMap<String, ConfigOption> configOptions = new HashMap<String, ConfigOption>();
        configOptions.putAll(this.extractConfigOptions(ExecutionConfigOptions.class));
        configOptions.putAll(this.extractConfigOptions(OptimizerConfigOptions.class));
        try {
            configOptions.putAll(this.extractConfigOptions(PythonOptions.class));
        }
        catch (NoClassDefFoundError e) {
            LOGGER.warn("No pyflink jars found");
        }
        configOptions.putAll(this.extractConfigOptions(TableConfigOptions.class));
        return configOptions;
    }

    private Map<String, ConfigOption> extractConfigOptions(Class clazz) {
        Field[] fields;
        HashMap<String, ConfigOption> configOptions = new HashMap<String, ConfigOption>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.getType().isAssignableFrom(ConfigOption.class)) continue;
            try {
                ConfigOption configOption = (ConfigOption)field.get(ConfigOption.class);
                configOptions.put(configOption.key(), configOption);
            }
            catch (Throwable e) {
                LOGGER.warn("Fail to get ConfigOption", e);
            }
        }
        return configOptions;
    }

    public void setBatchRuntimeMode(Object tableConfig) {
        ((TableConfig)tableConfig).getConfiguration().set(ExecutionOptions.RUNTIME_MODE, (Object)RuntimeExecutionMode.BATCH);
    }

    public void setOldPlanner(Object tableConfig) {
        ((TableConfig)tableConfig).getConfiguration().set(TableConfigOptions.TABLE_PLANNER, (Object)PlannerType.OLD);
    }

    public String[] rowToString(Object row, Object table, Object tableConfig) {
        String zone = (String)((TableConfig)tableConfig).getConfiguration().get(TableConfigOptions.LOCAL_TIME_ZONE);
        ZoneId zoneId = ((String)TableConfigOptions.LOCAL_TIME_ZONE.defaultValue()).equals(zone) ? ZoneId.systemDefault() : ZoneId.of(zone);
        ResolvedSchema resolvedSchema = ((Table)table).getResolvedSchema();
        return PrintUtils.rowToString((Row)((Row)row), (ResolvedSchema)resolvedSchema, (ZoneId)zoneId);
    }

    public boolean isTimeIndicatorType(Object type) {
        return FlinkTypeFactory.isTimeIndicatorType((TypeInformation)((TypeInformation)type));
    }

    private Object lookupExecutor(ClassLoader classLoader, Object settings, Object sEnv) {
        try {
            ExecutorFactory executorFactory = (ExecutorFactory)FactoryUtil.discoverFactory((ClassLoader)classLoader, ExecutorFactory.class, (String)((EnvironmentSettings)settings).getExecutor());
            Method createMethod = executorFactory.getClass().getMethod("create", StreamExecutionEnvironment.class);
            return createMethod.invoke((Object)executorFactory, sEnv);
        }
        catch (Exception e) {
            throw new TableException("Could not instantiate the executor. Make sure a planner module is on the classpath", (Throwable)e);
        }
    }

    public ImmutablePair<Object, Object> createPlannerAndExecutor(ClassLoader classLoader, Object environmentSettings, Object sEnv, Object tableConfig, Object functionCatalog, Object catalogManager) {
        EnvironmentSettings settings = (EnvironmentSettings)environmentSettings;
        Executor executor = (Executor)this.lookupExecutor(classLoader, environmentSettings, sEnv);
        Planner planner = PlannerFactoryUtil.createPlanner((String)settings.getPlanner(), (Executor)executor, (TableConfig)((TableConfig)tableConfig), (CatalogManager)((CatalogManager)catalogManager), (FunctionCatalog)((FunctionCatalog)functionCatalog));
        return ImmutablePair.of((Object)planner, (Object)executor);
    }
}

