/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.logging.ats;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.tez.common.VersionInfo;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.dag.impl.ServicePluginInfo;
import org.apache.tez.dag.app.dag.impl.VertexStats;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.events.AMLaunchedEvent;
import org.apache.tez.dag.history.events.AMStartedEvent;
import org.apache.tez.dag.history.events.AppLaunchedEvent;
import org.apache.tez.dag.history.events.ContainerLaunchedEvent;
import org.apache.tez.dag.history.events.ContainerStoppedEvent;
import org.apache.tez.dag.history.events.DAGFinishedEvent;
import org.apache.tez.dag.history.events.DAGInitializedEvent;
import org.apache.tez.dag.history.events.DAGRecoveredEvent;
import org.apache.tez.dag.history.events.DAGStartedEvent;
import org.apache.tez.dag.history.events.DAGSubmittedEvent;
import org.apache.tez.dag.history.events.TaskAttemptFinishedEvent;
import org.apache.tez.dag.history.events.TaskAttemptStartedEvent;
import org.apache.tez.dag.history.events.TaskFinishedEvent;
import org.apache.tez.dag.history.events.TaskStartedEvent;
import org.apache.tez.dag.history.events.VertexConfigurationDoneEvent;
import org.apache.tez.dag.history.events.VertexFinishedEvent;
import org.apache.tez.dag.history.events.VertexInitializedEvent;
import org.apache.tez.dag.history.events.VertexStartedEvent;
import org.apache.tez.dag.history.logging.EntityTypes;
import org.apache.tez.dag.history.utils.DAGUtils;
import org.apache.tez.dag.records.TezVertexID;

public final class HistoryEventTimelineConversion {
    private HistoryEventTimelineConversion() {
    }

    private static void validateEvent(HistoryEvent event) {
        if (!event.isHistoryEvent()) {
            throw new UnsupportedOperationException("Invalid Event, does not support history, eventType=" + event.getEventType());
        }
    }

    public static List<TimelineEntity> convertToTimelineEntities(HistoryEvent historyEvent) {
        HistoryEventTimelineConversion.validateEvent(historyEvent);
        switch (historyEvent.getEventType()) {
            case APP_LAUNCHED: {
                return Collections.singletonList(HistoryEventTimelineConversion.convertAppLaunchedEvent((AppLaunchedEvent)historyEvent));
            }
            case AM_LAUNCHED: {
                return Collections.singletonList(HistoryEventTimelineConversion.convertAMLaunchedEvent((AMLaunchedEvent)historyEvent));
            }
            case AM_STARTED: {
                return Collections.singletonList(HistoryEventTimelineConversion.convertAMStartedEvent((AMStartedEvent)historyEvent));
            }
            case CONTAINER_LAUNCHED: {
                return Collections.singletonList(HistoryEventTimelineConversion.convertContainerLaunchedEvent((ContainerLaunchedEvent)historyEvent));
            }
            case CONTAINER_STOPPED: {
                return Collections.singletonList(HistoryEventTimelineConversion.convertContainerStoppedEvent((ContainerStoppedEvent)historyEvent));
            }
            case DAG_SUBMITTED: {
                return Lists.newArrayList((Object[])new TimelineEntity[]{HistoryEventTimelineConversion.convertDAGSubmittedEvent((DAGSubmittedEvent)historyEvent), HistoryEventTimelineConversion.convertDAGSubmittedToDAGExtraInfoEntity((DAGSubmittedEvent)historyEvent)});
            }
            case DAG_INITIALIZED: {
                return Collections.singletonList(HistoryEventTimelineConversion.convertDAGInitializedEvent((DAGInitializedEvent)historyEvent));
            }
            case DAG_STARTED: {
                return Collections.singletonList(HistoryEventTimelineConversion.convertDAGStartedEvent((DAGStartedEvent)historyEvent));
            }
            case DAG_FINISHED: {
                return Lists.newArrayList((Object[])new TimelineEntity[]{HistoryEventTimelineConversion.convertDAGFinishedEvent((DAGFinishedEvent)historyEvent), HistoryEventTimelineConversion.convertDAGFinishedToDAGExtraInfoEntity((DAGFinishedEvent)historyEvent)});
            }
            case VERTEX_INITIALIZED: {
                return Collections.singletonList(HistoryEventTimelineConversion.convertVertexInitializedEvent((VertexInitializedEvent)historyEvent));
            }
            case VERTEX_STARTED: {
                return Collections.singletonList(HistoryEventTimelineConversion.convertVertexStartedEvent((VertexStartedEvent)historyEvent));
            }
            case VERTEX_FINISHED: {
                return Collections.singletonList(HistoryEventTimelineConversion.convertVertexFinishedEvent((VertexFinishedEvent)historyEvent));
            }
            case TASK_STARTED: {
                return Collections.singletonList(HistoryEventTimelineConversion.convertTaskStartedEvent((TaskStartedEvent)historyEvent));
            }
            case TASK_FINISHED: {
                return Collections.singletonList(HistoryEventTimelineConversion.convertTaskFinishedEvent((TaskFinishedEvent)historyEvent));
            }
            case TASK_ATTEMPT_STARTED: {
                return Collections.singletonList(HistoryEventTimelineConversion.convertTaskAttemptStartedEvent((TaskAttemptStartedEvent)historyEvent));
            }
            case TASK_ATTEMPT_FINISHED: {
                return Collections.singletonList(HistoryEventTimelineConversion.convertTaskAttemptFinishedEvent((TaskAttemptFinishedEvent)historyEvent));
            }
            case VERTEX_CONFIGURE_DONE: {
                return Collections.singletonList(HistoryEventTimelineConversion.convertVertexReconfigureDoneEvent((VertexConfigurationDoneEvent)historyEvent));
            }
            case DAG_RECOVERED: {
                return Collections.singletonList(HistoryEventTimelineConversion.convertDAGRecoveredEvent((DAGRecoveredEvent)historyEvent));
            }
            case VERTEX_COMMIT_STARTED: 
            case VERTEX_GROUP_COMMIT_STARTED: 
            case VERTEX_GROUP_COMMIT_FINISHED: 
            case DAG_COMMIT_STARTED: 
            case DAG_KILL_REQUEST: {
                throw new UnsupportedOperationException("Invalid Event, does not support history, eventType=" + historyEvent.getEventType());
            }
        }
        throw new UnsupportedOperationException("Unhandled Event, eventType=" + historyEvent.getEventType());
    }

    private static TimelineEntity convertDAGRecoveredEvent(DAGRecoveredEvent event) {
        TimelineEntity atsEntity = new TimelineEntity();
        atsEntity.setEntityId(event.getDagID().toString());
        atsEntity.setEntityType(EntityTypes.TEZ_DAG_ID.name());
        TimelineEvent recoverEvt = new TimelineEvent();
        recoverEvt.setEventType(HistoryEventType.DAG_RECOVERED.name());
        recoverEvt.setTimestamp(event.getRecoveredTime());
        recoverEvt.addEventInfo("applicationAttemptId", (Object)event.getApplicationAttemptId().toString());
        if (event.getRecoveredDagState() != null) {
            recoverEvt.addEventInfo("dagState", (Object)event.getRecoveredDagState().name());
        }
        if (event.getRecoveryFailureReason() != null) {
            recoverEvt.addEventInfo("recoveryFailureReason", (Object)event.getRecoveryFailureReason());
        }
        atsEntity.addEvent(recoverEvt);
        atsEntity.addPrimaryFilter("user", (Object)event.getUser());
        atsEntity.addPrimaryFilter("applicationId", (Object)event.getApplicationAttemptId().getApplicationId().toString());
        atsEntity.addPrimaryFilter("dagName", (Object)event.getDagName());
        atsEntity.addOtherInfo("inProgressLogsURL_" + event.getApplicationAttemptId().getAttemptId(), (Object)event.getContainerLogs());
        return atsEntity;
    }

    private static TimelineEntity convertAppLaunchedEvent(AppLaunchedEvent event) {
        TimelineEntity atsEntity = new TimelineEntity();
        atsEntity.setEntityId("tez_" + event.getApplicationId().toString());
        atsEntity.setEntityType(EntityTypes.TEZ_APPLICATION.name());
        atsEntity.addPrimaryFilter("user", (Object)event.getUser());
        atsEntity.addOtherInfo("config", (Object)DAGUtils.convertConfigurationToATSMap((Configuration)event.getConf()));
        atsEntity.addOtherInfo("applicationId", (Object)event.getApplicationId().toString());
        atsEntity.addOtherInfo("user", (Object)event.getUser());
        atsEntity.setStartTime(Long.valueOf(event.getLaunchTime()));
        if (event.getVersion() != null) {
            atsEntity.addOtherInfo("tezVersion", (Object)DAGUtils.convertTezVersionToATSMap((VersionInfo)event.getVersion()));
        }
        atsEntity.addOtherInfo("amWebServiceVersion", (Object)"2");
        return atsEntity;
    }

    private static TimelineEntity convertAMLaunchedEvent(AMLaunchedEvent event) {
        TimelineEntity atsEntity = new TimelineEntity();
        atsEntity.setEntityId("tez_" + event.getApplicationAttemptId().toString());
        atsEntity.setEntityType(EntityTypes.TEZ_APPLICATION_ATTEMPT.name());
        atsEntity.addPrimaryFilter("user", (Object)event.getUser());
        atsEntity.addPrimaryFilter("applicationId", (Object)event.getApplicationAttemptId().getApplicationId().toString());
        atsEntity.setStartTime(Long.valueOf(event.getLaunchTime()));
        TimelineEvent launchEvt = new TimelineEvent();
        launchEvt.setEventType(HistoryEventType.AM_LAUNCHED.name());
        launchEvt.setTimestamp(event.getLaunchTime());
        atsEntity.addEvent(launchEvt);
        atsEntity.addOtherInfo("appSubmitTime", (Object)event.getAppSubmitTime());
        atsEntity.addOtherInfo("applicationId", (Object)event.getApplicationAttemptId().getApplicationId().toString());
        atsEntity.addOtherInfo("applicationAttemptId", (Object)event.getApplicationAttemptId().toString());
        atsEntity.addOtherInfo("user", (Object)event.getUser());
        return atsEntity;
    }

    private static TimelineEntity convertAMStartedEvent(AMStartedEvent event) {
        TimelineEntity atsEntity = new TimelineEntity();
        atsEntity.setEntityId("tez_" + event.getApplicationAttemptId().toString());
        atsEntity.setEntityType(EntityTypes.TEZ_APPLICATION_ATTEMPT.name());
        atsEntity.addPrimaryFilter("user", (Object)event.getUser());
        atsEntity.addPrimaryFilter("applicationId", (Object)event.getApplicationAttemptId().getApplicationId().toString());
        TimelineEvent startEvt = new TimelineEvent();
        startEvt.setEventType(HistoryEventType.AM_STARTED.name());
        startEvt.setTimestamp(event.getStartTime());
        atsEntity.addEvent(startEvt);
        return atsEntity;
    }

    private static TimelineEntity convertContainerLaunchedEvent(ContainerLaunchedEvent event) {
        TimelineEntity atsEntity = new TimelineEntity();
        atsEntity.setEntityId("tez_" + event.getContainerId().toString());
        atsEntity.setEntityType(EntityTypes.TEZ_CONTAINER_ID.name());
        atsEntity.addRelatedEntity(EntityTypes.TEZ_APPLICATION_ATTEMPT.name(), "tez_" + event.getApplicationAttemptId().toString());
        atsEntity.addPrimaryFilter("applicationId", (Object)event.getApplicationAttemptId().getApplicationId().toString());
        atsEntity.addOtherInfo("containerId", (Object)event.getContainerId().toString());
        atsEntity.setStartTime(Long.valueOf(event.getLaunchTime()));
        TimelineEvent launchEvt = new TimelineEvent();
        launchEvt.setEventType(HistoryEventType.CONTAINER_LAUNCHED.name());
        launchEvt.setTimestamp(event.getLaunchTime());
        atsEntity.addEvent(launchEvt);
        return atsEntity;
    }

    private static TimelineEntity convertContainerStoppedEvent(ContainerStoppedEvent event) {
        TimelineEntity atsEntity = new TimelineEntity();
        atsEntity.setEntityId("tez_" + event.getContainerId().toString());
        atsEntity.setEntityType(EntityTypes.TEZ_CONTAINER_ID.name());
        atsEntity.addRelatedEntity(EntityTypes.TEZ_APPLICATION_ATTEMPT.name(), "tez_" + event.getApplicationAttemptId().toString());
        TimelineEvent stoppedEvt = new TimelineEvent();
        stoppedEvt.setEventType(HistoryEventType.CONTAINER_STOPPED.name());
        stoppedEvt.setTimestamp(event.getStoppedTime());
        atsEntity.addEvent(stoppedEvt);
        atsEntity.addPrimaryFilter("applicationId", (Object)event.getApplicationAttemptId().getApplicationId().toString());
        atsEntity.addPrimaryFilter("exitStatus", (Object)event.getExitStatus());
        atsEntity.addOtherInfo("exitStatus", (Object)event.getExitStatus());
        atsEntity.addOtherInfo("endTime", (Object)event.getStoppedTime());
        return atsEntity;
    }

    private static TimelineEntity convertDAGFinishedEvent(DAGFinishedEvent event) {
        TimelineEntity atsEntity = new TimelineEntity();
        atsEntity.setEntityId(event.getDAGID().toString());
        atsEntity.setEntityType(EntityTypes.TEZ_DAG_ID.name());
        TimelineEvent finishEvt = new TimelineEvent();
        finishEvt.setEventType(HistoryEventType.DAG_FINISHED.name());
        finishEvt.setTimestamp(event.getFinishTime());
        atsEntity.addEvent(finishEvt);
        atsEntity.addPrimaryFilter("user", (Object)event.getUser());
        atsEntity.addPrimaryFilter("applicationId", (Object)event.getApplicationId().toString());
        atsEntity.addPrimaryFilter("dagName", (Object)event.getDagName());
        atsEntity.addPrimaryFilter("status", (Object)event.getState().name());
        if (event.getDAGPlan().hasCallerContext() && event.getDAGPlan().getCallerContext().hasCallerId()) {
            atsEntity.addPrimaryFilter("callerId", (Object)event.getDAGPlan().getCallerContext().getCallerId());
        }
        atsEntity.addOtherInfo("startTime", (Object)event.getStartTime());
        atsEntity.addOtherInfo("endTime", (Object)event.getFinishTime());
        atsEntity.addOtherInfo("timeTaken", (Object)(event.getFinishTime() - event.getStartTime()));
        atsEntity.addOtherInfo("status", (Object)event.getState().name());
        atsEntity.addOtherInfo("diagnostics", (Object)event.getDiagnostics());
        atsEntity.addOtherInfo("completionApplicationAttemptId", (Object)event.getApplicationAttemptId().toString());
        Map dagTaskStats = event.getDagTaskStats();
        if (dagTaskStats != null) {
            for (Map.Entry entry : dagTaskStats.entrySet()) {
                atsEntity.addOtherInfo((String)entry.getKey(), entry.getValue());
            }
        }
        return atsEntity;
    }

    private static TimelineEntity convertDAGFinishedToDAGExtraInfoEntity(DAGFinishedEvent event) {
        TimelineEntity atsEntity = new TimelineEntity();
        atsEntity.setEntityId(event.getDAGID().toString());
        atsEntity.setEntityType(EntityTypes.TEZ_DAG_EXTRA_INFO.name());
        atsEntity.addRelatedEntity(EntityTypes.TEZ_DAG_ID.name(), event.getDAGID().toString());
        TimelineEvent submitEvt = new TimelineEvent();
        submitEvt.setEventType(HistoryEventType.DAG_FINISHED.name());
        submitEvt.setTimestamp(event.getFinishTime());
        atsEntity.addEvent(submitEvt);
        atsEntity.addOtherInfo("counters", (Object)DAGUtils.convertCountersToATSMap((TezCounters)event.getTezCounters()));
        return atsEntity;
    }

    private static TimelineEntity convertDAGInitializedEvent(DAGInitializedEvent event) {
        TimelineEntity atsEntity = new TimelineEntity();
        atsEntity.setEntityId(event.getDAGID().toString());
        atsEntity.setEntityType(EntityTypes.TEZ_DAG_ID.name());
        TimelineEvent initEvt = new TimelineEvent();
        initEvt.setEventType(HistoryEventType.DAG_INITIALIZED.name());
        initEvt.setTimestamp(event.getInitTime());
        atsEntity.addEvent(initEvt);
        atsEntity.addPrimaryFilter("user", (Object)event.getUser());
        atsEntity.addPrimaryFilter("applicationId", (Object)event.getApplicationId().toString());
        atsEntity.addPrimaryFilter("dagName", (Object)event.getDagName());
        atsEntity.addOtherInfo("initTime", (Object)event.getInitTime());
        if (event.getVertexNameIDMap() != null) {
            TreeMap<String, String> nameIdStrMap = new TreeMap<String, String>();
            for (Map.Entry entry : event.getVertexNameIDMap().entrySet()) {
                nameIdStrMap.put((String)entry.getKey(), ((TezVertexID)entry.getValue()).toString());
            }
            atsEntity.addOtherInfo("vertexNameIdMapping", nameIdStrMap);
        }
        return atsEntity;
    }

    private static TimelineEntity convertDAGStartedEvent(DAGStartedEvent event) {
        TimelineEntity atsEntity = new TimelineEntity();
        atsEntity.setEntityId(event.getDAGID().toString());
        atsEntity.setEntityType(EntityTypes.TEZ_DAG_ID.name());
        TimelineEvent startEvt = new TimelineEvent();
        startEvt.setEventType(HistoryEventType.DAG_STARTED.name());
        startEvt.setTimestamp(event.getStartTime());
        atsEntity.addEvent(startEvt);
        atsEntity.addPrimaryFilter("user", (Object)event.getUser());
        atsEntity.addPrimaryFilter("applicationId", (Object)event.getApplicationId().toString());
        atsEntity.addPrimaryFilter("dagName", (Object)event.getDagName());
        atsEntity.addOtherInfo("startTime", (Object)event.getStartTime());
        atsEntity.addOtherInfo("status", (Object)event.getDagState().toString());
        return atsEntity;
    }

    private static TimelineEntity convertDAGSubmittedEvent(DAGSubmittedEvent event) {
        TimelineEntity atsEntity = new TimelineEntity();
        atsEntity.setEntityId(event.getDAGID().toString());
        atsEntity.setEntityType(EntityTypes.TEZ_DAG_ID.name());
        atsEntity.addRelatedEntity(EntityTypes.TEZ_APPLICATION.name(), "tez_" + event.getApplicationAttemptId().getApplicationId().toString());
        atsEntity.addRelatedEntity(EntityTypes.TEZ_APPLICATION_ATTEMPT.name(), "tez_" + event.getApplicationAttemptId().toString());
        TimelineEvent submitEvt = new TimelineEvent();
        submitEvt.setEventType(HistoryEventType.DAG_SUBMITTED.name());
        submitEvt.setTimestamp(event.getSubmitTime());
        atsEntity.addEvent(submitEvt);
        atsEntity.setStartTime(Long.valueOf(event.getSubmitTime()));
        atsEntity.addPrimaryFilter("user", (Object)event.getUser());
        atsEntity.addPrimaryFilter("dagName", (Object)event.getDAGName());
        atsEntity.addPrimaryFilter("applicationId", (Object)event.getApplicationId().toString());
        if (event.getDAGPlan().hasCallerContext() && event.getDAGPlan().getCallerContext().hasCallerId()) {
            DAGProtos.CallerContextProto callerContext = event.getDagPlan().getCallerContext();
            atsEntity.addPrimaryFilter("callerId", (Object)callerContext.getCallerId());
            atsEntity.addOtherInfo("callerId", (Object)callerContext.getCallerId());
            atsEntity.addOtherInfo("callerContext", (Object)callerContext.getContext());
        }
        if (event.getQueueName() != null) {
            atsEntity.addPrimaryFilter("queueName", (Object)event.getQueueName());
        }
        atsEntity.addOtherInfo("applicationId", (Object)event.getApplicationAttemptId().getApplicationId().toString());
        atsEntity.addOtherInfo("applicationAttemptId", (Object)event.getApplicationAttemptId().toString());
        atsEntity.addOtherInfo("user", (Object)event.getUser());
        atsEntity.addOtherInfo("amWebServiceVersion", (Object)"2");
        atsEntity.addOtherInfo("inProgressLogsURL_" + event.getApplicationAttemptId().getAttemptId(), (Object)event.getContainerLogs());
        if (event.getDAGPlan().hasCallerContext() && event.getDAGPlan().getCallerContext().hasCallerId() && event.getDAGPlan().getCallerContext().hasCallerType()) {
            atsEntity.addOtherInfo("callerId", (Object)event.getDAGPlan().getCallerContext().getCallerId());
            atsEntity.addOtherInfo("callerType", (Object)event.getDAGPlan().getCallerContext().getCallerType());
        }
        if (event.getQueueName() != null) {
            atsEntity.addOtherInfo("queueName", (Object)event.getQueueName());
        }
        return atsEntity;
    }

    private static TimelineEntity convertDAGSubmittedToDAGExtraInfoEntity(DAGSubmittedEvent event) {
        TimelineEntity atsEntity = new TimelineEntity();
        atsEntity.setEntityId(event.getDAGID().toString());
        atsEntity.setEntityType(EntityTypes.TEZ_DAG_EXTRA_INFO.name());
        atsEntity.addRelatedEntity(EntityTypes.TEZ_DAG_ID.name(), event.getDAGID().toString());
        TimelineEvent submitEvt = new TimelineEvent();
        submitEvt.setEventType(HistoryEventType.DAG_SUBMITTED.name());
        submitEvt.setTimestamp(event.getSubmitTime());
        atsEntity.addEvent(submitEvt);
        atsEntity.setStartTime(Long.valueOf(event.getSubmitTime()));
        try {
            atsEntity.addOtherInfo("dagPlan", (Object)DAGUtils.convertDAGPlanToATSMap((DAGProtos.DAGPlan)event.getDAGPlan()));
        }
        catch (IOException e) {
            throw new TezUncheckedException((Throwable)e);
        }
        return atsEntity;
    }

    private static TimelineEntity convertTaskAttemptFinishedEvent(TaskAttemptFinishedEvent event) {
        TimelineEntity atsEntity = new TimelineEntity();
        atsEntity.setEntityId(event.getTaskAttemptID().toString());
        atsEntity.setEntityType(EntityTypes.TEZ_TASK_ATTEMPT_ID.name());
        atsEntity.addPrimaryFilter("applicationId", (Object)event.getApplicationId().toString());
        atsEntity.addPrimaryFilter(EntityTypes.TEZ_DAG_ID.name(), (Object)event.getDAGID().toString());
        atsEntity.addPrimaryFilter(EntityTypes.TEZ_VERTEX_ID.name(), (Object)event.getVertexID().toString());
        atsEntity.addPrimaryFilter(EntityTypes.TEZ_TASK_ID.name(), (Object)event.getTaskID().toString());
        TimelineEvent finishEvt = new TimelineEvent();
        finishEvt.setEventType(HistoryEventType.TASK_ATTEMPT_FINISHED.name());
        finishEvt.setTimestamp(event.getFinishTime());
        atsEntity.addEvent(finishEvt);
        atsEntity.addPrimaryFilter("status", (Object)event.getState().name());
        if (event.getTaskFailureType() != null) {
            atsEntity.addOtherInfo("taskFailureType", (Object)event.getTaskFailureType().name());
        }
        atsEntity.addOtherInfo("creationTime", (Object)event.getCreationTime());
        atsEntity.addOtherInfo("allocationTime", (Object)event.getAllocationTime());
        atsEntity.addOtherInfo("startTime", (Object)event.getStartTime());
        atsEntity.addOtherInfo("endTime", (Object)event.getFinishTime());
        if (event.getCreationCausalTA() != null) {
            atsEntity.addOtherInfo("creationCausalAttempt", (Object)event.getCreationCausalTA().toString());
        }
        atsEntity.addOtherInfo("timeTaken", (Object)(event.getFinishTime() - event.getStartTime()));
        atsEntity.addOtherInfo("status", (Object)event.getState().name());
        if (event.getTaskAttemptError() != null) {
            atsEntity.addOtherInfo("taskAttemptErrorEnum", (Object)event.getTaskAttemptError().name());
        }
        atsEntity.addOtherInfo("diagnostics", (Object)event.getDiagnostics());
        atsEntity.addOtherInfo("counters", (Object)DAGUtils.convertCountersToATSMap((TezCounters)event.getCounters()));
        if (event.getDataEvents() != null && !event.getDataEvents().isEmpty()) {
            atsEntity.addOtherInfo("lastDataEvents", (Object)DAGUtils.convertDataEventDependecyInfoToATS((List)event.getDataEvents()));
        }
        if (event.getNodeId() != null) {
            atsEntity.addOtherInfo("nodeId", (Object)event.getNodeId().toString());
        }
        if (event.getContainerId() != null) {
            atsEntity.addOtherInfo("containerId", (Object)event.getContainerId().toString());
        }
        if (event.getInProgressLogsUrl() != null) {
            atsEntity.addOtherInfo("inProgressLogsURL", (Object)event.getInProgressLogsUrl());
        }
        if (event.getCompletedLogsUrl() != null) {
            atsEntity.addOtherInfo("completedLogsURL", (Object)event.getCompletedLogsUrl());
        }
        if (event.getNodeHttpAddress() != null) {
            atsEntity.addOtherInfo("nodeHttpAddress", (Object)event.getNodeHttpAddress());
        }
        return atsEntity;
    }

    private static TimelineEntity convertTaskAttemptStartedEvent(TaskAttemptStartedEvent event) {
        TimelineEntity atsEntity = new TimelineEntity();
        atsEntity.setEntityId(event.getTaskAttemptID().toString());
        atsEntity.setEntityType(EntityTypes.TEZ_TASK_ATTEMPT_ID.name());
        atsEntity.setStartTime(Long.valueOf(event.getStartTime()));
        atsEntity.addRelatedEntity(EntityTypes.TEZ_TASK_ID.name(), event.getTaskID().toString());
        atsEntity.addPrimaryFilter("applicationId", (Object)event.getApplicationId().toString());
        atsEntity.addPrimaryFilter(EntityTypes.TEZ_DAG_ID.name(), (Object)event.getDAGID().toString());
        atsEntity.addPrimaryFilter(EntityTypes.TEZ_VERTEX_ID.name(), (Object)event.getVertexID().toString());
        atsEntity.addPrimaryFilter(EntityTypes.TEZ_TASK_ID.name(), (Object)event.getTaskID().toString());
        TimelineEvent startEvt = new TimelineEvent();
        startEvt.setEventType(HistoryEventType.TASK_ATTEMPT_STARTED.name());
        startEvt.setTimestamp(event.getStartTime());
        atsEntity.addEvent(startEvt);
        atsEntity.addOtherInfo("startTime", (Object)event.getStartTime());
        if (event.getInProgressLogsUrl() != null) {
            atsEntity.addOtherInfo("inProgressLogsURL", (Object)event.getInProgressLogsUrl());
        }
        if (event.getCompletedLogsUrl() != null) {
            atsEntity.addOtherInfo("completedLogsURL", (Object)event.getCompletedLogsUrl());
        }
        atsEntity.addOtherInfo("nodeId", (Object)event.getNodeId().toString());
        atsEntity.addOtherInfo("nodeHttpAddress", (Object)event.getNodeHttpAddress());
        atsEntity.addOtherInfo("containerId", (Object)event.getContainerId().toString());
        atsEntity.addOtherInfo("status", (Object)TaskAttemptState.RUNNING.name());
        return atsEntity;
    }

    private static TimelineEntity convertTaskFinishedEvent(TaskFinishedEvent event) {
        TimelineEntity atsEntity = new TimelineEntity();
        atsEntity.setEntityId(event.getTaskID().toString());
        atsEntity.setEntityType(EntityTypes.TEZ_TASK_ID.name());
        atsEntity.addPrimaryFilter("applicationId", (Object)event.getApplicationId().toString());
        atsEntity.addPrimaryFilter(EntityTypes.TEZ_DAG_ID.name(), (Object)event.getDAGID().toString());
        atsEntity.addPrimaryFilter(EntityTypes.TEZ_VERTEX_ID.name(), (Object)event.getVertexID().toString());
        TimelineEvent finishEvt = new TimelineEvent();
        finishEvt.setEventType(HistoryEventType.TASK_FINISHED.name());
        finishEvt.setTimestamp(event.getFinishTime());
        atsEntity.addEvent(finishEvt);
        atsEntity.addPrimaryFilter("status", (Object)event.getState().name());
        atsEntity.addOtherInfo("endTime", (Object)event.getFinishTime());
        atsEntity.addOtherInfo("timeTaken", (Object)(event.getFinishTime() - event.getStartTime()));
        atsEntity.addOtherInfo("status", (Object)event.getState().name());
        atsEntity.addOtherInfo("numFailedTaskAttempts", (Object)event.getNumFailedAttempts());
        if (event.getSuccessfulAttemptID() != null) {
            atsEntity.addOtherInfo("successfulAttemptId", (Object)event.getSuccessfulAttemptID().toString());
        }
        atsEntity.addOtherInfo("diagnostics", (Object)event.getDiagnostics());
        atsEntity.addOtherInfo("counters", (Object)DAGUtils.convertCountersToATSMap((TezCounters)event.getTezCounters()));
        return atsEntity;
    }

    private static TimelineEntity convertTaskStartedEvent(TaskStartedEvent event) {
        TimelineEntity atsEntity = new TimelineEntity();
        atsEntity.setEntityId(event.getTaskID().toString());
        atsEntity.setEntityType(EntityTypes.TEZ_TASK_ID.name());
        atsEntity.addRelatedEntity(EntityTypes.TEZ_VERTEX_ID.name(), event.getVertexID().toString());
        atsEntity.addPrimaryFilter("applicationId", (Object)event.getApplicationId().toString());
        atsEntity.addPrimaryFilter(EntityTypes.TEZ_DAG_ID.name(), (Object)event.getDAGID().toString());
        atsEntity.addPrimaryFilter(EntityTypes.TEZ_VERTEX_ID.name(), (Object)event.getVertexID().toString());
        TimelineEvent startEvt = new TimelineEvent();
        startEvt.setEventType(HistoryEventType.TASK_STARTED.name());
        startEvt.setTimestamp(event.getStartTime());
        atsEntity.addEvent(startEvt);
        atsEntity.setStartTime(Long.valueOf(event.getStartTime()));
        atsEntity.addOtherInfo("startTime", (Object)event.getStartTime());
        atsEntity.addOtherInfo("scheduledTime", (Object)event.getScheduledTime());
        atsEntity.addOtherInfo("status", (Object)event.getState().name());
        return atsEntity;
    }

    private static TimelineEntity convertVertexFinishedEvent(VertexFinishedEvent event) {
        Map vertexTaskStats;
        TimelineEntity atsEntity = new TimelineEntity();
        atsEntity.setEntityId(event.getVertexID().toString());
        atsEntity.setEntityType(EntityTypes.TEZ_VERTEX_ID.name());
        atsEntity.addPrimaryFilter("applicationId", (Object)event.getApplicationId().toString());
        atsEntity.addPrimaryFilter(EntityTypes.TEZ_DAG_ID.name(), (Object)event.getDAGID().toString());
        TimelineEvent finishEvt = new TimelineEvent();
        finishEvt.setEventType(HistoryEventType.VERTEX_FINISHED.name());
        finishEvt.setTimestamp(event.getFinishTime());
        atsEntity.addEvent(finishEvt);
        atsEntity.addPrimaryFilter("status", (Object)event.getState().name());
        atsEntity.addOtherInfo("vertexName", (Object)event.getVertexName());
        atsEntity.addOtherInfo("endTime", (Object)event.getFinishTime());
        atsEntity.addOtherInfo("timeTaken", (Object)(event.getFinishTime() - event.getStartTime()));
        atsEntity.addOtherInfo("status", (Object)event.getState().name());
        atsEntity.addOtherInfo("diagnostics", (Object)event.getDiagnostics());
        atsEntity.addOtherInfo("counters", (Object)DAGUtils.convertCountersToATSMap((TezCounters)event.getTezCounters()));
        atsEntity.addOtherInfo("stats", (Object)DAGUtils.convertVertexStatsToATSMap((VertexStats)event.getVertexStats()));
        if (event.getServicePluginInfo() != null) {
            atsEntity.addOtherInfo("servicePlugin", (Object)DAGUtils.convertServicePluginToATSMap((ServicePluginInfo)event.getServicePluginInfo()));
        }
        if ((vertexTaskStats = event.getVertexTaskStats()) != null) {
            for (Map.Entry entry : vertexTaskStats.entrySet()) {
                atsEntity.addOtherInfo((String)entry.getKey(), entry.getValue());
            }
        }
        return atsEntity;
    }

    private static TimelineEntity convertVertexInitializedEvent(VertexInitializedEvent event) {
        TimelineEntity atsEntity = new TimelineEntity();
        atsEntity.setEntityId(event.getVertexID().toString());
        atsEntity.setEntityType(EntityTypes.TEZ_VERTEX_ID.name());
        atsEntity.addRelatedEntity(EntityTypes.TEZ_DAG_ID.name(), event.getDAGID().toString());
        atsEntity.addPrimaryFilter("applicationId", (Object)event.getApplicationId().toString());
        atsEntity.addPrimaryFilter(EntityTypes.TEZ_DAG_ID.name(), (Object)event.getDAGID().toString());
        TimelineEvent initEvt = new TimelineEvent();
        initEvt.setEventType(HistoryEventType.VERTEX_INITIALIZED.name());
        initEvt.setTimestamp(event.getInitedTime());
        atsEntity.addEvent(initEvt);
        atsEntity.setStartTime(Long.valueOf(event.getInitedTime()));
        atsEntity.addOtherInfo("vertexName", (Object)event.getVertexName());
        atsEntity.addOtherInfo("initRequestedTime", (Object)event.getInitRequestedTime());
        atsEntity.addOtherInfo("initTime", (Object)event.getInitedTime());
        atsEntity.addOtherInfo("numTasks", (Object)event.getNumTasks());
        atsEntity.addOtherInfo("processorClassName", (Object)event.getProcessorName());
        if (event.getServicePluginInfo() != null) {
            atsEntity.addOtherInfo("servicePlugin", (Object)DAGUtils.convertServicePluginToATSMap((ServicePluginInfo)event.getServicePluginInfo()));
        }
        return atsEntity;
    }

    private static TimelineEntity convertVertexStartedEvent(VertexStartedEvent event) {
        TimelineEntity atsEntity = new TimelineEntity();
        atsEntity.setEntityId(event.getVertexID().toString());
        atsEntity.setEntityType(EntityTypes.TEZ_VERTEX_ID.name());
        atsEntity.addPrimaryFilter("applicationId", (Object)event.getApplicationId().toString());
        atsEntity.addPrimaryFilter(EntityTypes.TEZ_DAG_ID.name(), (Object)event.getDAGID().toString());
        TimelineEvent startEvt = new TimelineEvent();
        startEvt.setEventType(HistoryEventType.VERTEX_STARTED.name());
        startEvt.setTimestamp(event.getStartTime());
        atsEntity.addEvent(startEvt);
        atsEntity.addOtherInfo("startRequestedTime", (Object)event.getStartRequestedTime());
        atsEntity.addOtherInfo("startTime", (Object)event.getStartTime());
        atsEntity.addOtherInfo("status", (Object)event.getVertexState().toString());
        return atsEntity;
    }

    private static TimelineEntity convertVertexReconfigureDoneEvent(VertexConfigurationDoneEvent event) {
        TimelineEntity atsEntity = new TimelineEntity();
        atsEntity.setEntityId(event.getVertexID().toString());
        atsEntity.setEntityType(EntityTypes.TEZ_VERTEX_ID.name());
        atsEntity.addPrimaryFilter("applicationId", (Object)event.getApplicationId().toString());
        atsEntity.addPrimaryFilter(EntityTypes.TEZ_DAG_ID.name(), (Object)event.getDAGID().toString());
        TimelineEvent updateEvt = new TimelineEvent();
        updateEvt.setEventType(HistoryEventType.VERTEX_CONFIGURE_DONE.name());
        updateEvt.setTimestamp(event.getReconfigureDoneTime());
        HashMap<String, Serializable> eventInfo = new HashMap<String, Serializable>();
        if (event.getSourceEdgeProperties() != null && !event.getSourceEdgeProperties().isEmpty()) {
            HashMap<String, Map> updatedEdgeManagers = new HashMap<String, Map>();
            for (Map.Entry entry : event.getSourceEdgeProperties().entrySet()) {
                updatedEdgeManagers.put((String)entry.getKey(), DAGUtils.convertEdgeProperty((EdgeProperty)((EdgeProperty)entry.getValue())));
            }
            eventInfo.put("updatedEdgeManagers", updatedEdgeManagers);
        }
        eventInfo.put("numTasks", Integer.valueOf(event.getNumTasks()));
        updateEvt.setEventInfo(eventInfo);
        atsEntity.addEvent(updateEvt);
        atsEntity.addOtherInfo("numTasks", (Object)event.getNumTasks());
        return atsEntity;
    }
}

