/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.ats.acls;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntityGroupId;
import org.apache.tez.client.TezClient;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.HistoryLogLevel;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.logging.ats.ATSV15HistoryLoggingService;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.hadoop.shim.HadoopShim;
import org.apache.tez.runtime.library.processor.SleepProcessor;
import org.apache.tez.tests.MiniTezClusterWithTimeline;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestATSHistoryV15 {
    private static final Logger LOG = LoggerFactory.getLogger(TestATSHistoryV15.class);
    protected static MiniTezClusterWithTimeline mrrTezCluster = null;
    protected static MiniDFSCluster dfsCluster = null;
    private static String timelineAddress;
    private static Random random;
    private static Configuration conf;
    private static FileSystem remoteFs;
    private static String TEST_ROOT_DIR;
    private static Path atsActivePath;

    @BeforeClass
    public static void setup() throws IOException {
        try {
            conf.set("hdfs.minidfs.basedir", TEST_ROOT_DIR);
            dfsCluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).format(true).racks(null).build();
            remoteFs = dfsCluster.getFileSystem();
        }
        catch (IOException io) {
            throw new RuntimeException("problem starting mini dfs cluster", io);
        }
        if (mrrTezCluster == null) {
            try {
                mrrTezCluster = new MiniTezClusterWithTimeline(TestATSHistoryV15.class.getName(), 1, 1, 1, true);
                Configuration conf = new Configuration();
                conf.setBoolean("yarn.timeline-service.enabled", true);
                conf.set("yarn.timeline-service.leveldb-timeline-store.path", TEST_ROOT_DIR);
                conf.set("fs.defaultFS", remoteFs.getUri().toString());
                conf.setInt("yarn.nodemanager.delete.debug-delay-sec", 20000);
                atsActivePath = new Path("/tmp/ats/active/" + random.nextInt(100000));
                Path atsDonePath = new Path("/tmp/ats/done/" + random.nextInt(100000));
                conf.setDouble("yarn.timeline-service.version", 1.5);
                remoteFs.mkdirs(atsActivePath);
                remoteFs.mkdirs(atsDonePath);
                conf.setInt("dfs.replication", 1);
                conf.set("yarn.timeline-service.entity-group-fs-store.active-dir", remoteFs.resolvePath(atsActivePath).toString());
                conf.set("yarn.timeline-service.entity-group-fs-store.done-dir", remoteFs.resolvePath(atsDonePath).toString());
                mrrTezCluster.init(conf);
                mrrTezCluster.start();
            }
            catch (Throwable e) {
                LOG.info("Failed to start Mini Tez Cluster", e);
            }
        }
        if ((timelineAddress = mrrTezCluster.getConfig().get("yarn.timeline-service.webapp.address")) != null) {
            timelineAddress = timelineAddress.replace("0.0.0.0", "localhost");
        }
    }

    @AfterClass
    public static void tearDown() throws InterruptedException {
        LOG.info("Shutdown invoked");
        Thread.sleep(10000L);
        if (mrrTezCluster != null) {
            mrrTezCluster.stop();
            mrrTezCluster = null;
        }
        if (dfsCluster != null) {
            dfsCluster.shutdown();
            dfsCluster = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=50000L)
    public void testSimpleDAG() throws Exception {
        TezClient tezSession = null;
        String viewAcls = "nobody nobody_group";
        try {
            SleepProcessor.SleepProcessorConfig spConf = new SleepProcessor.SleepProcessorConfig(1);
            DAG dag = DAG.create((String)"TezSleepProcessor");
            Vertex vertex = Vertex.create((String)"SleepVertex", (ProcessorDescriptor)((ProcessorDescriptor)ProcessorDescriptor.create((String)SleepProcessor.class.getName()).setUserPayload(spConf.toUserPayload())), (int)1, (Resource)Resource.newInstance((int)256, (int)1));
            dag.addVertex(vertex);
            TezConfiguration tezConf = new TezConfiguration(mrrTezCluster.getConfig());
            tezConf.set("yarn.timeline-service.entity-group-fs-store.summary-entity-types", "TEZ_DAG_ID");
            tezConf.set("tez.am.view-acls", viewAcls);
            tezConf.set("tez.history.logging.service.class", ATSV15HistoryLoggingService.class.getName());
            Path remoteStagingDir = remoteFs.makeQualified(new Path("/tmp", String.valueOf(random.nextInt(100000))));
            remoteFs.mkdirs(remoteStagingDir);
            tezConf.set("tez.staging-dir", remoteStagingDir.toString());
            tezSession = TezClient.create((String)"TezSleepProcessor", (TezConfiguration)tezConf, (boolean)true);
            tezSession.start();
            ApplicationId applicationId = tezSession.getAppMasterApplicationId();
            DAGClient dagClient = tezSession.submitDAG(dag);
            DAGStatus dagStatus = dagClient.getDAGStatus(null);
            while (!dagStatus.isCompleted()) {
                LOG.info("Waiting for job to complete. Sleeping for 500ms. Current state: " + dagStatus.getState());
                Thread.sleep(500L);
                dagStatus = dagClient.getDAGStatus(null);
            }
            Assert.assertEquals((Object)DAGStatus.State.SUCCEEDED, (Object)dagStatus.getState());
            int count = this.verifyATSDataOnHDFS(atsActivePath, applicationId);
            Assert.assertEquals((String)("Count is: " + count), (long)2L, (long)count);
        }
        finally {
            if (tezSession != null) {
                tezSession.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testATSLogLevelNone() throws Exception {
        TezClient tezSession = null;
        String viewAcls = "nobody nobody_group";
        try {
            SleepProcessor.SleepProcessorConfig spConf = new SleepProcessor.SleepProcessorConfig(1);
            DAG dag = DAG.create((String)"TezSleepProcessor");
            Vertex vertex = Vertex.create((String)"SleepVertex", (ProcessorDescriptor)((ProcessorDescriptor)ProcessorDescriptor.create((String)SleepProcessor.class.getName()).setUserPayload(spConf.toUserPayload())), (int)1, (Resource)Resource.newInstance((int)256, (int)1));
            dag.addVertex(vertex);
            TezConfiguration tezConf = new TezConfiguration(mrrTezCluster.getConfig());
            tezConf.set("yarn.timeline-service.entity-group-fs-store.summary-entity-types", "TEZ_DAG_ID");
            tezConf.set("tez.am.view-acls", viewAcls);
            tezConf.set("tez.history.logging.service.class", ATSV15HistoryLoggingService.class.getName());
            Path remoteStagingDir = remoteFs.makeQualified(new Path("/tmp", String.valueOf(random.nextInt(100000))));
            remoteFs.mkdirs(remoteStagingDir);
            tezConf.set("tez.staging-dir", remoteStagingDir.toString());
            tezSession = TezClient.create((String)"TezSleepProcessor", (TezConfiguration)tezConf, (boolean)true);
            tezSession.start();
            ApplicationId applicationId = tezSession.getAppMasterApplicationId();
            dag.setHistoryLogLevel(HistoryLogLevel.NONE);
            DAGClient dagClient = tezSession.submitDAG(dag);
            DAGStatus dagStatus = dagClient.getDAGStatus(null);
            while (!dagStatus.isCompleted()) {
                LOG.info("Waiting for job to complete. Sleeping for 500ms. Current state: " + dagStatus.getState());
                Thread.sleep(500L);
                dagStatus = dagClient.getDAGStatus(null);
            }
            Assert.assertEquals((Object)DAGStatus.State.SUCCEEDED, (Object)dagStatus.getState());
            int count = this.verifyATSDataOnHDFS(atsActivePath, applicationId);
            Assert.assertEquals((String)("Count is: " + count), (long)1L, (long)count);
        }
        finally {
            if (tezSession != null) {
                tezSession.stop();
            }
        }
    }

    private int verifyATSDataOnHDFS(Path p, ApplicationId applicationId) throws IOException {
        int count = 0;
        RemoteIterator iter = remoteFs.listFiles(p, true);
        while (iter.hasNext()) {
            LocatedFileStatus f = (LocatedFileStatus)iter.next();
            LOG.info("Found file " + f.toString());
            if (f.isDirectory()) {
                count += this.verifyATSDataOnHDFS(f.getPath(), applicationId);
                continue;
            }
            if (!f.getPath().getName().contains("" + applicationId.getClusterTimestamp() + "_" + applicationId.getId())) continue;
            ++count;
        }
        return count;
    }

    @Test
    public void testGetGroupId() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1000L, (int)1);
        TezDAGID dagid = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        for (final HistoryEventType eventType : HistoryEventType.values()) {
            HistoryEvent historyEvent = new HistoryEvent(){

                public HistoryEventType getEventType() {
                    return eventType;
                }

                public boolean isRecoveryEvent() {
                    return false;
                }

                public boolean isHistoryEvent() {
                    return false;
                }

                public void toProtoStream(CodedOutputStream outputStream) throws IOException {
                }

                public void fromProtoStream(CodedInputStream inputStream) throws IOException {
                }
            };
            DAGHistoryEvent event = new DAGHistoryEvent(dagid, historyEvent);
            ATSV15HistoryLoggingService service = new ATSV15HistoryLoggingService();
            AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
            Mockito.when((Object)appContext.getApplicationID()).thenReturn((Object)appId);
            Mockito.when((Object)appContext.getHadoopShim()).thenReturn((Object)new HadoopShim(){});
            service.setAppContext(appContext);
            TimelineEntityGroupId grpId = service.getGroupId(event);
            Assert.assertNotNull((Object)grpId);
            Assert.assertEquals((Object)appId, (Object)grpId.getApplicationId());
            switch (eventType) {
                case AM_LAUNCHED: 
                case APP_LAUNCHED: 
                case AM_STARTED: 
                case CONTAINER_LAUNCHED: 
                case CONTAINER_STOPPED: {
                    Assert.assertEquals((Object)appId.toString(), (Object)grpId.getTimelineEntityGroupId());
                    break;
                }
                default: {
                    Assert.assertEquals((Object)dagid.toString(), (Object)grpId.getTimelineEntityGroupId());
                }
            }
            service.close();
        }
    }

    static {
        random = new Random();
        conf = new Configuration();
        TEST_ROOT_DIR = "target/" + TestATSHistoryV15.class.getName() + "-tmpDir";
    }
}

