/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.orderedgrouped;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.mockito.Mockito;

public class DummyCompressionCodec
implements CompressionCodec,
Configurable {
    @VisibleForTesting
    int createInputStreamCalled = 0;
    private Configuration conf;

    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return new DummyCompressionOutputStream(out);
    }

    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        return new DummyCompressionOutputStream(out);
    }

    public Class<? extends Compressor> getCompressorType() {
        return Compressor.class;
    }

    public Compressor createCompressor() {
        return (Compressor)Mockito.mock(Compressor.class);
    }

    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return new DummyCompressionInputStream(in);
    }

    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        ++this.createInputStreamCalled;
        return new DummyCompressionInputStream(in);
    }

    public Class<? extends Decompressor> getDecompressorType() {
        return Decompressor.class;
    }

    public Decompressor createDecompressor() {
        return (Decompressor)Mockito.mock(Decompressor.class);
    }

    public String getDefaultExtension() {
        return null;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    class DummyCompressionOutputStream
    extends CompressionOutputStream {
        protected DummyCompressionOutputStream(OutputStream out) {
            super(out);
        }

        public void write(int b) throws IOException {
            this.out.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        public void finish() throws IOException {
        }

        public void resetState() throws IOException {
        }
    }

    class DummyCompressionInputStream
    extends CompressionInputStream {
        protected DummyCompressionInputStream(InputStream in) throws IOException {
            super(in);
        }

        public int read() throws IOException {
            return this.in.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.in.read(b, off, len);
        }

        public void resetState() throws IOException {
        }
    }
}

