/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.sort.impl;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.runtime.api.OutputContext;
import org.apache.tez.runtime.api.OutputStatisticsReporter;
import org.apache.tez.runtime.api.TaskContext;
import org.apache.tez.runtime.api.impl.ExecutionContextImpl;
import org.apache.tez.runtime.library.api.TezRuntimeConfiguration;
import org.apache.tez.runtime.library.common.combine.Combiner;
import org.apache.tez.runtime.library.common.sort.impl.ExternalSorter;
import org.apache.tez.runtime.library.common.sort.impl.IFile;
import org.apache.tez.runtime.library.common.sort.impl.PipelinedSorter;
import org.apache.tez.runtime.library.common.sort.impl.TezIndexRecord;
import org.apache.tez.runtime.library.common.sort.impl.TezRawKeyValueIterator;
import org.apache.tez.runtime.library.common.sort.impl.TezSpillRecord;
import org.apache.tez.runtime.library.conf.OrderedPartitionedKVOutputConfig;
import org.apache.tez.runtime.library.partitioner.HashPartitioner;
import org.apache.tez.runtime.library.testutils.RandomTextGenerator;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;

public class TestPipelinedSorter {
    private static Configuration conf;
    private static FileSystem localFs;
    private static Path workDir;
    private static LocalDirAllocator dirAllocator;
    private OutputContext outputContext;
    private int numOutputs;
    private long initialAvailableMem;
    private static TreeMap<Text, Text> sortedDataMap;
    private static final Random RANDOM;
    int start = 32;
    int end = 123;
    int gap = this.end - this.start;

    @AfterClass
    public static void cleanup() throws IOException {
        localFs.delete(workDir, true);
    }

    @Before
    public void setup() throws IOException {
        conf = TestPipelinedSorter.getConf();
        ApplicationId appId = ApplicationId.newInstance((long)10000L, (int)1);
        TezCounters counters = new TezCounters();
        String uniqueId = UUID.randomUUID().toString();
        String auxiliaryService = conf.get("tez.am.shuffle.auxiliary-service.id", "mapreduce_shuffle");
        this.outputContext = TestPipelinedSorter.createMockOutputContext(counters, appId, uniqueId, auxiliaryService);
    }

    public static Configuration getConf() {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        conf.set("fs.permissions.umask-mode", "077");
        conf.set("tez.runtime.sorter.class", OrderedPartitionedKVOutputConfig.SorterImpl.PIPELINED.name());
        conf.set("tez.runtime.key.class", Text.class.getName());
        conf.set("tez.runtime.value.class", Text.class.getName());
        conf.set("tez.runtime.partitioner.class", HashPartitioner.class.getName());
        conf.setBoolean("tez.runtime.enable.final-merge.in.output", true);
        if (workDir != null) {
            String localDirs = workDir.toString();
            conf.setStrings("tez.runtime.framework.local.dirs", new String[]{localDirs});
        }
        return conf;
    }

    @After
    public void reset() throws IOException {
        TestPipelinedSorter.cleanup();
        localFs.mkdirs(workDir);
    }

    @Test
    public void basicTest() throws IOException {
        conf.setInt("tez.runtime.io.sort.mb", 5);
        this.basicTest(1, 100000, 100, 0xA00000L, 0x300000);
        this.verifyOutputPermissions(this.outputContext.getUniqueIdentifier());
    }

    @Test
    public void testWithoutPartitionStats() throws IOException {
        conf.setBoolean("tez.runtime.report.partition.stats", false);
        this.basicTest(1, 0, 0, 0xA00000L, 0x300000);
        conf.setBoolean("tez.runtime.report.partition.stats", true);
    }

    @Test
    public void testWithEmptyData() throws IOException {
        conf.setInt("tez.runtime.io.sort.mb", 5);
        this.basicTest(1, 0, 0, 0xA00000L, 0x300000);
    }

    @Test
    public void testEmptyDataWithPipelinedShuffle() throws IOException {
        this.numOutputs = 1;
        this.initialAvailableMem = 0x100000L;
        conf.setBoolean("tez.runtime.enable.final-merge.in.output", false);
        conf.setInt("tez.runtime.pipelined.sorter.min-block.size.in.mb", 1);
        PipelinedSorter sorter = new PipelinedSorter(this.outputContext, conf, this.numOutputs, this.initialAvailableMem);
        this.writeData((ExternalSorter)sorter, 0, 0x100000);
        Assert.assertTrue((sorter.finalOutputFile == null ? 1 : 0) != 0);
        TezCounter numShuffleChunks = this.outputContext.getCounters().findCounter((Enum)TaskCounter.SHUFFLE_CHUNK_COUNT);
        conf.setBoolean("tez.runtime.enable.final-merge.in.output", true);
    }

    @Test
    public void testEmptyPartitionsTwoSpillsNoEmptyEvents() throws Exception {
        this.testEmptyPartitionsHelper(2, false);
    }

    @Test
    public void testEmptyPartitionsTwoSpillsWithEmptyEvents() throws Exception {
        this.testEmptyPartitionsHelper(2, true);
    }

    @Test
    public void testEmptyPartitionsNoSpillsNoEmptyEvents() throws Exception {
        this.testEmptyPartitionsHelper(0, false);
    }

    @Test
    public void testEmptyPartitionsNoSpillsWithEmptyEvents() throws Exception {
        this.testEmptyPartitionsHelper(0, true);
    }

    public void testEmptyPartitionsHelper(int numKeys, boolean sendEmptyPartitionDetails) throws IOException, InterruptedException {
        int partitions;
        this.numOutputs = partitions = 50;
        this.initialAvailableMem = 0x100000L;
        conf.setBoolean("tez.runtime.empty.partitions.info-via-events.enabled", sendEmptyPartitionDetails);
        conf.setBoolean("tez.runtime.enable.final-merge.in.output", true);
        conf.setInt("tez.runtime.pipelined.sorter.min-block.size.in.mb", 1);
        PipelinedSorter sorter = new PipelinedSorter(this.outputContext, conf, partitions, this.initialAvailableMem);
        this.writeData((ExternalSorter)sorter, numKeys, 1000000);
        if (numKeys == 0) {
            Assert.assertTrue((sorter.getNumSpills() == 1 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((sorter.getNumSpills() == numKeys + 1 ? 1 : 0) != 0);
        }
        this.verifyCounters(sorter, this.outputContext);
        this.verifyOutputPermissions(this.outputContext.getUniqueIdentifier());
        Path indexFile = sorter.getFinalIndexFile();
        TezSpillRecord spillRecord = new TezSpillRecord(indexFile, conf);
        for (int i = 0; i < partitions; ++i) {
            TezIndexRecord tezIndexRecord = spillRecord.getIndex(i);
            if (tezIndexRecord.hasData()) continue;
            if (sendEmptyPartitionDetails) {
                Assert.assertEquals((String)("Unexpected raw length for " + i + "th partition"), (long)0L, (long)tezIndexRecord.getRawLength());
                continue;
            }
            Assert.assertEquals((String)("Unexpected raw length for " + i + "th partition"), (long)6L, (long)tezIndexRecord.getRawLength());
        }
    }

    @Test
    public void basicTestWithSmallBlockSize() throws IOException {
        this.basicTest(1, 5, 0x300000, 0xA00000L, 0x300000);
    }

    @Test
    public void testWithLargeKeyValue() throws IOException {
        this.basicTest(1, 5, 0xF00000, 0x3000000L, 0x3000000);
    }

    @Test
    public void testKVExceedsBuffer() throws IOException {
        this.basicTest(1, 2, 0x100000, 0x100000L, 0x100000);
    }

    @Test
    public void testKVExceedsBuffer2() throws IOException {
        this.basicTest(1, 2, 0x100000, 0x100000L, 0x10000000);
    }

    @Test
    public void testExceedsKVWithMultiplePartitions() throws IOException {
        conf.setBoolean("tez.runtime.enable.final-merge.in.output", true);
        this.numOutputs = 5;
        this.initialAvailableMem = 0x100000L;
        conf.setInt("tez.runtime.pipelined.sorter.min-block.size.in.mb", 1);
        PipelinedSorter sorter = new PipelinedSorter(this.outputContext, conf, this.numOutputs, this.initialAvailableMem);
        this.writeData((ExternalSorter)sorter, 100, 0x100000);
        this.verifyCounters(sorter, this.outputContext);
        this.verifyOutputPermissions(this.outputContext.getUniqueIdentifier());
    }

    @Test
    public void testExceedsKVWithPipelinedShuffle() throws IOException {
        this.numOutputs = 1;
        this.initialAvailableMem = 0x100000L;
        conf.setBoolean("tez.runtime.enable.final-merge.in.output", false);
        conf.setInt("tez.runtime.pipelined.sorter.min-block.size.in.mb", 1);
        PipelinedSorter sorter = new PipelinedSorter(this.outputContext, conf, this.numOutputs, this.initialAvailableMem);
        this.writeData((ExternalSorter)sorter, 5, 0x100000);
        Assert.assertTrue((sorter.finalOutputFile == null ? 1 : 0) != 0);
        TezCounter numShuffleChunks = this.outputContext.getCounters().findCounter((Enum)TaskCounter.SHUFFLE_CHUNK_COUNT);
        Assert.assertTrue(((long)sorter.getNumSpills() == numShuffleChunks.getValue() ? 1 : 0) != 0);
        conf.setBoolean("tez.runtime.enable.final-merge.in.output", true);
    }

    @Test
    public void test_TEZ_2602_50mb() throws IOException {
        Text key;
        this.numOutputs = 1;
        this.initialAvailableMem = 0x100000L;
        conf.setBoolean("tez.runtime.enable.final-merge.in.output", true);
        conf.setInt("tez.runtime.pipelined.sorter.min-block.size.in.mb", 1);
        PipelinedSorter sorter = new PipelinedSorter(this.outputContext, conf, this.numOutputs, this.initialAvailableMem);
        Text value = new Text("1");
        for (long size = 0x3200000L; size > 0L; size -= (long)key.getLength()) {
            key = RandomTextGenerator.generateSentence();
            sorter.write((Object)key, (Object)value);
        }
        sorter.flush();
        sorter.close();
        this.verifyOutputPermissions(this.outputContext.getUniqueIdentifier());
    }

    public void testLargeDataWithMixedKV() throws IOException {
        this.numOutputs = 1;
        this.initialAvailableMem = 0x3000000L;
        conf.setBoolean("tez.runtime.enable.final-merge.in.output", true);
        PipelinedSorter sorter = new PipelinedSorter(this.outputContext, conf, this.numOutputs, this.initialAvailableMem);
        Text key = new Text(RandomStringUtils.randomAlphanumeric((int)0xA00000));
        Text value = new Text(RandomStringUtils.randomAlphanumeric((int)0xA00000));
        sorter.write((Object)key, (Object)value);
        key = new Text(RandomStringUtils.randomAlphanumeric((int)0x1800000));
        value = new Text(RandomStringUtils.randomAlphanumeric((int)0x1800000));
        sorter.write((Object)key, (Object)value);
        key = new Text(RandomStringUtils.randomAlphanumeric((int)0xA00000));
        value = new Text(RandomStringUtils.randomAlphanumeric((int)0xA00000));
        sorter.write((Object)key, (Object)value);
        sorter.flush();
        sorter.close();
        this.verifyOutputPermissions(this.outputContext.getUniqueIdentifier());
    }

    @Test
    public void testWithVariableKVLength1() throws IOException {
        int[] numkeys = new int[]{2, 2};
        int[] keylens = new int[]{0x2000000, 0x700000};
        this.basicTest2(1, numkeys, keylens, 0x4000000L, 0x2000000);
    }

    @Test
    public void testWithVariableKVLength() throws IOException {
        int[] numkeys = new int[]{2, 2};
        int[] keylens = new int[]{0x200000, 0x700000};
        this.basicTest2(1, numkeys, keylens, 0x4000000L, 0x2000000);
    }

    @Test
    public void testWithVariableKVLength2() throws IOException {
        int[] numkeys = new int[]{20, 10, 20};
        int[] keylens = new int[]{10240, 204800, 10240};
        this.basicTest2(1, numkeys, keylens, 0xA00000L, 2);
    }

    @Test
    public void testWithCustomComparator() throws IOException {
        conf.set("tez.runtime.key.comparator.class", CustomComparator.class.getName());
        this.basicTest(1, 100000, 100, 0xA00000L, 0x300000);
    }

    @Test
    public void testWithPipelinedShuffle() throws IOException {
        this.numOutputs = 1;
        this.initialAvailableMem = 0x500000L;
        conf.setInt("tez.runtime.io.sort.mb", 5);
        conf.setBoolean("tez.runtime.enable.final-merge.in.output", false);
        conf.setInt("tez.runtime.pipelined.sorter.min-block.size.in.mb", 1);
        PipelinedSorter sorter = new PipelinedSorter(this.outputContext, conf, this.numOutputs, this.initialAvailableMem);
        this.writeData((ExternalSorter)sorter, 10000, 100, false);
        sorter.flush();
        List events = sorter.close();
        Assert.assertTrue((sorter.finalOutputFile == null ? 1 : 0) != 0);
        conf.setBoolean("tez.runtime.enable.final-merge.in.output", true);
        ((OutputContext)Mockito.verify((Object)this.outputContext, (VerificationMode)VerificationModeFactory.times((int)0))).sendEvents((List)Mockito.any());
        Assert.assertTrue((events.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCountersWithMultiplePartitions() throws IOException {
        conf.setBoolean("tez.runtime.enable.final-merge.in.output", true);
        this.numOutputs = 5;
        this.initialAvailableMem = 0x500000L;
        conf.setInt("tez.runtime.pipelined.sorter.min-block.size.in.mb", 1);
        PipelinedSorter sorter = new PipelinedSorter(this.outputContext, conf, this.numOutputs, this.initialAvailableMem);
        this.writeData((ExternalSorter)sorter, 10000, 100);
        this.verifyCounters(sorter, this.outputContext);
        this.verifyOutputPermissions(this.outputContext.getUniqueIdentifier());
    }

    @Test
    public void testMultipleSpills() throws IOException {
        conf.setBoolean("tez.runtime.enable.final-merge.in.output", true);
        this.numOutputs = 5;
        this.initialAvailableMem = 0x500000L;
        conf.setInt("tez.runtime.pipelined.sorter.min-block.size.in.mb", 3);
        PipelinedSorter sorter = new PipelinedSorter(this.outputContext, conf, this.numOutputs, this.initialAvailableMem);
        this.writeData((ExternalSorter)sorter, 25000, 1000);
        Assert.assertFalse((String)"Expecting needsRLE to be false", (boolean)sorter.needsRLE());
        this.verifyCounters(sorter, this.outputContext);
        this.verifyOutputPermissions(this.outputContext.getUniqueIdentifier());
    }

    @Test
    public void testWithCombiner() throws IOException {
        conf.setBoolean("tez.runtime.enable.final-merge.in.output", true);
        conf.set("tez.runtime.combiner.class", DummyCombiner.class.getName());
        this.numOutputs = 5;
        this.initialAvailableMem = 0x500000L;
        conf.setInt("tez.runtime.pipelined.sorter.min-block.size.in.mb", 3);
        PipelinedSorter sorter = new PipelinedSorter(this.outputContext, conf, this.numOutputs, this.initialAvailableMem);
        this.writeData((ExternalSorter)sorter, 1, 20);
        Path outputFile = sorter.finalOutputFile;
        FileSystem fs = outputFile.getFileSystem(conf);
        IFile.Reader reader = new IFile.Reader(fs, outputFile, null, null, null, false, -1, 4096);
        this.verifyData(reader);
        reader.close();
        this.verifyCounters(sorter, this.outputContext);
        this.verifyOutputPermissions(this.outputContext.getUniqueIdentifier());
    }

    @Test
    public void testMultipleSpills_WithRLE() throws IOException {
        conf.setBoolean("tez.runtime.enable.final-merge.in.output", true);
        this.numOutputs = 5;
        this.initialAvailableMem = 0x500000L;
        conf.setInt("tez.runtime.pipelined.sorter.min-block.size.in.mb", 3);
        PipelinedSorter sorter = new PipelinedSorter(this.outputContext, conf, this.numOutputs, this.initialAvailableMem);
        this.writeSimilarKeys((ExternalSorter)sorter, 25000, 1000, true);
        Assert.assertTrue((String)"Expecting needsRLE to be true", (boolean)sorter.needsRLE());
        this.verifyCounters(sorter, this.outputContext);
        this.verifyOutputPermissions(this.outputContext.getUniqueIdentifier());
    }

    @Test
    public void basicTestForBufferUsage() throws IOException {
        this.numOutputs = 1;
        conf.setBoolean("tez.runtime.pipelined.sorter.lazy-allocate.memory", true);
        PipelinedSorter sorter = new PipelinedSorter(this.outputContext, conf, this.numOutputs, 0x6400000L);
        Assert.assertTrue((sorter.maxNumberOfBlocks >= 2 ? 1 : 0) != 0);
        for (int i = 0; i < 200; ++i) {
            this.writeData((ExternalSorter)sorter, 1, 0x100000, false);
        }
        int avg = (int)sorter.bufferUsage.stream().mapToDouble(d -> d.intValue()).average().orElse(0.0);
        for (int i = 0; i < sorter.bufferUsage.size(); ++i) {
            int usage = (Integer)sorter.bufferUsage.get(i);
            Assert.assertTrue((String)("Buffer index " + i + " is not used correctly.  usage: " + usage + ", avg: " + avg), (usage >= avg ? 1 : 0) != 0);
        }
        conf.setBoolean("tez.runtime.pipelined.sorter.lazy-allocate.memory", false);
    }

    public void basicTest2(int partitions, int[] numkeys, int[] keysize, long initialAvailableMem, int blockSize) throws IOException {
        this.numOutputs = partitions;
        conf.setInt("tez.runtime.pipelined.sorter.min-block.size.in.mb", 100);
        PipelinedSorter sorter = new PipelinedSorter(this.outputContext, conf, this.numOutputs, initialAvailableMem);
        this.writeData2((ExternalSorter)sorter, numkeys, keysize);
        this.verifyCounters(sorter, this.outputContext);
    }

    private void writeData2(ExternalSorter sorter, int[] numKeys, int[] keyLen) throws IOException {
        sortedDataMap.clear();
        int counter = 0;
        for (int numkey : numKeys) {
            int curKeyLen = keyLen[counter];
            char[] buffer = new char[curKeyLen];
            for (int i = 0; i < numkey; ++i) {
                Text random = new Text(this.randomAlphanumeric(buffer));
                sorter.write((Object)random, (Object)random);
            }
            ++counter;
        }
        sorter.flush();
        sorter.close();
        this.verifyOutputPermissions(this.outputContext.getUniqueIdentifier());
    }

    public void basicTest(int partitions, int numKeys, int keySize, long initialAvailableMem, int minBlockSize) throws IOException {
        this.numOutputs = partitions;
        conf.setInt("tez.runtime.pipelined.sorter.min-block.size.in.mb", minBlockSize >> 20);
        PipelinedSorter sorter = new PipelinedSorter(this.outputContext, conf, this.numOutputs, initialAvailableMem);
        this.writeData((ExternalSorter)sorter, numKeys, keySize);
        TezRuntimeConfiguration.ReportPartitionStats partitionStats = TezRuntimeConfiguration.ReportPartitionStats.fromString((String)conf.get("tez.runtime.report.partition.stats", TezRuntimeConfiguration.TEZ_RUNTIME_REPORT_PARTITION_STATS_DEFAULT));
        if (partitionStats.isEnabled()) {
            Assert.assertTrue((sorter.getPartitionStats() != null ? 1 : 0) != 0);
        }
        this.verifyCounters(sorter, this.outputContext);
        this.verifyOutputPermissions(this.outputContext.getUniqueIdentifier());
        Path outputFile = sorter.finalOutputFile;
        FileSystem fs = outputFile.getFileSystem(conf);
        TezCounter finalOutputBytes = this.outputContext.getCounters().findCounter((Enum)TaskCounter.OUTPUT_BYTES_PHYSICAL);
        if (finalOutputBytes.getValue() > 0L) {
            IFile.Reader reader = new IFile.Reader(fs, outputFile, null, null, null, false, -1, 4096);
            this.verifyData(reader);
            reader.close();
        }
        ((OutputContext)Mockito.verify((Object)this.outputContext, (VerificationMode)Mockito.atLeastOnce())).notifyProgress();
    }

    private void verifyCounters(PipelinedSorter sorter, OutputContext context) {
        TezCounter finalOutputBytes;
        TezCounter numShuffleChunks = context.getCounters().findCounter((Enum)TaskCounter.SHUFFLE_CHUNK_COUNT);
        TezCounter additionalSpills = context.getCounters().findCounter((Enum)TaskCounter.ADDITIONAL_SPILL_COUNT);
        TezCounter additionalSpillBytesWritten = context.getCounters().findCounter((Enum)TaskCounter.ADDITIONAL_SPILLS_BYTES_WRITTEN);
        TezCounter additionalSpillBytesRead = context.getCounters().findCounter((Enum)TaskCounter.ADDITIONAL_SPILLS_BYTES_READ);
        if (sorter.isFinalMergeEnabled()) {
            Assert.assertTrue((additionalSpills.getValue() == (long)(sorter.getNumSpills() - 1) ? 1 : 0) != 0);
            Assert.assertTrue((1L == numShuffleChunks.getValue() ? 1 : 0) != 0);
            if (sorter.getNumSpills() > 1) {
                Assert.assertTrue((additionalSpillBytesRead.getValue() > 0L ? 1 : 0) != 0);
                Assert.assertTrue((additionalSpillBytesWritten.getValue() > 0L ? 1 : 0) != 0);
            }
        } else {
            Assert.assertTrue((0L == additionalSpills.getValue() ? 1 : 0) != 0);
            Assert.assertTrue(((long)sorter.getNumSpills() == numShuffleChunks.getValue() ? 1 : 0) != 0);
            Assert.assertTrue((additionalSpillBytesRead.getValue() == 0L ? 1 : 0) != 0);
            Assert.assertTrue((additionalSpillBytesWritten.getValue() == 0L ? 1 : 0) != 0);
        }
        Assert.assertTrue(((finalOutputBytes = context.getCounters().findCounter((Enum)TaskCounter.OUTPUT_BYTES_PHYSICAL)).getValue() >= 0L ? 1 : 0) != 0);
        TezCounter outputBytesWithOverheadCounter = context.getCounters().findCounter((Enum)TaskCounter.OUTPUT_BYTES_WITH_OVERHEAD);
        Assert.assertTrue((outputBytesWithOverheadCounter.getValue() >= 0L ? 1 : 0) != 0);
    }

    @Test
    public void memTest() throws IOException {
        conf.setInt("tez.runtime.io.sort.mb", 3076);
        long size = ExternalSorter.getInitialMemoryRequirement((Configuration)conf, (long)0x100000000L);
        Assert.assertTrue((size == 0xC0400000L ? 1 : 0) != 0);
        this.initialAvailableMem = 0xA00000L;
        conf.setInt("tez.runtime.pipelined.sorter.min-block.size.in.mb", 1);
        PipelinedSorter sorter = new PipelinedSorter(this.outputContext, conf, this.numOutputs, this.initialAvailableMem);
        Assert.assertTrue((sorter.maxNumberOfBlocks == 10 ? 1 : 0) != 0);
        conf.setInt("tez.runtime.pipelined.sorter.min-block.size.in.mb", 3);
        sorter = new PipelinedSorter(this.outputContext, conf, this.numOutputs, this.initialAvailableMem);
        Assert.assertTrue((sorter.maxNumberOfBlocks == 3 ? 1 : 0) != 0);
        conf.setInt("tez.runtime.pipelined.sorter.min-block.size.in.mb", 10);
        sorter = new PipelinedSorter(this.outputContext, conf, this.numOutputs, this.initialAvailableMem);
        Assert.assertTrue((sorter.maxNumberOfBlocks == 1 ? 1 : 0) != 0);
        conf.setInt("tez.runtime.pipelined.sorter.min-block.size.in.mb", 10);
        sorter = new PipelinedSorter(this.outputContext, conf, this.numOutputs, this.initialAvailableMem);
        Assert.assertTrue((sorter.maxNumberOfBlocks == 1 ? 1 : 0) != 0);
        int blockSize = sorter.computeBlockSize(0L, 0xA00000L);
        Assert.assertTrue((blockSize == 0 ? 1 : 0) != 0);
        conf.setInt("tez.runtime.pipelined.sorter.min-block.size.in.mb", 200);
        sorter = new PipelinedSorter(this.outputContext, conf, this.numOutputs, 314572800L);
        Assert.assertTrue((sorter.maxNumberOfBlocks == 1 ? 1 : 0) != 0);
        blockSize = sorter.computeBlockSize(314572800L, 314572800L);
        Assert.assertTrue((blockSize == 314572800 ? 1 : 0) != 0);
        conf.setInt("tez.runtime.pipelined.sorter.min-block.size.in.mb", 3500);
        try {
            sorter = new PipelinedSorter(this.outputContext, conf, this.numOutputs, 314572800L);
        }
        catch (IllegalArgumentException iae) {
            Assert.assertTrue((boolean)iae.getMessage().contains("positive value between 0 and 2047"));
        }
        conf.setBoolean("tez.runtime.pipelined.sorter.lazy-allocate.memory", false);
        conf.setInt("tez.runtime.pipelined.sorter.min-block.size.in.mb", 32);
        sorter = new PipelinedSorter(this.outputContext, conf, this.numOutputs, 0x4000000L);
        Assert.assertTrue((sorter.maxNumberOfBlocks == 2 ? 1 : 0) != 0);
        blockSize = sorter.computeBlockSize(0x4000000L, 0x4000000L);
        Assert.assertTrue((blockSize == 0x2000000 ? 1 : 0) != 0);
        blockSize = sorter.computeBlockSize(0x2000000L, 0x4000000L);
        Assert.assertTrue((blockSize == 0x2000000 ? 1 : 0) != 0);
        blockSize = sorter.computeBlockSize(0x3000000L, 0x4000000L);
        Assert.assertTrue((blockSize == 0x3000000 ? 1 : 0) != 0);
        conf.setInt("tez.runtime.pipelined.sorter.min-block.size.in.mb", 8);
        sorter = new PipelinedSorter(this.outputContext, conf, this.numOutputs, 0x4000000L);
        Assert.assertTrue((sorter.maxNumberOfBlocks == 8 ? 1 : 0) != 0);
        blockSize = sorter.computeBlockSize(0x4000000L, 0x4000000L);
        Assert.assertTrue((blockSize == 0x800000 ? 1 : 0) != 0);
    }

    @Test
    public void test_without_lazyMemAllocation() throws IOException {
        this.numOutputs = 10;
        conf.setInt("tez.runtime.io.sort.mb", 128);
        conf.setInt("tez.runtime.pipelined.sorter.min-block.size.in.mb", 2000);
        conf.setBoolean("tez.runtime.pipelined.sorter.lazy-allocate.memory", false);
        PipelinedSorter sorter = new PipelinedSorter(this.outputContext, conf, this.numOutputs, 0x8000000L);
        Assert.assertTrue((String)("Expected 1 sort buffers. current len=" + sorter.buffers.size()), (sorter.buffers.size() == 1 ? 1 : 0) != 0);
        conf.setInt("tez.runtime.io.sort.mb", 128);
        conf.setInt("tez.runtime.pipelined.sorter.min-block.size.in.mb", 62);
        conf.setBoolean("tez.runtime.pipelined.sorter.lazy-allocate.memory", false);
        sorter = new PipelinedSorter(this.outputContext, conf, this.numOutputs, 0x8000000L);
        Assert.assertTrue((String)("Expected 2 sort buffers. current len=" + sorter.buffers.size()), (sorter.buffers.size() == 2 ? 1 : 0) != 0);
        conf.setInt("tez.runtime.io.sort.mb", 48);
        conf.setInt("tez.runtime.pipelined.sorter.min-block.size.in.mb", 62);
        conf.setBoolean("tez.runtime.pipelined.sorter.lazy-allocate.memory", false);
        sorter = new PipelinedSorter(this.outputContext, conf, this.numOutputs, 0x3000000L);
        Assert.assertTrue((String)("Expected 1 sort buffers. current len=" + sorter.buffers.size()), (sorter.buffers.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void test_with_lazyMemAllocation() throws IOException {
        this.numOutputs = 10;
        conf.setInt("tez.runtime.io.sort.mb", 128);
        conf.setBoolean("tez.runtime.pipelined.sorter.lazy-allocate.memory", true);
        PipelinedSorter sorter = new PipelinedSorter(this.outputContext, conf, this.numOutputs, 0x8000000L);
        Assert.assertTrue((String)("Expected 1 sort buffers. current len=" + sorter.buffers.size()), (sorter.buffers.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((ByteBuffer)sorter.buffers.get(0)).capacity() == 33554368 ? 1 : 0) != 0);
        this.writeData((ExternalSorter)sorter, 100, 0x100000, false);
        Assert.assertTrue((sorter.buffers.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((((ByteBuffer)sorter.buffers.get(0)).capacity() == 33554368 ? 1 : 0) != 0);
        Assert.assertTrue((((ByteBuffer)sorter.buffers.get(1)).capacity() == 0x6000040 ? 1 : 0) != 0);
        this.closeSorter((ExternalSorter)sorter);
        this.verifyCounters(sorter, this.outputContext);
        conf.setInt("tez.runtime.io.sort.mb", 300);
        conf.setBoolean("tez.runtime.pipelined.sorter.lazy-allocate.memory", true);
        sorter = new PipelinedSorter(this.outputContext, conf, this.numOutputs, 314572800L);
        Assert.assertTrue((sorter.buffers.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((ByteBuffer)sorter.buffers.get(0)).capacity() == 33554368 ? 1 : 0) != 0);
        this.writeData((ExternalSorter)sorter, 50, 0x100000, false);
        Assert.assertTrue((sorter.buffers.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((((ByteBuffer)sorter.buffers.get(0)).capacity() == 33554368 ? 1 : 0) != 0);
        Assert.assertTrue((((ByteBuffer)sorter.buffers.get(1)).capacity() == 281018432 ? 1 : 0) != 0);
        conf.setInt("tez.runtime.io.sort.mb", 48);
        conf.setBoolean("tez.runtime.pipelined.sorter.lazy-allocate.memory", true);
        sorter = new PipelinedSorter(this.outputContext, conf, this.numOutputs, 0x3000000L);
        Assert.assertTrue((String)("Expected 1 sort buffers. current len=" + sorter.buffers.size()), (sorter.buffers.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((ByteBuffer)sorter.buffers.get(0)).capacity() == 33554368 ? 1 : 0) != 0);
        this.writeData((ExternalSorter)sorter, 20, 0x100000, false);
        Assert.assertTrue((sorter.buffers.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((((ByteBuffer)sorter.buffers.get(0)).capacity() == 33554368 ? 1 : 0) != 0);
        Assert.assertTrue((((ByteBuffer)sorter.buffers.get(1)).capacity() == 0x1000040 ? 1 : 0) != 0);
        this.closeSorter((ExternalSorter)sorter);
    }

    @Test
    public void testLazyAllocateMem() throws IOException {
        PipelinedSorter iae2;
        this.numOutputs = 10;
        conf.setInt("tez.runtime.io.sort.mb", 128);
        conf.setBoolean("tez.runtime.pipelined.sorter.lazy-allocate.memory", false);
        conf.setInt("tez.runtime.pipelined.sorter.min-block.size.in.mb", 4500);
        try {
            PipelinedSorter pipelinedSorter = new PipelinedSorter(this.outputContext, conf, this.numOutputs, 4718592000L);
        }
        catch (IllegalArgumentException iae2) {
            Assert.assertTrue((boolean)iae2.getMessage().contains("tez.runtime.pipelined.sorter.min-block.size.in.mb"));
            Assert.assertTrue((boolean)iae2.getMessage().contains("value between 0 and 2047"));
        }
        conf.setInt("tez.runtime.pipelined.sorter.min-block.size.in.mb", -1);
        try {
            iae2 = new PipelinedSorter(this.outputContext, conf, this.numOutputs, 4718592000L);
        }
        catch (IllegalArgumentException iae3) {
            Assert.assertTrue((boolean)iae3.getMessage().contains("tez.runtime.pipelined.sorter.min-block.size.in.mb"));
            Assert.assertTrue((boolean)iae3.getMessage().contains("value between 0 and 2047"));
        }
        conf.setBoolean("tez.runtime.pipelined.sorter.lazy-allocate.memory", true);
        conf.setInt("tez.runtime.pipelined.sorter.min-block.size.in.mb", -1);
        try {
            iae2 = new PipelinedSorter(this.outputContext, conf, this.numOutputs, 4718592000L);
        }
        catch (IllegalArgumentException iae4) {
            Assert.assertTrue((boolean)iae4.getMessage().contains("tez.runtime.pipelined.sorter.min-block.size.in.mb"));
            Assert.assertTrue((boolean)iae4.getMessage().contains("value between 0 and 2047"));
        }
    }

    @Test
    public void testWithLargeKeyValueWithMinBlockSize() throws IOException {
        this.basicTest(1, 5, 0x200000, 0x3000000L, 0x1000000);
    }

    @Test
    public void testWithLargeRecordAndLowMemory() throws IOException {
        Text key;
        this.numOutputs = 1;
        this.initialAvailableMem = 0x100000L;
        conf.setBoolean("tez.runtime.enable.final-merge.in.output", true);
        conf.setInt("tez.runtime.pipelined.sorter.min-block.size.in.mb", 1);
        PipelinedSorter sorter = new PipelinedSorter(this.outputContext, conf, this.numOutputs, this.initialAvailableMem);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 3072; ++i) {
            builder.append("1");
        }
        Text value = new Text(builder.toString());
        for (long size = 0x3200000L; size > 0L; size -= (long)key.getLength()) {
            key = RandomTextGenerator.generateSentence();
            sorter.write((Object)key, (Object)value);
        }
        sorter.flush();
        sorter.close();
        this.verifyOutputPermissions(this.outputContext.getUniqueIdentifier());
    }

    private void verifyOutputPermissions(String spillId) throws IOException {
        String subpath = "output/" + spillId + "/" + "file.out";
        Path outputPath = dirAllocator.getLocalPathToRead(subpath, conf);
        Path indexPath = dirAllocator.getLocalPathToRead(subpath + ".index", conf);
        Assert.assertEquals((String)"Incorrect output permissions", (long)416L, (long)localFs.getFileStatus(outputPath).getPermission().toShort());
        Assert.assertEquals((String)"Incorrect index permissions", (long)416L, (long)localFs.getFileStatus(indexPath).getPermission().toShort());
    }

    private void writeData(ExternalSorter sorter, int numKeys, int keyLen) throws IOException {
        this.writeData(sorter, numKeys, keyLen, true);
    }

    private void writeSimilarKeys(ExternalSorter sorter, int numKeys, int keyLen, boolean autoClose) throws IOException {
        sortedDataMap.clear();
        char[] buffer = new char[keyLen];
        String keyStr = this.randomAlphanumeric(buffer);
        for (int i = 0; i < numKeys; ++i) {
            if (i % 4 == 0) {
                keyStr = this.randomAlphanumeric(buffer);
            }
            Text key = new Text(keyStr);
            Text value = new Text(RandomStringUtils.randomAlphanumeric((int)keyLen));
            sorter.write((Object)key, (Object)value);
            sortedDataMap.put(key, value);
        }
        if (autoClose) {
            this.closeSorter(sorter);
        }
    }

    private String randomAlphanumeric(char[] buffer) {
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = (char)(RANDOM.nextInt(this.gap) + this.start);
        }
        return new String(buffer);
    }

    private void writeData(ExternalSorter sorter, int numKeys, int keyLen, boolean autoClose) throws IOException {
        char[] buffer = new char[keyLen];
        sortedDataMap.clear();
        for (int i = 0; i < numKeys; ++i) {
            String randomStr = this.randomAlphanumeric(buffer);
            Text random = new Text(randomStr);
            sorter.write((Object)random, (Object)random);
            sortedDataMap.put(random, random);
        }
        if (autoClose) {
            this.closeSorter(sorter);
        }
    }

    private void closeSorter(ExternalSorter sorter) throws IOException {
        if (sorter != null) {
            sorter.flush();
            sorter.close();
        }
    }

    private void verifyData(IFile.Reader reader) throws IOException {
        Text readKey = new Text();
        Text readValue = new Text();
        DataInputBuffer keyIn = new DataInputBuffer();
        DataInputBuffer valIn = new DataInputBuffer();
        SerializationFactory serializationFactory = new SerializationFactory(conf);
        Deserializer keyDeserializer = serializationFactory.getDeserializer(Text.class);
        Deserializer valDeserializer = serializationFactory.getDeserializer(Text.class);
        keyDeserializer.open((InputStream)keyIn);
        valDeserializer.open((InputStream)valIn);
        int numRecordsRead = 0;
        for (Map.Entry<Text, Text> entry : sortedDataMap.entrySet()) {
            Text key = entry.getKey();
            Text val = entry.getValue();
            if (!reader.nextRawKey(keyIn)) continue;
            reader.nextRawValue(valIn);
            readKey = (Text)keyDeserializer.deserialize((Object)readKey);
            readValue = (Text)valDeserializer.deserialize((Object)readValue);
            Assert.assertTrue((boolean)key.equals((Object)readKey));
            Assert.assertTrue((boolean)val.equals((Object)readValue));
            ++numRecordsRead;
        }
        Assert.assertTrue((numRecordsRead == sortedDataMap.size() ? 1 : 0) != 0);
    }

    private static OutputContext createMockOutputContext(TezCounters counters, ApplicationId appId, String uniqueId, String auxiliaryService) throws IOException {
        OutputContext outputContext = (OutputContext)Mockito.mock(OutputContext.class);
        ExecutionContextImpl execContext = new ExecutionContextImpl("localhost");
        DataOutputBuffer serviceProviderMetaData = new DataOutputBuffer();
        serviceProviderMetaData.writeInt(80);
        ((OutputContext)Mockito.doReturn((Object)ByteBuffer.wrap(serviceProviderMetaData.getData())).when((Object)outputContext)).getServiceProviderMetaData(auxiliaryService);
        ((OutputContext)Mockito.doReturn((Object)execContext).when((Object)outputContext)).getExecutionContext();
        ((OutputContext)Mockito.doReturn((Object)Mockito.mock(OutputStatisticsReporter.class)).when((Object)outputContext)).getStatisticsReporter();
        ((OutputContext)Mockito.doReturn((Object)counters).when((Object)outputContext)).getCounters();
        ((OutputContext)Mockito.doReturn((Object)appId).when((Object)outputContext)).getApplicationId();
        ((OutputContext)Mockito.doReturn((Object)1).when((Object)outputContext)).getDAGAttemptNumber();
        ((OutputContext)Mockito.doReturn((Object)"dagName").when((Object)outputContext)).getDAGName();
        ((OutputContext)Mockito.doReturn((Object)"destinationVertexName").when((Object)outputContext)).getDestinationVertexName();
        ((OutputContext)Mockito.doReturn((Object)1).when((Object)outputContext)).getOutputIndex();
        ((OutputContext)Mockito.doReturn((Object)1).when((Object)outputContext)).getTaskAttemptNumber();
        ((OutputContext)Mockito.doReturn((Object)1).when((Object)outputContext)).getTaskIndex();
        ((OutputContext)Mockito.doReturn((Object)1).when((Object)outputContext)).getTaskVertexIndex();
        ((OutputContext)Mockito.doReturn((Object)"vertexName").when((Object)outputContext)).getTaskVertexName();
        ((OutputContext)Mockito.doReturn((Object)uniqueId).when((Object)outputContext)).getUniqueIdentifier();
        Path outDirBase = new Path(workDir, "outDir_" + uniqueId);
        String[] outDirs = new String[]{outDirBase.toString()};
        ((OutputContext)Mockito.doReturn((Object)outDirs).when((Object)outputContext)).getWorkDirs();
        return outputContext;
    }

    static {
        localFs = null;
        workDir = null;
        sortedDataMap = Maps.newTreeMap();
        conf = TestPipelinedSorter.getConf();
        try {
            localFs = FileSystem.getLocal((Configuration)conf);
            workDir = new Path(new Path(System.getProperty("test.build.data", "/tmp")), TestPipelinedSorter.class.getName()).makeQualified(localFs.getUri(), localFs.getWorkingDirectory());
            dirAllocator = new LocalDirAllocator("tez.runtime.framework.local.dirs");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        RANDOM = new Random();
    }

    public static class CustomComparator
    extends WritableComparator {
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            ByteBuffer bb1 = ByteBuffer.wrap(b1, s1, l1);
            ByteBuffer bb2 = ByteBuffer.wrap(b2, s2, l2);
            return bb1.compareTo(bb2);
        }
    }

    public static class DummyCombiner
    implements Combiner {
        public DummyCombiner(TaskContext ctx) {
        }

        public void combine(TezRawKeyValueIterator rawIter, IFile.Writer writer) throws InterruptedException, IOException {
            while (rawIter.next()) {
                writer.append(rawIter.getKey(), rawIter.getValue());
            }
        }
    }
}

