/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.task;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.tez.common.ContainerContext;
import org.apache.tez.common.TezTaskUmbilicalProtocol;
import org.apache.tez.runtime.task.ContainerReporter;
import org.apache.tez.runtime.task.TaskExecutionTestHelpers;
import org.junit.Assert;
import org.junit.Test;

public class TestContainerExecution {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testGetTaskShouldDie() throws InterruptedException, ExecutionException {
        ListeningExecutorService executor = null;
        try {
            ExecutorService rawExecutor = Executors.newFixedThreadPool(1);
            executor = MoreExecutors.listeningDecorator((ExecutorService)rawExecutor);
            ApplicationId appId = ApplicationId.newInstance((long)10000L, (int)1);
            ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
            ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)1);
            TaskExecutionTestHelpers.TezTaskUmbilicalForTest umbilical = new TaskExecutionTestHelpers.TezTaskUmbilicalForTest();
            ContainerContext containerContext = new ContainerContext(containerId.toString());
            ContainerReporter containerReporter = new ContainerReporter((TezTaskUmbilicalProtocol)umbilical, containerContext, 100);
            ListenableFuture getTaskFuture = executor.submit((Callable)containerReporter);
            getTaskFuture.get();
            Assert.assertEquals((long)1L, (long)umbilical.getTaskInvocations());
        }
        finally {
            executor.shutdownNow();
        }
    }
}

