/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.task;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.tez.common.ContainerContext;
import org.apache.tez.common.ContainerTask;
import org.apache.tez.common.TezTaskUmbilicalProtocol;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.api.AbstractLogicalIOProcessor;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.api.TaskFailureType;
import org.apache.tez.runtime.api.events.TaskAttemptCompletedEvent;
import org.apache.tez.runtime.api.events.TaskAttemptFailedEvent;
import org.apache.tez.runtime.api.events.TaskAttemptKilledEvent;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.runtime.api.impl.TezHeartbeatRequest;
import org.apache.tez.runtime.api.impl.TezHeartbeatResponse;
import org.apache.tez.runtime.task.TaskReporter;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TaskExecutionTestHelpers {
    public static final String HEARTBEAT_EXCEPTION_STRING = "HeartbeatException";

    private TaskExecutionTestHelpers() {
    }

    public static TezException createProcessorTezException() {
        return new TezException("TezException");
    }

    public static IOException createProcessorIOException() {
        return new IOException("IOException");
    }

    private static String getDiagnosticsWithoutNodeIp(String diagnostics) {
        String diagnosticsWithoutIP = diagnostics;
        if (diagnostics != null && diagnostics.startsWith("Node:")) {
            diagnosticsWithoutIP = diagnostics.substring(diagnostics.indexOf(" : ") + 3);
            String nodeIp = diagnostics.substring(5, diagnostics.indexOf(" : "));
            Assert.assertFalse((boolean)nodeIp.isEmpty());
        }
        return diagnosticsWithoutIP;
    }

    public static ContainerId createContainerId(ApplicationId appId) {
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        return ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)1);
    }

    public static TaskReporter createTaskReporter(ApplicationId appId, TezTaskUmbilicalForTest umbilical) {
        return new TaskReporter((TezTaskUmbilicalProtocol)umbilical, 100L, 1000L, 100, new AtomicLong(0L), TaskExecutionTestHelpers.createContainerId(appId).toString());
    }

    public static class TezTaskUmbilicalForTest
    implements TezTaskUmbilicalProtocol {
        private static final Logger LOG = LoggerFactory.getLogger(TezTaskUmbilicalForTest.class);
        private final List<TezEvent> requestEvents = new LinkedList<TezEvent>();
        private final ReentrantLock umbilicalLock = new ReentrantLock();
        private final Condition eventCondition = this.umbilicalLock.newCondition();
        private boolean pendingEvent = false;
        private boolean eventEnacted = false;
        private final AtomicInteger taskInvocations = new AtomicInteger(0);
        private boolean shouldThrowException = false;
        private boolean shouldSendDieSignal = false;

        public void signalThrowException() {
            this.umbilicalLock.lock();
            try {
                this.shouldThrowException = true;
                this.pendingEvent = true;
            }
            finally {
                this.umbilicalLock.unlock();
            }
        }

        public void signalSendShouldDie() {
            this.umbilicalLock.lock();
            try {
                this.shouldSendDieSignal = true;
                this.pendingEvent = true;
            }
            finally {
                this.umbilicalLock.unlock();
            }
        }

        public void awaitRegisteredEvent() throws InterruptedException {
            this.umbilicalLock.lock();
            try {
                if (this.eventEnacted) {
                    return;
                }
                LOG.info("Awaiting event");
                this.eventCondition.await();
            }
            finally {
                this.umbilicalLock.unlock();
            }
        }

        public void resetTrackedEvents() {
            this.umbilicalLock.lock();
            try {
                this.requestEvents.clear();
            }
            finally {
                this.umbilicalLock.unlock();
            }
        }

        public void verifyNoCompletionEvents() {
            this.umbilicalLock.lock();
            try {
                for (TezEvent event : this.requestEvents) {
                    if (event.getEvent() instanceof TaskAttemptFailedEvent) {
                        Assert.fail((String)"Found a TaskAttemptFailedEvent when not expected");
                    }
                    if (!(event.getEvent() instanceof TaskAttemptCompletedEvent)) continue;
                    Assert.fail((String)"Found a TaskAttemptCompletedvent when not expected");
                }
            }
            finally {
                this.umbilicalLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void verifyTaskFailedEvent(String diagnostics) {
            this.umbilicalLock.lock();
            try {
                for (TezEvent event : this.requestEvents) {
                    if (!(event.getEvent() instanceof TaskAttemptFailedEvent)) continue;
                    TaskAttemptFailedEvent failedEvent = (TaskAttemptFailedEvent)event.getEvent();
                    if (failedEvent.getDiagnostics().startsWith(diagnostics)) {
                        return;
                    }
                    Assert.fail((String)("Diagnostic message does not match expected message. Found [" + failedEvent.getDiagnostics() + "], Expected: [" + diagnostics + "]"));
                }
                Assert.fail((String)"No TaskAttemptFailedEvents sent over umbilical");
            }
            finally {
                this.umbilicalLock.unlock();
            }
        }

        public void verifyTaskFailedEvent(String diagStart, String diagContains) {
            this.verifyTaskFailedEvent(diagStart, diagContains, TaskFailureType.NON_FATAL);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void verifyTaskFailedEvent(String diagStart, String diagContains, TaskFailureType taskFailureType) {
            this.umbilicalLock.lock();
            try {
                for (TezEvent event : this.requestEvents) {
                    if (!(event.getEvent() instanceof TaskAttemptFailedEvent)) continue;
                    TaskAttemptFailedEvent failedEvent = (TaskAttemptFailedEvent)event.getEvent();
                    String diagnostics = TaskExecutionTestHelpers.getDiagnosticsWithoutNodeIp(failedEvent.getDiagnostics());
                    if (diagnostics.startsWith(diagStart)) {
                        if (diagContains == null) continue;
                        if (diagnostics.contains(diagContains)) {
                            Assert.assertEquals((Object)taskFailureType, (Object)failedEvent.getTaskFailureType());
                            return;
                        }
                        Assert.fail((String)("Diagnostic message does not contain expected message. Found [" + diagnostics + "], Expected: [" + diagContains + "]"));
                        continue;
                    }
                    Assert.fail((String)("Diagnostic message does not start with expected message. Found [" + diagnostics + "], Expected: [" + diagStart + "]"));
                }
                Assert.fail((String)"No TaskAttemptFailedEvents sent over umbilical");
            }
            finally {
                this.umbilicalLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void verifyTaskKilledEvent(String diagStart, String diagContains) {
            this.umbilicalLock.lock();
            try {
                for (TezEvent event : this.requestEvents) {
                    if (!(event.getEvent() instanceof TaskAttemptKilledEvent)) continue;
                    TaskAttemptKilledEvent killedEvent = (TaskAttemptKilledEvent)event.getEvent();
                    String diagnostics = TaskExecutionTestHelpers.getDiagnosticsWithoutNodeIp(killedEvent.getDiagnostics());
                    if (diagnostics.startsWith(diagStart)) {
                        if (diagContains == null) continue;
                        if (diagnostics.contains(diagContains)) {
                            return;
                        }
                        Assert.fail((String)("Diagnostic message does not contain expected message. Found [" + diagnostics + "], Expected: [" + diagContains + "]"));
                        continue;
                    }
                    Assert.fail((String)("Diagnostic message does not start with expected message. Found [" + diagnostics + "], Expected: [" + diagStart + "]"));
                }
                Assert.fail((String)"No TaskAttemptKilledEvents sent over umbilical");
            }
            finally {
                this.umbilicalLock.unlock();
            }
        }

        public void verifyTaskSuccessEvent() {
            this.umbilicalLock.lock();
            try {
                for (TezEvent event : this.requestEvents) {
                    if (!(event.getEvent() instanceof TaskAttemptCompletedEvent)) continue;
                    return;
                }
                Assert.fail((String)"No TaskAttemptFailedEvents sent over umbilical");
            }
            finally {
                this.umbilicalLock.unlock();
            }
        }

        public long getProtocolVersion(String protocol, long clientVersion) {
            return 0L;
        }

        public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) {
            return null;
        }

        public ContainerTask getTask(ContainerContext containerContext) throws IOException {
            this.taskInvocations.incrementAndGet();
            return new ContainerTask(null, true, null, null, false);
        }

        public boolean canCommit(TezTaskAttemptID taskid) throws IOException {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TezHeartbeatResponse heartbeat(TezHeartbeatRequest request) throws IOException, TezException {
            this.umbilicalLock.lock();
            if (request.getEvents() != null) {
                this.requestEvents.addAll(request.getEvents());
            }
            try {
                if (this.shouldThrowException) {
                    LOG.info("TestUmbilical throwing Exception");
                    throw new IOException(TaskExecutionTestHelpers.HEARTBEAT_EXCEPTION_STRING);
                }
                TezHeartbeatResponse response = new TezHeartbeatResponse();
                response.setLastRequestId(request.getRequestId());
                if (this.shouldSendDieSignal) {
                    LOG.info("TestUmbilical returning shouldDie=true");
                    response.setShouldDie();
                }
                TezHeartbeatResponse tezHeartbeatResponse = response;
                return tezHeartbeatResponse;
            }
            finally {
                if (this.pendingEvent) {
                    this.eventEnacted = true;
                    LOG.info("Signalling Event");
                    this.eventCondition.signal();
                }
                this.umbilicalLock.unlock();
            }
        }

        public int getTaskInvocations() {
            return this.taskInvocations.get();
        }
    }

    public static class TestProcessor
    extends AbstractLogicalIOProcessor {
        private static final int EMPTY = 0;
        private static final int THROW_IO_EXCEPTION = 1;
        private static final int THROW_TEZ_EXCEPTION = 2;
        private static final int SIGNAL_DEPRECATEDFATAL_AND_THROW = 3;
        private static final int SIGNAL_DEPRECATEDFATAL_AND_LOOP = 4;
        private static final int SIGNAL_DEPRECATEDFATAL_AND_COMPLETE = 5;
        private static final int SIGNAL_FATAL_AND_THROW = 6;
        private static final int SIGNAL_NON_FATAL_AND_THROW = 7;
        private static final int SELF_KILL_AND_COMPLETE = 8;
        public static final byte[] CONF_EMPTY = new byte[]{0};
        public static final byte[] CONF_THROW_IO_EXCEPTION = new byte[]{1};
        public static final byte[] CONF_THROW_TEZ_EXCEPTION = new byte[]{2};
        public static final byte[] CONF_SIGNAL_DEPRECATEDFATAL_AND_THROW = new byte[]{3};
        public static final byte[] CONF_SIGNAL_DEPRECATEDFATAL_AND_LOOP = new byte[]{4};
        public static final byte[] CONF_SIGNAL_DEPRECATEDFATAL_AND_COMPLETE = new byte[]{5};
        public static final byte[] CONF_SIGNAL_FATAL_AND_THROW = new byte[]{6};
        public static final byte[] CONF_SIGNAL_NON_FATAL_AND_THROW = new byte[]{7};
        public static final byte[] CONF_SELF_KILL_AND_COMPLETE = new byte[]{8};
        private static final Logger LOG = LoggerFactory.getLogger(TestProcessor.class);
        private static final ReentrantLock processorLock = new ReentrantLock();
        private static final Condition processorCondition = processorLock.newCondition();
        private static final Condition loopCondition = processorLock.newCondition();
        private static final Condition completionCondition = processorLock.newCondition();
        private static final Condition runningCondition = processorLock.newCondition();
        private static volatile boolean completed = false;
        private static volatile boolean running = false;
        private static volatile boolean looping = false;
        private static volatile boolean signalled = false;
        private static boolean receivedInterrupt = false;
        private static volatile boolean wasAborted = false;
        private boolean throwIOException = false;
        private boolean throwTezException = false;
        private boolean signalDeprecatedFatalAndThrow = false;
        private boolean signalDeprecatedFatalAndLoop = false;
        private boolean signalDeprecatedFatalAndComplete = false;
        private boolean signalFatalAndThrow = false;
        private boolean signalNonFatalAndThrow = false;
        private boolean selfKillAndComplete = false;

        public TestProcessor(ProcessorContext context) {
            super(context);
        }

        public void initialize() throws Exception {
            this.parseConf(this.getContext().getUserPayload().deepCopyAsArray());
        }

        public void handleEvents(List<Event> processorEvents) {
        }

        public void close() throws Exception {
        }

        private void parseConf(byte[] bytes) {
            byte b = bytes[0];
            this.throwIOException = b == 1;
            this.throwTezException = b == 2;
            this.signalDeprecatedFatalAndThrow = b == 3;
            this.signalDeprecatedFatalAndLoop = b == 4;
            this.signalDeprecatedFatalAndComplete = b == 5;
            this.signalFatalAndThrow = b == 6;
            this.signalNonFatalAndThrow = b == 7;
            this.selfKillAndComplete = b == 8;
        }

        public static void reset() {
            signalled = false;
            receivedInterrupt = false;
            completed = false;
            running = false;
            wasAborted = false;
        }

        public static void signal() {
            LOG.info("Signalled");
            processorLock.lock();
            try {
                signalled = true;
                processorCondition.signal();
            }
            finally {
                processorLock.unlock();
            }
        }

        public static void awaitStart() throws InterruptedException {
            LOG.info("Awaiting Process run");
            processorLock.lock();
            try {
                if (running) {
                    return;
                }
                runningCondition.await();
            }
            finally {
                processorLock.unlock();
            }
        }

        public static void awaitLoop() throws InterruptedException {
            LOG.info("Awaiting loop after signalling error");
            processorLock.lock();
            try {
                if (looping) {
                    return;
                }
                loopCondition.await();
            }
            finally {
                processorLock.unlock();
            }
        }

        public static void awaitCompletion() throws InterruptedException {
            LOG.info("Await completion");
            processorLock.lock();
            try {
                if (!completed) {
                    completionCondition.await();
                }
            }
            finally {
                processorLock.unlock();
            }
        }

        public static boolean wasInterrupted() {
            processorLock.lock();
            try {
                boolean bl = receivedInterrupt;
                return bl;
            }
            finally {
                processorLock.unlock();
            }
        }

        public static boolean wasAborted() {
            processorLock.lock();
            try {
                boolean bl = wasAborted;
                return bl;
            }
            finally {
                processorLock.unlock();
            }
        }

        public void abort() {
            wasAborted = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Map<String, LogicalInput> inputs, Map<String, LogicalOutput> outputs) throws Exception {
            block16: {
                processorLock.lock();
                running = true;
                runningCondition.signal();
                LOG.info("Signal is: " + signalled);
                if (!signalled) {
                    LOG.info("Waiting for processor signal");
                    processorCondition.await();
                }
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                LOG.info("Received processor signal");
                if (this.throwIOException) {
                    throw TaskExecutionTestHelpers.createProcessorIOException();
                }
                if (this.throwTezException) {
                    throw TaskExecutionTestHelpers.createProcessorTezException();
                }
                if (this.signalDeprecatedFatalAndThrow) {
                    IOException io = new IOException(IOException.class.getSimpleName());
                    this.getContext().fatalError((Throwable)io, IOException.class.getSimpleName());
                    throw io;
                }
                if (!this.signalDeprecatedFatalAndComplete) break block16;
                IOException io = new IOException(IOException.class.getSimpleName());
                this.getContext().fatalError((Throwable)io, IOException.class.getSimpleName());
                completed = true;
                completionCondition.signal();
                processorLock.unlock();
                return;
            }
            try {
                try {
                    if (this.signalDeprecatedFatalAndLoop) {
                        IOException io = TaskExecutionTestHelpers.createProcessorIOException();
                        this.getContext().fatalError((Throwable)io, IOException.class.getSimpleName());
                        LOG.info("looping");
                        looping = true;
                        loopCondition.signal();
                        LOG.info("Waiting for Processor signal again");
                        processorCondition.await();
                        LOG.info("Received second processor signal");
                    } else {
                        if (this.signalFatalAndThrow) {
                            IOException io = new IOException(IOException.class.getSimpleName());
                            this.getContext().reportFailure(TaskFailureType.FATAL, (Throwable)io, IOException.class.getSimpleName());
                            LOG.info("throwing");
                            throw io;
                        }
                        if (this.signalNonFatalAndThrow) {
                            IOException io = new IOException(IOException.class.getSimpleName());
                            this.getContext().reportFailure(TaskFailureType.NON_FATAL, (Throwable)io, IOException.class.getSimpleName());
                            LOG.info("throwing");
                            throw io;
                        }
                        if (this.selfKillAndComplete) {
                            LOG.info("Reporting kill self");
                            this.getContext().killSelf((Throwable)new IOException(IOException.class.getSimpleName()), "SELFKILL");
                            LOG.info("Returning");
                        }
                    }
                }
                catch (InterruptedException e) {
                    receivedInterrupt = true;
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                completed = true;
                completionCondition.signal();
                processorLock.unlock();
            }
        }
    }
}

