/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.tez.common.counters.AbstractCounters;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.apache.tez.runtime.api.impl.TaskStatistics;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.runtime.api.impl.TezUmbilical;
import org.apache.tez.runtime.metrics.TaskCounterUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RuntimeTask {
    protected final AtomicBoolean errorReported = new AtomicBoolean(false);
    protected float progress;
    protected final TezCounters tezCounters;
    private final Map<String, TezCounters> counterMap = Maps.newConcurrentMap();
    protected final TaskSpec taskSpec;
    protected final Configuration tezConf;
    protected final TezUmbilical tezUmbilical;
    protected final AtomicInteger eventCounter;
    protected final AtomicInteger nextFromEventId;
    protected final AtomicInteger nextPreRoutedEventId;
    private final AtomicBoolean taskDone;
    private final TaskCounterUpdater counterUpdater;
    private final TaskStatistics statistics;
    private final AtomicBoolean progressNotified = new AtomicBoolean(false);
    private final long lfsBytesWriteLimit;
    private static final Logger LOG = LoggerFactory.getLogger(RuntimeTask.class);
    protected final AtomicReference<State> state = new AtomicReference();

    protected RuntimeTask(TaskSpec taskSpec, Configuration tezConf, TezUmbilical tezUmbilical, String pid, boolean setupSysCounterUpdater) {
        this.taskSpec = taskSpec;
        this.tezConf = tezConf;
        this.tezUmbilical = tezUmbilical;
        this.tezCounters = new TezCounters();
        this.eventCounter = new AtomicInteger(0);
        this.nextFromEventId = new AtomicInteger(0);
        this.nextPreRoutedEventId = new AtomicInteger(0);
        this.progress = 0.0f;
        this.taskDone = new AtomicBoolean(false);
        this.statistics = new TaskStatistics();
        this.counterUpdater = setupSysCounterUpdater ? new TaskCounterUpdater(this.tezCounters, tezConf, pid) : null;
        this.lfsBytesWriteLimit = tezConf.getLong("tez.task.local-fs.write-limit.bytes", -1L);
    }

    public boolean isRunning() {
        return this.state.get() == State.RUNNING;
    }

    public TezCounters addAndGetTezCounter(String name) {
        TezCounters counter = new TezCounters();
        this.counterMap.put(name, counter);
        return counter;
    }

    public boolean hasInitialized() {
        return EnumSet.of(State.RUNNING, State.CLOSED).contains((Object)this.state.get());
    }

    public String getVertexName() {
        return this.taskSpec.getVertexName();
    }

    public void registerError() {
        this.errorReported.set(true);
    }

    public final void notifyProgressInvocation() {
        this.progressNotified.lazySet(true);
    }

    public boolean getAndClearProgressNotification() {
        boolean retVal = this.progressNotified.getAndSet(false);
        return retVal;
    }

    public boolean wasErrorReported() {
        return this.errorReported.get();
    }

    public synchronized void setProgress(float progress) {
        this.progress = progress;
    }

    public synchronized float getProgress() {
        return this.progress;
    }

    public TezCounters getCounters() {
        TezCounters fullCounters = new TezCounters();
        fullCounters.incrAllCounters((AbstractCounters)this.tezCounters);
        for (TezCounters counter : this.counterMap.values()) {
            fullCounters.incrAllCounters((AbstractCounters)counter);
        }
        return fullCounters;
    }

    public TaskStatistics getTaskStatistics() {
        return this.statistics;
    }

    public TezTaskAttemptID getTaskAttemptID() {
        return this.taskSpec.getTaskAttemptID();
    }

    public abstract int getMaxEventsToHandle();

    public abstract void handleEvents(Collection<TezEvent> var1);

    public int getEventCounter() {
        return this.eventCounter.get();
    }

    public int getNextFromEventId() {
        return this.nextFromEventId.get();
    }

    public int getNextPreRoutedEventId() {
        return this.nextPreRoutedEventId.get();
    }

    public void setNextFromEventId(int nextFromEventId) {
        this.nextFromEventId.set(nextFromEventId);
    }

    public void setNextPreRoutedEventId(int nextPreRoutedEventId) {
        this.nextPreRoutedEventId.set(nextPreRoutedEventId);
    }

    public boolean isTaskDone() {
        return this.taskDone.get();
    }

    public void setFrameworkCounters() {
        if (this.counterUpdater != null) {
            this.counterUpdater.updateCounters();
        }
    }

    protected void setTaskDone() {
        this.taskDone.set(true);
    }

    public abstract void abortTask();

    protected final boolean isUpdatingSystemCounters() {
        return this.counterUpdater != null;
    }

    public void checkTaskLimits() throws LocalWriteLimitException {
        if (this.lfsBytesWriteLimit >= 0L) {
            Long lfsBytesWritten = null;
            try {
                LocalFileSystem localFS = FileSystem.getLocal((Configuration)this.tezConf);
                lfsBytesWritten = FileSystem.getGlobalStorageStatistics().get(localFS.getScheme()).getLong("bytesWritten");
            }
            catch (IOException e) {
                LOG.warn("Could not get LocalFileSystem bytesWritten counter");
            }
            if (lfsBytesWritten != null && lfsBytesWritten > this.lfsBytesWriteLimit) {
                throw new LocalWriteLimitException("Too much write to local file system. current value is " + lfsBytesWritten + " the limit is " + this.lfsBytesWriteLimit);
            }
        }
    }

    protected static enum State {
        NEW,
        INITED,
        RUNNING,
        CLOSED;

    }

    public static class LocalWriteLimitException
    extends IOException {
        public LocalWriteLimitException(String str) {
            super(str);
        }
    }
}

