/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.task;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.tez.common.TezTaskUmbilicalProtocol;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.LogicalIOProcessorRuntimeTask;
import org.apache.tez.runtime.RuntimeTask;
import org.apache.tez.runtime.api.events.TaskStatusUpdateEvent;
import org.apache.tez.runtime.api.impl.InputSpec;
import org.apache.tez.runtime.api.impl.OutputSpec;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.apache.tez.runtime.api.impl.TaskStatistics;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.runtime.api.impl.TezHeartbeatRequest;
import org.apache.tez.runtime.api.impl.TezHeartbeatResponse;
import org.apache.tez.runtime.task.TaskReporter;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestTaskReporter {
    private static final File TEST_DIR = new File(System.getProperty("test.build.data"), TestTaskReporter.class.getName()).getAbsoluteFile();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testContinuousHeartbeatsOnMaxEvents() throws Exception {
        final Object lock = new Object();
        final AtomicBoolean hb2Done = new AtomicBoolean(false);
        int maxEvents = 5;
        TezTaskUmbilicalProtocol mockUmbilical = (TezTaskUmbilicalProtocol)Mockito.mock(TezTaskUmbilicalProtocol.class);
        ((TezTaskUmbilicalProtocol)Mockito.doAnswer((Answer)new Answer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                TezHeartbeatRequest request = (TezHeartbeatRequest)args[0];
                if (request.getRequestId() == 1L || request.getRequestId() == 2L) {
                    TezHeartbeatResponse response = new TezHeartbeatResponse(TestTaskReporter.this.createEvents(5));
                    response.setLastRequestId(request.getRequestId());
                    return response;
                }
                if (request.getRequestId() == 3L) {
                    TezHeartbeatResponse response = new TezHeartbeatResponse(TestTaskReporter.this.createEvents(1));
                    response.setLastRequestId(request.getRequestId());
                    Object object = lock;
                    synchronized (object) {
                        hb2Done.set(true);
                        lock.notify();
                    }
                    return response;
                }
                throw new TezUncheckedException("Invalid request id for test: " + request.getRequestId());
            }
        }).when((Object)mockUmbilical)).heartbeat((TezHeartbeatRequest)Mockito.any());
        TezTaskAttemptID mockTaskAttemptId = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        LogicalIOProcessorRuntimeTask mockTask = (LogicalIOProcessorRuntimeTask)Mockito.mock(LogicalIOProcessorRuntimeTask.class);
        ((LogicalIOProcessorRuntimeTask)Mockito.doReturn((Object)"vertexName").when((Object)mockTask)).getVertexName();
        ((LogicalIOProcessorRuntimeTask)Mockito.doReturn((Object)mockTaskAttemptId).when((Object)mockTask)).getTaskAttemptID();
        TaskReporter.HeartbeatCallable heartbeatCallable = new TaskReporter.HeartbeatCallable((RuntimeTask)mockTask, mockUmbilical, 100000L, 100000L, 5, new AtomicLong(0L), "containerIdStr");
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.submit(heartbeatCallable);
        try {
            Object object = lock;
            synchronized (object) {
                if (!hb2Done.get()) {
                    lock.wait();
                }
            }
            ((TezTaskUmbilicalProtocol)Mockito.verify((Object)mockUmbilical, (VerificationMode)Mockito.times((int)3))).heartbeat((TezHeartbeatRequest)Mockito.any());
            Thread.sleep(200L);
            ((TezTaskUmbilicalProtocol)Mockito.verify((Object)mockUmbilical, (VerificationMode)Mockito.times((int)3))).heartbeat((TezHeartbeatRequest)Mockito.any());
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testEventThrottling() throws Exception {
        TezTaskAttemptID mockTaskAttemptId = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        LogicalIOProcessorRuntimeTask mockTask = (LogicalIOProcessorRuntimeTask)Mockito.mock(LogicalIOProcessorRuntimeTask.class);
        Mockito.when((Object)mockTask.getMaxEventsToHandle()).thenReturn((Object)10000, (Object[])new Integer[]{1});
        Mockito.when((Object)mockTask.getVertexName()).thenReturn((Object)"vertexName");
        Mockito.when((Object)mockTask.getTaskAttemptID()).thenReturn((Object)mockTaskAttemptId);
        TezTaskUmbilicalProtocol mockUmbilical = (TezTaskUmbilicalProtocol)Mockito.mock(TezTaskUmbilicalProtocol.class);
        TezHeartbeatResponse resp1 = new TezHeartbeatResponse(this.createEvents(5));
        resp1.setLastRequestId(1L);
        TezHeartbeatResponse resp2 = new TezHeartbeatResponse(this.createEvents(1));
        resp2.setLastRequestId(2L);
        resp2.setShouldDie();
        Mockito.when((Object)mockUmbilical.heartbeat((TezHeartbeatRequest)Mockito.isA(TezHeartbeatRequest.class))).thenReturn((Object)resp1, (Object[])new TezHeartbeatResponse[]{resp2});
        TaskReporter.HeartbeatCallable heartbeatCallable = new TaskReporter.HeartbeatCallable((RuntimeTask)mockTask, mockUmbilical, 100000L, 100000L, 5, new AtomicLong(0L), "containerIdStr");
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future result = executor.submit(heartbeatCallable);
            Assert.assertFalse((boolean)((Boolean)result.get()));
        }
        finally {
            executor.shutdownNow();
        }
        ArgumentCaptor captor = ArgumentCaptor.forClass(TezHeartbeatRequest.class);
        ((TezTaskUmbilicalProtocol)Mockito.verify((Object)mockUmbilical, (VerificationMode)Mockito.times((int)2))).heartbeat((TezHeartbeatRequest)captor.capture());
        TezHeartbeatRequest req = (TezHeartbeatRequest)captor.getValue();
        Assert.assertEquals((long)2L, (long)req.getRequestId());
        Assert.assertEquals((long)1L, (long)req.getMaxEvents());
    }

    @Test(timeout=5000L)
    public void testStatusUpdateAfterInitializationAndCounterFlag() {
        TezTaskAttemptID mockTaskAttemptId = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        LogicalIOProcessorRuntimeTask mockTask = (LogicalIOProcessorRuntimeTask)Mockito.mock(LogicalIOProcessorRuntimeTask.class);
        ((LogicalIOProcessorRuntimeTask)Mockito.doReturn((Object)"vertexName").when((Object)mockTask)).getVertexName();
        ((LogicalIOProcessorRuntimeTask)Mockito.doReturn((Object)mockTaskAttemptId).when((Object)mockTask)).getTaskAttemptID();
        boolean progressNotified = false;
        ((LogicalIOProcessorRuntimeTask)Mockito.doReturn((Object)progressNotified).when((Object)mockTask)).getAndClearProgressNotification();
        TezTaskUmbilicalProtocol mockUmbilical = (TezTaskUmbilicalProtocol)Mockito.mock(TezTaskUmbilicalProtocol.class);
        float progress = 0.5f;
        TaskStatistics stats = new TaskStatistics();
        TezCounters counters = new TezCounters();
        ((LogicalIOProcessorRuntimeTask)Mockito.doReturn((Object)Float.valueOf(progress)).when((Object)mockTask)).getProgress();
        ((LogicalIOProcessorRuntimeTask)Mockito.doReturn((Object)stats).when((Object)mockTask)).getTaskStatistics();
        ((LogicalIOProcessorRuntimeTask)Mockito.doReturn((Object)counters).when((Object)mockTask)).getCounters();
        TaskReporter.HeartbeatCallable heartbeatCallable = new TaskReporter.HeartbeatCallable((RuntimeTask)mockTask, mockUmbilical, 100000L, 100000L, 5, new AtomicLong(0L), "containerIdStr");
        ((LogicalIOProcessorRuntimeTask)Mockito.doReturn((Object)false).when((Object)mockTask)).hasInitialized();
        TaskStatusUpdateEvent event = heartbeatCallable.getStatusUpdateEvent(true);
        ((LogicalIOProcessorRuntimeTask)Mockito.verify((Object)mockTask, (VerificationMode)Mockito.times((int)1))).hasInitialized();
        ((LogicalIOProcessorRuntimeTask)Mockito.verify((Object)mockTask, (VerificationMode)Mockito.times((int)0))).getProgress();
        ((LogicalIOProcessorRuntimeTask)Mockito.verify((Object)mockTask, (VerificationMode)Mockito.times((int)0))).getAndClearProgressNotification();
        ((LogicalIOProcessorRuntimeTask)Mockito.verify((Object)mockTask, (VerificationMode)Mockito.times((int)0))).getTaskStatistics();
        ((LogicalIOProcessorRuntimeTask)Mockito.verify((Object)mockTask, (VerificationMode)Mockito.times((int)0))).getCounters();
        Assert.assertEquals((float)0.0f, (float)event.getProgress(), (float)0.0f);
        Assert.assertEquals((Object)false, (Object)event.getProgressNotified());
        Assert.assertNull((Object)event.getCounters());
        Assert.assertNull((Object)event.getStatistics());
        ((LogicalIOProcessorRuntimeTask)Mockito.doReturn((Object)true).when((Object)mockTask)).hasInitialized();
        event = heartbeatCallable.getStatusUpdateEvent(false);
        ((LogicalIOProcessorRuntimeTask)Mockito.verify((Object)mockTask, (VerificationMode)Mockito.times((int)2))).hasInitialized();
        ((LogicalIOProcessorRuntimeTask)Mockito.verify((Object)mockTask, (VerificationMode)Mockito.times((int)1))).getProgress();
        ((LogicalIOProcessorRuntimeTask)Mockito.verify((Object)mockTask, (VerificationMode)Mockito.times((int)1))).getAndClearProgressNotification();
        ((LogicalIOProcessorRuntimeTask)Mockito.verify((Object)mockTask, (VerificationMode)Mockito.times((int)0))).getTaskStatistics();
        ((LogicalIOProcessorRuntimeTask)Mockito.verify((Object)mockTask, (VerificationMode)Mockito.times((int)0))).getCounters();
        Assert.assertEquals((float)progress, (float)event.getProgress(), (float)0.0f);
        Assert.assertEquals((Object)progressNotified, (Object)event.getProgressNotified());
        Assert.assertNull((Object)event.getCounters());
        Assert.assertNull((Object)event.getStatistics());
        progressNotified = true;
        ((LogicalIOProcessorRuntimeTask)Mockito.doReturn((Object)progressNotified).when((Object)mockTask)).getAndClearProgressNotification();
        ((LogicalIOProcessorRuntimeTask)Mockito.doReturn((Object)true).when((Object)mockTask)).hasInitialized();
        event = heartbeatCallable.getStatusUpdateEvent(true);
        ((LogicalIOProcessorRuntimeTask)Mockito.verify((Object)mockTask, (VerificationMode)Mockito.times((int)3))).hasInitialized();
        ((LogicalIOProcessorRuntimeTask)Mockito.verify((Object)mockTask, (VerificationMode)Mockito.times((int)2))).getProgress();
        ((LogicalIOProcessorRuntimeTask)Mockito.verify((Object)mockTask, (VerificationMode)Mockito.times((int)2))).getAndClearProgressNotification();
        ((LogicalIOProcessorRuntimeTask)Mockito.verify((Object)mockTask, (VerificationMode)Mockito.times((int)1))).getTaskStatistics();
        ((LogicalIOProcessorRuntimeTask)Mockito.verify((Object)mockTask, (VerificationMode)Mockito.times((int)1))).getCounters();
        Assert.assertEquals((float)progress, (float)event.getProgress(), (float)0.0f);
        Assert.assertEquals((Object)progressNotified, (Object)event.getProgressNotified());
        Assert.assertEquals((Object)counters, (Object)event.getCounters());
        Assert.assertEquals((Object)stats, (Object)event.getStatistics());
    }

    @Test
    public void testLocalFileSystemBytesWrittenLimit() throws IOException {
        TaskSpec mockSpec = (TaskSpec)Mockito.mock(TaskSpec.class);
        Mockito.when((Object)mockSpec.getInputs()).thenReturn(Collections.singletonList((InputSpec)Mockito.mock(InputSpec.class)));
        Mockito.when((Object)mockSpec.getOutputs()).thenReturn(Collections.singletonList((OutputSpec)Mockito.mock(OutputSpec.class)));
        TezConfiguration tezConf = new TezConfiguration();
        LogicalIOProcessorRuntimeTask lio1 = new LogicalIOProcessorRuntimeTask(mockSpec, 0, (Configuration)tezConf, null, null, null, null, null, null, "", null, Runtime.getRuntime().maxMemory(), true, null, null);
        LocalFileSystem localFS = FileSystem.getLocal((Configuration)tezConf);
        FileSystem.clearStatistics();
        Path tmpPath = new Path(TEST_DIR + "/testLocalFileSystemBytesWrittenLimit" + new Random(System.currentTimeMillis()).nextInt());
        try (FSDataOutputStream out = localFS.create(tmpPath, true);){
            out.write(new byte[1024]);
        }
        lio1.checkTaskLimits();
        tezConf.setLong("tez.task.local-fs.write-limit.bytes", 10L);
        lio1 = new LogicalIOProcessorRuntimeTask(mockSpec, 0, (Configuration)tezConf, null, null, null, null, null, null, "", null, Runtime.getRuntime().maxMemory(), true, null, null);
        try {
            lio1.checkTaskLimits();
            Assert.fail((String)"Expected to throw LocalWriteLimitException");
        }
        catch (RuntimeTask.LocalWriteLimitException localWriteLimitException) {
            Assert.assertTrue((boolean)localWriteLimitException.getMessage().contains("Too much write to local file system"));
        }
    }

    private List<TezEvent> createEvents(int numEvents) {
        ArrayList list = Lists.newArrayListWithCapacity((int)numEvents);
        for (int i = 0; i < numEvents; ++i) {
            list.add((TezEvent)Mockito.mock(TezEvent.class));
        }
        return list;
    }
}

