/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.metrics;

import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.runtime.metrics.TaskCounterUpdater;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTaskCounterUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(TestTaskCounterUpdater.class);
    private static final Configuration CONF = new Configuration();

    @Test
    public void basicTest() {
        TezCounters counters = new TezCounters();
        TaskCounterUpdater updater = new TaskCounterUpdater(counters, CONF, "pid");
        updater.updateCounters();
        LOG.info("Counters (after first update): {}", (Object)counters);
        this.assertCounter(counters, TaskCounter.GC_TIME_MILLIS);
        TezCounter cpuCounter = this.assertCounter(counters, TaskCounter.CPU_MILLISECONDS);
        long oldVal = cpuCounter.getValue();
        Assert.assertTrue((cpuCounter.getValue() > 0L ? 1 : 0) != 0);
        updater.updateCounters();
        LOG.info("Counters (after second update): {}", (Object)counters);
        Assert.assertTrue((String)("Counter not updated, old=" + oldVal + ", new=" + cpuCounter.getValue()), (cpuCounter.getValue() > oldVal ? 1 : 0) != 0);
    }

    private TezCounter assertCounter(TezCounters counters, TaskCounter taskCounter) {
        TezCounter counter = counters.findCounter((Enum)taskCounter);
        Assert.assertNotNull((Object)counter);
        return counter;
    }
}

