/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.metrics;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.tez.common.counters.FileSystemCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.runtime.metrics.TaskCounterUpdater;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFileSystemStatisticUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(TestFileSystemStatisticUpdater.class);
    private static MiniDFSCluster dfsCluster;
    private static final Configuration CONF;
    private static FileSystem remoteFs;
    private static final String TEST_ROOT_DIR;

    @BeforeClass
    public static void beforeClass() throws Exception {
        CONF.set("hdfs.minidfs.basedir", TEST_ROOT_DIR);
    }

    @AfterClass
    public static void tearDown() {
        if (dfsCluster != null) {
            dfsCluster.shutdown();
            dfsCluster = null;
        }
    }

    @Before
    public void setup() throws IOException {
        FileSystem.clearStatistics();
        try {
            if (dfsCluster != null) {
                dfsCluster.shutdown();
            }
            dfsCluster = new MiniDFSCluster.Builder(CONF).numDataNodes(2).build();
            remoteFs = dfsCluster.getFileSystem();
        }
        catch (IOException io) {
            throw new RuntimeException("problem starting mini dfs cluster", io);
        }
    }

    @Test
    public void basicTest() throws IOException {
        TezCounters counters = new TezCounters();
        TaskCounterUpdater updater = new TaskCounterUpdater(counters, CONF, "pid");
        DFSTestUtil.writeFile((FileSystem)remoteFs, (Path)new Path("/tmp/foo/abc.txt"), (String)"xyz");
        updater.updateCounters();
        LOG.info("Counters (after first update): {}", (Object)counters);
        this.assertCounter(counters, FileSystemCounter.OP_MKDIRS, 0);
        this.assertCounter(counters, FileSystemCounter.OP_CREATE, 1);
        this.assertCounter(counters, FileSystemCounter.BYTES_WRITTEN, 3);
        this.assertCounter(counters, FileSystemCounter.WRITE_OPS, 1);
        this.assertCounter(counters, FileSystemCounter.OP_GET_FILE_STATUS, 1);
        this.assertCounter(counters, FileSystemCounter.OP_CREATE, 1);
        DFSTestUtil.writeFile((FileSystem)remoteFs, (Path)new Path("/tmp/foo/abc1.txt"), (String)"xyz");
        updater.updateCounters();
        LOG.info("Counters (after second update): {}", (Object)counters);
        this.assertCounter(counters, FileSystemCounter.OP_CREATE, 2);
        this.assertCounter(counters, FileSystemCounter.BYTES_WRITTEN, 6);
        this.assertCounter(counters, FileSystemCounter.WRITE_OPS, 2);
        this.assertCounter(counters, FileSystemCounter.OP_GET_FILE_STATUS, 2);
        this.assertCounter(counters, FileSystemCounter.OP_CREATE, 2);
        updater.updateCounters();
        LOG.info("Counters (after third update): {}", (Object)counters);
        this.assertCounter(counters, FileSystemCounter.OP_CREATE, 2);
    }

    private void assertCounter(TezCounters counters, FileSystemCounter fsCounter, int value) {
        TezCounter counter = counters.findCounter(remoteFs.getScheme(), fsCounter);
        Assert.assertNotNull((Object)counter);
        Assert.assertEquals((long)value, (long)counter.getValue());
    }

    static {
        CONF = new Configuration();
        TEST_ROOT_DIR = "target/" + TestFileSystemStatisticUpdater.class.getName() + "-tmpDir";
    }
}

