/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.tez.runtime.InputReadyTracker;
import org.apache.tez.runtime.api.AbstractLogicalInput;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.Input;
import org.apache.tez.runtime.api.MergedInputContext;
import org.apache.tez.runtime.api.MergedLogicalInput;
import org.apache.tez.runtime.api.Reader;
import org.apache.tez.runtime.api.impl.TezMergedInputContextImpl;
import org.junit.Assert;
import org.junit.Test;

public class TestInputReadyTracker {
    private static final long SLEEP_TIME = 200L;

    @Test(timeout=20000L)
    public void testWithoutGrouping1() throws InterruptedException {
        InputReadyTracker inputReadyTracker = new InputReadyTracker();
        ImmediatelyReadyInputForTest input1 = new ImmediatelyReadyInputForTest(inputReadyTracker);
        ControlledReadyInputForTest input2 = new ControlledReadyInputForTest(inputReadyTracker);
        long startTime = 0L;
        long readyTime = 0L;
        ArrayList<AbstractLogicalInput> requestList = new ArrayList<AbstractLogicalInput>();
        requestList.add(input1);
        requestList.add(input2);
        Input readyInput = inputReadyTracker.waitForAnyInputReady(requestList);
        Assert.assertTrue((boolean)input1.isReady);
        Assert.assertFalse((boolean)input2.isReady);
        Assert.assertEquals((Object)((Object)input1), (Object)readyInput);
        startTime = System.nanoTime();
        this.setDelayedInputReady(input2);
        Assert.assertFalse((boolean)inputReadyTracker.waitForAllInputsReady(requestList, 0L));
        Assert.assertTrue((boolean)inputReadyTracker.waitForAllInputsReady(requestList, -1L));
        readyTime = System.nanoTime();
        Assert.assertTrue((boolean)input2.isReady);
        Assert.assertTrue((readyTime >= startTime + 200L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)input1.isReady);
    }

    @Test(timeout=20000L)
    public void testWithoutGrouping2() throws InterruptedException {
        InputReadyTracker inputReadyTracker = new InputReadyTracker();
        ControlledReadyInputForTest input1 = new ControlledReadyInputForTest(inputReadyTracker);
        ControlledReadyInputForTest input2 = new ControlledReadyInputForTest(inputReadyTracker);
        ControlledReadyInputForTest input3 = new ControlledReadyInputForTest(inputReadyTracker);
        long startTime = 0L;
        long readyTime = 0L;
        ArrayList<ControlledReadyInputForTest> requestList = new ArrayList<ControlledReadyInputForTest>();
        requestList.add(input1);
        requestList.add(input2);
        requestList.add(input3);
        startTime = System.nanoTime();
        this.setDelayedInputReady(input2);
        Input readyInput = inputReadyTracker.waitForAnyInputReady(requestList);
        Assert.assertEquals((Object)((Object)input2), (Object)readyInput);
        readyTime = System.nanoTime();
        Assert.assertTrue((boolean)input2.isReady);
        Assert.assertTrue((readyTime >= startTime + 200L ? 1 : 0) != 0);
        Assert.assertFalse((boolean)input1.isReady);
        Assert.assertFalse((boolean)input3.isReady);
        requestList = new ArrayList();
        requestList.add(input1);
        requestList.add(input3);
        startTime = System.nanoTime();
        this.setDelayedInputReady(input1);
        readyInput = inputReadyTracker.waitForAnyInputReady(requestList);
        Assert.assertEquals((Object)((Object)input1), (Object)readyInput);
        readyTime = System.nanoTime();
        Assert.assertTrue((boolean)input1.isReady);
        Assert.assertTrue((readyTime >= startTime + 200L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)input2.isReady);
        Assert.assertFalse((boolean)input3.isReady);
        requestList = new ArrayList();
        requestList.add(input3);
        startTime = System.nanoTime();
        this.setDelayedInputReady(input3);
        readyInput = inputReadyTracker.waitForAnyInputReady(requestList, 0L);
        Assert.assertNull((Object)readyInput);
        readyInput = inputReadyTracker.waitForAnyInputReady(requestList, -1L);
        Assert.assertEquals((Object)((Object)input3), (Object)readyInput);
        readyTime = System.nanoTime();
        Assert.assertTrue((boolean)input3.isReady);
        Assert.assertTrue((readyTime >= startTime + 200L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)input1.isReady);
        Assert.assertTrue((boolean)input2.isReady);
    }

    @Test(timeout=20000L)
    public void testGrouped() throws InterruptedException {
        InputReadyTracker inputReadyTracker = new InputReadyTracker();
        ImmediatelyReadyInputForTest input1 = new ImmediatelyReadyInputForTest(inputReadyTracker);
        ControlledReadyInputForTest input2 = new ControlledReadyInputForTest(inputReadyTracker);
        ImmediatelyReadyInputForTest input3 = new ImmediatelyReadyInputForTest(inputReadyTracker);
        ControlledReadyInputForTest input4 = new ControlledReadyInputForTest(inputReadyTracker);
        ArrayList<Input> group1Inputs = new ArrayList<Input>();
        group1Inputs.add((Input)input1);
        group1Inputs.add((Input)input2);
        ArrayList<Input> group2Inputs = new ArrayList<Input>();
        group2Inputs.add((Input)input3);
        group2Inputs.add((Input)input4);
        HashMap<String, MergedLogicalInput> mergedInputMap = new HashMap<String, MergedLogicalInput>();
        TezMergedInputContextImpl mergedInputContext1 = new TezMergedInputContextImpl(null, "group1", mergedInputMap, inputReadyTracker, null, null);
        TezMergedInputContextImpl mergedInputContext2 = new TezMergedInputContextImpl(null, "group2", mergedInputMap, inputReadyTracker, null, null);
        AnyOneMergedInputForTest group1 = new AnyOneMergedInputForTest((MergedInputContext)mergedInputContext1, group1Inputs);
        AllMergedInputForTest group2 = new AllMergedInputForTest((MergedInputContext)mergedInputContext2, group2Inputs);
        mergedInputMap.put("group1", group1);
        mergedInputMap.put("group2", group2);
        ArrayList groups = Lists.newArrayList((Object[])new MergedLogicalInput[]{group1, group2});
        inputReadyTracker.setGroupedInputs((Collection)groups);
        long startTime = 0L;
        long readyTime = 0L;
        ArrayList<MergedLogicalInput> requestList = new ArrayList<MergedLogicalInput>();
        requestList.add(group1);
        Input readyInput = inputReadyTracker.waitForAnyInputReady(requestList);
        Assert.assertTrue((boolean)group1.isReady);
        Assert.assertTrue((boolean)input1.isReady);
        Assert.assertFalse((boolean)input2.isReady);
        Assert.assertEquals((Object)((Object)group1), (Object)readyInput);
        requestList = new ArrayList();
        requestList.add(group2);
        startTime = System.nanoTime();
        this.setDelayedInputReady(input4);
        inputReadyTracker.waitForAllInputsReady(requestList);
        readyTime = System.nanoTime();
        Assert.assertTrue((boolean)group2.isReady);
        Assert.assertTrue((boolean)input3.isReady);
        Assert.assertTrue((boolean)input4.isReady);
        Assert.assertTrue((readyTime >= startTime + 200L ? 1 : 0) != 0);
    }

    private long setDelayedInputReady(final ControlledReadyInputForTest input) {
        long startTime = System.nanoTime();
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                input.setInputIsReady();
            }
        }.start();
        return startTime;
    }

    private static class ImmediatelyReadyInputForTest
    extends AbstractLogicalInput {
        private volatile boolean isReady = true;

        ImmediatelyReadyInputForTest(InputReadyTracker inputReadyTracker) {
            super(null, 0);
            inputReadyTracker.setInputIsReady((Input)this);
        }

        public List<Event> initialize() throws Exception {
            return null;
        }

        public void start() throws Exception {
        }

        public Reader getReader() throws Exception {
            return null;
        }

        public void handleEvents(List<Event> inputEvents) throws Exception {
        }

        public List<Event> close() throws Exception {
            return null;
        }
    }

    private static class ControlledReadyInputForTest
    extends AbstractLogicalInput {
        private volatile boolean isReady = false;
        private InputReadyTracker inputReadyTracker;

        ControlledReadyInputForTest(InputReadyTracker inputReadyTracker) {
            super(null, 0);
            this.inputReadyTracker = inputReadyTracker;
        }

        public List<Event> initialize() throws Exception {
            return null;
        }

        public void start() throws Exception {
        }

        public Reader getReader() throws Exception {
            return null;
        }

        public void handleEvents(List<Event> inputEvents) throws Exception {
        }

        public List<Event> close() throws Exception {
            return null;
        }

        public void setInputIsReady() {
            this.isReady = true;
            this.inputReadyTracker.setInputIsReady((Input)this);
        }
    }

    private static class AnyOneMergedInputForTest
    extends MergedLogicalInput {
        private volatile boolean isReady = false;

        public AnyOneMergedInputForTest(MergedInputContext context, List<Input> inputs) {
            super(context, inputs);
        }

        public Reader getReader() throws Exception {
            return null;
        }

        public void setConstituentInputIsReady(Input input) {
            this.isReady = true;
            this.informInputReady();
        }
    }

    private static class AllMergedInputForTest
    extends MergedLogicalInput {
        private volatile boolean isReady = false;
        private Set<Input> readyInputs = Sets.newHashSet();

        public AllMergedInputForTest(MergedInputContext context, List<Input> inputs) {
            super(context, inputs);
        }

        public Reader getReader() throws Exception {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setConstituentInputIsReady(Input input) {
            AllMergedInputForTest allMergedInputForTest = this;
            synchronized (allMergedInputForTest) {
                this.readyInputs.add(input);
            }
            if (this.readyInputs.size() == this.getInputs().size()) {
                this.isReady = true;
                this.informInputReady();
            }
        }
    }
}

