/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.output;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.common.TezExecutors;
import org.apache.tez.common.TezSharedExecutor;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DataSinkDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.hadoop.shim.DefaultHadoopShim;
import org.apache.tez.hadoop.shim.HadoopShim;
import org.apache.tez.mapreduce.TestUmbilical;
import org.apache.tez.mapreduce.TezTestUtils;
import org.apache.tez.mapreduce.common.Utils;
import org.apache.tez.mapreduce.output.MROutput;
import org.apache.tez.runtime.LogicalIOProcessorRuntimeTask;
import org.apache.tez.runtime.api.ExecutionContext;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.OutputContext;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.api.impl.ExecutionContextImpl;
import org.apache.tez.runtime.api.impl.OutputSpec;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.apache.tez.runtime.api.impl.TezUmbilical;
import org.apache.tez.runtime.library.api.KeyValueWriter;
import org.apache.tez.runtime.library.processor.SimpleProcessor;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;

public class TestMROutput {
    static File tmpDir;

    @BeforeClass
    public static void setupClass() {
        tmpDir = Files.createTempDir();
        tmpDir.deleteOnExit();
    }

    @Test(timeout=5000L)
    public void testNewAPI_TextOutputFormat() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("tez.mapreduce.is_map_processor", true);
        DataSinkDescriptor dataSink = MROutput.createConfigBuilder((Configuration)conf, org.apache.hadoop.mapreduce.lib.output.TextOutputFormat.class, (String)tmpDir.getPath()).build();
        OutputContext outputContext = this.createMockOutputContext(dataSink.getOutputDescriptor().getUserPayload(), new Configuration(false));
        MROutput output = new MROutput(outputContext, 2);
        output.initialize();
        Assert.assertEquals((Object)true, (Object)output.isMapperOutput);
        Assert.assertEquals((Object)true, (Object)output.useNewApi);
        Assert.assertEquals(org.apache.hadoop.mapreduce.lib.output.TextOutputFormat.class, output.newOutputFormat.getClass());
        Assert.assertNull((Object)output.oldOutputFormat);
        Assert.assertNotNull((Object)output.newApiTaskAttemptContext);
        Assert.assertNull((Object)output.oldApiTaskAttemptContext);
        Assert.assertNotNull((Object)output.newRecordWriter);
        Assert.assertNull((Object)output.oldRecordWriter);
        Assert.assertEquals(org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter.class, output.committer.getClass());
    }

    @Test
    public void testMergeConfig() throws Exception {
        String outputPath = "/tmp/output";
        Configuration localConf = new Configuration(false);
        localConf.set("local-key", "local-value");
        DataSinkDescriptor dataSink = MROutput.createConfigBuilder((Configuration)localConf, TextOutputFormat.class, (String)outputPath).build();
        Configuration baseConf = new Configuration(false);
        baseConf.set("base-key", "base-value");
        OutputContext outputContext = this.createMockOutputContext(dataSink.getOutputDescriptor().getUserPayload(), baseConf);
        MROutput output = new MROutput(outputContext, 2);
        output.initialize();
        JobConf mergedConf = output.jobConf;
        Assert.assertEquals((Object)"local-value", (Object)mergedConf.get("local-key"));
        Assert.assertEquals((Object)"base-value", (Object)mergedConf.get("base-key"));
    }

    @Test
    public void testJobUUIDSet() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("tez.mapreduce.is_map_processor", true);
        DataSinkDescriptor dataSink = MROutput.createConfigBuilder((Configuration)conf, org.apache.hadoop.mapreduce.lib.output.TextOutputFormat.class, (String)tmpDir.getPath()).build();
        OutputContext outputContext = this.createMockOutputContext(dataSink.getOutputDescriptor().getUserPayload(), new Configuration(false));
        MROutput output = new MROutput(outputContext, 2);
        output.initialize();
        String invalidDAGID = "invalid default";
        String dagID = output.jobConf.get("job.committer.uuid", invalidDAGID);
        Assert.assertNotEquals((Object)dagID, (Object)invalidDAGID);
        Assert.assertNotEquals((Object)output.jobConf.get("mapreduce.task.attempt.id"), (Object)dagID);
        Assert.assertEquals((Object)dagID, (Object)Utils.getDAGID((OutputContext)outputContext));
    }

    @Test(timeout=5000L)
    public void testOldAPI_TextOutputFormat() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("tez.mapreduce.is_map_processor", false);
        DataSinkDescriptor dataSink = MROutput.createConfigBuilder((Configuration)conf, TextOutputFormat.class, (String)tmpDir.getPath()).build();
        OutputContext outputContext = this.createMockOutputContext(dataSink.getOutputDescriptor().getUserPayload(), new Configuration(false));
        MROutput output = new MROutput(outputContext, 2);
        output.initialize();
        Assert.assertEquals((Object)false, (Object)output.isMapperOutput);
        Assert.assertEquals((Object)false, (Object)output.useNewApi);
        Assert.assertEquals(TextOutputFormat.class, output.oldOutputFormat.getClass());
        Assert.assertNull((Object)output.newOutputFormat);
        Assert.assertNotNull((Object)output.oldApiTaskAttemptContext);
        Assert.assertNull((Object)output.newApiTaskAttemptContext);
        Assert.assertNotNull((Object)output.oldRecordWriter);
        Assert.assertNull((Object)output.newRecordWriter);
        Assert.assertEquals(FileOutputCommitter.class, output.committer.getClass());
    }

    @Test(timeout=5000L)
    public void testNewAPI_SequenceFileOutputFormat() throws Exception {
        JobConf conf = new JobConf();
        conf.setOutputKeyClass(NullWritable.class);
        conf.setOutputValueClass(Text.class);
        DataSinkDescriptor dataSink = MROutput.createConfigBuilder((Configuration)conf, org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat.class, (String)tmpDir.getPath()).build();
        OutputContext outputContext = this.createMockOutputContext(dataSink.getOutputDescriptor().getUserPayload(), new Configuration(false));
        MROutput output = new MROutput(outputContext, 2);
        output.initialize();
        Assert.assertEquals((Object)true, (Object)output.useNewApi);
        Assert.assertEquals(org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat.class, output.newOutputFormat.getClass());
        Assert.assertNull((Object)output.oldOutputFormat);
        Assert.assertEquals(NullWritable.class, (Object)output.newApiTaskAttemptContext.getOutputKeyClass());
        Assert.assertEquals(Text.class, (Object)output.newApiTaskAttemptContext.getOutputValueClass());
        Assert.assertNull((Object)output.oldApiTaskAttemptContext);
        Assert.assertNotNull((Object)output.newRecordWriter);
        Assert.assertNull((Object)output.oldRecordWriter);
        Assert.assertEquals(org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter.class, output.committer.getClass());
    }

    @Test(timeout=5000L)
    public void testOldAPI_SequenceFileOutputFormat() throws Exception {
        JobConf conf = new JobConf();
        conf.setOutputKeyClass(NullWritable.class);
        conf.setOutputValueClass(Text.class);
        DataSinkDescriptor dataSink = MROutput.createConfigBuilder((Configuration)conf, SequenceFileOutputFormat.class, (String)tmpDir.getPath()).build();
        OutputContext outputContext = this.createMockOutputContext(dataSink.getOutputDescriptor().getUserPayload(), new Configuration(false));
        MROutput output = new MROutput(outputContext, 2);
        output.initialize();
        Assert.assertEquals((Object)false, (Object)output.useNewApi);
        Assert.assertEquals(SequenceFileOutputFormat.class, output.oldOutputFormat.getClass());
        Assert.assertNull((Object)output.newOutputFormat);
        Assert.assertEquals(NullWritable.class, (Object)output.oldApiTaskAttemptContext.getOutputKeyClass());
        Assert.assertEquals(Text.class, (Object)output.oldApiTaskAttemptContext.getOutputValueClass());
        Assert.assertNull((Object)output.newApiTaskAttemptContext);
        Assert.assertNotNull((Object)output.oldRecordWriter);
        Assert.assertNull((Object)output.newRecordWriter);
        Assert.assertEquals(FileOutputCommitter.class, output.committer.getClass());
    }

    @Test(timeout=5000L)
    public void testNewAPI_WorkOutputPathOutputFormat() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("tez.mapreduce.is_map_processor", true);
        DataSinkDescriptor dataSink = MROutput.createConfigBuilder((Configuration)conf, NewAPI_WorkOutputPathReadingOutputFormat.class, (String)tmpDir.getPath()).build();
        OutputContext outputContext = this.createMockOutputContext(dataSink.getOutputDescriptor().getUserPayload(), new Configuration(false));
        MROutput output = new MROutput(outputContext, 2);
        output.initialize();
        Assert.assertEquals((Object)true, (Object)output.isMapperOutput);
        Assert.assertEquals((Object)true, (Object)output.useNewApi);
        Assert.assertEquals(NewAPI_WorkOutputPathReadingOutputFormat.class, output.newOutputFormat.getClass());
        Assert.assertNull((Object)output.oldOutputFormat);
        Assert.assertNotNull((Object)output.newApiTaskAttemptContext);
        Assert.assertNull((Object)output.oldApiTaskAttemptContext);
        Assert.assertNotNull((Object)output.newRecordWriter);
        Assert.assertNull((Object)output.oldRecordWriter);
        Assert.assertEquals(org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter.class, output.committer.getClass());
    }

    @Test(timeout=5000L)
    public void testOldAPI_WorkOutputPathOutputFormat() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("tez.mapreduce.is_map_processor", false);
        DataSinkDescriptor dataSink = MROutput.createConfigBuilder((Configuration)conf, OldAPI_WorkOutputPathReadingOutputFormat.class, (String)tmpDir.getPath()).build();
        OutputContext outputContext = this.createMockOutputContext(dataSink.getOutputDescriptor().getUserPayload(), new Configuration(false));
        MROutput output = new MROutput(outputContext, 2);
        output.initialize();
        Assert.assertEquals((Object)false, (Object)output.isMapperOutput);
        Assert.assertEquals((Object)false, (Object)output.useNewApi);
        Assert.assertEquals(OldAPI_WorkOutputPathReadingOutputFormat.class, output.oldOutputFormat.getClass());
        Assert.assertNull((Object)output.newOutputFormat);
        Assert.assertNotNull((Object)output.oldApiTaskAttemptContext);
        Assert.assertNull((Object)output.newApiTaskAttemptContext);
        Assert.assertNotNull((Object)output.oldRecordWriter);
        Assert.assertNull((Object)output.newRecordWriter);
        Assert.assertEquals(FileOutputCommitter.class, output.committer.getClass());
    }

    private OutputContext createMockOutputContext(UserPayload payload, Configuration baseConf) {
        OutputContext outputContext = (OutputContext)Mockito.mock(OutputContext.class);
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        Mockito.when((Object)outputContext.getUserPayload()).thenReturn((Object)payload);
        Mockito.when((Object)outputContext.getApplicationId()).thenReturn((Object)appId);
        Mockito.when((Object)outputContext.getTaskVertexIndex()).thenReturn((Object)1);
        Mockito.when((Object)outputContext.getTaskAttemptNumber()).thenReturn((Object)1);
        Mockito.when((Object)outputContext.getCounters()).thenReturn((Object)new TezCounters());
        Mockito.when((Object)outputContext.getContainerConfiguration()).thenReturn((Object)baseConf);
        return outputContext;
    }

    public static LogicalIOProcessorRuntimeTask createLogicalTask(Configuration conf, TezUmbilical umbilical, String dagName, String vertexName, TezExecutors sharedExecutor) throws Exception {
        ProcessorDescriptor procDesc = ProcessorDescriptor.create((String)TestProcessor.class.getName());
        LinkedList inputSpecs = Lists.newLinkedList();
        LinkedList outputSpecs = Lists.newLinkedList();
        outputSpecs.add(new OutputSpec("Null", MROutput.createConfigBuilder((Configuration)conf, TestOutputFormat.class).build().getOutputDescriptor(), 1));
        TaskSpec taskSpec = new TaskSpec(TezTestUtils.getMockTaskAttemptId(0, 0, 0, 0), dagName, vertexName, -1, procDesc, (List)inputSpecs, (List)outputSpecs, null, null);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path workDir = new Path(new Path(System.getProperty("test.build.data", "/tmp")), "TestMapOutput").makeQualified(fs.getUri(), fs.getWorkingDirectory());
        return new LogicalIOProcessorRuntimeTask(taskSpec, 0, conf, new String[]{workDir.toString()}, umbilical, null, new HashMap(), (Multimap)HashMultimap.create(), null, "", (ExecutionContext)new ExecutionContextImpl("localhost"), Runtime.getRuntime().maxMemory(), true, (HadoopShim)new DefaultHadoopShim(), sharedExecutor);
    }

    @Ignore
    @Test
    public void testPerf() throws Exception {
        Configuration conf = new Configuration();
        TezSharedExecutor sharedExecutor = new TezSharedExecutor(conf);
        LogicalIOProcessorRuntimeTask task = TestMROutput.createLogicalTask(conf, new TestUmbilical(), "dag", "vertex", (TezExecutors)sharedExecutor);
        task.initialize();
        task.run();
        task.close();
        sharedExecutor.shutdownNow();
    }

    public static class NewAPI_WorkOutputPathReadingOutputFormat
    extends FileOutputFormat<String, String> {
        public RecordWriter<String, String> getRecordWriter(TaskAttemptContext job) throws IOException, InterruptedException {
            Path workOutputPath = this.getDefaultWorkFile(job, ".foo");
            Assert.assertNotNull((Object)workOutputPath);
            return new NoOpRecordWriter();
        }

        public static class NoOpRecordWriter
        extends RecordWriter<String, String> {
            public void write(String key, String value) throws IOException, InterruptedException {
            }

            public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            }
        }
    }

    public static class OldAPI_WorkOutputPathReadingOutputFormat
    extends org.apache.hadoop.mapred.FileOutputFormat<String, String> {
        public org.apache.hadoop.mapred.RecordWriter<String, String> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
            Path workOutputPath = org.apache.hadoop.mapred.FileOutputFormat.getWorkOutputPath((JobConf)job);
            Assert.assertNotNull((Object)workOutputPath);
            return new NoOpRecordWriter();
        }

        public static class NoOpRecordWriter
        implements org.apache.hadoop.mapred.RecordWriter<String, String> {
            public void write(String key, String value) throws IOException {
            }

            public void close(Reporter reporter) throws IOException {
            }
        }
    }

    public static class TestProcessor
    extends SimpleProcessor {
        public TestProcessor(ProcessorContext context) {
            super(context);
        }

        public void run() throws Exception {
            KeyValueWriter writer = (KeyValueWriter)((LogicalOutput)this.getOutputs().values().iterator().next()).getWriter();
            for (int i = 0; i < 1000000; ++i) {
                writer.write((Object)"key", (Object)"value");
            }
        }
    }

    public static class TestOutputFormat
    extends OutputFormat<String, String> {
        public RecordWriter<String, String> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
            return new TestRecordWriter(true);
        }

        public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        }

        public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
            return new TestOutputCommitter();
        }

        public static class TestRecordWriter
        extends RecordWriter<String, String> {
            Writer writer;
            boolean doWrite;

            TestRecordWriter(boolean write) throws IOException {
                this.doWrite = write;
                if (this.doWrite) {
                    File f = File.createTempFile("test", null);
                    f.deleteOnExit();
                    this.writer = new BufferedWriter(new FileWriter(f));
                }
            }

            public void write(String key, String value) throws IOException, InterruptedException {
                if (this.doWrite) {
                    this.writer.write(key);
                    this.writer.write(value);
                }
            }

            public void close(TaskAttemptContext context) throws IOException, InterruptedException {
                this.writer.close();
            }
        }
    }

    public static class TestOutputCommitter
    extends OutputCommitter {
        public void setupJob(JobContext jobContext) throws IOException {
        }

        public void setupTask(TaskAttemptContext taskContext) throws IOException {
        }

        public boolean needsTaskCommit(TaskAttemptContext taskContext) throws IOException {
            return false;
        }

        public void commitTask(TaskAttemptContext taskContext) throws IOException {
        }

        public void abortTask(TaskAttemptContext taskContext) throws IOException {
        }
    }
}

