/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.lib;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.mapreduce.lib.MRReaderMapReduce;
import org.apache.tez.mapreduce.lib.MRReaderMapred;
import org.apache.tez.runtime.api.InputContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestKVReadersWithMR {
    private JobConf conf;
    private TezCounters counters;
    private TezCounter inputRecordCounter;

    @Before
    public void setup() {
        this.conf = new JobConf();
        this.counters = new TezCounters();
        this.inputRecordCounter = this.counters.findCounter((Enum)TaskCounter.INPUT_RECORDS_PROCESSED);
    }

    @Test(timeout=10000L)
    public void testMRReaderMapred() throws IOException {
        this.testWithSpecificNumberOfKV(0);
        this.testWithSpecificNumberOfKV(10);
        this.testWithSpecificNumberOfKV_MapReduce(0);
        this.testWithSpecificNumberOfKV_MapReduce(10);
    }

    public void testWithSpecificNumberOfKV(int kvPairs) throws IOException {
        InputContext mockContext = (InputContext)Mockito.mock(InputContext.class);
        MRReaderMapred reader = new MRReaderMapred(this.conf, this.counters, this.inputRecordCounter, mockContext);
        reader.recordReader = new DummyRecordReader(kvPairs);
        int records = 0;
        while (reader.next()) {
            ((InputContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)(++records)))).notifyProgress();
        }
        Assert.assertTrue((kvPairs == records ? 1 : 0) != 0);
        try {
            boolean hasNext = reader.next();
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("For usage, please refer to"));
        }
    }

    public void testWithSpecificNumberOfKV_MapReduce(int kvPairs) throws IOException {
        InputContext mockContext = (InputContext)Mockito.mock(InputContext.class);
        MRReaderMapReduce reader = new MRReaderMapReduce(this.conf, this.counters, this.inputRecordCounter, -1L, 1, 10, 20, 30, mockContext);
        reader.recordReader = new DummyRecordReaderMapReduce(kvPairs);
        int records = 0;
        while (reader.next()) {
            ((InputContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)(++records)))).notifyProgress();
        }
        Assert.assertTrue((kvPairs == records ? 1 : 0) != 0);
        try {
            boolean hasNext = reader.next();
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("For usage, please refer to"));
        }
    }

    @Test
    public void testIncrementalConfigWithMultipleProperties() throws IOException {
        InputContext mockContext = (InputContext)Mockito.mock(InputContext.class);
        MRReaderMapred reader = new MRReaderMapred(this.conf, this.counters, this.inputRecordCounter, mockContext);
        this.conf.set("tez.mrreader.config.update.properties", "column.names,does_not_exist,column.ids");
        this.conf.set("column.names", "first_name,last_name,id");
        this.conf.set("column.ids", "1,2,3");
        this.conf.set("random", "value");
        Configuration incrementalConf = reader.getConfigUpdates();
        Assert.assertEquals((long)2L, (long)incrementalConf.size());
        Assert.assertEquals((Object)"first_name,last_name,id", (Object)incrementalConf.get("column.names"));
        Assert.assertEquals((Object)"1,2,3", (Object)incrementalConf.get("column.ids"));
    }

    @Test
    public void testIncrementalConfigWithSingleProperty() throws IOException {
        InputContext mockContext = (InputContext)Mockito.mock(InputContext.class);
        MRReaderMapred reader = new MRReaderMapred(this.conf, this.counters, this.inputRecordCounter, mockContext);
        this.conf.set("tez.mrreader.config.update.properties", "column.names");
        this.conf.set("column.names", "first_name,last_name,id");
        this.conf.set("random", "value");
        Configuration incrementalConf = reader.getConfigUpdates();
        Assert.assertEquals((long)1L, (long)incrementalConf.size());
        Assert.assertEquals((Object)"first_name,last_name,id", (Object)incrementalConf.get("column.names"));
    }

    @Test
    public void testIncrementalConfigWithZeroProperty() throws IOException {
        InputContext mockContext = (InputContext)Mockito.mock(InputContext.class);
        MRReaderMapred reader = new MRReaderMapred(this.conf, this.counters, this.inputRecordCounter, mockContext);
        this.conf.set("random", "value");
        Configuration incrementalConf = reader.getConfigUpdates();
        Assert.assertNull((Object)incrementalConf);
    }

    static class DummyRecordReader
    implements org.apache.hadoop.mapred.RecordReader {
        int records;

        public DummyRecordReader(int records) {
            this.records = records;
        }

        public boolean next(Object o, Object o2) throws IOException {
            return this.records-- > 0;
        }

        public Object createKey() {
            return null;
        }

        public Object createValue() {
            return null;
        }

        public long getPos() throws IOException {
            return 0L;
        }

        public void close() throws IOException {
        }

        public float getProgress() throws IOException {
            return 0.0f;
        }
    }

    static class DummyRecordReaderMapReduce
    extends RecordReader {
        int records;

        public DummyRecordReaderMapReduce(int records) {
            this.records = records;
        }

        public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            return this.records-- > 0;
        }

        public Object getCurrentKey() throws IOException, InterruptedException {
            return null;
        }

        public Object getCurrentValue() throws IOException, InterruptedException {
            return null;
        }

        public float getProgress() throws IOException, InterruptedException {
            return 0.0f;
        }

        public void close() throws IOException {
        }
    }
}

