/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.combine;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskCounter;
import org.apache.hadoop.util.Progress;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.mapreduce.combine.MRCombiner;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.api.TaskContext;
import org.apache.tez.runtime.library.common.sort.impl.IFile;
import org.apache.tez.runtime.library.common.sort.impl.TezRawKeyValueIterator;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestMRCombiner {
    @Test
    public void testRunOldCombiner() throws IOException, InterruptedException {
        TezConfiguration conf = new TezConfiguration();
        this.setKeyAndValueClassTypes(conf);
        conf.setClass("mapred.combiner.class", OldReducer.class, Object.class);
        TaskContext taskContext = this.getTaskContext(conf);
        MRCombiner combiner = new MRCombiner(taskContext);
        IFile.Writer writer = (IFile.Writer)Mockito.mock(IFile.Writer.class);
        combiner.combine((TezRawKeyValueIterator)new TezRawKeyValueIteratorTest(), writer);
        long inputRecords = taskContext.getCounters().findCounter((Enum)TaskCounter.COMBINE_INPUT_RECORDS).getValue();
        long outputRecords = taskContext.getCounters().findCounter((Enum)TaskCounter.COMBINE_OUTPUT_RECORDS).getValue();
        Assert.assertEquals((long)6L, (long)inputRecords);
        Assert.assertEquals((long)3L, (long)outputRecords);
        this.verifyKeyAndValues(writer);
    }

    @Test
    public void testRunNewCombiner() throws IOException, InterruptedException {
        TezConfiguration conf = new TezConfiguration();
        this.setKeyAndValueClassTypes(conf);
        conf.setBoolean("mapred.mapper.new-api", true);
        conf.setClass("mapreduce.job.combine.class", NewReducer.class, Object.class);
        TaskContext taskContext = this.getTaskContext(conf);
        MRCombiner combiner = new MRCombiner(taskContext);
        IFile.Writer writer = (IFile.Writer)Mockito.mock(IFile.Writer.class);
        combiner.combine((TezRawKeyValueIterator)new TezRawKeyValueIteratorTest(), writer);
        long inputRecords = taskContext.getCounters().findCounter((Enum)TaskCounter.COMBINE_INPUT_RECORDS).getValue();
        long outputRecords = taskContext.getCounters().findCounter((Enum)TaskCounter.COMBINE_OUTPUT_RECORDS).getValue();
        Assert.assertEquals((long)6L, (long)inputRecords);
        Assert.assertEquals((long)3L, (long)outputRecords);
        this.verifyKeyAndValues(writer);
    }

    @Test
    public void testTop2RunOldCombiner() throws IOException, InterruptedException {
        TezConfiguration conf = new TezConfiguration();
        this.setKeyAndValueClassTypes(conf);
        conf.setClass("mapred.combiner.class", Top2OldReducer.class, Object.class);
        TaskContext taskContext = this.getTaskContext(conf);
        MRCombiner combiner = new MRCombiner(taskContext);
        IFile.Writer writer = (IFile.Writer)Mockito.mock(IFile.Writer.class);
        combiner.combine((TezRawKeyValueIterator)new TezRawKeyValueIteratorTest(), writer);
        long inputRecords = taskContext.getCounters().findCounter((Enum)TaskCounter.COMBINE_INPUT_RECORDS).getValue();
        long outputRecords = taskContext.getCounters().findCounter((Enum)TaskCounter.COMBINE_OUTPUT_RECORDS).getValue();
        Assert.assertEquals((long)6L, (long)inputRecords);
        Assert.assertEquals((long)5L, (long)outputRecords);
    }

    @Test
    public void testTop2RunNewCombiner() throws IOException, InterruptedException {
        TezConfiguration conf = new TezConfiguration();
        this.setKeyAndValueClassTypes(conf);
        conf.setBoolean("mapred.mapper.new-api", true);
        conf.setClass("mapreduce.job.combine.class", Top2NewReducer.class, Object.class);
        TaskContext taskContext = this.getTaskContext(conf);
        MRCombiner combiner = new MRCombiner(taskContext);
        IFile.Writer writer = (IFile.Writer)Mockito.mock(IFile.Writer.class);
        combiner.combine((TezRawKeyValueIterator)new TezRawKeyValueIteratorTest(), writer);
        long inputRecords = taskContext.getCounters().findCounter((Enum)TaskCounter.COMBINE_INPUT_RECORDS).getValue();
        long outputRecords = taskContext.getCounters().findCounter((Enum)TaskCounter.COMBINE_OUTPUT_RECORDS).getValue();
        Assert.assertEquals((long)6L, (long)inputRecords);
        Assert.assertEquals((long)5L, (long)outputRecords);
    }

    private void setKeyAndValueClassTypes(TezConfiguration conf) {
        conf.setClass("tez.runtime.key.class", Text.class, Object.class);
        conf.setClass("tez.runtime.value.class", IntWritable.class, Object.class);
    }

    private TaskContext getTaskContext(TezConfiguration conf) throws IOException {
        UserPayload payload = TezUtils.createUserPayloadFromConf((Configuration)conf);
        TaskContext taskContext = (TaskContext)Mockito.mock(InputContext.class);
        Mockito.when((Object)taskContext.getUserPayload()).thenReturn((Object)payload);
        Mockito.when((Object)taskContext.getCounters()).thenReturn((Object)new TezCounters());
        Mockito.when((Object)taskContext.getApplicationId()).thenReturn((Object)ApplicationId.newInstance((long)123456L, (int)1));
        return taskContext;
    }

    private void verifyKeyAndValues(IFile.Writer writer) throws IOException {
        ((IFile.Writer)Mockito.verify((Object)writer, (VerificationMode)Mockito.atLeastOnce())).append((Object)new Text("tez"), (Object)new IntWritable(3));
        ((IFile.Writer)Mockito.verify((Object)writer, (VerificationMode)Mockito.atLeastOnce())).append((Object)new Text("apache"), (Object)new IntWritable(1));
        ((IFile.Writer)Mockito.verify((Object)writer, (VerificationMode)Mockito.atLeastOnce())).append((Object)new Text("hadoop"), (Object)new IntWritable(2));
    }

    private static class OldReducer
    implements org.apache.hadoop.mapred.Reducer<Text, IntWritable, Text, IntWritable> {
        private OldReducer() {
        }

        public void configure(JobConf arg0) {
        }

        public void close() throws IOException {
        }

        public void reduce(Text key, Iterator<IntWritable> value, OutputCollector<Text, IntWritable> collector, Reporter reporter) throws IOException {
            int count = 0;
            while (value.hasNext()) {
                count += value.next().get();
            }
            collector.collect((Object)new Text(key.toString()), (Object)new IntWritable(count));
        }
    }

    private static class TezRawKeyValueIteratorTest
    implements TezRawKeyValueIterator {
        private int i = -1;
        private String[] keys = new String[]{"tez", "tez", "tez", "apache", "hadoop", "hadoop"};

        private TezRawKeyValueIteratorTest() {
        }

        public boolean next() throws IOException {
            boolean hasNext = this.hasNext();
            if (hasNext) {
                ++this.i;
            }
            return hasNext;
        }

        public boolean hasNext() throws IOException {
            return this.i < this.keys.length - 1;
        }

        public DataInputBuffer getValue() throws IOException {
            DataInputBuffer value = new DataInputBuffer();
            IntWritable intValue = new IntWritable(1);
            DataOutputBuffer out = new DataOutputBuffer();
            intValue.write((DataOutput)out);
            value.reset(out.getData(), out.getLength());
            return value;
        }

        public Progress getProgress() {
            return null;
        }

        public boolean isSameKey() throws IOException {
            return false;
        }

        public DataInputBuffer getKey() throws IOException {
            DataInputBuffer key = new DataInputBuffer();
            Text text = new Text(this.keys[this.i]);
            DataOutputBuffer out = new DataOutputBuffer();
            text.write((DataOutput)out);
            key.reset(out.getData(), out.getLength());
            return key;
        }

        public void close() throws IOException {
        }
    }

    private static class NewReducer
    extends Reducer<Text, IntWritable, Text, IntWritable> {
        private NewReducer() {
        }

        protected void reduce(Text key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int count = 0;
            for (IntWritable value : values) {
                count += value.get();
            }
            context.write((Object)new Text(key.toString()), (Object)new IntWritable(count));
        }
    }

    private static class Top2OldReducer
    extends OldReducer {
        private Top2OldReducer() {
        }

        @Override
        public void reduce(Text key, Iterator<IntWritable> value, OutputCollector<Text, IntWritable> collector, Reporter reporter) throws IOException {
            int i = 0;
            while (value.hasNext()) {
                int val = value.next().get();
                if (i++ >= 2) continue;
                collector.collect((Object)new Text(key.toString()), (Object)new IntWritable(val));
            }
        }
    }

    private static class Top2NewReducer
    extends NewReducer {
        private Top2NewReducer() {
        }

        @Override
        protected void reduce(Text key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int i = 0;
            for (IntWritable value : values) {
                if (i++ >= 2) break;
                context.write((Object)new Text(key.toString()), (Object)value);
            }
        }
    }
}

