/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.tools.javadoc.util;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.tez.tools.javadoc.model.Config;
import org.apache.tez.tools.javadoc.model.ConfigProperty;
import org.apache.tez.tools.javadoc.util.Writer;

public class XmlWriter
extends Writer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Config config) throws IOException {
        String fileName;
        PrintWriter out = null;
        if (config.getConfigName() == null || config.getConfigName().isEmpty()) {
            throw new RuntimeException("Config Name is null or empty");
        }
        String string = fileName = config.getTemplateName() == null || config.getTemplateName().isEmpty() ? config.getConfigName() : config.getTemplateName();
        if (!fileName.endsWith(".xml")) {
            fileName = fileName + ".xml";
        }
        try {
            File file = new File(fileName);
            this.writeApacheHeader(file);
            out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), StandardCharsets.UTF_8));
            out.println("<?xml-stylesheet type=\"text/xsl\" href=\"configuration.xsl\"?>");
            out.println();
            out.println("<!-- WARNING: THIS IS A GENERATED TEMPLATE PURELY FOR DOCUMENTATION PURPOSES");
            out.println(" AND SHOULD NOT BE USED AS A CONFIGURATION FILE FOR TEZ -->");
            out.println();
            out.println("<configuration>");
            for (ConfigProperty configProperty : config.getConfigProperties().values()) {
                if (!this.isValidConfigProperty(configProperty)) continue;
                out.println();
                out.println("  <property>");
                out.println("    <name>" + configProperty.getPropertyName() + "</name>");
                if (configProperty.getDefaultValue() != null && !configProperty.getDefaultValue().isEmpty()) {
                    out.println("    <defaultValue>" + configProperty.getDefaultValue() + "</defaultValue>");
                }
                if (configProperty.getDescription() != null && !configProperty.getDescription().isEmpty()) {
                    out.println("    <description>" + StringEscapeUtils.escapeXml((String)configProperty.getDescription()) + "</description>");
                }
                if (configProperty.getType() != null && !configProperty.getType().isEmpty()) {
                    out.println("    <type>" + configProperty.getType() + "</type>");
                }
                if (configProperty.isUnstable()) {
                    out.println("    <unstable>true</unstable>");
                }
                if (configProperty.isEvolving()) {
                    out.println("    <evolving>true</evolving>");
                }
                if (configProperty.isPrivate()) {
                    out.println("    <private>true</private>");
                }
                out.println("  </property>");
            }
            out.println();
            out.println("</configuration>");
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private void writeApacheHeader(File file) throws IOException {
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("apache-licence.xml.header");
             OutputStream out = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            ByteStreams.copy((InputStream)in, (OutputStream)out);
        }
    }
}

