/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.tools.javadoc.doclet;

import com.sun.source.util.DocTrees;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.common.annotation.ConfigurationClass;
import org.apache.tez.common.annotation.ConfigurationProperty;
import org.apache.tez.tools.javadoc.model.Config;
import org.apache.tez.tools.javadoc.model.ConfigProperty;
import org.apache.tez.tools.javadoc.util.HtmlWriter;
import org.apache.tez.tools.javadoc.util.XmlWriter;

public class ConfigStandardDoclet
implements Doclet {
    private static boolean debugMode = false;
    private Reporter reporter;

    private static String stripQuotes(String s) {
        if (s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    @Override
    public void init(Locale locale, Reporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public String getName() {
        return "Tez";
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_9;
    }

    private void logMessage(String message) {
        if (!debugMode) {
            return;
        }
        this.reporter.print(Diagnostic.Kind.NOTE, message);
    }

    @Override
    public boolean run(DocletEnvironment docEnv) {
        this.logMessage("Running doclet " + ConfigStandardDoclet.class.getSimpleName());
        DocTrees docTrees = docEnv.getDocTrees();
        for (Element element : docEnv.getIncludedElements()) {
            if (!element.getKind().equals((Object)ElementKind.CLASS) || !(element instanceof TypeElement)) continue;
            this.processDoc(docTrees, (TypeElement)element);
        }
        return true;
    }

    private void processDoc(DocTrees docTrees, TypeElement doc) {
        this.logMessage("Parsing : " + doc);
        if (!doc.getKind().equals((Object)ElementKind.CLASS)) {
            this.logMessage("Ignoring non-class: " + doc);
            return;
        }
        List<? extends AnnotationMirror> annotations = doc.getAnnotationMirrors();
        boolean isConfigClass = false;
        String templateName = null;
        for (AnnotationMirror annotationMirror : annotations) {
            this.logMessage("Checking annotation: " + annotationMirror.getAnnotationType());
            if (!annotationMirror.getAnnotationType().asElement().toString().equals(ConfigurationClass.class.getName())) continue;
            isConfigClass = true;
            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> element : elementValues.entrySet()) {
                if (!element.getKey().getSimpleName().toString().equals("templateFileName")) continue;
                templateName = ConfigStandardDoclet.stripQuotes(element.getValue().getValue().toString());
            }
        }
        if (!isConfigClass) {
            this.logMessage("Ignoring non-config class: " + doc);
            return;
        }
        this.logMessage("Processing config class: " + doc);
        Config config = new Config(doc.getSimpleName().toString(), templateName);
        Map<String, ConfigProperty> map = config.getConfigProperties();
        this.processElements(docTrees, doc, map);
        HtmlWriter writer = new HtmlWriter();
        try {
            writer.write(config);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        XmlWriter xmlWriter = new XmlWriter();
        try {
            xmlWriter.write(config);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void processElements(DocTrees docTrees, TypeElement doc, Map<String, ConfigProperty> configProperties) {
        List<? extends Element> elements = doc.getEnclosedElements();
        for (Element element : elements) {
            if (!(element instanceof VariableElement) || !element.getKind().equals((Object)ElementKind.FIELD)) continue;
            VariableElement field = (VariableElement)element;
            if (field.getModifiers().contains((Object)Modifier.PRIVATE)) {
                this.logMessage("Skipping private field: " + field);
                continue;
            }
            if (field.getModifiers().contains((Object)Modifier.STATIC)) {
                this.logMessage("Skipping non-static field: " + field);
                continue;
            }
            String fieldName = field.getSimpleName().toString();
            if (fieldName.endsWith("_PREFIX")) {
                this.logMessage("Skipping non-config prefix constant field: " + field);
                continue;
            }
            if (fieldName.equals("TEZ_SITE_XML")) {
                this.logMessage("Skipping constant field: " + field);
                continue;
            }
            if (fieldName.endsWith("_DEFAULT")) {
                String name = fieldName.substring(0, fieldName.lastIndexOf("_DEFAULT"));
                if (!configProperties.containsKey(name)) {
                    configProperties.put(name, new ConfigProperty());
                }
                ConfigProperty configProperty = configProperties.get(name);
                if (field.getConstantValue() == null) {
                    String val = field.getConstantValue().toString();
                    this.logMessage("Got null constant value, name=" + name + ", field=" + fieldName + ", val=" + val);
                    configProperty.setDefaultValue(val);
                } else {
                    configProperty.setDefaultValue(field.getConstantValue().toString());
                }
                configProperty.setInferredType(field.getSimpleName().toString());
                if (!name.equals("TEZ_AM_STAGING_DIR") || configProperty.getDefaultValue() == null) continue;
                String defaultValue = configProperty.getDefaultValue();
                defaultValue = defaultValue.replace(System.getProperty("user.name"), "${user.name}");
                configProperty.setDefaultValue(defaultValue);
                continue;
            }
            if (!configProperties.containsKey(fieldName)) {
                configProperties.put(fieldName, new ConfigProperty());
            }
            ConfigProperty configProperty = configProperties.get(fieldName);
            configProperty.setPropertyName(field.getConstantValue().toString());
            List<? extends AnnotationMirror> annotationDescs = field.getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : annotationDescs) {
                String elementFqName = annotationMirror.getAnnotationType().asElement().toString();
                if (elementFqName.equals(InterfaceAudience.Private.class.getCanonicalName())) {
                    configProperty.setPrivate(true);
                }
                if (elementFqName.equals(InterfaceStability.Unstable.class.getCanonicalName())) {
                    configProperty.setUnstable(true);
                }
                if (elementFqName.equals(InterfaceStability.Evolving.class.getCanonicalName())) {
                    configProperty.setEvolving(true);
                }
                if (!elementFqName.equals(ConfigurationProperty.class.getCanonicalName())) continue;
                configProperty.setValidConfigProp(true);
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> element2 : annotationMirror.getElementValues().entrySet()) {
                    if (element2.getKey().getSimpleName().toString().equals("type")) {
                        configProperty.setType(ConfigStandardDoclet.stripQuotes(element2.getValue().getValue().toString()));
                        continue;
                    }
                    this.logMessage("Unhandled annotation property: " + element2.getKey().getSimpleName());
                }
            }
            configProperty.setDescription(docTrees.getDocCommentTree(field).getFullBody().toString());
        }
    }

    @Override
    public Set<? extends Doclet.Option> getSupportedOptions() {
        Doclet.Option[] options = new Doclet.Option[]{new Doclet.Option(){
            private final List<String> someOption = Arrays.asList("-debug", "--debug");

            @Override
            public int getArgumentCount() {
                return 0;
            }

            @Override
            public String getDescription() {
                return "Debug mode";
            }

            @Override
            public Doclet.Option.Kind getKind() {
                return Doclet.Option.Kind.STANDARD;
            }

            @Override
            public List<String> getNames() {
                return this.someOption;
            }

            @Override
            public String getParameters() {
                return "";
            }

            @Override
            public boolean process(String opt, List<String> arguments) {
                debugMode = true;
                return true;
            }
        }};
        return new HashSet<Doclet.Option>(Arrays.asList(options));
    }
}

