/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.history;

import com.google.common.collect.Sets;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileOutputStream;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.client.CallerContext;
import org.apache.tez.client.TezClient;
import org.apache.tez.common.counters.DAGCounter;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.DataSinkDescriptor;
import org.apache.tez.dag.api.DataSourceDescriptor;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.dag.api.event.VertexState;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.api.oldrecords.TaskState;
import org.apache.tez.dag.app.dag.DAGState;
import org.apache.tez.dag.history.logging.ats.ATSHistoryLoggingService;
import org.apache.tez.dag.history.logging.impl.SimpleHistoryLoggingService;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.examples.WordCount;
import org.apache.tez.history.ATSImportTool;
import org.apache.tez.history.parser.ATSFileParser;
import org.apache.tez.history.parser.SimpleHistoryParser;
import org.apache.tez.history.parser.datamodel.BaseInfo;
import org.apache.tez.history.parser.datamodel.DagInfo;
import org.apache.tez.history.parser.datamodel.EdgeInfo;
import org.apache.tez.history.parser.datamodel.TaskAttemptInfo;
import org.apache.tez.history.parser.datamodel.TaskInfo;
import org.apache.tez.history.parser.datamodel.VertexInfo;
import org.apache.tez.mapreduce.input.MRInput;
import org.apache.tez.mapreduce.output.MROutput;
import org.apache.tez.mapreduce.processor.SimpleMRProcessor;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.library.conf.OrderedPartitionedKVEdgeConfig;
import org.apache.tez.runtime.library.input.OrderedGroupedKVInput;
import org.apache.tez.runtime.library.output.OrderedPartitionedKVOutput;
import org.apache.tez.runtime.library.partitioner.HashPartitioner;
import org.apache.tez.tests.MiniTezClusterWithTimeline;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHistoryParser {
    private static MiniDFSCluster miniDFSCluster;
    private static MiniTezClusterWithTimeline miniTezCluster;
    private static Path inputLoc;
    private static final String INPUT = "Input";
    private static final String OUTPUT = "Output";
    private static final String TOKENIZER = "Tokenizer";
    private static final String SUMMATION = "Summation";
    private static final String SIMPLE_HISTORY_DIR = "/tmp/simplehistory/";
    private static final String HISTORY_TXT = "history.txt";
    private static Configuration conf;
    private static FileSystem fs;
    private static String TEST_ROOT_DIR;
    private static String TEZ_BASE_DIR;
    private static String DOWNLOAD_DIR;
    private static String yarnTimelineAddress;

    @BeforeClass
    public static void setupCluster() throws Exception {
        conf = new Configuration();
        conf.setBoolean("dfs.namenode.edits.noeditlogchannelflush", false);
        EditLogFileOutputStream.setShouldSkipFsyncForTesting((boolean)true);
        conf.set("hdfs.minidfs.basedir", TEST_ROOT_DIR);
        miniDFSCluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(true).build();
        fs = miniDFSCluster.getFileSystem();
        conf.set("fs.defaultFS", fs.getUri().toString());
        TestHistoryParser.setupTezCluster();
    }

    @AfterClass
    public static void shutdownCluster() {
        try {
            if (miniDFSCluster != null) {
                miniDFSCluster.shutdown();
            }
            if (miniTezCluster != null) {
                miniTezCluster.stop();
            }
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)new File(TEST_ROOT_DIR));
                FileUtils.deleteDirectory((File)new File(TEZ_BASE_DIR));
            }
            catch (IOException iOException) {}
        }
    }

    public static void setupTezCluster() throws Exception {
        conf.setInt("tez.runtime.shuffle.connect.timeout", 3000);
        conf.setInt("tez.runtime.shuffle.read.timeout", 3000);
        conf.setInt("tez.runtime.shuffle.fetch.failures.limit", 2);
        conf.setBoolean("tez.task.generate.counters.per.io", true);
        conf.setBoolean("tez.allow.disabled.timeline-domains", true);
        conf.setBoolean("yarn.timeline-service.enabled", true);
        conf.set("tez.history.logging.service.class", ATSHistoryLoggingService.class.getName());
        conf.set("tez.simple.history.logging.dir", SIMPLE_HISTORY_DIR);
        miniTezCluster = new MiniTezClusterWithTimeline(TEZ_BASE_DIR, 1, 1, 1, true);
        miniTezCluster.init(conf);
        miniTezCluster.start();
        TestHistoryParser.createSampleFile(inputLoc);
        TezConfiguration tezConf = new TezConfiguration(miniTezCluster.getConfig());
        tezConf.setBoolean("yarn.timeline-service.enabled", true);
        tezConf.set("yarn.timeline-service.webapp.address", miniTezCluster.getConfig().get("yarn.timeline-service.webapp.address"));
        tezConf.setBoolean("tez.allow.disabled.timeline-domains", true);
        tezConf.set("tez.history.logging.service.class", ATSHistoryLoggingService.class.getName());
        yarnTimelineAddress = miniTezCluster.getConfig().get("yarn.timeline-service.webapp.address");
    }

    @Test
    public void testParserWithSuccessfulJob() throws Exception {
        String dagId = this.runWordCount(WordCount.TokenProcessor.class.getName(), WordCount.SumProcessor.class.getName(), "WordCount", true);
        String[] args = new String[]{"--dagId=" + dagId, "--downloadDir=" + DOWNLOAD_DIR, "--yarnTimelineAddress=" + yarnTimelineAddress};
        int result = ATSImportTool.process((String[])args);
        Assert.assertTrue((result == 0 ? 1 : 0) != 0);
        DagInfo dagInfoFromATS = this.getDagInfo(dagId);
        this.verifyDagInfo(dagInfoFromATS, true);
        this.verifyJobSpecificInfo(dagInfoFromATS);
        this.checkConfig(dagInfoFromATS);
        dagId = this.runWordCount(WordCount.TokenProcessor.class.getName(), WordCount.SumProcessor.class.getName(), "WordCount", false);
        Thread.sleep(10000L);
        DagInfo shDagInfo = this.getDagInfoFromSimpleHistory(dagId);
        this.verifyDagInfo(shDagInfo, false);
        this.verifyJobSpecificInfo(shDagInfo);
        this.isDAGEqual(dagInfoFromATS, shDagInfo);
    }

    private DagInfo getDagInfoFromSimpleHistory(String dagId) throws TezException, IOException {
        TezDAGID tezDAGID = TezDAGID.fromString((String)dagId);
        ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)tezDAGID.getApplicationId(), (int)1);
        Path historyPath = new Path(conf.get("fs.defaultFS") + SIMPLE_HISTORY_DIR + HISTORY_TXT + "." + applicationAttemptId);
        FileSystem fs = historyPath.getFileSystem(conf);
        Path localPath = new Path(DOWNLOAD_DIR, HISTORY_TXT);
        fs.copyToLocalFile(historyPath, localPath);
        File localFile = new File(DOWNLOAD_DIR, HISTORY_TXT);
        SimpleHistoryParser parser = new SimpleHistoryParser(Arrays.asList(localFile));
        DagInfo dagInfo = parser.getDAGData(dagId);
        Assert.assertTrue((boolean)dagInfo.getDagId().equals(dagId));
        return dagInfo;
    }

    private void checkConfig(DagInfo dagInfo) {
        Assert.assertTrue((String)("DagInfo is " + dagInfo), (dagInfo != null ? 1 : 0) != 0);
        Assert.assertTrue((String)("DagInfo config size=" + dagInfo.getAppConfig().size()), (dagInfo.getAppConfig().size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("DagInfo config=" + dagInfo.getAppConfig()), (Integer.parseInt((String)dagInfo.getAppConfig().get("dfs.replication")) > 0 ? 1 : 0) != 0);
    }

    private void verifyJobSpecificInfo(DagInfo dagInfo) {
        Assert.assertTrue((dagInfo.getNumVertices() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dagInfo.getName().equals("WordCount"));
        Assert.assertTrue((boolean)dagInfo.getVertex(TOKENIZER).getProcessorClassName().equals(WordCount.TokenProcessor.class.getName()));
        Assert.assertTrue((boolean)dagInfo.getVertex(SUMMATION).getProcessorClassName().equals(WordCount.SumProcessor.class.getName()));
        Assert.assertTrue((dagInfo.getFinishTime() > dagInfo.getStartTime() ? 1 : 0) != 0);
        Assert.assertTrue((dagInfo.getEdges().size() == 1 ? 1 : 0) != 0);
        EdgeInfo edgeInfo = (EdgeInfo)dagInfo.getEdges().iterator().next();
        Assert.assertTrue((boolean)edgeInfo.getDataMovementType().equals(EdgeProperty.DataMovementType.SCATTER_GATHER.toString()));
        Assert.assertTrue((boolean)edgeInfo.getSourceVertex().getVertexName().equals(TOKENIZER));
        Assert.assertTrue((boolean)edgeInfo.getDestinationVertex().getVertexName().equals(SUMMATION));
        Assert.assertTrue((boolean)edgeInfo.getInputVertexName().equals(TOKENIZER));
        Assert.assertTrue((boolean)edgeInfo.getOutputVertexName().equals(SUMMATION));
        Assert.assertTrue((boolean)edgeInfo.getEdgeSourceClass().equals(OrderedPartitionedKVOutput.class.getName()));
        Assert.assertTrue((boolean)edgeInfo.getEdgeDestinationClass().equals(OrderedGroupedKVInput.class.getName()));
        Assert.assertTrue((dagInfo.getVertices().size() == 2 ? 1 : 0) != 0);
        String lastSourceTA = null;
        String lastDataEventSourceTA = null;
        for (VertexInfo vertexInfo : dagInfo.getVertices()) {
            Assert.assertTrue((vertexInfo.getKilledTasksCount() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((vertexInfo.getInitRequestedTime() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertexInfo.getInitTime() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertexInfo.getStartRequestedTime() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertexInfo.getStartTime() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertexInfo.getFinishTime() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertexInfo.getFinishTime() > vertexInfo.getStartTime() ? 1 : 0) != 0);
            long finishTime = 0L;
            for (TaskInfo taskInfo : vertexInfo.getTasks()) {
                Assert.assertTrue((taskInfo.getNumberOfTaskAttempts() == 1 ? 1 : 0) != 0);
                Assert.assertTrue((taskInfo.getMaxTaskAttemptDuration() >= 0L ? 1 : 0) != 0);
                Assert.assertTrue((taskInfo.getMinTaskAttemptDuration() >= 0L ? 1 : 0) != 0);
                Assert.assertTrue((taskInfo.getAvgTaskAttemptDuration() >= 0.0f ? 1 : 0) != 0);
                Assert.assertTrue((taskInfo.getLastTaskAttemptToFinish() != null ? 1 : 0) != 0);
                Assert.assertTrue((taskInfo.getContainersMapping().size() > 0 ? 1 : 0) != 0);
                Assert.assertTrue((taskInfo.getSuccessfulTaskAttempts().size() > 0 ? 1 : 0) != 0);
                Assert.assertTrue((taskInfo.getFailedTaskAttempts().size() == 0 ? 1 : 0) != 0);
                Assert.assertTrue((taskInfo.getKilledTaskAttempts().size() == 0 ? 1 : 0) != 0);
                Assert.assertTrue((taskInfo.getFinishTime() > taskInfo.getStartTime() ? 1 : 0) != 0);
                List attempts = taskInfo.getTaskAttempts();
                if (vertexInfo.getVertexName().equals(TOKENIZER)) {
                    if (finishTime < taskInfo.getFinishTime()) {
                        finishTime = taskInfo.getFinishTime();
                        lastSourceTA = taskInfo.getSuccessfulAttemptId();
                    }
                } else {
                    for (TaskAttemptInfo attempt : attempts) {
                        TaskAttemptInfo.DataDependencyEvent item = (TaskAttemptInfo.DataDependencyEvent)attempt.getLastDataEvents().get(0);
                        Assert.assertTrue((item.getTimestamp() > 0L ? 1 : 0) != 0);
                        if (lastDataEventSourceTA == null) {
                            lastDataEventSourceTA = item.getTaskAttemptId();
                            continue;
                        }
                        Assert.assertTrue((boolean)lastDataEventSourceTA.equals(item.getTaskAttemptId()));
                    }
                }
                for (TaskAttemptInfo attemptInfo : taskInfo.getTaskAttempts()) {
                    Assert.assertTrue((attemptInfo.getCreationTime() > 0L ? 1 : 0) != 0);
                    Assert.assertTrue((attemptInfo.getAllocationTime() > 0L ? 1 : 0) != 0);
                    Assert.assertTrue((attemptInfo.getStartTime() > 0L ? 1 : 0) != 0);
                    Assert.assertTrue((attemptInfo.getFinishTime() > attemptInfo.getStartTime() ? 1 : 0) != 0);
                }
            }
            Assert.assertTrue((vertexInfo.getLastTaskToFinish() != null ? 1 : 0) != 0);
            if (vertexInfo.getVertexName().equals(TOKENIZER)) {
                Assert.assertTrue((vertexInfo.getInputEdges().size() == 0 ? 1 : 0) != 0);
                Assert.assertTrue((vertexInfo.getOutputEdges().size() == 1 ? 1 : 0) != 0);
                Assert.assertTrue((vertexInfo.getOutputVertices().size() == 1 ? 1 : 0) != 0);
                Assert.assertTrue((vertexInfo.getInputVertices().size() == 0 ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((vertexInfo.getInputEdges().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((vertexInfo.getOutputEdges().size() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((vertexInfo.getOutputVertices().size() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((vertexInfo.getInputVertices().size() == 1 ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)lastSourceTA.equals(lastDataEventSourceTA));
    }

    @Test
    public void testParserWithSuccessfulJob_InvalidATS() throws Exception {
        String dagId = this.runWordCount(WordCount.TokenProcessor.class.getName(), WordCount.SumProcessor.class.getName(), "WordCount-With-WrongATS-URL", true);
        String atsAddress = "--atsAddress=http://atsHost:8188";
        String[] args = new String[]{"--dagId=" + dagId, "--downloadDir=" + DOWNLOAD_DIR, atsAddress};
        try {
            int result = ATSImportTool.process((String[])args);
            Assert.fail((String)"Should have failed with processException");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Test
    public void testParserWithFailedJob() throws Exception {
        String dagId = this.runWordCount(WordCount.TokenProcessor.class.getName(), FailProcessor.class.getName(), "WordCount-With-Exception", true);
        String[] args = new String[]{"--dagId=" + dagId, "--downloadDir=" + DOWNLOAD_DIR, "--yarnTimelineAddress=" + yarnTimelineAddress};
        int result = ATSImportTool.process((String[])args);
        Assert.assertTrue((result == 0 ? 1 : 0) != 0);
        DagInfo dagInfo = this.getDagInfo(dagId);
        this.checkConfig(dagInfo);
        this.verifyDagInfo(dagInfo, true);
        VertexInfo summationVertex = dagInfo.getVertex(SUMMATION);
        Assert.assertTrue((summationVertex.getFailedTasks().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((TaskInfo)summationVertex.getFailedTasks().get(0)).getFailedTaskAttempts().size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)summationVertex.getStatus().equals(VertexState.FAILED.toString()));
        Assert.assertTrue((dagInfo.getFailedVertices().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((VertexInfo)dagInfo.getFailedVertices().get(0)).getVertexName().equals(SUMMATION));
        Assert.assertTrue((dagInfo.getSuccessfullVertices().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((VertexInfo)dagInfo.getSuccessfullVertices().get(0)).getVertexName().equals(TOKENIZER));
        Assert.assertTrue((boolean)dagInfo.getStatus().equals(DAGState.FAILED.toString()));
        this.verifyCounter(dagInfo.getCounter(DAGCounter.NUM_FAILED_TASKS.toString()), null, 4L);
        this.verifyCounter(dagInfo.getCounter(DAGCounter.NUM_SUCCEEDED_TASKS.toString()), null, 1L);
        this.verifyCounter(dagInfo.getCounter(DAGCounter.TOTAL_LAUNCHED_TASKS.toString()), null, 5L);
        this.verifyCounter(dagInfo.getCounter(TaskCounter.INPUT_RECORDS_PROCESSED.toString()), "TaskCounter_Tokenizer_INPUT_Input", 10L);
        this.verifyCounter(dagInfo.getCounter(TaskCounter.ADDITIONAL_SPILLS_BYTES_READ.toString()), "TaskCounter_Tokenizer_OUTPUT_Summation", 0L);
        this.verifyCounter(dagInfo.getCounter(TaskCounter.OUTPUT_RECORDS.toString()), "TaskCounter_Tokenizer_OUTPUT_Summation", 20L);
        this.verifyCounter(dagInfo.getCounter(TaskCounter.SPILLED_RECORDS.toString()), "TaskCounter_Tokenizer_OUTPUT_Summation", 20L);
        for (TaskInfo taskInfo : summationVertex.getTasks()) {
            TaskAttemptInfo lastAttempt = null;
            for (TaskAttemptInfo attemptInfo : taskInfo.getTaskAttempts()) {
                if (lastAttempt != null) {
                    Assert.assertTrue((boolean)lastAttempt.getTaskAttemptId().equals(attemptInfo.getCreationCausalTA()));
                    Assert.assertTrue((lastAttempt.getTerminationCause() != null ? 1 : 0) != 0);
                }
                lastAttempt = attemptInfo;
            }
        }
        Assert.assertTrue((boolean)dagInfo.getDiagnostics().contains("Failing this processor for some reason"));
    }

    private void isDAGEqual(DagInfo dagInfo1, DagInfo dagInfo2) {
        Assert.assertNotNull((Object)dagInfo1);
        Assert.assertNotNull((Object)dagInfo2);
        Assert.assertEquals((Object)dagInfo1.getStatus(), (Object)dagInfo2.getStatus());
        this.isEdgeEqual(dagInfo1.getEdges(), dagInfo2.getEdges());
        this.isVertexEqual(dagInfo1.getVertices(), dagInfo2.getVertices());
    }

    private void isVertexEqual(VertexInfo vertexInfo1, VertexInfo vertexInfo2) {
        Assert.assertTrue((vertexInfo1 != null ? 1 : 0) != 0);
        Assert.assertTrue((vertexInfo2 != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)vertexInfo1.getVertexName().equals(vertexInfo2.getVertexName()));
        Assert.assertTrue((boolean)vertexInfo1.getProcessorClassName().equals(vertexInfo2.getProcessorClassName()));
        Assert.assertTrue((vertexInfo1.getNumTasks() == vertexInfo2.getNumTasks() ? 1 : 0) != 0);
        Assert.assertTrue((vertexInfo1.getCompletedTasksCount() == vertexInfo2.getCompletedTasksCount() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)vertexInfo1.getStatus().equals(vertexInfo2.getStatus()));
        this.isEdgeEqual(vertexInfo1.getInputEdges(), vertexInfo2.getInputEdges());
        this.isEdgeEqual(vertexInfo1.getOutputEdges(), vertexInfo2.getOutputEdges());
        Assert.assertTrue((vertexInfo1.getInputVertices().size() == vertexInfo2.getInputVertices().size() ? 1 : 0) != 0);
        Assert.assertTrue((vertexInfo1.getOutputVertices().size() == vertexInfo2.getOutputVertices().size() ? 1 : 0) != 0);
        Assert.assertTrue((vertexInfo1.getNumTasks() == vertexInfo2.getNumTasks() ? 1 : 0) != 0);
        this.isTaskEqual(vertexInfo1.getTasks(), vertexInfo2.getTasks());
    }

    private void isVertexEqual(List<VertexInfo> vertexList1, List<VertexInfo> vertexList2) {
        Assert.assertTrue((String)"Vertices sizes should be the same", (vertexList1.size() == vertexList2.size() ? 1 : 0) != 0);
        Iterator<VertexInfo> it1 = vertexList1.iterator();
        Iterator<VertexInfo> it2 = vertexList2.iterator();
        while (it1.hasNext()) {
            Assert.assertTrue((boolean)it2.hasNext());
            VertexInfo info1 = it1.next();
            VertexInfo info2 = it2.next();
            this.isVertexEqual(info1, info2);
        }
    }

    private void isEdgeEqual(EdgeInfo edgeInfo1, EdgeInfo edgeInfo2) {
        Assert.assertTrue((edgeInfo1 != null ? 1 : 0) != 0);
        Assert.assertTrue((edgeInfo2 != null ? 1 : 0) != 0);
        String info1 = edgeInfo1.toString();
        String info2 = edgeInfo1.toString();
        Assert.assertTrue((boolean)info1.equals(info2));
    }

    private void isEdgeEqual(Collection<EdgeInfo> info1, Collection<EdgeInfo> info2) {
        Assert.assertTrue((String)"sizes should be the same", (info1.size() == info1.size() ? 1 : 0) != 0);
        Iterator<EdgeInfo> it1 = info1.iterator();
        Iterator<EdgeInfo> it2 = info2.iterator();
        while (it1.hasNext()) {
            Assert.assertTrue((boolean)it2.hasNext());
            this.isEdgeEqual(it1.next(), it2.next());
        }
    }

    private void isTaskEqual(Collection<TaskInfo> info1, Collection<TaskInfo> info2) {
        Assert.assertTrue((String)"sizes should be the same", (info1.size() == info1.size() ? 1 : 0) != 0);
        Iterator<TaskInfo> it1 = info1.iterator();
        Iterator<TaskInfo> it2 = info2.iterator();
        while (it1.hasNext()) {
            Assert.assertTrue((boolean)it2.hasNext());
            this.isTaskEqual(it1.next(), it2.next());
        }
    }

    private void isTaskEqual(TaskInfo taskInfo1, TaskInfo taskInfo2) {
        Assert.assertTrue((taskInfo1 != null ? 1 : 0) != 0);
        Assert.assertTrue((taskInfo2 != null ? 1 : 0) != 0);
        Assert.assertTrue((taskInfo1.getVertexInfo() != null ? 1 : 0) != 0);
        Assert.assertTrue((taskInfo2.getVertexInfo() != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)taskInfo1.getStatus().equals(taskInfo2.getStatus()));
        Assert.assertTrue((boolean)taskInfo1.getVertexInfo().getVertexName().equals(taskInfo2.getVertexInfo().getVertexName()));
        this.isTaskAttemptEqual(taskInfo1.getTaskAttempts(), taskInfo2.getTaskAttempts());
        this.isCountersSame((BaseInfo)taskInfo1, (BaseInfo)taskInfo2);
    }

    private void isCountersSame(BaseInfo info1, BaseInfo info2) {
        this.isCounterSame(info1.getCounter(TaskCounter.ADDITIONAL_SPILL_COUNT.name()), info2.getCounter(TaskCounter.ADDITIONAL_SPILL_COUNT.name()));
        this.isCounterSame(info1.getCounter(TaskCounter.SPILLED_RECORDS.name()), info2.getCounter(TaskCounter.SPILLED_RECORDS.name()));
        this.isCounterSame(info1.getCounter(TaskCounter.OUTPUT_RECORDS.name()), info2.getCounter(TaskCounter.OUTPUT_RECORDS.name()));
        this.isCounterSame(info1.getCounter(TaskCounter.OUTPUT_BYTES.name()), info2.getCounter(TaskCounter.OUTPUT_BYTES.name()));
        this.isCounterSame(info1.getCounter(TaskCounter.OUTPUT_RECORDS.name()), info2.getCounter(TaskCounter.OUTPUT_RECORDS.name()));
        this.isCounterSame(info1.getCounter(TaskCounter.REDUCE_INPUT_GROUPS.name()), info2.getCounter(TaskCounter.REDUCE_INPUT_GROUPS.name()));
        this.isCounterSame(info1.getCounter(TaskCounter.REDUCE_INPUT_RECORDS.name()), info2.getCounter(TaskCounter.REDUCE_INPUT_RECORDS.name()));
    }

    private void isCounterSame(Map<String, TezCounter> counter1, Map<String, TezCounter> counter2) {
        for (Map.Entry<String, TezCounter> entry : counter1.entrySet()) {
            String source = entry.getKey();
            long val = entry.getValue().getValue();
            Assert.assertTrue((boolean)counter2.containsKey(entry.getKey()));
            Assert.assertTrue((counter2.get(entry.getKey()).getValue() == val ? 1 : 0) != 0);
        }
    }

    private void isTaskAttemptEqual(Collection<TaskAttemptInfo> info1, Collection<TaskAttemptInfo> info2) {
        Assert.assertTrue((String)"sizes should be the same", (info1.size() == info1.size() ? 1 : 0) != 0);
        Iterator<TaskAttemptInfo> it1 = info1.iterator();
        Iterator<TaskAttemptInfo> it2 = info2.iterator();
        while (it1.hasNext()) {
            Assert.assertTrue((boolean)it2.hasNext());
            this.isTaskAttemptEqual(it1.next(), it2.next());
        }
    }

    private void isTaskAttemptEqual(TaskAttemptInfo info1, TaskAttemptInfo info2) {
        Assert.assertTrue((info1 != null ? 1 : 0) != 0);
        Assert.assertTrue((info2 != null ? 1 : 0) != 0);
        Assert.assertTrue((info1.getTaskInfo() != null ? 1 : 0) != 0);
        Assert.assertTrue((info2.getTaskInfo() != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)info1.getStatus().equals(info2.getStatus()));
        Assert.assertTrue((boolean)info1.getTaskInfo().getVertexInfo().getVertexName().equals(info2.getTaskInfo().getVertexInfo().getVertexName()));
        this.isCountersSame((BaseInfo)info1, (BaseInfo)info2);
    }

    private static void createSampleFile(Path inputLoc) throws IOException {
        fs.deleteOnExit(inputLoc);
        FSDataOutputStream out = fs.create(inputLoc);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out));
        for (int i = 0; i < 10; ++i) {
            writer.write("Sample " + RandomStringUtils.randomAlphanumeric((int)5));
            writer.newLine();
        }
        writer.close();
    }

    private DagInfo getDagInfo(String dagId) throws TezException {
        File downloadedFile = new File(DOWNLOAD_DIR + "/" + dagId + ".zip");
        ATSFileParser parser = new ATSFileParser(Arrays.asList(downloadedFile));
        DagInfo dagInfo = parser.getDAGData(dagId);
        Assert.assertTrue((boolean)dagInfo.getDagId().equals(dagId));
        return dagInfo;
    }

    private void verifyCounter(Map<String, TezCounter> counterMap, String counterGroupName, long expectedVal) {
        for (Map.Entry<String, TezCounter> entry : counterMap.entrySet()) {
            if (counterGroupName != null) {
                if (!entry.getKey().equals(counterGroupName)) continue;
                Assert.assertTrue((entry.getValue().getValue() == expectedVal ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((entry.getValue().getValue() == expectedVal ? 1 : 0) != 0);
        }
    }

    TezClient getTezClient(boolean withTimeline) throws Exception {
        TezConfiguration tezConf = new TezConfiguration(miniTezCluster.getConfig());
        if (withTimeline) {
            tezConf.setBoolean("yarn.timeline-service.enabled", withTimeline);
            tezConf.set("tez.history.logging.service.class", ATSHistoryLoggingService.class.getName());
        } else {
            tezConf.set("tez.history.logging.service.class", SimpleHistoryLoggingService.class.getName());
        }
        tezConf.setBoolean("tez.allow.disabled.timeline-domains", true);
        TezClient tezClient = TezClient.create((String)"WordCount", (TezConfiguration)tezConf, (boolean)false);
        tezClient.start();
        tezClient.waitTillReady();
        return tezClient;
    }

    private String runWordCount(String tokenizerProcessor, String summationProcessor, String dagName, boolean withTimeline) throws Exception {
        Path outputLoc = new Path("/tmp/outPath_" + System.currentTimeMillis());
        DataSourceDescriptor dataSource = MRInput.createConfigBuilder((Configuration)conf, TextInputFormat.class, (String)inputLoc.toString()).build();
        DataSinkDescriptor dataSink = MROutput.createConfigBuilder((Configuration)conf, TextOutputFormat.class, (String)outputLoc.toString()).build();
        Vertex tokenizerVertex = Vertex.create((String)TOKENIZER, (ProcessorDescriptor)ProcessorDescriptor.create((String)tokenizerProcessor)).addDataSource(INPUT, dataSource);
        OrderedPartitionedKVEdgeConfig edgeConf = OrderedPartitionedKVEdgeConfig.newBuilder((String)Text.class.getName(), (String)IntWritable.class.getName(), (String)HashPartitioner.class.getName()).build();
        Vertex summationVertex = Vertex.create((String)SUMMATION, (ProcessorDescriptor)ProcessorDescriptor.create((String)summationProcessor), (int)1).addDataSink(OUTPUT, dataSink);
        DAG dag = DAG.create((String)dagName);
        dag.addVertex(tokenizerVertex).addVertex(summationVertex).addEdge(Edge.create((Vertex)tokenizerVertex, (Vertex)summationVertex, (EdgeProperty)edgeConf.createDefaultEdgeProperty()));
        TezClient tezClient = this.getTezClient(withTimeline);
        CallerContext callerContext = CallerContext.create((String)"TezExamples", (String)"Tez WordCount Example Job");
        ApplicationId appId = tezClient.getAppMasterApplicationId();
        if (appId == null) {
            appId = ApplicationId.newInstance((long)1001L, (int)1);
        }
        callerContext.setCallerIdAndType(appId.toString(), "TezApplication");
        dag.setCallerContext(callerContext);
        DAGClient client = tezClient.submitDAG(dag);
        client.waitForCompletionWithStatusUpdates((Set)Sets.newHashSet((Object[])new StatusGetOpts[]{StatusGetOpts.GET_COUNTERS}));
        TezDAGID tezDAGID = TezDAGID.getInstance((ApplicationId)tezClient.getAppMasterApplicationId(), (int)1);
        if (tezClient != null) {
            tezClient.stop();
        }
        return tezDAGID.toString();
    }

    private void verifyDagInfo(DagInfo dagInfo, boolean ats) {
        Object versionInfo;
        if (ats) {
            versionInfo = dagInfo.getVersionInfo();
            Assert.assertTrue((versionInfo != null ? 1 : 0) != 0);
            Assert.assertTrue((versionInfo.getVersion() != null ? 1 : 0) != 0);
            Assert.assertTrue((versionInfo.getRevision() != null ? 1 : 0) != 0);
            Assert.assertTrue((versionInfo.getBuildTime() != null ? 1 : 0) != 0);
        }
        Assert.assertTrue((dagInfo.getUserName() != null ? 1 : 0) != 0);
        Assert.assertTrue((!dagInfo.getUserName().isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((dagInfo.getStartTime() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((dagInfo.getFinishTimeInterval() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((dagInfo.getStartTimeInterval() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((dagInfo.getStartTime() > 0L ? 1 : 0) != 0);
        if (dagInfo.getStatus().equalsIgnoreCase(DAGState.SUCCEEDED.toString())) {
            Assert.assertTrue((dagInfo.getFinishTime() >= dagInfo.getStartTime() ? 1 : 0) != 0);
        }
        Assert.assertTrue((dagInfo.getFinishTimeInterval() > dagInfo.getStartTimeInterval() ? 1 : 0) != 0);
        Assert.assertTrue((dagInfo.getStartTime() > dagInfo.getSubmitTime() ? 1 : 0) != 0);
        Assert.assertTrue((dagInfo.getTimeTaken() > 0L ? 1 : 0) != 0);
        Assert.assertNotNull((Object)dagInfo.getCallerContext());
        Assert.assertEquals((Object)"TezExamples", (Object)dagInfo.getCallerContext().getContext());
        Assert.assertEquals((Object)"Tez WordCount Example Job", (Object)dagInfo.getCallerContext().getBlob());
        Assert.assertNotNull((Object)dagInfo.getCallerContext().getCallerId());
        Assert.assertEquals((Object)"TezApplication", (Object)dagInfo.getCallerContext().getCallerType());
        versionInfo = dagInfo.getVertices().iterator();
        while (versionInfo.hasNext()) {
            VertexInfo vertexInfo;
            this.verifyVertex(vertexInfo, (vertexInfo = (VertexInfo)versionInfo.next()).getFailedTasksCount() > 0);
        }
        VertexInfo fastestVertex = dagInfo.getFastestVertex();
        Assert.assertTrue((fastestVertex != null ? 1 : 0) != 0);
        if (dagInfo.getStatus().equals(DAGState.SUCCEEDED)) {
            Assert.assertTrue((dagInfo.getSlowestVertex() != null ? 1 : 0) != 0);
        }
    }

    private void verifyVertex(VertexInfo vertexInfo, boolean hasFailedTasks) {
        Assert.assertTrue((vertexInfo != null ? 1 : 0) != 0);
        if (hasFailedTasks) {
            Assert.assertTrue((vertexInfo.getFailedTasksCount() > 0 ? 1 : 0) != 0);
        }
        Assert.assertTrue((vertexInfo.getStartTimeInterval() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((vertexInfo.getStartTime() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((vertexInfo.getFinishTimeInterval() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((vertexInfo.getStartTimeInterval() < vertexInfo.getFinishTimeInterval() ? 1 : 0) != 0);
        Assert.assertTrue((vertexInfo.getVertexName() != null ? 1 : 0) != 0);
        if (!hasFailedTasks) {
            Assert.assertTrue((vertexInfo.getFinishTime() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertexInfo.getFailedTasks().size() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((vertexInfo.getSucceededTasksCount() == vertexInfo.getSuccessfulTasks().size() ? 1 : 0) != 0);
            Assert.assertTrue((vertexInfo.getFailedTasksCount() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((vertexInfo.getAvgTaskDuration() > 0.0f ? 1 : 0) != 0);
            Assert.assertTrue((vertexInfo.getMaxTaskDuration() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertexInfo.getMinTaskDuration() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertexInfo.getTimeTaken() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((boolean)vertexInfo.getStatus().equalsIgnoreCase(VertexState.SUCCEEDED.toString()));
            Assert.assertTrue((vertexInfo.getCompletedTasksCount() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((vertexInfo.getFirstTaskToStart() != null ? 1 : 0) != 0);
            Assert.assertTrue((vertexInfo.getSucceededTasksCount() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((vertexInfo.getTasks().size() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((vertexInfo.getFinishTime() > vertexInfo.getStartTime() ? 1 : 0) != 0);
        }
        for (TaskInfo taskInfo : vertexInfo.getTasks()) {
            if (!taskInfo.getStatus().equals(TaskState.SUCCEEDED.toString())) continue;
            this.verifyTask(taskInfo, false);
        }
        for (TaskInfo taskInfo : vertexInfo.getFailedTasks()) {
            this.verifyTask(taskInfo, true);
        }
        Assert.assertTrue((vertexInfo.getProcessorClassName() != null ? 1 : 0) != 0);
        Assert.assertTrue((vertexInfo.getStatus() != null ? 1 : 0) != 0);
        Assert.assertTrue((vertexInfo.getDagInfo() != null ? 1 : 0) != 0);
        Assert.assertTrue((vertexInfo.getInitTimeInterval() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((vertexInfo.getNumTasks() > 0 ? 1 : 0) != 0);
    }

    private void verifyTask(TaskInfo taskInfo, boolean hasFailedAttempts) {
        Assert.assertTrue((taskInfo != null ? 1 : 0) != 0);
        Assert.assertTrue((taskInfo.getStatus() != null ? 1 : 0) != 0);
        Assert.assertTrue((taskInfo.getStartTimeInterval() > 0L ? 1 : 0) != 0);
        if (!hasFailedAttempts) {
            Assert.assertTrue((boolean)taskInfo.getStatus().equals(TaskState.SUCCEEDED.toString()));
            Assert.assertTrue((taskInfo.getFinishTimeInterval() > 0L && taskInfo.getFinishTime() > taskInfo.getFinishTimeInterval() ? 1 : 0) != 0);
            Assert.assertTrue((taskInfo.getStartTimeInterval() > 0L && taskInfo.getStartTime() > taskInfo.getStartTimeInterval() ? 1 : 0) != 0);
            Assert.assertTrue((taskInfo.getSuccessfulAttemptId() != null ? 1 : 0) != 0);
            Assert.assertTrue((taskInfo.getSuccessfulTaskAttempt() != null ? 1 : 0) != 0);
            Assert.assertTrue((taskInfo.getFinishTime() > taskInfo.getStartTime() ? 1 : 0) != 0);
        }
        Assert.assertTrue((taskInfo.getTaskId() != null ? 1 : 0) != 0);
        for (TaskAttemptInfo attemptInfo : taskInfo.getTaskAttempts()) {
            this.verifyTaskAttemptInfo(attemptInfo);
        }
    }

    private void verifyTaskAttemptInfo(TaskAttemptInfo attemptInfo) {
        if (attemptInfo.getStatus() != null && attemptInfo.getStatus().equals(TaskAttemptState.SUCCEEDED)) {
            Assert.assertTrue((attemptInfo.getStartTimeInterval() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((attemptInfo.getFinishTimeInterval() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((attemptInfo.getCreationTime() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((attemptInfo.getAllocationTime() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((attemptInfo.getStartTime() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((attemptInfo.getFinishTime() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((attemptInfo.getFinishTime() > attemptInfo.getStartTime() ? 1 : 0) != 0);
            Assert.assertTrue((attemptInfo.getFinishTime() > attemptInfo.getFinishTimeInterval() ? 1 : 0) != 0);
            Assert.assertTrue((attemptInfo.getStartTime() > attemptInfo.getStartTimeInterval() ? 1 : 0) != 0);
            Assert.assertTrue((attemptInfo.getNodeId() != null ? 1 : 0) != 0);
            Assert.assertTrue((attemptInfo.getTimeTaken() != -1L ? 1 : 0) != 0);
            Assert.assertTrue((attemptInfo.getEvents() != null ? 1 : 0) != 0);
            Assert.assertTrue((attemptInfo.getTezCounters() != null ? 1 : 0) != 0);
            Assert.assertTrue((attemptInfo.getContainer() != null ? 1 : 0) != 0);
        }
        Assert.assertTrue((attemptInfo.getTaskInfo() != null ? 1 : 0) != 0);
    }

    static {
        inputLoc = new Path("/tmp/sample.txt");
        conf = new Configuration();
        TEST_ROOT_DIR = "target/" + TestHistoryParser.class.getName() + "-tmpDir";
        TEZ_BASE_DIR = "target/" + TestHistoryParser.class.getName() + "-tez";
        DOWNLOAD_DIR = TEST_ROOT_DIR + "/" + "download";
    }

    public static class FailProcessor
    extends SimpleMRProcessor {
        public FailProcessor(ProcessorContext context) {
            super(context);
        }

        public void run() throws Exception {
            throw new Exception("Failing this processor for some reason");
        }
    }
}

