/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.EntityDescriptor;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.api.impl.GroupInputSpec;
import org.apache.tez.runtime.api.impl.InputSpec;
import org.apache.tez.runtime.api.impl.OutputSpec;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.apache.tez.test.service.rpc.TezTestServiceProtocolProtos;

public final class ProtoConverters {
    private ProtoConverters() {
    }

    public static TaskSpec getTaskSpecfromProto(TezTestServiceProtocolProtos.TaskSpecProto taskSpecProto) {
        TezTaskAttemptID taskAttemptID = TezTaskAttemptID.fromString((String)taskSpecProto.getTaskAttemptIdString());
        ProcessorDescriptor processorDescriptor = null;
        if (taskSpecProto.hasProcessorDescriptor()) {
            processorDescriptor = DagTypeConverters.convertProcessorDescriptorFromDAGPlan((DAGProtos.TezEntityDescriptorProto)taskSpecProto.getProcessorDescriptor());
        }
        ArrayList<InputSpec> inputSpecList = new ArrayList<InputSpec>(taskSpecProto.getInputSpecsCount());
        if (taskSpecProto.getInputSpecsCount() > 0) {
            for (Object inputSpecProto : taskSpecProto.getInputSpecsList()) {
                inputSpecList.add(ProtoConverters.getInputSpecFromProto((TezTestServiceProtocolProtos.IOSpecProto)inputSpecProto));
            }
        }
        ArrayList<OutputSpec> outputSpecList = new ArrayList<OutputSpec>(taskSpecProto.getOutputSpecsCount());
        if (taskSpecProto.getOutputSpecsCount() > 0) {
            for (Object outputSpecProto : taskSpecProto.getOutputSpecsList()) {
                outputSpecList.add(ProtoConverters.getOutputSpecFromProto((TezTestServiceProtocolProtos.IOSpecProto)outputSpecProto));
            }
        }
        ArrayList<GroupInputSpec> groupInputSpecs = new ArrayList<GroupInputSpec>(taskSpecProto.getGroupedInputSpecsCount());
        if (taskSpecProto.getGroupedInputSpecsCount() > 0) {
            for (TezTestServiceProtocolProtos.GroupInputSpecProto groupInputSpecProto : taskSpecProto.getGroupedInputSpecsList()) {
                groupInputSpecs.add(ProtoConverters.getGroupInputSpecFromProto(groupInputSpecProto));
            }
        }
        Configuration taskConf = null;
        if (taskSpecProto.hasTaskConf()) {
            taskConf = new Configuration(false);
            Map confMap = DagTypeConverters.convertConfFromProto((DAGProtos.ConfigurationProto)taskSpecProto.getTaskConf());
            for (Map.Entry e : confMap.entrySet()) {
                taskConf.set((String)e.getKey(), (String)e.getValue());
            }
        }
        TaskSpec taskSpec = new TaskSpec(taskAttemptID, taskSpecProto.getDagName(), taskSpecProto.getVertexName(), taskSpecProto.getVertexParallelism(), processorDescriptor, inputSpecList, outputSpecList, groupInputSpecs, taskConf);
        return taskSpec;
    }

    public static TezTestServiceProtocolProtos.TaskSpecProto convertTaskSpecToProto(TaskSpec taskSpec) {
        TezTestServiceProtocolProtos.TaskSpecProto.Builder builder = TezTestServiceProtocolProtos.TaskSpecProto.newBuilder();
        builder.setTaskAttemptIdString(taskSpec.getTaskAttemptID().toString());
        builder.setDagName(taskSpec.getDAGName());
        builder.setVertexName(taskSpec.getVertexName());
        builder.setVertexParallelism(taskSpec.getVertexParallelism());
        if (taskSpec.getProcessorDescriptor() != null) {
            builder.setProcessorDescriptor(DagTypeConverters.convertToDAGPlan((EntityDescriptor)taskSpec.getProcessorDescriptor()));
        }
        if (taskSpec.getInputs() != null && !taskSpec.getInputs().isEmpty()) {
            for (InputSpec inputSpec : taskSpec.getInputs()) {
                builder.addInputSpecs(ProtoConverters.convertInputSpecToProto(inputSpec));
            }
        }
        if (taskSpec.getOutputs() != null && !taskSpec.getOutputs().isEmpty()) {
            for (OutputSpec outputSpec : taskSpec.getOutputs()) {
                builder.addOutputSpecs(ProtoConverters.convertOutputSpecToProto(outputSpec));
            }
        }
        if (taskSpec.getGroupInputs() != null && !taskSpec.getGroupInputs().isEmpty()) {
            for (GroupInputSpec groupInputSpec : taskSpec.getGroupInputs()) {
                builder.addGroupedInputSpecs(ProtoConverters.convertGroupInputSpecToProto(groupInputSpec));
            }
        }
        if (taskSpec.getTaskConf() != null) {
            DAGProtos.ConfigurationProto.Builder confBuilder = DAGProtos.ConfigurationProto.newBuilder();
            for (Map.Entry entry : taskSpec.getTaskConf()) {
                confBuilder.addConfKeyValues(DAGProtos.PlanKeyValuePair.newBuilder().setKey((String)entry.getKey()).setValue((String)entry.getValue()).build());
            }
            builder.setTaskConf(confBuilder.build());
        }
        return builder.build();
    }

    public static InputSpec getInputSpecFromProto(TezTestServiceProtocolProtos.IOSpecProto inputSpecProto) {
        InputDescriptor inputDescriptor = null;
        if (inputSpecProto.hasIoDescriptor()) {
            inputDescriptor = DagTypeConverters.convertInputDescriptorFromDAGPlan((DAGProtos.TezEntityDescriptorProto)inputSpecProto.getIoDescriptor());
        }
        InputSpec inputSpec = new InputSpec(inputSpecProto.getConnectedVertexName(), inputDescriptor, inputSpecProto.getPhysicalEdgeCount());
        return inputSpec;
    }

    public static TezTestServiceProtocolProtos.IOSpecProto convertInputSpecToProto(InputSpec inputSpec) {
        TezTestServiceProtocolProtos.IOSpecProto.Builder builder = TezTestServiceProtocolProtos.IOSpecProto.newBuilder();
        if (inputSpec.getSourceVertexName() != null) {
            builder.setConnectedVertexName(inputSpec.getSourceVertexName());
        }
        if (inputSpec.getInputDescriptor() != null) {
            builder.setIoDescriptor(DagTypeConverters.convertToDAGPlan((EntityDescriptor)inputSpec.getInputDescriptor()));
        }
        builder.setPhysicalEdgeCount(inputSpec.getPhysicalEdgeCount());
        return builder.build();
    }

    public static OutputSpec getOutputSpecFromProto(TezTestServiceProtocolProtos.IOSpecProto outputSpecProto) {
        OutputDescriptor outputDescriptor = null;
        if (outputSpecProto.hasIoDescriptor()) {
            outputDescriptor = DagTypeConverters.convertOutputDescriptorFromDAGPlan((DAGProtos.TezEntityDescriptorProto)outputSpecProto.getIoDescriptor());
        }
        OutputSpec outputSpec = new OutputSpec(outputSpecProto.getConnectedVertexName(), outputDescriptor, outputSpecProto.getPhysicalEdgeCount());
        return outputSpec;
    }

    public static TezTestServiceProtocolProtos.IOSpecProto convertOutputSpecToProto(OutputSpec outputSpec) {
        TezTestServiceProtocolProtos.IOSpecProto.Builder builder = TezTestServiceProtocolProtos.IOSpecProto.newBuilder();
        if (outputSpec.getDestinationVertexName() != null) {
            builder.setConnectedVertexName(outputSpec.getDestinationVertexName());
        }
        if (outputSpec.getOutputDescriptor() != null) {
            builder.setIoDescriptor(DagTypeConverters.convertToDAGPlan((EntityDescriptor)outputSpec.getOutputDescriptor()));
        }
        builder.setPhysicalEdgeCount(outputSpec.getPhysicalEdgeCount());
        return builder.build();
    }

    public static GroupInputSpec getGroupInputSpecFromProto(TezTestServiceProtocolProtos.GroupInputSpecProto groupInputSpecProto) {
        GroupInputSpec groupSpec = new GroupInputSpec(groupInputSpecProto.getGroupName(), (List)groupInputSpecProto.getGroupVerticesList(), DagTypeConverters.convertInputDescriptorFromDAGPlan((DAGProtos.TezEntityDescriptorProto)groupInputSpecProto.getMergedInputDescriptor()));
        return groupSpec;
    }

    public static TezTestServiceProtocolProtos.GroupInputSpecProto convertGroupInputSpecToProto(GroupInputSpec groupInputSpec) {
        TezTestServiceProtocolProtos.GroupInputSpecProto.Builder builder = TezTestServiceProtocolProtos.GroupInputSpecProto.newBuilder();
        builder.setGroupName(groupInputSpec.getGroupName());
        builder.addAllGroupVertices((Iterable)groupInputSpec.getGroupVertices());
        builder.setMergedInputDescriptor(DagTypeConverters.convertToDAGPlan((EntityDescriptor)groupInputSpec.getMergedInputDescriptor()));
        return builder.build();
    }
}

