/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.shufflehandler;

import com.google.common.base.Charsets;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.SecureIOUtils;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.tez.common.Preconditions;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.runtime.library.common.security.SecureShuffleUtils;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.ShuffleHeader;
import org.apache.tez.runtime.library.common.sort.impl.TezIndexRecord;
import org.apache.tez.shufflehandler.IndexCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ShuffleHandler.class);
    public static final String SHUFFLE_HANDLER_LOCAL_DIRS = "tez.shuffle.handler.local-dirs";
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection.*reset|connection.*closed|broken.*pipe).*$", 2);
    private int port;
    private Shuffle SHUFFLE;
    private NioEventLoopGroup bossGroup;
    private NioEventLoopGroup workerGroup;
    private final ChannelGroup accepted = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    private final Configuration conf;
    private final ConcurrentMap<String, Boolean> registeredApps = new ConcurrentHashMap<String, Boolean>();
    private final int maxShuffleConnections;
    private Map<String, String> userRsrc;
    private JobTokenSecretManager secretManager;
    public static final String SHUFFLE_PORT_CONFIG_KEY = "tez.shuffle.port";
    public static final int DEFAULT_SHUFFLE_PORT = 15551;
    public static final String SHUFFLE_CONNECTION_KEEP_ALIVE_ENABLED = "mapreduce.shuffle.connection-keep-alive.enable";
    public static final boolean DEFAULT_SHUFFLE_CONNECTION_KEEP_ALIVE_ENABLED = false;
    public static final String SHUFFLE_CONNECTION_KEEP_ALIVE_TIME_OUT = "mapreduce.shuffle.connection-keep-alive.timeout";
    public static final int DEFAULT_SHUFFLE_CONNECTION_KEEP_ALIVE_TIME_OUT = 5;
    public static final String SHUFFLE_MAPOUTPUT_META_INFO_CACHE_SIZE = "mapreduce.shuffle.mapoutput-info.meta.cache.size";
    public static final int DEFAULT_SHUFFLE_MAPOUTPUT_META_INFO_CACHE_SIZE = 1000;
    public static final String CONNECTION_CLOSE = "close";
    public static final String MAX_SHUFFLE_CONNECTIONS = "mapreduce.shuffle.max.connections";
    public static final int DEFAULT_MAX_SHUFFLE_CONNECTIONS = 0;
    public static final String MAX_SHUFFLE_THREADS = "mapreduce.shuffle.max.threads";
    public static final int DEFAULT_MAX_SHUFFLE_THREADS = 0;
    final boolean connectionKeepAliveEnabled;
    final int connectionKeepAliveTimeOut;
    final int mapOutputMetaInfoCacheSize;
    private static final AtomicBoolean started = new AtomicBoolean(false);
    private static final AtomicBoolean initing = new AtomicBoolean(false);
    private static ShuffleHandler INSTANCE;

    public ShuffleHandler(Configuration conf) {
        this.conf = conf;
        this.maxShuffleConnections = conf.getInt(MAX_SHUFFLE_CONNECTIONS, 0);
        int maxShuffleThreads = conf.getInt(MAX_SHUFFLE_THREADS, 0);
        if (maxShuffleThreads == 0) {
            maxShuffleThreads = 2 * Runtime.getRuntime().availableProcessors();
        }
        String BOSS_THREAD_NAME_PREFIX = "ShuffleHandler Netty Boss #";
        final AtomicInteger bossThreadCounter = new AtomicInteger(0);
        this.bossGroup = new NioEventLoopGroup(maxShuffleThreads, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "ShuffleHandler Netty Boss #" + bossThreadCounter.incrementAndGet());
            }
        });
        String WORKER_THREAD_NAME_PREFIX = "ShuffleHandler Netty Worker #";
        final AtomicInteger workerThreadCounter = new AtomicInteger(0);
        this.workerGroup = new NioEventLoopGroup(maxShuffleThreads, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "ShuffleHandler Netty Worker #" + workerThreadCounter.incrementAndGet());
            }
        });
        this.connectionKeepAliveEnabled = conf.getBoolean(SHUFFLE_CONNECTION_KEEP_ALIVE_ENABLED, false);
        this.connectionKeepAliveTimeOut = Math.max(1, conf.getInt(SHUFFLE_CONNECTION_KEEP_ALIVE_TIME_OUT, 5));
        this.mapOutputMetaInfoCacheSize = Math.max(1, conf.getInt(SHUFFLE_MAPOUTPUT_META_INFO_CACHE_SIZE, 1000));
        this.userRsrc = new ConcurrentHashMap<String, String>();
        this.secretManager = new JobTokenSecretManager();
    }

    public void start() throws Exception {
        ServerBootstrap bootstrap = (ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(NioServerSocketChannel.class)).group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workerGroup).localAddress(this.port);
        this.initPipeline(bootstrap, this.conf);
        this.port = this.conf.getInt(SHUFFLE_PORT_CONFIG_KEY, 15551);
        Channel ch = bootstrap.bind().sync().channel();
        this.accepted.add((Object)ch);
        this.port = ((InetSocketAddress)ch.localAddress()).getPort();
        this.conf.set(SHUFFLE_PORT_CONFIG_KEY, Integer.toString(this.port));
        this.SHUFFLE.setPort(this.port);
        LOG.info("TezShuffleHandler listening on port " + this.port);
    }

    private void initPipeline(ServerBootstrap bootstrap, Configuration conf) throws Exception {
        this.SHUFFLE = this.getShuffle(conf);
        if (conf.getBoolean("mapreduce.shuffle.ssl.enabled", false)) {
            throw new UnsupportedOperationException("SSL Shuffle is not currently supported for the test shuffle handler");
        }
        ChannelInitializer<NioSocketChannel> channelInitializer = new ChannelInitializer<NioSocketChannel>(){

            public void initChannel(NioSocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
                pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(65536));
                pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
                pipeline.addLast("chunking", (ChannelHandler)new ChunkedWriteHandler());
                pipeline.addLast("shuffle", (ChannelHandler)ShuffleHandler.this.SHUFFLE);
            }
        };
        bootstrap.childHandler((ChannelHandler)channelInitializer);
    }

    public static void initializeAndStart(Configuration conf) throws Exception {
        if (!initing.getAndSet(true)) {
            INSTANCE = new ShuffleHandler(conf);
            INSTANCE.start();
            started.set(true);
        }
    }

    public static ShuffleHandler get() {
        Preconditions.checkState((boolean)started.get(), (Object)"ShuffleHandler must be started before invoking started");
        return INSTANCE;
    }

    public int getPort() {
        return this.port;
    }

    public void registerApplication(String applicationIdString, Token<JobTokenIdentifier> appToken, String user) {
        Boolean registered = this.registeredApps.putIfAbsent(applicationIdString, true);
        if (registered == null) {
            this.recordJobShuffleInfo(applicationIdString, user, appToken);
        }
    }

    public void unregisterApplication(String applicationIdString) {
        this.removeJobShuffleInfo(applicationIdString);
    }

    public void stop() throws Exception {
        this.accepted.close().awaitUninterruptibly(10L, TimeUnit.SECONDS);
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully();
        }
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
        }
    }

    protected Shuffle getShuffle(Configuration conf) {
        return new Shuffle(conf);
    }

    private void addJobToken(String appIdString, String user, Token<JobTokenIdentifier> jobToken) {
        String jobIdString = appIdString.replace("application", "job");
        this.userRsrc.put(jobIdString, user);
        this.secretManager.addTokenForJob(jobIdString, jobToken);
        LOG.info("Added token for " + jobIdString);
    }

    private void recordJobShuffleInfo(String appIdString, String user, Token<JobTokenIdentifier> jobToken) {
        this.addJobToken(appIdString, user, jobToken);
    }

    private void removeJobShuffleInfo(String appIdString) {
        this.secretManager.removeTokenForJob(appIdString);
        this.userRsrc.remove(appIdString);
    }

    @ChannelHandler.Sharable
    class Shuffle
    extends ChannelInboundHandlerAdapter {
        private final Configuration conf;
        private final IndexCache indexCache;
        private final LocalDirAllocator lDirAlloc = new LocalDirAllocator("tez.shuffle.handler.local-dirs");
        private int port;
        private final String USERCACHE_CONSTANT = "usercache";
        private final String APPCACHE_CONSTANT = "appcache";

        public Shuffle(Configuration conf) {
            this.conf = conf;
            this.indexCache = new IndexCache(conf);
            this.port = conf.getInt(ShuffleHandler.SHUFFLE_PORT_CONFIG_KEY, 15551);
        }

        public void setPort(int port) {
            this.port = port;
        }

        private List<String> splitMaps(List<String> mapq) {
            if (null == mapq) {
                return null;
            }
            ArrayList<String> ret = new ArrayList<String>();
            for (String s : mapq) {
                Collections.addAll(ret, s.split(","));
            }
            return ret;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            if (ShuffleHandler.this.maxShuffleConnections > 0 && ShuffleHandler.this.accepted.size() >= ShuffleHandler.this.maxShuffleConnections) {
                LOG.info(String.format("Current number of shuffle connections (%d) is greater than or equal to the max allowed shuffle connections (%d)", ShuffleHandler.this.accepted.size(), ShuffleHandler.this.maxShuffleConnections));
                ctx.channel().close();
                return;
            }
            ShuffleHandler.this.accepted.add((Object)ctx.channel());
            super.channelActive(ctx);
        }

        public void channelRead(ChannelHandlerContext ctx, Object message) throws Exception {
            String jobId;
            int reduceId;
            HttpRequest request = (HttpRequest)message;
            if (request.getMethod() != HttpMethod.GET) {
                this.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED);
                return;
            }
            if (!"mapreduce".equals(request.headers().get("name")) || !"1.0.0".equals(request.headers().get("version"))) {
                this.sendError(ctx, "Incompatible shuffle request version", HttpResponseStatus.BAD_REQUEST);
            }
            Map q = new QueryStringDecoder(request.getUri()).parameters();
            List keepAliveList = (List)q.get("keepAlive");
            boolean keepAliveParam = false;
            if (keepAliveList != null && keepAliveList.size() == 1) {
                keepAliveParam = Boolean.valueOf((String)keepAliveList.get(0));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("KeepAliveParam : " + keepAliveList + " : " + keepAliveParam);
                }
            }
            List<String> mapIds = this.splitMaps((List)q.get("map"));
            List reduceQ = (List)q.get("reduce");
            List jobQ = (List)q.get("job");
            if (LOG.isDebugEnabled()) {
                LOG.debug("RECV: " + request.getUri() + "\n  mapId: " + mapIds + "\n  reduceId: " + reduceQ + "\n  jobId: " + jobQ + "\n  keepAlive: " + keepAliveParam);
            }
            if (mapIds == null || reduceQ == null || jobQ == null) {
                this.sendError(ctx, "Required param job, map and reduce", HttpResponseStatus.BAD_REQUEST);
                return;
            }
            if (reduceQ.size() != 1 || jobQ.size() != 1) {
                this.sendError(ctx, "Too many job/reduce parameters", HttpResponseStatus.BAD_REQUEST);
                return;
            }
            try {
                reduceId = Integer.parseInt((String)reduceQ.get(0));
                jobId = (String)jobQ.get(0);
            }
            catch (NumberFormatException e) {
                this.sendError(ctx, "Bad reduce parameter", HttpResponseStatus.BAD_REQUEST);
                return;
            }
            catch (IllegalArgumentException e) {
                this.sendError(ctx, "Bad job parameter", HttpResponseStatus.BAD_REQUEST);
                return;
            }
            String reqUri = request.getUri();
            if (null == reqUri) {
                this.sendError(ctx, HttpResponseStatus.FORBIDDEN);
                return;
            }
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            try {
                this.verifyRequest(jobId, ctx, request, (HttpResponse)response, new URL("http", "", this.port, reqUri));
            }
            catch (IOException e) {
                LOG.warn("Shuffle failure ", (Throwable)e);
                this.sendError(ctx, e.getMessage(), HttpResponseStatus.UNAUTHORIZED);
                return;
            }
            HashMap<String, MapOutputInfo> mapOutputInfoMap = new HashMap<String, MapOutputInfo>();
            Channel ch = ctx.channel();
            String user = (String)ShuffleHandler.this.userRsrc.get(jobId);
            String outputBasePathStr = this.getBaseLocation(jobId, user);
            try {
                this.populateHeaders(mapIds, outputBasePathStr, user, reduceId, request, (HttpResponse)response, keepAliveParam, mapOutputInfoMap);
            }
            catch (IOException e) {
                ch.writeAndFlush((Object)response);
                LOG.error("Shuffle error in populating headers :", (Throwable)e);
                String errorMessage = this.getErrorMessage(e);
                this.sendError(ctx, errorMessage, HttpResponseStatus.INTERNAL_SERVER_ERROR);
                return;
            }
            ch.writeAndFlush((Object)response);
            ChannelFuture lastMap = null;
            for (String mapId : mapIds) {
                try {
                    MapOutputInfo info = (MapOutputInfo)mapOutputInfoMap.get(mapId);
                    if (info == null) {
                        info = this.getMapOutputInfo(outputBasePathStr, mapId, reduceId, user);
                    }
                    if (null != (lastMap = this.sendMapOutput(ctx, ch, user, mapId, reduceId, info))) continue;
                    this.sendError(ctx, HttpResponseStatus.NOT_FOUND);
                    return;
                }
                catch (IOException e) {
                    LOG.error("Shuffle error :", (Throwable)e);
                    String errorMessage = this.getErrorMessage(e);
                    this.sendError(ctx, errorMessage, HttpResponseStatus.INTERNAL_SERVER_ERROR);
                    return;
                }
            }
            lastMap.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }

        private String getErrorMessage(Throwable t) {
            StringBuffer sb = new StringBuffer(t.getMessage());
            while (t.getCause() != null) {
                sb.append(t.getCause().getMessage());
                t = t.getCause();
            }
            return sb.toString();
        }

        private String getBaseLocation(String jobIdString, String user) {
            String[] parts = jobIdString.split("_");
            Preconditions.checkArgument((parts.length == 3 ? 1 : 0) != 0, (Object)"Invalid jobId. Expecting 3 parts");
            ApplicationId appID = ApplicationId.newInstance((long)Long.parseLong(parts[1]), (int)Integer.parseInt(parts[2]));
            String baseStr = "usercache/" + user + "/" + "appcache" + "/" + ConverterUtils.toString((ApplicationId)appID) + "/output/";
            return baseStr;
        }

        protected MapOutputInfo getMapOutputInfo(String base, String mapId, int reduce, String user) throws IOException {
            Path indexFileName = this.lDirAlloc.getLocalPathToRead(base + "/file.out.index", this.conf);
            TezIndexRecord info = this.indexCache.getIndexInformation(mapId, reduce, indexFileName, user);
            Path mapOutputFileName = this.lDirAlloc.getLocalPathToRead(base + "/file.out", this.conf);
            if (LOG.isDebugEnabled()) {
                LOG.debug(base + " : " + mapOutputFileName + " : " + indexFileName);
            }
            MapOutputInfo outputInfo = new MapOutputInfo(mapOutputFileName, info);
            return outputInfo;
        }

        protected void populateHeaders(List<String> mapIds, String outputBaseStr, String user, int reduce, HttpRequest request, HttpResponse response, boolean keepAliveParam, Map<String, MapOutputInfo> mapOutputInfoMap) throws IOException {
            long contentLength = 0L;
            for (String mapId : mapIds) {
                String base = outputBaseStr + mapId;
                MapOutputInfo outputInfo = this.getMapOutputInfo(base, mapId, reduce, user);
                if (mapOutputInfoMap.size() < ShuffleHandler.this.mapOutputMetaInfoCacheSize) {
                    mapOutputInfoMap.put(mapId, outputInfo);
                }
                Path indexFileName = this.lDirAlloc.getLocalPathToRead(base + "/file.out.index", this.conf);
                TezIndexRecord info = this.indexCache.getIndexInformation(mapId, reduce, indexFileName, user);
                ShuffleHeader header = new ShuffleHeader(mapId, info.getPartLength(), info.getRawLength(), reduce);
                DataOutputBuffer dob = new DataOutputBuffer();
                header.write((DataOutput)dob);
                contentLength += info.getPartLength();
                contentLength += (long)dob.getLength();
            }
            this.setResponseHeaders(response, keepAliveParam, contentLength);
        }

        protected void setResponseHeaders(HttpResponse response, boolean keepAliveParam, long contentLength) {
            if (!ShuffleHandler.this.connectionKeepAliveEnabled && !keepAliveParam) {
                LOG.info("Setting connection close header...");
                response.headers().set("Connection", (Object)ShuffleHandler.CONNECTION_CLOSE);
            } else {
                response.headers().set("Content-Length", (Object)String.valueOf(contentLength));
                response.headers().set("Connection", (Object)"keep-alive");
                response.headers().set("keep-alive", (Object)("timeout=" + ShuffleHandler.this.connectionKeepAliveTimeOut));
                LOG.info("Content Length in shuffle : " + contentLength);
            }
        }

        protected void verifyRequest(String appid, ChannelHandlerContext ctx, HttpRequest request, HttpResponse response, URL requestUri) throws IOException {
            SecretKey tokenSecret = ShuffleHandler.this.secretManager.retrieveTokenSecret(appid);
            if (null == tokenSecret) {
                LOG.info("Request for unknown token " + appid);
                throw new IOException("could not find jobid");
            }
            String enc_str = SecureShuffleUtils.buildMsgFrom((URL)requestUri);
            String urlHashStr = request.headers().get("UrlHash");
            if (urlHashStr == null) {
                LOG.info("Missing header hash for " + appid);
                throw new IOException("fetcher cannot be authenticated");
            }
            if (LOG.isDebugEnabled()) {
                int len = urlHashStr.length();
                LOG.debug("verifying request. enc_str=" + enc_str + "; hash=..." + urlHashStr.substring(len - len / 2, len - 1));
            }
            SecureShuffleUtils.verifyReply((String)urlHashStr, (String)enc_str, (SecretKey)tokenSecret);
            String reply = SecureShuffleUtils.generateHash((byte[])urlHashStr.getBytes(Charsets.UTF_8), (SecretKey)tokenSecret);
            response.headers().set("ReplyHash", (Object)reply);
            response.headers().set("name", (Object)"mapreduce");
            response.headers().set("version", (Object)"1.0.0");
            if (LOG.isDebugEnabled()) {
                int len = reply.length();
                LOG.debug("Fetcher request verfied. enc_str=" + enc_str + ";reply=" + reply.substring(len - len / 2, len - 1));
            }
        }

        protected ChannelFuture sendMapOutput(ChannelHandlerContext ctx, Channel ch, String user, String mapId, int reduce, MapOutputInfo mapOutputInfo) throws IOException {
            RandomAccessFile spill;
            TezIndexRecord info = mapOutputInfo.indexRecord;
            ShuffleHeader header = new ShuffleHeader(mapId, info.getPartLength(), info.getRawLength(), reduce);
            DataOutputBuffer dob = new DataOutputBuffer();
            header.write((DataOutput)dob);
            ch.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])dob.getData(), (int)0, (int)dob.getLength()));
            File spillfile = new File(mapOutputInfo.mapOutputFileName.toString());
            try {
                spill = SecureIOUtils.openForRandomRead((File)spillfile, (String)"r", (String)user, null);
            }
            catch (FileNotFoundException e) {
                LOG.info(spillfile + " not found");
                return null;
            }
            DefaultFileRegion partition = new DefaultFileRegion(spill.getChannel(), info.getStartOffset(), info.getPartLength());
            ChannelFuture writeFuture = ch.writeAndFlush((Object)partition);
            return writeFuture;
        }

        protected void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
            this.sendError(ctx, "", status);
        }

        protected void sendError(ChannelHandlerContext ctx, String message, HttpResponseStatus status) {
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
            response.headers().set("Content-Type", (Object)"text/plain; charset=UTF-8");
            response.headers().set("name", (Object)"mapreduce");
            response.headers().set("version", (Object)"1.0.0");
            response.content().writeBytes(Unpooled.copiedBuffer((CharSequence)message, (Charset)CharsetUtil.UTF_8));
            ctx.channel().writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (cause instanceof TooLongFrameException) {
                this.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
                return;
            }
            if (cause instanceof IOException) {
                if (cause instanceof ClosedChannelException) {
                    LOG.debug("Ignoring closed channel error", cause);
                    return;
                }
                String message = String.valueOf(cause.getMessage());
                if (IGNORABLE_ERROR_MESSAGE.matcher(message).matches()) {
                    LOG.debug("Ignoring client socket close", cause);
                    return;
                }
            }
            LOG.error("Shuffle error: ", cause);
            if (ctx.channel().isActive()) {
                LOG.error("Shuffle error", cause);
                this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
        }

        class MapOutputInfo {
            final Path mapOutputFileName;
            final TezIndexRecord indexRecord;

            MapOutputInfo(Path mapOutputFileName, TezIndexRecord indexRecord) {
                this.mapOutputFileName = mapOutputFileName;
                this.indexRecord = indexRecord;
            }
        }
    }
}

