/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.common.Preconditions;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.serviceplugins.api.TaskAttemptEndReason;
import org.apache.tez.serviceplugins.api.TaskScheduler;
import org.apache.tez.serviceplugins.api.TaskSchedulerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezTestServiceTaskSchedulerService
extends TaskScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(TezTestServiceTaskSchedulerService.class);
    private final List<String> serviceHosts;
    private final ContainerFactory containerFactory;
    private final Random random = new Random();
    private final int containerPort;
    private final ConcurrentMap<Object, ContainerId> runningTasks = new ConcurrentHashMap<Object, ContainerId>();
    private final int memoryPerInstance;
    private final int coresPerInstance;
    private final int executorsPerInstance;
    private final Resource resourcePerContainer;

    public TezTestServiceTaskSchedulerService(TaskSchedulerContext taskSchedulerContext) {
        super(taskSchedulerContext);
        this.serviceHosts = new LinkedList<String>();
        this.containerFactory = new ContainerFactory(taskSchedulerContext.getApplicationAttemptId(), taskSchedulerContext.getCustomClusterIdentifier());
        Configuration conf = null;
        try {
            conf = TezUtils.createConfFromUserPayload((UserPayload)taskSchedulerContext.getInitialUserPayload());
        }
        catch (IOException e) {
            throw new TezUncheckedException((Throwable)e);
        }
        this.memoryPerInstance = conf.getInt("tez.test.service.memory.per.instance.mb", -1);
        Preconditions.checkArgument((this.memoryPerInstance > 0 ? 1 : 0) != 0, (Object)"tez.test.service.memory.per.instance.mb must be configured");
        this.executorsPerInstance = conf.getInt("tez.test.service.num.executors.per-instance", -1);
        Preconditions.checkArgument((this.executorsPerInstance > 0 ? 1 : 0) != 0, (Object)"tez.test.service.num.executors.per-instance must be configured");
        this.coresPerInstance = conf.getInt("tez.test.service.vcpus.per.instance", this.executorsPerInstance);
        this.containerPort = conf.getInt("tez.test.service.rpc.port", -1);
        Preconditions.checkArgument((this.executorsPerInstance > 0 ? 1 : 0) != 0, (Object)"tez.test.service.rpc.port must be configured");
        int memoryPerContainer = (int)((float)this.memoryPerInstance / (float)this.executorsPerInstance);
        int coresPerContainer = (int)((float)this.coresPerInstance / (float)this.executorsPerInstance);
        this.resourcePerContainer = Resource.newInstance((int)memoryPerContainer, (int)coresPerContainer);
        String[] hosts = conf.getTrimmedStrings("tez.test.service.hosts");
        if (hosts == null || hosts.length == 0) {
            hosts = new String[]{"localhost"};
        }
        for (String host : hosts) {
            this.serviceHosts.add(host);
        }
        LOG.info("Running with configuration: memoryPerInstance=" + this.memoryPerInstance + ", vcoresPerInstance=" + this.coresPerInstance + ", executorsPerInstance=" + this.executorsPerInstance + ", resourcePerContainerInferred=" + this.resourcePerContainer + ", hosts=" + this.serviceHosts.toString());
    }

    public Resource getAvailableResources() {
        return Resource.newInstance((int)Ints.checkedCast((long)(this.serviceHosts.size() * this.memoryPerInstance)), (int)(this.serviceHosts.size() * this.coresPerInstance));
    }

    public int getClusterNodeCount() {
        return this.serviceHosts.size();
    }

    public void dagComplete() {
    }

    public Resource getTotalResources() {
        return Resource.newInstance((int)Ints.checkedCast((long)(this.serviceHosts.size() * this.memoryPerInstance)), (int)(this.serviceHosts.size() * this.coresPerInstance));
    }

    public void blacklistNode(NodeId nodeId) {
        LOG.info("BlacklistNode not supported");
    }

    public void unblacklistNode(NodeId nodeId) {
        LOG.info("unBlacklistNode not supported");
    }

    public void allocateTask(Object task, Resource capability, String[] hosts, String[] racks, Priority priority, Object containerSignature, Object clientCookie) {
        String host = this.selectHost(hosts);
        Container container = this.containerFactory.createContainer(this.resourcePerContainer, priority, host, this.containerPort);
        this.runningTasks.put(task, container.getId());
        this.getContext().taskAllocated(task, clientCookie, container);
    }

    public void allocateTask(Object task, Resource capability, ContainerId containerId, Priority priority, Object containerSignature, Object clientCookie) {
        String host = this.selectHost(null);
        Container container = this.containerFactory.createContainer(this.resourcePerContainer, priority, host, this.containerPort);
        this.runningTasks.put(task, container.getId());
        this.getContext().taskAllocated(task, clientCookie, container);
    }

    public boolean deallocateTask(Object task, boolean taskSucceeded, TaskAttemptEndReason endReason, String diagnostics) {
        ContainerId containerId = (ContainerId)this.runningTasks.remove(task);
        if (containerId == null) {
            LOG.error("Could not determine ContainerId for task: " + task + " . Could have hit a race condition. Ignoring. The query may hang since this \"unknown\" container is now taking up a slot permanently");
            return false;
        }
        this.getContext().containerBeingReleased(containerId);
        return true;
    }

    public Object deallocateContainer(ContainerId containerId) {
        LOG.info("Ignoring deallocateContainer for containerId: " + containerId);
        return null;
    }

    public void setShouldUnregister() {
    }

    public boolean hasUnregistered() {
        return true;
    }

    private String selectHost(String[] requestedHosts) {
        String host;
        if (requestedHosts != null && requestedHosts.length > 0) {
            Arrays.sort(requestedHosts);
            host = requestedHosts[0];
            LOG.info("Selected host: " + host + " from requested hosts: " + Arrays.toString(requestedHosts));
        } else {
            host = this.serviceHosts.get(this.random.nextInt(this.serviceHosts.size()));
            LOG.info("Selected random host: " + host + " since the request contained no host information");
        }
        return host;
    }

    public int getHeldContainersCount() {
        return 0;
    }

    static class ContainerFactory {
        AtomicInteger nextId = new AtomicInteger(1);
        final ApplicationAttemptId customAppAttemptId;

        public ContainerFactory(ApplicationAttemptId appAttemptId, long appIdLong) {
            ApplicationId appId = ApplicationId.newInstance((long)appIdLong, (int)appAttemptId.getApplicationId().getId());
            this.customAppAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)appAttemptId.getAttemptId());
        }

        public Container createContainer(Resource capability, Priority priority, String hostname, int port) {
            ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)this.customAppAttemptId, (int)this.nextId.getAndIncrement());
            NodeId nodeId = NodeId.newInstance((String)hostname, (int)port);
            String nodeHttpAddress = "hostname:0";
            Container container = Container.newInstance((ContainerId)containerId, (NodeId)nodeId, (String)nodeHttpAddress, (Resource)capability, (Priority)priority, null);
            return container;
        }
    }
}

