/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.web;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.webapp.Controller;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.WebAppException;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.LimitExceededException;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.client.ProgressBuilder;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.app.dag.TaskAttempt;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMWebController
extends Controller {
    private static final Logger LOG = LoggerFactory.getLogger(AMWebController.class);
    static final String ORIGIN = "Origin";
    static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    static final String ALLOWED_METHODS = "GET, HEAD";
    static final String ALLOWED_HEADERS = "X-Requested-With,Content-Type,Accept,Origin";
    static final String DAG_PROGRESS = "dagProgress";
    static final String VERTEX_PROGRESS = "vertexProgress";
    static final String VERTEX_PROGRESSES = "vertexProgresses";
    static final int MAX_QUERIED = 100;
    public static final String VERSION = "2";
    private AppContext appContext;
    private String historyUrl;

    @Inject
    public AMWebController(Controller.RequestContext requestContext, AppContext appContext, @Named(value="TezUIHistoryURL") String historyUrl) {
        super(requestContext);
        this.appContext = appContext;
        this.historyUrl = historyUrl;
    }

    public void index() {
        this.ui();
    }

    public void ui() {
        this.render(StaticAMView.class);
    }

    public void main() {
        this.ui();
    }

    public void about() {
        this.renderJSON("Tez AM UI WebServices");
    }

    static String encodeHeader(String header) {
        if (header == null) {
            return null;
        }
        return header.split("\n|\r")[0].trim();
    }

    @VisibleForTesting
    public void setCorsHeaders() {
        HttpServletResponse res = this.response();
        String historyUrlBase = this.appContext.getAMConf().get("tez.tez-ui.history-url.base", "");
        String origin = this.request().getHeader(ORIGIN);
        if (origin == null) {
            try {
                URL url = new URL(historyUrlBase);
                origin = url.getProtocol() + "://" + url.getAuthority();
            }
            catch (MalformedURLException e) {
                LOG.debug("Invalid url set for tez history url base: {}", (Object)historyUrlBase, (Object)e);
            }
        }
        if (origin != null) {
            origin = AMWebController.encodeHeader(origin);
            res.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN, origin);
        }
        res.setHeader(ACCESS_CONTROL_ALLOW_METHODS, ALLOWED_METHODS);
        res.setHeader(ACCESS_CONTROL_ALLOW_CREDENTIALS, Boolean.TRUE.toString());
        res.setHeader(ACCESS_CONTROL_ALLOW_HEADERS, ALLOWED_HEADERS);
        res.setHeader(ACCESS_CONTROL_MAX_AGE, "1800");
    }

    void sendErrorResponse(int sc, String msg, Exception e) {
        LOG.debug(msg, (Throwable)e);
        try {
            this.response().sendError(sc, msg);
        }
        catch (IOException e1) {
            throw new WebAppException((Throwable)e);
        }
    }

    @VisibleForTesting
    static boolean _hasAccess(UserGroupInformation callerUGI, AppContext appContext) {
        if (callerUGI == null) {
            return !appContext.getAMACLManager().isAclsEnabled();
        }
        return appContext.getAMACLManager().checkDAGViewAccess(callerUGI);
    }

    public boolean hasAccess() {
        String remoteUser = this.request().getRemoteUser();
        UserGroupInformation callerUGI = null;
        if (remoteUser != null && !remoteUser.isEmpty()) {
            callerUGI = UserGroupInformation.createRemoteUser((String)remoteUser);
        }
        return AMWebController._hasAccess(callerUGI, this.appContext);
    }

    public void getDagProgress() {
        int dagID;
        this.setCorsHeaders();
        if (!this.hasAccess()) {
            this.sendErrorResponse(401, "Access denied for user: " + this.request().getRemoteUser(), null);
            return;
        }
        try {
            dagID = this.getQueryParamInt("dagID");
        }
        catch (NumberFormatException e) {
            this.sendErrorResponse(400, "Invalid dag id:", e);
            return;
        }
        DAG currentDAG = this.appContext.getCurrentDAG();
        if (currentDAG == null || dagID != currentDAG.getID().getId()) {
            this.sendErrorResponse(404, "Not current Dag: " + dagID, null);
            return;
        }
        HashMap<String, ProgressInfo> result = new HashMap<String, ProgressInfo>();
        result.put(DAG_PROGRESS, new ProgressInfo(currentDAG.getID().toString(), currentDAG.getCompletedTaskProgress()));
        this.renderJSON(result);
    }

    public void getVertexProgress() {
        int vertexID;
        int dagID;
        this.setCorsHeaders();
        if (!this.hasAccess()) {
            this.sendErrorResponse(401, "Access denied for user: " + this.request().getRemoteUser(), null);
            return;
        }
        try {
            dagID = this.getQueryParamInt("dagID");
            vertexID = this.getQueryParamInt("vertexID");
        }
        catch (NumberFormatException e) {
            this.sendErrorResponse(400, "Invalid dag or vertex id", e);
            return;
        }
        DAG currentDAG = this.appContext.getCurrentDAG();
        if (currentDAG == null || currentDAG.getID().getId() != dagID) {
            this.sendErrorResponse(404, "Not current Dag: " + dagID, null);
            return;
        }
        TezVertexID tezVertexID = TezVertexID.getInstance((TezDAGID)currentDAG.getID(), (int)vertexID);
        Vertex vertex = currentDAG.getVertex(tezVertexID);
        if (vertex == null) {
            this.sendErrorResponse(404, "vertex not found: " + vertexID, null);
            return;
        }
        HashMap<String, ProgressInfo> result = new HashMap<String, ProgressInfo>();
        result.put(VERTEX_PROGRESS, new ProgressInfo(tezVertexID.toString(), vertex.getCompletedTaskProgress()));
        this.renderJSON(result);
    }

    Collection<Vertex> getVerticesByIdx(DAG dag, Collection<Integer> indexes) {
        ArrayList<Vertex> vertices = new ArrayList<Vertex>(indexes.size());
        TezDAGID tezDAGID = dag.getID();
        for (Integer idx : indexes) {
            Vertex vertex;
            TezVertexID tezVertexID = TezVertexID.getInstance((TezDAGID)tezDAGID, (int)idx);
            if (tezVertexID == null || (vertex = dag.getVertex(tezVertexID)) == null) continue;
            vertices.add(vertex);
        }
        return vertices;
    }

    int getQueryParamInt(String name) throws NumberFormatException {
        String valueStr = this.$(name).trim();
        return Integer.parseInt(valueStr);
    }

    public void getVertexProgresses() {
        int dagID;
        this.setCorsHeaders();
        if (!this.hasAccess()) {
            this.sendErrorResponse(401, "Access denied for user: " + this.request().getRemoteUser(), null);
            return;
        }
        ArrayList<Integer> vertexIDs = new ArrayList<Integer>();
        try {
            dagID = this.getQueryParamInt("dagID");
            for (String vertexIDStr : this.$("vertexID").trim().split(",", 100)) {
                vertexIDs.add(Integer.parseInt(vertexIDStr));
            }
        }
        catch (NumberFormatException e) {
            this.sendErrorResponse(400, "Invalid dag or vertices id", e);
            return;
        }
        DAG currentDAG = this.appContext.getCurrentDAG();
        if (currentDAG == null || currentDAG.getID().getId() != dagID) {
            this.sendErrorResponse(404, "Not current Dag: " + dagID, null);
            return;
        }
        Collection<Vertex> vertices = vertexIDs.isEmpty() ? currentDAG.getVertices().values() : this.getVerticesByIdx(currentDAG, vertexIDs);
        ArrayList<ProgressInfo> progresses = new ArrayList<ProgressInfo>(vertices.size());
        for (Vertex vertex : vertices) {
            progresses.add(new ProgressInfo(vertex.getVertexId().toString(), vertex.getCompletedTaskProgress()));
        }
        HashMap<String, ArrayList<ProgressInfo>> result = new HashMap<String, ArrayList<ProgressInfo>>();
        result.put(VERTEX_PROGRESSES, progresses);
        this.renderJSON(result);
    }

    @VisibleForTesting
    protected boolean setupResponse() {
        this.setCorsHeaders();
        if (!this.hasAccess()) {
            this.sendErrorResponse(401, "Access denied for user: " + this.request().getRemoteUser(), null);
            return false;
        }
        return true;
    }

    DAG checkAndGetDAGFromRequest() {
        DAG dag = null;
        int errorCode = 200;
        String message = null;
        NumberFormatException ex = null;
        try {
            int dagID = this.getQueryParamInt("dagID");
            dag = this.appContext.getCurrentDAG();
            if (dag == null || dag.getID().getId() != dagID) {
                errorCode = 404;
                message = "Not current Dag: " + dagID;
            }
        }
        catch (NumberFormatException e) {
            errorCode = 400;
            message = "Invalid dag id";
            ex = e;
        }
        if (errorCode != 200) {
            dag = null;
            this.sendErrorResponse(errorCode, message, ex);
        }
        return dag;
    }

    Collection<Integer> getVertexIDsFromRequest() {
        String valueStr = this.$("vertexID").trim();
        ArrayList<Integer> vertexIDs = new ArrayList<Integer>();
        if (!valueStr.equals("")) {
            String[] vertexIdsStr = valueStr.split(",", 100);
            try {
                for (String vertexIdStr : vertexIdsStr) {
                    int vertexId = Integer.parseInt(vertexIdStr);
                    vertexIDs.add(vertexId);
                }
            }
            catch (NumberFormatException nfe) {
                this.sendErrorResponse(400, "invalid vertex ID passed in as parameter", nfe);
                vertexIDs = null;
            }
        }
        return vertexIDs;
    }

    Map<String, Set<String>> getCounterListFromRequest() {
        String counterStr = this.$("counters").trim();
        if (counterStr == null || counterStr.isEmpty()) {
            return null;
        }
        String delimiter = ";";
        String groupDelimiter = "/";
        String counterDelimiter = ",";
        StringTokenizer tokenizer = new StringTokenizer(counterStr, delimiter);
        TreeMap<String, Set<String>> counterList = new TreeMap<String, Set<String>>();
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken().trim();
            int pos = token.indexOf(groupDelimiter);
            if (pos == -1) {
                counterList.put(token, Collections.emptySet());
                continue;
            }
            String counterGroup = token.substring(0, pos);
            HashSet counters = Collections.emptySet();
            if (pos < token.length() - 1) {
                String counterNames = token.substring(pos + 1, token.length());
                counters = Sets.newHashSet((Iterable)Splitter.on((String)counterDelimiter).omitEmptyStrings().trimResults().split((CharSequence)counterNames));
            }
            counterList.put(counterGroup, counters);
        }
        return counterList;
    }

    List<String> splitString(String str, String delimiter, Integer limit) {
        ArrayList<String> items = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(str, delimiter);
        for (int count = 0; tokenizer.hasMoreElements() && count < limit; ++count) {
            items.add(tokenizer.nextToken());
        }
        return items;
    }

    List<Integer> getIntegersFromRequest(String paramName, Integer limit) {
        String valuesStr = this.$(paramName).trim();
        ArrayList<Integer> values = new ArrayList<Integer>();
        if (!valuesStr.equals("")) {
            try {
                for (String valueStr : this.splitString(valuesStr, ",", limit)) {
                    int value = Integer.parseInt(valueStr);
                    values.add(value);
                }
            }
            catch (NumberFormatException nfe) {
                this.sendErrorResponse(400, String.format("invalid %s passed in as parameter", paramName), nfe);
                values = null;
            }
        }
        return values;
    }

    List<List<Integer>> getIDsFromRequest(String paramName, Integer limit, Integer count) {
        String valuesStr = this.$(paramName).trim();
        ArrayList<List<Integer>> values = new ArrayList<List<Integer>>();
        if (!valuesStr.equals("")) {
            try {
                for (String valueStr : this.splitString(valuesStr, ",", limit)) {
                    ArrayList<Integer> innerValues = new ArrayList<Integer>();
                    String[] innerValueStrs = valueStr.split("_");
                    if (innerValueStrs.length != count) continue;
                    for (String innerValueStr : innerValueStrs) {
                        int value = Integer.parseInt(innerValueStr);
                        innerValues.add(value);
                    }
                    values.add(innerValues);
                }
            }
            catch (NumberFormatException nfe) {
                this.sendErrorResponse(400, String.format("invalid %s passed in as parameter", paramName), nfe);
                values = null;
            }
        }
        return values;
    }

    public void getDagInfo() {
        if (!this.setupResponse()) {
            return;
        }
        DAG dag = this.checkAndGetDAGFromRequest();
        if (dag == null) {
            return;
        }
        Map<String, Set<String>> counterNames = this.getCounterListFromRequest();
        HashMap<String, Object> dagInfo = new HashMap<String, Object>();
        dagInfo.put("id", dag.getID().toString());
        dagInfo.put("progress", Float.toString(dag.getCompletedTaskProgress()));
        dagInfo.put("status", dag.getState().toString());
        try {
            TezCounters counters;
            Map<String, Map<String, Long>> counterMap;
            if (counterNames != null && !counterNames.isEmpty() && (counterMap = this.constructCounterMapInfo(counters = dag.getCachedCounters(), counterNames)) != null && !counterMap.isEmpty()) {
                dagInfo.put("counters", counterMap);
            }
        }
        catch (LimitExceededException limitExceededException) {
            // empty catch block
        }
        this.renderJSON(ImmutableMap.of((Object)"dag", dagInfo));
    }

    Map<String, Map<String, Long>> constructCounterMapInfo(TezCounters counters, Map<String, Set<String>> counterNames) {
        if (counterNames == null || counterNames.isEmpty()) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Requested counter names=" + counterNames.entrySet());
            LOG.debug("actual counters=" + counters);
        }
        TreeMap<String, Map<String, Long>> counterInfo = new TreeMap<String, Map<String, Long>>();
        if (counterNames.containsKey("*")) {
            for (CounterGroup grpCounters : counters) {
                HashMap<String, Long> matchedCounters = new HashMap<String, Long>();
                for (TezCounter counter : grpCounters) {
                    matchedCounters.put(counter.getName(), counter.getValue());
                }
                counterInfo.put(grpCounters.getName(), matchedCounters);
            }
        } else {
            for (Map.Entry<String, Set<String>> entry : counterNames.entrySet()) {
                HashMap<String, Long> matchedCounters = new HashMap<String, Long>();
                CounterGroup grpCounters = (CounterGroup)counters.getGroup(entry.getKey());
                for (TezCounter counter : grpCounters) {
                    if (!entry.getValue().isEmpty() && !entry.getValue().contains(counter.getName())) continue;
                    matchedCounters.put(counter.getName(), counter.getValue());
                }
                counterInfo.put(entry.getKey(), matchedCounters);
            }
        }
        return counterInfo;
    }

    private Map<String, Object> getVertexInfoMap(Vertex vertex, Map<String, Set<String>> counterNames) {
        HashMap<String, Object> vertexInfo = new HashMap<String, Object>();
        vertexInfo.put("id", vertex.getVertexId().toString());
        vertexInfo.put("status", vertex.getState().toString());
        vertexInfo.put("progress", Float.toString(vertex.getCompletedTaskProgress()));
        vertexInfo.put("initTime", Long.toString(vertex.getInitTime()));
        vertexInfo.put("startTime", Long.toString(vertex.getStartTime()));
        vertexInfo.put("finishTime", Long.toString(vertex.getFinishTime()));
        vertexInfo.put("firstTaskStartTime", Long.toString(vertex.getFirstTaskStartTime()));
        vertexInfo.put("lastTaskFinishTime", Long.toString(vertex.getLastTaskFinishTime()));
        ProgressBuilder vertexProgress = vertex.getVertexProgress();
        vertexInfo.put("totalTasks", Integer.toString(vertexProgress.getTotalTaskCount()));
        vertexInfo.put("runningTasks", Integer.toString(vertexProgress.getRunningTaskCount()));
        vertexInfo.put("succeededTasks", Integer.toString(vertexProgress.getSucceededTaskCount()));
        vertexInfo.put("failedTaskAttempts", Integer.toString(vertexProgress.getFailedTaskAttemptCount()));
        vertexInfo.put("killedTaskAttempts", Integer.toString(vertexProgress.getKilledTaskAttemptCount()));
        try {
            TezCounters counters;
            Map<String, Map<String, Long>> counterMap;
            if (counterNames != null && !counterNames.isEmpty() && (counterMap = this.constructCounterMapInfo(counters = vertex.getCachedCounters(), counterNames)) != null && !counterMap.isEmpty()) {
                vertexInfo.put("counters", counterMap);
            }
        }
        catch (LimitExceededException limitExceededException) {
            // empty catch block
        }
        return vertexInfo;
    }

    public void getVerticesInfo() {
        if (!this.setupResponse()) {
            return;
        }
        DAG dag = this.checkAndGetDAGFromRequest();
        if (dag == null) {
            return;
        }
        Collection<Integer> requestedIDs = this.getVertexIDsFromRequest();
        if (requestedIDs == null) {
            return;
        }
        Map<String, Set<String>> counterNames = this.getCounterListFromRequest();
        Collection<Vertex> vertexList = requestedIDs.isEmpty() ? dag.getVertices().values() : this.getVerticesByIdx(dag, requestedIDs);
        ArrayList<Map<String, Object>> verticesInfo = new ArrayList<Map<String, Object>>();
        for (Vertex v : vertexList) {
            verticesInfo.add(this.getVertexInfoMap(v, counterNames));
        }
        this.renderJSON(ImmutableMap.of((Object)"vertices", verticesInfo));
    }

    Vertex getVertexFromIndex(DAG dag, Integer vertexIndex) {
        TezVertexID tezVertexID = TezVertexID.getInstance((TezDAGID)dag.getID(), (int)vertexIndex);
        Vertex vertex = dag.getVertex(tezVertexID);
        return vertex;
    }

    List<Task> getRequestedTasks(DAG dag, Integer limit) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        List<List<Integer>> taskIDs = this.getIDsFromRequest("taskID", limit, 2);
        if (taskIDs == null) {
            return null;
        }
        if (!taskIDs.isEmpty()) {
            for (List<Integer> indexes : taskIDs) {
                Task task;
                Vertex vertex = this.getVertexFromIndex(dag, indexes.get(0));
                if (vertex == null || (task = vertex.getTask(indexes.get(1))) == null) continue;
                tasks.add(task);
                if (tasks.size() < limit) continue;
                break;
            }
        } else {
            List<Integer> vertexIDs = this.getIntegersFromRequest("vertexID", limit);
            if (vertexIDs == null) {
                return null;
            }
            if (!vertexIDs.isEmpty()) {
                for (Integer vertexID : vertexIDs) {
                    Vertex vertex = this.getVertexFromIndex(dag, vertexID);
                    if (vertex == null) continue;
                    ArrayList<Task> vertexTasks = new ArrayList<Task>(vertex.getTasks().values());
                    tasks.addAll(vertexTasks.subList(0, Math.min(vertexTasks.size(), limit - tasks.size())));
                    if (tasks.size() < limit) continue;
                    break;
                }
            } else {
                Collection<Vertex> vertices = dag.getVertices().values();
                for (Vertex vertex : vertices) {
                    ArrayList<Task> vertexTasks = new ArrayList<Task>(vertex.getTasks().values());
                    tasks.addAll(vertexTasks.subList(0, Math.min(vertexTasks.size(), limit - tasks.size())));
                    if (tasks.size() < limit) continue;
                    break;
                }
            }
        }
        return tasks;
    }

    public void getTasksInfo() {
        if (!this.setupResponse()) {
            return;
        }
        DAG dag = this.checkAndGetDAGFromRequest();
        if (dag == null) {
            return;
        }
        int limit = 100;
        try {
            limit = this.getQueryParamInt("limit");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        List<Task> tasks = this.getRequestedTasks(dag, limit);
        if (tasks == null) {
            return;
        }
        Map<String, Set<String>> counterNames = this.getCounterListFromRequest();
        ArrayList tasksInfo = new ArrayList();
        for (Task t : tasks) {
            HashMap<String, Object> taskInfo = new HashMap<String, Object>();
            taskInfo.put("id", t.getTaskID().toString());
            taskInfo.put("progress", Float.toString(t.getProgress()));
            taskInfo.put("status", t.getState().toString());
            try {
                TezCounters counters = t.getCounters();
                Map<String, Map<String, Long>> counterMap = this.constructCounterMapInfo(counters, counterNames);
                if (counterMap != null && !counterMap.isEmpty()) {
                    taskInfo.put("counters", counterMap);
                }
            }
            catch (LimitExceededException limitExceededException) {
                // empty catch block
            }
            tasksInfo.add(taskInfo);
        }
        this.renderJSON(ImmutableMap.of((Object)"tasks", tasksInfo));
    }

    List<TaskAttempt> getRequestedAttempts(DAG dag, Integer limit) {
        ArrayList<TaskAttempt> attempts = new ArrayList<TaskAttempt>();
        List<List<Integer>> attemptIDs = this.getIDsFromRequest("attemptID", limit, 3);
        if (attemptIDs == null) {
            return null;
        }
        if (!attemptIDs.isEmpty()) {
            for (List<Integer> indexes : attemptIDs) {
                TaskAttempt attempt;
                Task task;
                Vertex vertex = this.getVertexFromIndex(dag, indexes.get(0));
                if (vertex == null || (task = vertex.getTask(indexes.get(1))) == null || (attempt = task.getAttempt(TezTaskAttemptID.getInstance((TezTaskID)task.getTaskID(), (int)indexes.get(2)))) == null) continue;
                attempts.add(attempt);
                if (attempts.size() < limit) continue;
                break;
            }
        }
        return attempts;
    }

    public void getAttemptsInfo() {
        if (!this.setupResponse()) {
            return;
        }
        DAG dag = this.checkAndGetDAGFromRequest();
        if (dag == null) {
            return;
        }
        int limit = 100;
        try {
            limit = this.getQueryParamInt("limit");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        List<TaskAttempt> attempts = this.getRequestedAttempts(dag, limit);
        if (attempts == null) {
            return;
        }
        Map<String, Set<String>> counterNames = this.getCounterListFromRequest();
        ArrayList attemptsInfo = new ArrayList();
        for (TaskAttempt a : attempts) {
            HashMap<String, Object> attemptInfo = new HashMap<String, Object>();
            attemptInfo.put("id", a.getTaskAttemptID().toString());
            attemptInfo.put("progress", Float.toString(a.getProgress()));
            attemptInfo.put("status", a.getState().toString());
            try {
                TezCounters counters = a.getCounters();
                Map<String, Map<String, Long>> counterMap = this.constructCounterMapInfo(counters, counterNames);
                if (counterMap != null && !counterMap.isEmpty()) {
                    attemptInfo.put("counters", counterMap);
                }
            }
            catch (LimitExceededException limitExceededException) {
                // empty catch block
            }
            attemptsInfo.add(attemptInfo);
        }
        this.renderJSON(ImmutableMap.of((Object)"attempts", attemptsInfo));
    }

    @VisibleForTesting
    public void renderJSON(Object object) {
        super.renderJSON(object);
    }

    public static class StaticAMView
    extends View {
        @Inject
        AppContext appContext;
        @Inject
        @Named(value="TezUIHistoryURL")
        String historyUrl;

        public void render() {
            this.response().setContentType("text/html; charset=UTF-8");
            PrintWriter pw = this.writer();
            pw.write("<html>");
            pw.write("<head>");
            pw.write("<meta charset=\"utf-8\">");
            pw.write("<title>Redirecting to Tez UI</title>");
            pw.write("</head>");
            pw.write("<body>");
            if (this.historyUrl == null || this.historyUrl.isEmpty()) {
                pw.write("<h1>Tez UI Url is not defined.</h1><p>To enable tracking url pointing to Tez UI, set the config <b>tez.tez-ui.history-url.base</b> in the tez-site.xml.</p>");
            } else {
                pw.write("<h1>Redirecting to Tez UI</h1>. <p>If you are not redirected shortly, click <a href='" + this.historyUrl + "'><b>here</b></a></p>");
                pw.write("<script type='text/javascript'>setTimeout(function() { window.location.replace('" + this.historyUrl + "');}, 0); </script>");
            }
            pw.write("</body>");
            pw.write("</html>");
            pw.flush();
        }
    }

    @VisibleForTesting
    static class ProgressInfo {
        private String id;
        private float progress;

        public float getProgress() {
            return this.progress;
        }

        public String getId() {
            return this.id;
        }

        public ProgressInfo(String id, float progress) {
            this.id = id;
            this.progress = progress;
        }
    }
}

