/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.hadoop.yarn.client.api.async.impl.AMRMClientAsyncImpl;
import org.apache.hadoop.yarn.client.api.impl.AMRMClientImpl;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;
import org.apache.hadoop.yarn.util.RackResolver;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.tez.common.ContainerSignatureMatcher;
import org.apache.tez.common.Preconditions;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.app.dag.TaskAttempt;
import org.apache.tez.dag.app.rm.YarnTaskSchedulerServiceError;
import org.apache.tez.serviceplugins.api.DagInfo;
import org.apache.tez.serviceplugins.api.ServicePluginError;
import org.apache.tez.serviceplugins.api.TaskAttemptEndReason;
import org.apache.tez.serviceplugins.api.TaskScheduler;
import org.apache.tez.serviceplugins.api.TaskSchedulerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DagAwareYarnTaskScheduler
extends TaskScheduler
implements AMRMClientAsync.CallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DagAwareYarnTaskScheduler.class);
    private static final Comparator<HeldContainer> PREEMPT_ORDER_COMPARATOR = new PreemptOrderComparator();
    private AMRMClientAsyncWrapper client;
    private ScheduledExecutorService reuseExecutor;
    private ResourceCalculator resourceCalculator;
    private int numHeartbeats = 0;
    private Resource totalResources = Resource.newInstance((int)0, (int)0);
    @GuardedBy(value="this")
    private Resource allocatedResources = Resource.newInstance((int)0, (int)0);
    private final Set<NodeId> blacklistedNodes = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ContainerSignatureMatcher signatureMatcher;
    @GuardedBy(value="this")
    private final RequestTracker requestTracker = new RequestTracker();
    @GuardedBy(value="this")
    private final Map<ContainerId, HeldContainer> heldContainers = new HashMap<ContainerId, HeldContainer>();
    @GuardedBy(value="this")
    private final IdleContainerTracker idleTracker = new IdleContainerTracker();
    @GuardedBy(value="this")
    private final Map<Object, HeldContainer> taskAssignments = new HashMap<Object, HeldContainer>();
    @GuardedBy(value="this")
    private final Map<Integer, Set<HeldContainer>> vertexAssignments = new HashMap<Integer, Set<HeldContainer>>();
    @GuardedBy(value="this")
    private final BitSet assignedVertices = new BitSet();
    @GuardedBy(value="this")
    private final Map<ContainerId, Object> releasedContainers = new HashMap<ContainerId, Object>();
    @GuardedBy(value="this")
    private final Set<HeldContainer> sessionContainers = new HashSet<HeldContainer>();
    @GuardedBy(value="this")
    private ArrayList<BitSet> vertexDescendants = null;
    private volatile boolean stopRequested = false;
    private volatile boolean shouldUnregister = false;
    private volatile boolean hasUnregistered = false;
    private boolean shouldReuseContainers;
    private boolean reuseRackLocal;
    private boolean reuseNonLocal;
    private boolean reuseNewContainers;
    private long localitySchedulingDelay;
    private long idleContainerTimeoutMin;
    private long idleContainerTimeoutMax;
    private int sessionNumMinHeldContainers;
    private int preemptionPercentage;
    private int numHeartbeatsBetweenPreemptions;
    private int lastPreemptionHeartbeat = 0;
    private long preemptionMaxWaitTime;

    public DagAwareYarnTaskScheduler(TaskSchedulerContext taskSchedulerContext) {
        super(taskSchedulerContext);
        this.signatureMatcher = taskSchedulerContext.getContainerSignatureMatcher();
    }

    public void initialize() throws Exception {
        this.initialize(new AMRMClientAsyncWrapper((AMRMClient<TaskRequest>)new AMRMClientImpl(), 1000, this));
    }

    void initialize(AMRMClientAsyncWrapper client) throws Exception {
        super.initialize();
        this.client = client;
        Configuration conf = TezUtils.createConfFromUserPayload((UserPayload)this.getContext().getInitialUserPayload());
        client.init(conf);
        int heartbeatIntervalMax = conf.getInt("tez.am.am-rm.heartbeat.interval-ms.max", 1000);
        client.setHeartbeatInterval(heartbeatIntervalMax);
        this.shouldReuseContainers = conf.getBoolean("tez.am.container.reuse.enabled", true);
        this.reuseRackLocal = conf.getBoolean("tez.am.container.reuse.rack-fallback.enabled", true);
        this.reuseNonLocal = conf.getBoolean("tez.am.container.reuse.non-local-fallback.enabled", false);
        Preconditions.checkArgument((!this.reuseRackLocal && !this.reuseNonLocal || this.reuseRackLocal ? 1 : 0) != 0, (Object)"Re-use Rack-Local cannot be disabled if Re-use Non-Local has been enabled");
        this.reuseNewContainers = this.shouldReuseContainers && conf.getBoolean("tez.am.container.reuse.new-containers.enabled", false);
        this.localitySchedulingDelay = conf.getLong("tez.am.container.reuse.locality.delay-allocation-millis", 250L);
        Preconditions.checkArgument((this.localitySchedulingDelay >= 0L ? 1 : 0) != 0, (Object)"Locality Scheduling delay should be >=0");
        this.idleContainerTimeoutMin = conf.getLong("tez.am.container.idle.release-timeout-min.millis", 5000L);
        Preconditions.checkArgument((this.idleContainerTimeoutMin >= 0L || this.idleContainerTimeoutMin == -1L ? 1 : 0) != 0, (Object)"Idle container release min timeout should be either -1 or >=0");
        this.idleContainerTimeoutMax = conf.getLong("tez.am.container.idle.release-timeout-max.millis", 10000L);
        Preconditions.checkArgument((this.idleContainerTimeoutMax >= 0L && this.idleContainerTimeoutMax >= this.idleContainerTimeoutMin ? 1 : 0) != 0, (Object)"Idle container release max timeout should be >=0 and >= tez.am.container.idle.release-timeout-min.millis");
        this.sessionNumMinHeldContainers = conf.getInt("tez.am.session.min.held-containers", 0);
        Preconditions.checkArgument((this.sessionNumMinHeldContainers >= 0 ? 1 : 0) != 0, (Object)"Session minimum held containers should be >=0");
        this.preemptionPercentage = conf.getInt("tez.am.preemption.percentage", 10);
        Preconditions.checkArgument((this.preemptionPercentage >= 0 && this.preemptionPercentage <= 100 ? 1 : 0) != 0, (Object)"Preemption percentage should be between 0-100");
        this.numHeartbeatsBetweenPreemptions = conf.getInt("tez.am.preemption.heartbeats-between-preemptions", 3);
        Preconditions.checkArgument((this.numHeartbeatsBetweenPreemptions >= 1 ? 1 : 0) != 0, (Object)"Heartbeats between preemptions should be >=1");
        this.preemptionMaxWaitTime = conf.getInt("tez.am.preemption.max.wait-time-ms", 60000);
        Preconditions.checkArgument((this.preemptionMaxWaitTime >= 0L ? 1 : 0) != 0, (Object)"Preemption max wait time must be >=0");
        LOG.info("scheduler initialized with maxRMHeartbeatInterval:" + heartbeatIntervalMax + " reuseEnabled:" + this.shouldReuseContainers + " reuseRack:" + this.reuseRackLocal + " reuseAny:" + this.reuseNonLocal + " localityDelay:" + this.localitySchedulingDelay + " preemptPercentage:" + this.preemptionPercentage + " preemptMaxWaitTime:" + this.preemptionMaxWaitTime + " numHeartbeatsBetweenPreemptions:" + this.numHeartbeatsBetweenPreemptions + " idleContainerMinTimeout:" + this.idleContainerTimeoutMin + " idleContainerMaxTimeout:" + this.idleContainerTimeoutMax + " sessionMinHeldContainers:" + this.sessionNumMinHeldContainers);
    }

    public void start() throws Exception {
        super.start();
        this.client.start();
        if (this.shouldReuseContainers) {
            this.reuseExecutor = this.createExecutor();
        }
        TaskSchedulerContext ctx = this.getContext();
        RegisterApplicationMasterResponse response = this.client.registerApplicationMaster(ctx.getAppHostName(), ctx.getAppClientPort(), ctx.getAppTrackingUrl());
        ctx.setApplicationRegistrationData(response.getMaximumResourceCapability(), response.getApplicationACLs(), response.getClientToAMTokenMasterKey(), response.getQueue());
        this.resourceCalculator = response.getSchedulerResourceTypes().contains(YarnServiceProtos.SchedulerResourceTypes.CPU) ? new MemCpuResourceCalculator() : new MemResourceCalculator();
    }

    protected ScheduledExecutorService createExecutor() {
        return new ReuseContainerExecutor();
    }

    protected long now() {
        return Time.monotonicNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initiateStop() {
        ArrayList<ContainerId> releasedLaunchedContainers;
        super.initiateStop();
        LOG.debug("Initiating stop of task scheduler");
        this.stopRequested = true;
        DagAwareYarnTaskScheduler dagAwareYarnTaskScheduler = this;
        synchronized (dagAwareYarnTaskScheduler) {
            releasedLaunchedContainers = new ArrayList<ContainerId>(this.heldContainers.size());
            ArrayList<HeldContainer> heldList = new ArrayList<HeldContainer>(this.heldContainers.values());
            for (HeldContainer hc : heldList) {
                if (!this.releaseContainer(hc)) continue;
                releasedLaunchedContainers.add(hc.getId());
            }
            List<Object> tasks = this.requestTracker.getTasks();
            for (Object task : tasks) {
                this.removeTaskRequest(task);
            }
        }
        for (ContainerId id : releasedLaunchedContainers) {
            this.getContext().containerBeingReleased(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws Exception {
        super.shutdown();
        if (this.reuseExecutor != null) {
            this.reuseExecutor.shutdown();
            this.reuseExecutor.awaitTermination(2L, TimeUnit.SECONDS);
        }
        DagAwareYarnTaskScheduler dagAwareYarnTaskScheduler = this;
        synchronized (dagAwareYarnTaskScheduler) {
            if (this.shouldUnregister && !this.hasUnregistered) {
                TaskSchedulerContext.AppFinalStatus status = this.getContext().getFinalAppStatus();
                LOG.info("Unregistering from RM, exitStatus={} exitMessage={} trackingURL={}", new Object[]{status.exitStatus, status.exitMessage, status.postCompletionTrackingUrl});
                this.client.unregisterApplicationMaster(status.exitStatus, status.exitMessage, status.postCompletionTrackingUrl);
                this.hasUnregistered = true;
            }
        }
        this.client.stop();
    }

    public void onContainersAllocated(List<Container> containers) {
        super.onContainersAllocated(containers);
        TaskSchedulerContext.AMState appState = this.getContext().getAMState();
        if (this.stopRequested || appState == TaskSchedulerContext.AMState.COMPLETED) {
            LOG.info("Ignoring {} allocations since app is terminating", (Object)containers.size());
            for (Container c : containers) {
                this.client.releaseAssignedContainer(c.getId());
            }
            return;
        }
        List<Assignment> assignments = this.assignNewContainers(containers, this.getContext().getAMState(), this.getContext().isSession());
        this.informAppAboutAssignments(assignments);
    }

    private synchronized List<Assignment> assignNewContainers(List<Container> newContainers, TaskSchedulerContext.AMState appState, boolean isSession) {
        ArrayList<Assignment> assignments = new ArrayList<Assignment>(newContainers.size());
        ArrayList<HeldContainer> unassigned = new ArrayList<HeldContainer>(newContainers.size());
        for (Container c : newContainers) {
            HeldContainer hc = new HeldContainer(c);
            this.heldContainers.put(hc.getId(), hc);
            Resources.addTo((Resource)this.allocatedResources, (Resource)c.getResource());
            this.tryAssignNewContainer(hc, hc.getHost(), assignments, unassigned);
        }
        ArrayList<HeldContainer> containers = unassigned;
        unassigned = new ArrayList(containers.size());
        for (HeldContainer hc : containers) {
            this.tryAssignNewContainer(hc, hc.getRack(), assignments, unassigned);
        }
        containers = unassigned;
        unassigned = new ArrayList(containers.size());
        for (HeldContainer hc : containers) {
            this.tryAssignNewContainer(hc, "*", assignments, unassigned);
        }
        for (HeldContainer hc : unassigned) {
            if (this.reuseNewContainers) {
                this.idleTracker.add(hc);
                TaskRequest assigned = this.tryAssignReuseContainer(hc, appState, isSession);
                if (assigned == null) continue;
                assignments.add(new Assignment(assigned, hc.getContainer()));
                continue;
            }
            this.releaseContainer(hc);
        }
        return assignments;
    }

    @GuardedBy(value="this")
    private void tryAssignNewContainer(HeldContainer hc, String location, List<Assignment> assignments, List<HeldContainer> unassigned) {
        List results = this.client.getMatchingRequests(hc.getPriority(), location, hc.getCapability());
        if (!results.isEmpty()) {
            for (Collection requests : results) {
                TaskRequest request;
                if (requests.isEmpty() || this.maybeChangeNode(request = (TaskRequest)((Object)requests.iterator().next()), hc.getContainer().getNodeId())) continue;
                this.assignContainer(request, hc, location);
                assignments.add(new Assignment(request, hc.getContainer()));
                return;
            }
        }
        unassigned.add(hc);
    }

    @Nullable
    @GuardedBy(value="this")
    private TaskRequest tryAssignReuseContainer(HeldContainer hc, TaskSchedulerContext.AMState appState, boolean isSession) {
        if (this.stopRequested) {
            return null;
        }
        TaskRequest assignedRequest = null;
        switch (appState) {
            case IDLE: {
                this.handleReuseContainerWhenIdle(hc, isSession);
                break;
            }
            case RUNNING_APP: {
                if (this.requestTracker.isEmpty()) {
                    this.handleReuseContainerWhenIdle(hc, isSession);
                    break;
                }
                assignedRequest = this.tryAssignReuseContainerAppRunning(hc);
                if (assignedRequest != null) break;
                if (hc.atMaxMatchLevel()) {
                    LOG.info("Releasing idle container {} due to pending requests", (Object)hc.getId());
                    this.releaseContainer(hc);
                    break;
                }
                hc.scheduleForReuse(this.localitySchedulingDelay);
                break;
            }
            case COMPLETED: {
                LOG.info("Releasing container {} because app has completed", (Object)hc.getId());
                this.releaseContainer(hc);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected app state " + appState);
            }
        }
        return assignedRequest;
    }

    @GuardedBy(value="this")
    private void handleReuseContainerWhenIdle(HeldContainer hc, boolean isSession) {
        if (isSession && this.sessionContainers.isEmpty() && this.sessionNumMinHeldContainers > 0) {
            this.computeSessionContainers();
        }
        if (this.sessionContainers.contains(hc)) {
            LOG.info("Retaining container {} since it is a session container", (Object)hc);
            hc.resetMatchingLevel();
        } else {
            long expiration;
            long now = this.now();
            if (now >= (expiration = hc.getIdleExpirationTimestamp(now))) {
                LOG.info("Releasing expired idle container {}", (Object)hc.getId());
                this.releaseContainer(hc);
            } else {
                hc.scheduleForReuse(expiration - now);
            }
        }
    }

    @Nullable
    @GuardedBy(value="this")
    private TaskRequest tryAssignReuseContainerAppRunning(HeldContainer hc) {
        if (!hc.isAssignable()) {
            LOG.debug("Skipping scheduling of container {} because it state is {}", (Object)hc.getId(), (Object)hc.getState());
            return null;
        }
        TaskRequest assignedRequest = this.tryAssignReuseContainerForAffinity(hc);
        if (assignedRequest != null) {
            return assignedRequest;
        }
        for (Map.Entry<Priority, RequestPriorityStats> entry : this.requestTracker.getStatsEntries()) {
            Priority priority = entry.getKey();
            RequestPriorityStats stats = entry.getValue();
            if (!stats.allowedVertices.intersects(stats.vertices)) {
                LOG.debug("Skipping requests at priority {} because all requesting vertices are blocked by higher priority requests", (Object)priority);
                continue;
            }
            String matchLocation = hc.getMatchingLocation();
            if (stats.localityCount <= 0) {
                LOG.debug("Overriding locality match of container {} to ANY since there are no locality requests at priority {}", (Object)hc.getId(), (Object)priority);
                matchLocation = "*";
            }
            if ((assignedRequest = this.tryAssignReuseContainerForPriority(hc, matchLocation, priority, stats.allowedVertices)) == null) continue;
            break;
        }
        return assignedRequest;
    }

    @Nullable
    @GuardedBy(value="this")
    private TaskRequest tryAssignReuseContainerForAffinity(HeldContainer hc) {
        Collection<TaskRequest> affinities = hc.getAffinities();
        if (affinities != null) {
            for (TaskRequest request : affinities) {
                if (this.requestTracker.isRequestBlocked(request)) {
                    LOG.debug("Cannot assign task {} to container {} since vertex {} is a descendant of pending tasks", new Object[]{request.getTask(), hc.getId(), request.getVertexIndex()});
                    continue;
                }
                if (this.maybeChangeNode(request, hc.getContainer().getNodeId())) {
                    LOG.debug("Cannot assign task {} to container {} since node {} is running sibling attempts", new Object[]{request.getTask(), hc.getId(), request.getVertexIndex()});
                    continue;
                }
                this.assignContainer(request, hc, hc.getId());
                return request;
            }
        }
        return null;
    }

    @Nullable
    @GuardedBy(value="this")
    private TaskRequest tryAssignReuseContainerForPriority(HeldContainer hc, String matchLocation, Priority priority, BitSet allowedVertices) {
        List results = this.client.getMatchingRequests(priority, matchLocation, hc.getCapability());
        if (results.isEmpty()) {
            return null;
        }
        for (Collection requests : results) {
            for (TaskRequest request : requests) {
                int vertexIndex = request.getVertexIndex();
                if (!allowedVertices.get(vertexIndex)) {
                    LOG.debug("Not assigning task {} since it is a descendant of a pending vertex", request.getTask());
                    continue;
                }
                Object signature = hc.getSignature();
                if (signature != null && !this.signatureMatcher.isSuperSet(signature, request.getContainerSignature()) || this.maybeChangeNode(request, hc.getContainer().getNodeId())) continue;
                this.assignContainer(request, hc, matchLocation);
                return request;
            }
        }
        return null;
    }

    private void informAppAboutAssignments(List<Assignment> assignments) {
        if (!assignments.isEmpty()) {
            for (Assignment a : assignments) {
                this.informAppAboutAssignment(a.request, a.container);
            }
        }
    }

    private void informAppAboutAssignment(TaskRequest request, Container container) {
        if (this.blacklistedNodes.contains(container.getNodeId())) {
            Object task = request.getTask();
            LOG.info("Container {} allocated for task {} on blacklisted node {}", new Object[]{container.getId(), container.getNodeId(), task});
            this.deallocateContainer(container.getId());
            this.allocateTask(task, request.getCapability(), request.getNodes() == null ? null : request.getNodes().toArray(new String[request.getNodes().size()]), request.getRacks() == null ? null : request.getRacks().toArray(new String[request.getRacks().size()]), request.getPriority(), request.getContainerSignature(), request.getCookie());
        } else {
            this.getContext().taskAllocated(request.getTask(), request.getCookie(), container);
        }
    }

    /*
     * WARNING - void declaration
     */
    @GuardedBy(value="this")
    private void computeSessionContainers() {
        void var4_9;
        Iterator iter;
        void var4_7;
        HashMap<String, MutableInt> rackHeldNumber = new HashMap<String, MutableInt>();
        HashMap<String, LinkedList<HeldContainer>> nodeHeldContainers = new HashMap<String, LinkedList<HeldContainer>>();
        for (HeldContainer heldContainer : this.heldContainers.values()) {
            if (heldContainer.getSignature() == null) continue;
            MutableInt count = (MutableInt)rackHeldNumber.get(heldContainer.getRack());
            if (count == null) {
                count = new MutableInt(0);
                rackHeldNumber.put(heldContainer.getRack(), count);
            }
            count.increment();
            String host = heldContainer.getHost();
            LinkedList<HeldContainer> nodeContainers = (LinkedList<HeldContainer>)nodeHeldContainers.get(host);
            if (nodeContainers == null) {
                nodeContainers = new LinkedList<HeldContainer>();
                nodeHeldContainers.put(host, nodeContainers);
            }
            nodeContainers.add(heldContainer);
        }
        HashMap<String, MutableInt> rackToHoldNumber = new HashMap<String, MutableInt>();
        for (String rack : rackHeldNumber.keySet()) {
            rackToHoldNumber.put(rack, new MutableInt(0));
        }
        boolean bl = false;
        while (var4_7 < this.sessionNumMinHeldContainers && !rackHeldNumber.isEmpty()) {
            iter = rackHeldNumber.entrySet().iterator();
            while (var4_7 < this.sessionNumMinHeldContainers && iter.hasNext()) {
                Map.Entry entry = iter.next();
                MutableInt rackCount = (MutableInt)entry.getValue();
                rackCount.decrement();
                if (rackCount.intValue() >= 0) {
                    ++var4_7;
                    ((MutableInt)rackToHoldNumber.get(entry.getKey())).increment();
                    continue;
                }
                iter.remove();
            }
        }
        boolean bl2 = false;
        while (var4_9 < this.sessionNumMinHeldContainers && !nodeHeldContainers.isEmpty()) {
            iter = nodeHeldContainers.entrySet().iterator();
            while (var4_9 < this.sessionNumMinHeldContainers && iter.hasNext()) {
                List nodeContainers = (List)iter.next().getValue();
                if (nodeContainers.isEmpty()) {
                    iter.remove();
                    continue;
                }
                HeldContainer heldContainer = (HeldContainer)nodeContainers.remove(nodeContainers.size() - 1);
                MutableInt holdCount = (MutableInt)rackToHoldNumber.get(heldContainer.getRack());
                holdCount.decrement();
                if (holdCount.intValue() >= 0) {
                    ++var4_9;
                    this.sessionContainers.add(heldContainer);
                    continue;
                }
                iter.remove();
            }
        }
        LOG.info("Identified {} session containers out of {} total containers", (Object)this.sessionContainers.size(), (Object)this.heldContainers.size());
    }

    @GuardedBy(value="this")
    private void activateSessionContainers() {
        if (!this.sessionContainers.isEmpty()) {
            for (HeldContainer hc : this.sessionContainers) {
                if (!hc.isAssignable()) continue;
                hc.scheduleForReuse(this.localitySchedulingDelay);
            }
            this.sessionContainers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onContainersCompleted(List<ContainerStatus> statuses) {
        if (this.stopRequested) {
            return;
        }
        ArrayList<TaskStatus> taskStatusList = new ArrayList<TaskStatus>(statuses.size());
        DagAwareYarnTaskScheduler dagAwareYarnTaskScheduler = this;
        synchronized (dagAwareYarnTaskScheduler) {
            for (ContainerStatus status : statuses) {
                HeldContainer hc;
                ContainerId cid = status.getContainerId();
                LOG.info("Container {} completed with status {}", (Object)cid, (Object)status);
                Object task = this.releasedContainers.remove(cid);
                if (task == null && (hc = this.heldContainers.get(cid)) != null) {
                    task = this.containerCompleted(hc);
                }
                if (task == null) continue;
                taskStatusList.add(new TaskStatus(task, status));
            }
        }
        for (TaskStatus taskStatus : taskStatusList) {
            this.getContext().containerCompleted(taskStatus.task, taskStatus.status);
        }
    }

    public void onNodesUpdated(List<NodeReport> updatedNodes) {
        if (!this.stopRequested) {
            this.getContext().nodesUpdated(updatedNodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getProgress() {
        Collection<ContainerId> preemptedContainers;
        if (this.stopRequested) {
            return 1.0f;
        }
        DagAwareYarnTaskScheduler dagAwareYarnTaskScheduler = this;
        synchronized (dagAwareYarnTaskScheduler) {
            Resource freeResources = this.getAvailableResources();
            if (this.totalResources.getMemory() == 0) {
                this.totalResources = Resources.clone((Resource)freeResources);
                LOG.info("App total resource memory: {} cpu: {} activeAssignments: {}", new Object[]{this.totalResources.getMemory(), this.totalResources.getVirtualCores(), this.taskAssignments.size()});
            }
            ++this.numHeartbeats;
            if (LOG.isDebugEnabled() || this.numHeartbeats % 50 == 1) {
                LOG.debug(this.constructPeriodicLog(freeResources));
            }
            if ((preemptedContainers = this.maybePreempt(freeResources)) != null && !preemptedContainers.isEmpty()) {
                this.lastPreemptionHeartbeat = this.numHeartbeats;
            }
        }
        if (preemptedContainers != null && !preemptedContainers.isEmpty()) {
            for (ContainerId cid : preemptedContainers) {
                LOG.info("Preempting container {} currently allocated to a task", (Object)cid);
                this.getContext().preemptContainer(cid);
            }
        }
        return this.getContext().getProgress();
    }

    public void onShutdownRequest() {
        if (!this.stopRequested) {
            this.getContext().appShutdownRequested();
        }
    }

    public void onError(Throwable e) {
        LOG.error("Error from ARMRMClient", e);
        if (!this.stopRequested) {
            this.getContext().reportError((ServicePluginError)YarnTaskSchedulerServiceError.RESOURCEMANAGER_ERROR, StringUtils.stringifyException((Throwable)e), null);
        }
    }

    public Resource getAvailableResources() {
        Resource resource = this.client.getAvailableResources();
        return resource == null ? Resource.newInstance((int)0, (int)0) : resource;
    }

    public Resource getTotalResources() {
        return this.totalResources;
    }

    public int getClusterNodeCount() {
        return this.client.getClusterNodeCount();
    }

    public synchronized void blacklistNode(NodeId nodeId) {
        LOG.info("Blacklisting node: {}", (Object)nodeId);
        this.blacklistedNodes.add(nodeId);
        this.client.updateBlacklist(Collections.singletonList(nodeId.getHost()), null);
    }

    public synchronized void unblacklistNode(NodeId nodeId) {
        if (this.blacklistedNodes.remove(nodeId)) {
            LOG.info("Removing blacklist for node: {}", (Object)nodeId);
            this.client.updateBlacklist(null, Collections.singletonList(nodeId.getHost()));
        }
    }

    public void allocateTask(Object task, Resource capability, String[] hosts, String[] racks, Priority priority, Object containerSignature, Object clientCookie) {
        int vertexIndex = this.getContext().getVertexIndexForTask(task);
        TaskRequest request = new TaskRequest(task, vertexIndex, capability, hosts, racks, priority, containerSignature, clientCookie);
        this.addTaskRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allocateTask(Object task, Resource capability, ContainerId containerId, Priority priority, Object containerSignature, Object clientCookie) {
        String[] hosts = null;
        DagAwareYarnTaskScheduler dagAwareYarnTaskScheduler = this;
        synchronized (dagAwareYarnTaskScheduler) {
            HeldContainer held = this.heldContainers.get(containerId);
            if (held != null) {
                if (held.canFit(capability)) {
                    hosts = new String[]{held.getHost()};
                } else {
                    LOG.warn("Match request to container {} but {} does not fit in {}", new Object[]{containerId, capability, held.getCapability()});
                    containerId = null;
                }
            } else {
                LOG.info("Ignoring match request to unknown container {}", (Object)containerId);
                containerId = null;
            }
        }
        int vertexIndex = this.getContext().getVertexIndexForTask(task);
        TaskRequest request = new TaskRequest(task, vertexIndex, capability, hosts, null, priority, containerSignature, clientCookie, containerId);
        this.addTaskRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deallocateTask(Object task, boolean taskSucceeded, TaskAttemptEndReason endReason, String diagnostics) {
        HeldContainer hc;
        ContainerId releasedLaunchedContainer = null;
        TaskSchedulerContext.AMState appState = this.getContext().getAMState();
        boolean isSession = this.getContext().isSession();
        TaskRequest newAssignment = null;
        DagAwareYarnTaskScheduler dagAwareYarnTaskScheduler = this;
        synchronized (dagAwareYarnTaskScheduler) {
            TaskRequest request = this.removeTaskRequest(task);
            if (request != null) {
                LOG.debug("Deallocating task {} before it was allocated", task);
                return false;
            }
            hc = this.removeTaskAssignment(task);
            if (hc != null) {
                if (taskSucceeded && this.shouldReuseContainers) {
                    this.idleTracker.add(hc);
                    newAssignment = this.tryAssignReuseContainer(hc, appState, isSession);
                    if (newAssignment == null && hc.isReleasedAndUsed()) {
                        releasedLaunchedContainer = hc.getId();
                    }
                } else if (this.releaseContainer(hc)) {
                    releasedLaunchedContainer = hc.getId();
                }
            }
        }
        if (newAssignment != null) {
            this.informAppAboutAssignment(newAssignment, hc.getContainer());
            return true;
        }
        if (releasedLaunchedContainer != null) {
            this.getContext().containerBeingReleased(releasedLaunchedContainer);
            return true;
        }
        return hc != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object deallocateContainer(ContainerId containerId) {
        Object task = null;
        ContainerId releasedLaunchedContainer = null;
        DagAwareYarnTaskScheduler dagAwareYarnTaskScheduler = this;
        synchronized (dagAwareYarnTaskScheduler) {
            HeldContainer hc = this.heldContainers.remove(containerId);
            if (hc != null) {
                task = hc.getAssignedTask();
                if (task != null) {
                    LOG.info("Deallocated container {} from task {}", (Object)containerId, task);
                }
                if (this.releaseContainer(hc)) {
                    releasedLaunchedContainer = hc.getId();
                }
            } else {
                LOG.info("Ignoring deallocation of unknown container {}", (Object)containerId);
            }
        }
        if (releasedLaunchedContainer != null) {
            this.getContext().containerBeingReleased(releasedLaunchedContainer);
        }
        return task;
    }

    @GuardedBy(value="this")
    private void assignContainer(TaskRequest request, HeldContainer hc, Object match) {
        LOG.info("Assigning container {} to task {} host={} priority={} capability={} match={} lastTask={}", new Object[]{hc.getId(), request.getTask(), hc.getHost(), hc.getPriority(), hc.getCapability(), match, hc.getLastTask()});
        this.removeTaskRequest(request.getTask());
        this.addTaskAssignment(request, hc);
        this.idleTracker.remove(hc);
    }

    private synchronized boolean releaseContainer(HeldContainer hc) {
        Object task = this.containerCompleted(hc);
        this.client.releaseAssignedContainer(hc.getId());
        if (task != null) {
            this.releasedContainers.put(hc.getId(), task);
            return true;
        }
        return false;
    }

    @GuardedBy(value="this")
    private void addTaskAssignment(TaskRequest request, HeldContainer hc) {
        Integer vertexIndex;
        Set<HeldContainer> cset;
        HeldContainer oldContainer = this.taskAssignments.put(request.getTask(), hc);
        if (oldContainer != null) {
            LOG.error("Task {} being assigned to container {} but was already assigned to container {}", new Object[]{request.getTask(), hc.getId(), oldContainer.getId()});
        }
        if ((cset = this.vertexAssignments.get(vertexIndex = Integer.valueOf(request.vertexIndex))) == null) {
            cset = new HashSet<HeldContainer>();
            this.vertexAssignments.put(vertexIndex, cset);
            this.assignedVertices.set(vertexIndex);
        }
        cset.add(hc);
        if (!hc.isNew()) {
            this.getContext().containerReused(hc.getContainer());
        }
        hc.assignTask(request);
    }

    @GuardedBy(value="this")
    private HeldContainer removeTaskAssignment(Object task) {
        HeldContainer hc = this.taskAssignments.remove(task);
        if (hc != null) {
            TaskRequest request = hc.removeAssignment();
            if (request != null) {
                Integer vertexIndex = request.vertexIndex;
                Set<HeldContainer> cset = this.vertexAssignments.get(vertexIndex);
                if (cset != null && cset.remove(hc) && cset.isEmpty()) {
                    this.vertexAssignments.remove(vertexIndex);
                    this.assignedVertices.clear(vertexIndex);
                }
            } else {
                LOG.error("Container {} had assigned task {} but no request?!?", (Object)hc.getId(), task);
            }
        }
        return hc;
    }

    @Nullable
    @GuardedBy(value="this")
    private Object containerCompleted(HeldContainer hc) {
        this.idleTracker.remove(hc);
        this.heldContainers.remove(hc.getId());
        Resources.subtractFrom((Resource)this.allocatedResources, (Resource)hc.getCapability());
        this.removeTaskAssignment(hc.getAssignedTask());
        hc.released();
        return hc.getLastTask();
    }

    @GuardedBy(value="this")
    private void ensureVertexDescendants() {
        if (this.vertexDescendants == null) {
            DagInfo info = this.getContext().getCurrentDagInfo();
            if (info == null) {
                throw new IllegalStateException("Scheduling tasks but no current DAG info?");
            }
            int numVertices = info.getTotalVertices();
            ArrayList<BitSet> descendants = new ArrayList<BitSet>(numVertices);
            for (int i = 0; i < numVertices; ++i) {
                descendants.add(info.getVertexDescendants(i));
            }
            this.vertexDescendants = descendants;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTaskRequest(TaskRequest request) {
        Container assignedContainer = null;
        DagAwareYarnTaskScheduler dagAwareYarnTaskScheduler = this;
        synchronized (dagAwareYarnTaskScheduler) {
            if (this.shouldReuseContainers && !this.stopRequested && this.getContext().getAMState() != TaskSchedulerContext.AMState.COMPLETED) {
                this.ensureVertexDescendants();
                this.activateSessionContainers();
                HeldContainer hc = this.tryAssignTaskToIdleContainer(request);
                if (hc != null) {
                    assignedContainer = hc.getContainer();
                }
            }
            if (assignedContainer == null) {
                this.ensureVertexDescendants();
                TaskRequest old = this.requestTracker.add(request);
                if (old != null) {
                    this.removeTaskRequestByRequest(request);
                }
                this.client.addContainerRequest(request);
                HeldContainer hc = this.heldContainers.get(request.getAffinity());
                if (hc != null) {
                    hc.addAffinity(request);
                }
            }
        }
        if (assignedContainer != null) {
            this.informAppAboutAssignment(request, assignedContainer);
        }
    }

    @Nullable
    private synchronized TaskRequest removeTaskRequest(Object task) {
        TaskRequest request = this.requestTracker.remove(task);
        if (request != null) {
            this.removeTaskRequestByRequest(request);
        }
        return request;
    }

    @GuardedBy(value="this")
    private void removeTaskRequestByRequest(TaskRequest request) {
        this.client.removeContainerRequest(request);
        HeldContainer hc = this.heldContainers.get(request.getAffinity());
        if (hc != null) {
            hc.removeAffinity(request);
        }
    }

    @Nullable
    @GuardedBy(value="this")
    private HeldContainer tryAssignTaskToIdleContainer(TaskRequest request) {
        HeldContainer hc;
        if (this.requestTracker.isRequestBlocked(request)) {
            LOG.debug("Cannot assign task {} to an idle container since vertex {} is a descendant of pending tasks", request.getTask(), (Object)request.getVertexIndex());
            return null;
        }
        ContainerId affinity = request.getAffinity();
        if (affinity != null && (hc = this.heldContainers.get(affinity)) != null && hc.isAssignable() && !this.maybeChangeNode(request, hc.getContainer().getNodeId())) {
            this.assignContainer(request, hc, affinity);
            return hc;
        }
        if (request.hasLocality()) {
            hc = this.tryAssignTaskToIdleContainer(request, request.getNodes(), (EnumSet<HeldContainerState>)HeldContainerState.MATCHES_LOCAL_STATES);
            if (hc == null && (hc = this.tryAssignTaskToIdleContainer(request, request.getRacks(), (EnumSet<HeldContainerState>)HeldContainerState.MATCHES_RACK_STATES)) == null) {
                hc = this.tryAssignTaskToIdleContainer(request, "*", (EnumSet<HeldContainerState>)HeldContainerState.MATCHES_ANY_STATES);
            }
        } else {
            hc = this.tryAssignTaskToIdleContainer(request, "*", (EnumSet<HeldContainerState>)HeldContainerState.MATCHES_LOCAL_STATES);
        }
        return hc;
    }

    @Nullable
    @GuardedBy(value="this")
    private HeldContainer tryAssignTaskToIdleContainer(TaskRequest request, List<String> locations, EnumSet<HeldContainerState> eligibleStates) {
        if (locations != null && !locations.isEmpty()) {
            for (String location : locations) {
                HeldContainer hc = this.tryAssignTaskToIdleContainer(request, location, eligibleStates);
                if (hc == null) continue;
                return hc;
            }
        }
        return null;
    }

    @Nullable
    @GuardedBy(value="this")
    private HeldContainer tryAssignTaskToIdleContainer(TaskRequest request, String location, EnumSet<HeldContainerState> eligibleStates) {
        Set<HeldContainer> containers = this.idleTracker.getByLocation(location);
        HeldContainer bestMatch = null;
        if (containers != null && !containers.isEmpty()) {
            for (HeldContainer hc : containers) {
                if (!eligibleStates.contains((Object)hc.getState())) continue;
                Object csig = hc.getSignature();
                if (csig == null || this.signatureMatcher.isSuperSet(csig, request.getContainerSignature())) {
                    boolean needToChangeNode = this.maybeChangeNode(request, hc.getContainer().getNodeId());
                    int numAffinities = hc.getNumAffinities();
                    if (numAffinities == 0 && !needToChangeNode) {
                        bestMatch = hc;
                        break;
                    }
                    if (bestMatch != null && numAffinities >= bestMatch.getNumAffinities() || needToChangeNode) continue;
                    bestMatch = hc;
                    continue;
                }
                LOG.debug("Unable to assign task {} to container {} due to signature mismatch", request.getTask(), (Object)hc.getId());
            }
        }
        if (bestMatch != null) {
            this.assignContainer(request, bestMatch, location);
        }
        return bestMatch;
    }

    private boolean maybeChangeNode(TaskRequest request, NodeId nodeId) {
        Set<NodeId> nodesWithSiblingRunningAttempts;
        Object task = request.getTask();
        return task instanceof TaskAttempt && (nodesWithSiblingRunningAttempts = ((TaskAttempt)task).getTask().getNodesWithRunningAttempts()) != null && nodesWithSiblingRunningAttempts.contains(nodeId);
    }

    public void setShouldUnregister() {
        this.shouldUnregister = true;
    }

    public boolean hasUnregistered() {
        return this.hasUnregistered;
    }

    public synchronized void dagComplete() {
        for (HeldContainer hc : this.sessionContainers) {
            hc.resetMatchingLevel();
        }
        this.vertexDescendants = null;
    }

    @Nullable
    @GuardedBy(value="this")
    private Collection<ContainerId> maybePreempt(Resource freeResources) {
        HeldContainer hc;
        if (this.preemptionPercentage == 0 || this.numHeartbeats - this.lastPreemptionHeartbeat < this.numHeartbeatsBetweenPreemptions) {
            return null;
        }
        if (!this.requestTracker.isPreemptionDeadlineExpired() && this.requestTracker.fitsHighestPriorityRequest(freeResources)) {
            if (this.numHeartbeats % 50 == 1) {
                LOG.info("Highest priority request fits in free resources {}", (Object)freeResources);
            }
            return null;
        }
        int numIdleContainers = this.idleTracker.getNumContainers();
        if (numIdleContainers > 0) {
            if (this.numHeartbeats % 50 == 1) {
                LOG.info("Avoiding preemption since there are {} idle containers", (Object)numIdleContainers);
            }
            return null;
        }
        BitSet blocked = this.requestTracker.createVertexBlockedSet();
        if (!blocked.intersects(this.assignedVertices)) {
            if (this.numHeartbeats % 50 == 1) {
                LOG.info("Avoiding preemption since there are no descendants of the highest priority requests running");
            }
            return null;
        }
        Resource preemptLeft = this.requestTracker.getAmountToPreempt(this.preemptionPercentage);
        if (!this.resourceCalculator.anyAvailable(preemptLeft)) {
            if (this.numHeartbeats % 50 == 1) {
                LOG.info("Avoiding preemption since amount to preempt is {}", (Object)preemptLeft);
            }
            return null;
        }
        PriorityQueue<HeldContainer> candidates = new PriorityQueue<HeldContainer>(11, PREEMPT_ORDER_COMPARATOR);
        blocked.and(this.assignedVertices);
        int i = blocked.nextSetBit(0);
        while (i >= 0) {
            Collection containers = this.vertexAssignments.get(i);
            if (containers != null) {
                candidates.addAll(containers);
            } else {
                LOG.error("Vertex {} in assignedVertices but no assignments?", (Object)i);
            }
            i = blocked.nextSetBit(i + 1);
        }
        ArrayList<ContainerId> preemptedContainers = new ArrayList<ContainerId>();
        while ((hc = candidates.poll()) != null) {
            LOG.info("Preempting container {} currently allocated to task {}", (Object)hc.getId(), hc.getAssignedTask());
            preemptedContainers.add(hc.getId());
            this.resourceCalculator.deductFrom(preemptLeft, hc.getCapability());
            if (this.resourceCalculator.anyAvailable(preemptLeft)) continue;
            break;
        }
        return preemptedContainers;
    }

    @GuardedBy(value="this")
    private String constructPeriodicLog(Resource freeResource) {
        Priority highestPriority = this.requestTracker.getHighestPriority();
        return "Allocated: " + this.allocatedResources + " Free: " + freeResource + " pendingRequests: " + this.requestTracker.getNumRequests() + " heldContainers: " + this.heldContainers.size() + " heartbeats: " + this.numHeartbeats + " lastPreemptionHeartbeat: " + this.lastPreemptionHeartbeat + (highestPriority != null ? " highestWaitingRequestWaitStartTime: " + this.requestTracker.getHighestPriorityWaitTimestamp() + " highestWaitingRequestPriority: " + highestPriority : "");
    }

    @VisibleForTesting
    int getNumBlacklistedNodes() {
        return this.blacklistedNodes.size();
    }

    @VisibleForTesting
    Collection<HeldContainer> getSessionContainers() {
        return this.sessionContainers;
    }

    public int getHeldContainersCount() {
        return this.heldContainers.size();
    }

    static class AMRMClientAsyncWrapper
    extends AMRMClientAsyncImpl<TaskRequest> {
        AMRMClientAsyncWrapper(AMRMClient<TaskRequest> syncClient, int intervalMs, AMRMClientAsync.CallbackHandler handler) {
            super(syncClient, intervalMs, handler);
        }

        public void updateBlacklist(List<String> additions, List<String> removals) {
            this.client.updateBlacklist(additions, removals);
        }
    }

    static class TaskRequest
    extends AMRMClient.ContainerRequest {
        final Object task;
        final int vertexIndex;
        final Object signature;
        final Object cookie;
        final ContainerId affinityContainerId;

        TaskRequest(Object task, int vertexIndex, Resource capability, String[] hosts, String[] racks, Priority priority, Object signature, Object cookie) {
            this(task, vertexIndex, capability, hosts, racks, priority, signature, cookie, null);
        }

        TaskRequest(Object task, int vertexIndex, Resource capability, String[] hosts, String[] racks, Priority priority, Object signature, Object cookie, ContainerId affinityContainerId) {
            super(capability, hosts, racks, priority);
            this.task = task;
            this.vertexIndex = vertexIndex;
            this.signature = signature;
            this.cookie = cookie;
            this.affinityContainerId = affinityContainerId;
        }

        Object getTask() {
            return this.task;
        }

        int getVertexIndex() {
            return this.vertexIndex;
        }

        Object getContainerSignature() {
            return this.signature;
        }

        Object getCookie() {
            return this.cookie;
        }

        @Nullable
        ContainerId getAffinity() {
            return this.affinityContainerId;
        }

        boolean hasLocality() {
            List nodes = this.getNodes();
            List racks = this.getRacks();
            return nodes != null && !nodes.isEmpty() || racks != null && !racks.isEmpty();
        }
    }

    @VisibleForTesting
    class HeldContainer
    implements Callable<Void> {
        final Container container;
        final String rack;
        @GuardedBy(value="DagAwareYarnTaskScheduler.this")
        HeldContainerState state = HeldContainerState.MATCHING_LOCAL;
        @GuardedBy(value="DagAwareYarnTaskScheduler.this")
        Future<Void> future = null;
        @GuardedBy(value="DagAwareYarnTaskScheduler.this")
        Collection<TaskRequest> affinities = null;
        @GuardedBy(value="DagAwareYarnTaskScheduler.this")
        TaskRequest assignedRequest = null;
        @GuardedBy(value="DagAwareYarnTaskScheduler.this")
        TaskRequest lastRequest = null;
        @GuardedBy(value="DagAwareYarnTaskScheduler.this")
        long idleExpirationTimestamp = 0L;
        @GuardedBy(value="DagAwareYarnTaskScheduler.this")
        long assignmentTimestamp = 0L;

        HeldContainer(Container container) {
            this.container = container;
            this.rack = RackResolver.resolve((String)container.getNodeId().getHost()).getNetworkLocation();
        }

        HeldContainerState getState() {
            return this.state;
        }

        boolean isAssignable() {
            return this.state.isAssignable();
        }

        boolean isReleasedAndUsed() {
            return this.state == HeldContainerState.RELEASED && this.getLastTask() != null;
        }

        Container getContainer() {
            return this.container;
        }

        ContainerId getId() {
            return this.container.getId();
        }

        String getHost() {
            return this.container.getNodeId().getHost();
        }

        String getRack() {
            return this.rack;
        }

        Priority getPriority() {
            return this.container.getPriority();
        }

        Resource getCapability() {
            return this.container.getResource();
        }

        @Nullable
        Object getAssignedTask() {
            return this.assignedRequest != null ? this.assignedRequest.getTask() : null;
        }

        void assignTask(TaskRequest request) {
            assert (this.state != HeldContainerState.ASSIGNED && this.state != HeldContainerState.RELEASED);
            if (this.assignedRequest != null) {
                LOG.error("Container {} assigned task {} but already running task {}", new Object[]{this.getId(), request.getTask(), this.assignedRequest.getTask()});
            }
            this.assignedRequest = request;
            this.lastRequest = request;
            this.state = HeldContainerState.ASSIGNED;
            this.idleExpirationTimestamp = 0L;
            this.assignmentTimestamp = DagAwareYarnTaskScheduler.this.now();
            if (this.future != null) {
                this.future.cancel(false);
                this.future = null;
            }
        }

        TaskRequest removeAssignment() {
            assert (this.state == HeldContainerState.ASSIGNED);
            TaskRequest result = this.assignedRequest;
            this.assignedRequest = null;
            this.assignmentTimestamp = 0L;
            this.state = HeldContainerState.MATCHING_LOCAL;
            return result;
        }

        void addAffinity(TaskRequest request) {
            if (this.affinities == null) {
                this.affinities = new HashSet<TaskRequest>();
            }
            this.affinities.add(request);
        }

        void removeAffinity(TaskRequest request) {
            if (this.affinities != null && this.affinities.remove((Object)request) && this.affinities.isEmpty()) {
                this.affinities = null;
            }
        }

        int getNumAffinities() {
            return this.affinities != null ? this.affinities.size() : 0;
        }

        @Nullable
        Collection<TaskRequest> getAffinities() {
            return this.affinities;
        }

        void scheduleForReuse(long delayMillis) {
            block4: {
                assert (this.state != HeldContainerState.ASSIGNED && this.state != HeldContainerState.RELEASED);
                try {
                    if (this.future != null) {
                        this.future.cancel(false);
                    }
                    this.future = DagAwareYarnTaskScheduler.this.reuseExecutor.schedule(this, delayMillis, TimeUnit.MILLISECONDS);
                }
                catch (RejectedExecutionException e) {
                    if (DagAwareYarnTaskScheduler.this.stopRequested) break block4;
                    LOG.error("Container {} could not be scheduled for reuse!", (Object)this.getId(), (Object)e);
                }
            }
        }

        @Nullable
        Object getSignature() {
            return this.lastRequest != null ? this.lastRequest.getContainerSignature() : null;
        }

        @Nullable
        Object getLastTask() {
            return this.lastRequest != null ? this.lastRequest.getTask() : null;
        }

        boolean isNew() {
            return this.lastRequest == null;
        }

        String getMatchingLocation() {
            switch (this.state) {
                case MATCHING_LOCAL: {
                    return this.getHost();
                }
                case MATCHING_RACK: {
                    return this.getRack();
                }
                case MATCHING_ANY: {
                    return "*";
                }
            }
            throw new IllegalStateException("Container " + this.getId() + " trying to match in state " + (Object)((Object)this.state));
        }

        void moveToNextMatchingLevel() {
            switch (this.state) {
                case MATCHING_LOCAL: {
                    if (!DagAwareYarnTaskScheduler.this.reuseRackLocal) break;
                    this.state = HeldContainerState.MATCHING_RACK;
                    break;
                }
                case MATCHING_RACK: {
                    if (!DagAwareYarnTaskScheduler.this.reuseNonLocal) break;
                    this.state = HeldContainerState.MATCHING_ANY;
                    break;
                }
                case MATCHING_ANY: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Container " + this.getId() + " trying to match in state " + (Object)((Object)this.state));
                }
            }
        }

        boolean atMaxMatchLevel() {
            switch (this.state) {
                case MATCHING_LOCAL: {
                    return !DagAwareYarnTaskScheduler.this.reuseRackLocal;
                }
                case MATCHING_RACK: {
                    return !DagAwareYarnTaskScheduler.this.reuseNonLocal;
                }
                case MATCHING_ANY: {
                    return true;
                }
            }
            throw new IllegalStateException("Container " + this.getId() + " trying to match in state " + (Object)((Object)this.state));
        }

        void resetMatchingLevel() {
            if (this.isAssignable()) {
                this.state = HeldContainerState.MATCHING_LOCAL;
            }
        }

        long getIdleExpirationTimestamp(long now) {
            if (this.idleExpirationTimestamp == 0L) {
                this.idleExpirationTimestamp = DagAwareYarnTaskScheduler.this.idleContainerTimeoutMin > 0L ? now + (DagAwareYarnTaskScheduler.this.idleContainerTimeoutMin == DagAwareYarnTaskScheduler.this.idleContainerTimeoutMax ? DagAwareYarnTaskScheduler.this.idleContainerTimeoutMin : ThreadLocalRandom.current().nextLong(DagAwareYarnTaskScheduler.this.idleContainerTimeoutMin, DagAwareYarnTaskScheduler.this.idleContainerTimeoutMax)) : Long.MAX_VALUE;
            }
            return this.idleExpirationTimestamp;
        }

        long getAssignmentTimestamp() {
            return this.assignmentTimestamp;
        }

        boolean canFit(Resource capability) {
            Resource cr = this.container.getResource();
            return cr.getMemory() >= capability.getMemory() && cr.getVirtualCores() >= capability.getVirtualCores();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            TaskSchedulerContext.AMState appState = DagAwareYarnTaskScheduler.this.getContext().getAMState();
            boolean isSession = DagAwareYarnTaskScheduler.this.getContext().isSession();
            TaskRequest assigned = null;
            ContainerId released = null;
            DagAwareYarnTaskScheduler dagAwareYarnTaskScheduler = DagAwareYarnTaskScheduler.this;
            synchronized (dagAwareYarnTaskScheduler) {
                this.future = null;
                if (this.isAssignable()) {
                    this.moveToNextMatchingLevel();
                    assigned = DagAwareYarnTaskScheduler.this.tryAssignReuseContainer(this, appState, isSession);
                    if (assigned == null && this.isReleasedAndUsed()) {
                        released = this.getId();
                    }
                }
            }
            if (assigned != null) {
                DagAwareYarnTaskScheduler.this.informAppAboutAssignment(assigned, this.container);
            }
            if (released != null) {
                DagAwareYarnTaskScheduler.this.getContext().containerBeingReleased(released);
            }
            return null;
        }

        void released() {
            assert (this.state != HeldContainerState.RELEASED);
            this.state = HeldContainerState.RELEASED;
            if (this.future != null) {
                this.future.cancel(false);
            }
            this.future = null;
        }
    }

    private class RequestTracker {
        private final Map<Object, TaskRequest> requests = new HashMap<Object, TaskRequest>();
        private final NavigableMap<Priority, RequestPriorityStats> priorityStats = new TreeMap(Collections.reverseOrder());
        private Priority highestPriority = null;
        private long highestPriorityWaitTimestamp = 0L;

        private RequestTracker() {
        }

        @Nullable
        @GuardedBy(value="DagAwareYarnTaskScheduler.this")
        TaskRequest add(TaskRequest request) {
            TaskRequest oldRequest = this.requests.put(request.getTask(), request);
            Priority priority = request.getPriority();
            RequestPriorityStats stats = (RequestPriorityStats)this.priorityStats.get(priority);
            if (stats == null) {
                stats = this.addStatsForPriority(priority);
            }
            ++stats.requestCount;
            if (request.hasLocality()) {
                ++stats.localityCount;
            }
            this.incrVertexTaskCount(priority, stats, request.getVertexIndex());
            if (oldRequest != null) {
                this.updateStatsForRemoval(oldRequest);
            }
            return oldRequest;
        }

        @Nullable
        @GuardedBy(value="DagAwareYarnTaskScheduler.this")
        TaskRequest remove(Object task) {
            TaskRequest request = this.requests.remove(task);
            if (request != null) {
                this.updateStatsForRemoval(request);
                return request;
            }
            return null;
        }

        private RequestPriorityStats addStatsForPriority(Priority priority) {
            BitSet allowedVerts = new BitSet(DagAwareYarnTaskScheduler.this.vertexDescendants.size());
            Map.Entry<Priority, RequestPriorityStats> lowerEntry = this.priorityStats.lowerEntry(priority);
            if (lowerEntry != null) {
                RequestPriorityStats priorStats = lowerEntry.getValue();
                allowedVerts.or(priorStats.allowedVertices);
                allowedVerts.andNot(priorStats.descendants);
            } else {
                this.highestPriority = priority;
                this.highestPriorityWaitTimestamp = DagAwareYarnTaskScheduler.this.now();
                allowedVerts.set(0, DagAwareYarnTaskScheduler.this.vertexDescendants.size());
            }
            RequestPriorityStats stats = new RequestPriorityStats(DagAwareYarnTaskScheduler.this.vertexDescendants.size(), allowedVerts);
            this.priorityStats.put(priority, stats);
            return stats;
        }

        private void updateStatsForRemoval(TaskRequest request) {
            Priority priority = request.getPriority();
            RequestPriorityStats stats = (RequestPriorityStats)this.priorityStats.get(priority);
            this.decrVertexTaskCount(priority, stats, request.getVertexIndex());
            --stats.requestCount;
            if (request.hasLocality()) {
                --stats.localityCount;
            }
            if (stats.requestCount == 0) {
                this.priorityStats.remove(priority);
                if (this.highestPriority.equals((Object)priority)) {
                    if (this.priorityStats.isEmpty()) {
                        this.highestPriority = null;
                        this.highestPriorityWaitTimestamp = 0L;
                    } else {
                        this.highestPriority = (Priority)this.priorityStats.firstKey();
                        this.highestPriorityWaitTimestamp = DagAwareYarnTaskScheduler.this.now();
                    }
                }
            }
        }

        @GuardedBy(value="DagAwareYarnTaskScheduler.this")
        boolean isEmpty() {
            return this.requests.isEmpty();
        }

        @GuardedBy(value="DagAwareYarnTaskScheduler.this")
        int getNumRequests() {
            return this.requests.size();
        }

        @GuardedBy(value="DagAwareYarnTaskScheduler.this")
        List<Object> getTasks() {
            return new ArrayList<Object>(this.requests.keySet());
        }

        @GuardedBy(value="DagAwareYarnTaskScheduler.this")
        Collection<Map.Entry<Priority, RequestPriorityStats>> getStatsEntries() {
            return this.priorityStats.entrySet();
        }

        @Nullable
        @GuardedBy(value="DagAwareYarnTaskScheduler.this")
        Priority getHighestPriority() {
            if (this.priorityStats.isEmpty()) {
                return null;
            }
            return (Priority)this.priorityStats.firstKey();
        }

        @GuardedBy(value="DagAwareYarnTaskScheduler.this")
        long getHighestPriorityWaitTimestamp() {
            return this.highestPriorityWaitTimestamp;
        }

        @GuardedBy(value="DagAwareYarnTaskScheduler.this")
        boolean isRequestBlocked(TaskRequest request) {
            Map.Entry<Priority, RequestPriorityStats> entry = this.priorityStats.floorEntry(request.getPriority());
            if (entry != null) {
                RequestPriorityStats stats = entry.getValue();
                int vertexIndex = request.getVertexIndex();
                return !stats.allowedVertices.get(vertexIndex) || stats.descendants.get(vertexIndex);
            }
            return false;
        }

        private void incrVertexTaskCount(Priority priority, RequestPriorityStats stats, int vertexIndex) {
            Integer vertexIndexInt = vertexIndex;
            MutableInt taskCount = stats.vertexTaskCount.get(vertexIndexInt);
            if (taskCount != null) {
                taskCount.increment();
            } else {
                this.addVertexToRequestStats(priority, stats, vertexIndexInt);
            }
        }

        private void decrVertexTaskCount(Priority priority, RequestPriorityStats stats, int vertexIndex) {
            Integer vertexIndexInt = vertexIndex;
            MutableInt taskCount = stats.vertexTaskCount.get(vertexIndexInt);
            taskCount.decrement();
            if (taskCount.intValue() <= 0) {
                this.removeVertexFromRequestStats(priority, stats, vertexIndexInt);
            }
        }

        private void addVertexToRequestStats(Priority priority, RequestPriorityStats stats, Integer vertexIndexInt) {
            stats.vertexTaskCount.put(vertexIndexInt, new MutableInt(1));
            int vertexIndex = vertexIndexInt;
            stats.vertices.set(vertexIndex);
            BitSet d = (BitSet)DagAwareYarnTaskScheduler.this.vertexDescendants.get(vertexIndex);
            stats.descendants.or(d);
            for (RequestPriorityStats lowerStat : this.priorityStats.tailMap(priority, false).values()) {
                lowerStat.allowedVertices.andNot(d);
            }
        }

        private void removeVertexFromRequestStats(Priority priority, RequestPriorityStats stats, Integer vertexIndexInt) {
            stats.vertexTaskCount.remove(vertexIndexInt);
            int vertexIndex = vertexIndexInt;
            stats.vertices.clear(vertexIndex);
            stats.descendants.clear();
            for (Integer vIndex : stats.vertexTaskCount.keySet()) {
                stats.descendants.or((BitSet)DagAwareYarnTaskScheduler.this.vertexDescendants.get(vIndex));
            }
            Collection tailStats = this.priorityStats.tailMap(priority, false).values();
            if (!tailStats.isEmpty()) {
                BitSet cumulativeAllowed = new BitSet(DagAwareYarnTaskScheduler.this.vertexDescendants.size());
                cumulativeAllowed.or(stats.allowedVertices);
                cumulativeAllowed.andNot(stats.descendants);
                for (RequestPriorityStats s : tailStats) {
                    s.allowedVertices.clear();
                    s.allowedVertices.or(cumulativeAllowed);
                    cumulativeAllowed.andNot(s.descendants);
                }
            }
        }

        @GuardedBy(value="DagAwareYarnTaskScheduler.this")
        boolean isPreemptionDeadlineExpired() {
            return this.highestPriorityWaitTimestamp != 0L && DagAwareYarnTaskScheduler.this.now() - this.highestPriorityWaitTimestamp > DagAwareYarnTaskScheduler.this.preemptionMaxWaitTime;
        }

        @GuardedBy(value="DagAwareYarnTaskScheduler.this")
        boolean fitsHighestPriorityRequest(Resource freeResources) {
            if (this.priorityStats.isEmpty()) {
                return true;
            }
            Priority priority = (Priority)this.priorityStats.firstKey();
            List requestsList = DagAwareYarnTaskScheduler.this.client.getMatchingRequests(priority, "*", freeResources);
            return !requestsList.isEmpty();
        }

        @GuardedBy(value="DagAwareYarnTaskScheduler.this")
        Resource getAmountToPreempt(int preemptionPercentage) {
            if (this.priorityStats.isEmpty()) {
                return Resources.none();
            }
            Priority priority = (Priority)this.priorityStats.firstKey();
            List requestsList = DagAwareYarnTaskScheduler.this.client.getMatchingRequests(priority, "*", Resources.unbounded());
            int numRequests = 0;
            for (Collection requests : requestsList) {
                numRequests += requests.size();
            }
            numRequests = (int)Math.ceil((float)numRequests * ((float)preemptionPercentage / 100.0f));
            Resource toPreempt = Resource.newInstance((int)0, (int)0);
            if (numRequests != 0) {
                block1: for (Collection requests : requestsList) {
                    for (TaskRequest request : requests) {
                        Resources.addTo((Resource)toPreempt, (Resource)request.getCapability());
                        if (--numRequests != 0) continue;
                        break block1;
                    }
                }
            }
            return toPreempt;
        }

        @GuardedBy(value="DagAwareYarnTaskScheduler.this")
        BitSet createVertexBlockedSet() {
            BitSet blocked = new BitSet(DagAwareYarnTaskScheduler.this.vertexDescendants.size());
            Map.Entry<Priority, RequestPriorityStats> entry = this.priorityStats.lastEntry();
            if (entry != null) {
                RequestPriorityStats stats = entry.getValue();
                blocked.or(stats.allowedVertices);
                blocked.flip(0, blocked.size());
                blocked.or(stats.descendants);
            }
            return blocked;
        }
    }

    private static class IdleContainerTracker {
        final Map<String, Set<HeldContainer>> containersByLocation = new HashMap<String, Set<HeldContainer>>();
        int numContainers = 0;

        private IdleContainerTracker() {
        }

        @GuardedBy(value="DagAwareYarnTaskScheduler.this")
        void add(HeldContainer hc) {
            this.add(hc, hc.getHost());
            this.add(hc, hc.getRack());
            this.add(hc, "*");
            ++this.numContainers;
        }

        @GuardedBy(value="DagAwareYarnTaskScheduler.this")
        void remove(HeldContainer hc) {
            this.remove(hc, hc.getHost());
            this.remove(hc, hc.getRack());
            this.remove(hc, "*");
            --this.numContainers;
        }

        @GuardedBy(value="DagAwareYarnTaskScheduler.this")
        int getNumContainers() {
            return this.numContainers;
        }

        private void add(HeldContainer hc, String location) {
            Set<HeldContainer> containers = this.containersByLocation.get(location);
            if (containers == null) {
                containers = new HashSet<HeldContainer>();
                this.containersByLocation.put(location, containers);
            }
            containers.add(hc);
        }

        private void remove(HeldContainer hc, String location) {
            Set<HeldContainer> containers = this.containersByLocation.get(location);
            if (containers != null && containers.remove(hc) && containers.isEmpty()) {
                this.containersByLocation.remove(location);
            }
        }

        @Nullable
        @GuardedBy(value="DagAwareYarnTaskScheduler.this")
        Set<HeldContainer> getByLocation(String location) {
            return this.containersByLocation.get(location);
        }
    }

    private static class MemCpuResourceCalculator
    extends MemResourceCalculator {
        private MemCpuResourceCalculator() {
        }

        @Override
        public boolean anyAvailable(Resource rsrc) {
            return super.anyAvailable(rsrc) || rsrc.getVirtualCores() > 0;
        }

        @Override
        public void deductFrom(Resource total, Resource toSubtract) {
            super.deductFrom(total, toSubtract);
            total.setVirtualCores(total.getVirtualCores() - toSubtract.getVirtualCores());
        }
    }

    private static interface ResourceCalculator {
        public boolean anyAvailable(Resource var1);

        public void deductFrom(Resource var1, Resource var2);
    }

    private static class MemResourceCalculator
    implements ResourceCalculator {
        private MemResourceCalculator() {
        }

        @Override
        public boolean anyAvailable(Resource rsrc) {
            return rsrc.getMemory() > 0;
        }

        @Override
        public void deductFrom(Resource total, Resource toSubtract) {
            total.setMemory(total.getMemory() - toSubtract.getMemory());
        }
    }

    static class ReuseContainerExecutor
    extends ScheduledThreadPoolExecutor {
        ReuseContainerExecutor() {
            super(1, new ThreadFactoryBuilder().setNameFormat("ReuseContainerExecutor #%d").build());
            this.setRemoveOnCancelPolicy(true);
            this.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            if (t == null && r instanceof Future) {
                try {
                    ((Future)((Object)r)).get();
                }
                catch (ExecutionException ee) {
                    LOG.warn("Execution exception when running task in {}", (Object)Thread.currentThread().getName());
                    t = ee.getCause();
                }
                catch (InterruptedException ie) {
                    LOG.warn("Thread ({}) interrupted: ", (Object)Thread.currentThread(), (Object)ie);
                    Thread.currentThread().interrupt();
                }
                catch (Throwable throwable) {
                    t = throwable;
                }
            }
            if (t != null) {
                LOG.warn("Caught exception in thread {}", (Object)Thread.currentThread().getName(), (Object)t);
            }
        }
    }

    private static class Assignment {
        final TaskRequest request;
        final Container container;

        Assignment(TaskRequest request, Container container) {
            this.request = request;
            this.container = container;
        }
    }

    private static enum HeldContainerState {
        MATCHING_LOCAL(true),
        MATCHING_RACK(true),
        MATCHING_ANY(true),
        ASSIGNED(false),
        RELEASED(false);

        private static final EnumSet<HeldContainerState> MATCHES_LOCAL_STATES;
        private static final EnumSet<HeldContainerState> MATCHES_RACK_STATES;
        private static final EnumSet<HeldContainerState> MATCHES_ANY_STATES;
        private final boolean assignable;

        private HeldContainerState(boolean assignable) {
            this.assignable = assignable;
        }

        boolean isAssignable() {
            return this.assignable;
        }

        static {
            MATCHES_LOCAL_STATES = EnumSet.of(MATCHING_LOCAL, MATCHING_RACK, MATCHING_ANY);
            MATCHES_RACK_STATES = EnumSet.of(MATCHING_RACK, MATCHING_ANY);
            MATCHES_ANY_STATES = EnumSet.of(MATCHING_ANY);
        }
    }

    private static class RequestPriorityStats {
        final Map<Integer, MutableInt> vertexTaskCount = new HashMap<Integer, MutableInt>();
        final BitSet vertices;
        final BitSet descendants;
        final BitSet allowedVertices;
        int requestCount = 0;
        int localityCount = 0;

        RequestPriorityStats(int numTotalVertices, BitSet allowedVertices) {
            this.vertices = new BitSet(numTotalVertices);
            this.descendants = new BitSet(numTotalVertices);
            this.allowedVertices = allowedVertices;
        }
    }

    private static class TaskStatus {
        final Object task;
        final ContainerStatus status;

        TaskStatus(Object task, ContainerStatus status) {
            this.task = task;
            this.status = status;
        }
    }

    private static class PreemptOrderComparator
    implements Comparator<HeldContainer> {
        private PreemptOrderComparator() {
        }

        @Override
        public int compare(HeldContainer o1, HeldContainer o2) {
            long timestamp2;
            long timestamp1 = o1.getAssignmentTimestamp();
            if (timestamp1 == 0L) {
                timestamp1 = Long.MAX_VALUE;
            }
            if ((timestamp2 = o2.getAssignmentTimestamp()) == 0L) {
                timestamp2 = Long.MAX_VALUE;
            }
            return Long.compare(timestamp2, timestamp1);
        }
    }
}

