/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.VertexManagerPlugin;
import org.apache.tez.dag.api.VertexManagerPluginContext;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.TaskAttemptIdentifier;
import org.apache.tez.runtime.api.events.VertexManagerEvent;

public class VertexManagerPluginForTest
extends VertexManagerPlugin {
    VertexManagerPluginForTestConfig pluginConfig = new VertexManagerPluginForTestConfig();

    public VertexManagerPluginForTest(VertexManagerPluginContext context) {
        super(context);
    }

    public void initialize() {
        UserPayload payload = this.getContext().getUserPayload();
        if (payload != null && payload.getPayload() != null) {
            this.pluginConfig.initialize(this.getContext().getUserPayload().getPayload());
        }
    }

    public void onVertexStarted(List<TaskAttemptIdentifier> completions) {
        if (this.pluginConfig.getReconfigureOnStart()) {
            this.getContext().reconfigureVertex(this.pluginConfig.getNumTasks(), null, null);
        }
    }

    public void onSourceTaskCompleted(TaskAttemptIdentifier attempt) {
    }

    public void onVertexManagerEventReceived(VertexManagerEvent vmEvent) {
    }

    public void onRootVertexInitialized(String inputName, InputDescriptor inputDescriptor, List<Event> events) {
    }

    public static class VertexManagerPluginForTestConfig {
        Configuration conf = new Configuration(false);
        static final String RECONFIGURE_ON_START = "reconfigureOnStart";
        static final String NUM_TASKS = "numTasks";

        public void setReconfigureOnStart(boolean value) {
            this.conf.setBoolean(RECONFIGURE_ON_START, value);
        }

        public void setNumTasks(int value) {
            this.conf.setInt(NUM_TASKS, value);
        }

        boolean getReconfigureOnStart() {
            return this.conf.getBoolean(RECONFIGURE_ON_START, false);
        }

        int getNumTasks() {
            return this.conf.getInt(NUM_TASKS, 1);
        }

        public ByteBuffer getPayload() {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(b);
            try {
                this.conf.write((DataOutput)out);
            }
            catch (IOException e) {
                throw new TezUncheckedException((Throwable)e);
            }
            return ByteBuffer.wrap(b.toByteArray());
        }

        void initialize(ByteBuffer buff) {
            ByteBuffer copy = ByteBuffer.allocate(buff.capacity());
            copy.put(buff);
            copy.flip();
            ByteArrayInputStream b = new ByteArrayInputStream(copy.array());
            DataInputStream in = new DataInputStream(b);
            try {
                this.conf.readFields((DataInput)in);
            }
            catch (IOException e) {
                throw new TezUncheckedException((Throwable)e);
            }
        }
    }
}

