/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.impl.AMRMClientImpl;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.common.ContainerSignatureMatcher;
import org.apache.tez.common.ServicePluginLifecycle;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.NamedEntityDescriptor;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ServicePluginLifecycleAbstractService;
import org.apache.tez.dag.app.rm.TaskSchedulerContextImpl;
import org.apache.tez.dag.app.rm.TaskSchedulerContextImplWrapper;
import org.apache.tez.dag.app.rm.TaskSchedulerManager;
import org.apache.tez.dag.app.rm.TaskSchedulerWrapper;
import org.apache.tez.dag.app.rm.TezAMRMClientAsync;
import org.apache.tez.dag.app.rm.YarnTaskSchedulerService;
import org.apache.tez.hadoop.shim.HadoopShimsLoader;
import org.apache.tez.serviceplugins.api.DagInfo;
import org.apache.tez.serviceplugins.api.ServicePluginError;
import org.apache.tez.serviceplugins.api.TaskScheduler;
import org.apache.tez.serviceplugins.api.TaskSchedulerContext;
import org.junit.Assert;
import org.mockito.Mockito;

final class TestTaskSchedulerHelpers {
    private TestTaskSchedulerHelpers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void waitForDelayedDrainNotify(AtomicBoolean drainNotifier) throws InterruptedException {
        AtomicBoolean atomicBoolean = drainNotifier;
        synchronized (atomicBoolean) {
            while (!drainNotifier.get()) {
                drainNotifier.wait();
            }
        }
    }

    static CountingExecutorService createCountingExecutingService(ExecutorService rawExecutor) {
        return new CountingExecutorService(rawExecutor);
    }

    static TaskSchedulerContext setupMockTaskSchedulerContext(String appHost, int appPort, String appUrl, Configuration conf) {
        return TestTaskSchedulerHelpers.setupMockTaskSchedulerContext(appHost, appPort, appUrl, false, conf);
    }

    static TaskSchedulerContext setupMockTaskSchedulerContext(String appHost, int appPort, String appUrl, boolean isSession, Configuration conf) {
        return TestTaskSchedulerHelpers.setupMockTaskSchedulerContext(appHost, appPort, appUrl, isSession, null, null, null, conf);
    }

    static TaskSchedulerContext setupMockTaskSchedulerContext(String appHost, int appPort, String appUrl, boolean isSession, ApplicationAttemptId appAttemptId, Long customAppIdentifier, ContainerSignatureMatcher containerSignatureMatcher, Configuration conf) {
        UserPayload userPayload;
        TaskSchedulerContext mockContext = (TaskSchedulerContext)Mockito.mock(TaskSchedulerContext.class);
        Mockito.when((Object)mockContext.getAppHostName()).thenReturn((Object)appHost);
        Mockito.when((Object)mockContext.getAppClientPort()).thenReturn((Object)appPort);
        Mockito.when((Object)mockContext.getAppTrackingUrl()).thenReturn((Object)appUrl);
        Mockito.when((Object)mockContext.getAMState()).thenReturn((Object)TaskSchedulerContext.AMState.RUNNING_APP);
        try {
            userPayload = TezUtils.createUserPayloadFromConf((Configuration)conf);
        }
        catch (IOException e) {
            throw new TezUncheckedException((Throwable)e);
        }
        Mockito.when((Object)mockContext.getInitialUserPayload()).thenReturn((Object)userPayload);
        Mockito.when((Object)mockContext.isSession()).thenReturn((Object)isSession);
        if (containerSignatureMatcher != null) {
            Mockito.when((Object)mockContext.getContainerSignatureMatcher()).thenReturn((Object)containerSignatureMatcher);
        } else {
            Mockito.when((Object)mockContext.getContainerSignatureMatcher()).thenReturn((Object)new AlwaysMatchesContainerMatcher());
        }
        if (appAttemptId != null) {
            Mockito.when((Object)mockContext.getApplicationAttemptId()).thenReturn((Object)appAttemptId);
        }
        if (customAppIdentifier != null) {
            Mockito.when((Object)mockContext.getCustomClusterIdentifier()).thenReturn((Object)customAppIdentifier);
        }
        return mockContext;
    }

    private static class CountingExecutorService
    implements ExecutorService {
        final ExecutorService real;
        final CompletionService completionService;

        CountingExecutorService(ExecutorService real) {
            this.real = real;
            this.completionService = new ExecutorCompletionService(real);
        }

        @Override
        public void execute(Runnable command) {
            throw new UnsupportedOperationException("Not expected to be used");
        }

        @Override
        public void shutdown() {
            this.real.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            return this.real.shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            return this.real.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.real.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.real.awaitTermination(timeout, unit);
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return this.completionService.submit(task);
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return this.completionService.submit(task, result);
        }

        @Override
        public Future<?> submit(Runnable task) {
            throw new UnsupportedOperationException("Not expected to be used");
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            throw new UnsupportedOperationException("Not expected to be used");
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException("Not expected to be used");
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            throw new UnsupportedOperationException("Not expected to be used");
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            throw new UnsupportedOperationException("Not expected to be used");
        }
    }

    static class AlwaysMatchesContainerMatcher
    implements ContainerSignatureMatcher {
        AlwaysMatchesContainerMatcher() {
        }

        public boolean isSuperSet(Object cs1, Object cs2) {
            Objects.requireNonNull(cs1, "Arguments cannot be null");
            Objects.requireNonNull(cs2, "Arguments cannot be null");
            return true;
        }

        public boolean isExactMatch(Object cs1, Object cs2) {
            return true;
        }

        public Map<String, LocalResource> getAdditionalResources(Map<String, LocalResource> lr1, Map<String, LocalResource> lr2) {
            return Maps.newHashMap();
        }

        public Object union(Object cs1, Object cs2) {
            return cs1;
        }
    }

    static class PreemptionMatcher
    implements ContainerSignatureMatcher {
        PreemptionMatcher() {
        }

        public boolean isSuperSet(Object cs1, Object cs2) {
            Objects.requireNonNull(cs1, "Arguments cannot be null");
            Objects.requireNonNull(cs2, "Arguments cannot be null");
            return true;
        }

        public boolean isExactMatch(Object cs1, Object cs2) {
            return cs1 == cs2 && cs1 != null;
        }

        public Map<String, LocalResource> getAdditionalResources(Map<String, LocalResource> lr1, Map<String, LocalResource> lr2) {
            return Maps.newHashMap();
        }

        public Object union(Object cs1, Object cs2) {
            return cs1;
        }
    }

    static class TaskSchedulerContextDrainable
    implements TaskSchedulerContext {
        int completedEvents;
        int invocations;
        private final TaskSchedulerContext real;
        private final CountingExecutorService countingExecutorService;
        final AtomicInteger count = new AtomicInteger(0);

        public TaskSchedulerContextDrainable(TaskSchedulerContextImplWrapper real) {
            this.countingExecutorService = (CountingExecutorService)real.getExecutorService();
            this.real = real;
        }

        public void taskAllocated(Object task, Object appCookie, Container container) {
            this.count.incrementAndGet();
            ++this.invocations;
            this.real.taskAllocated(task, appCookie, container);
        }

        public void containerAllocated(Container container) {
            this.count.incrementAndGet();
            ++this.invocations;
            this.real.containerAllocated(container);
        }

        public void containerReused(Container container) {
            this.count.incrementAndGet();
            ++this.invocations;
            this.real.containerReused(container);
        }

        public void containerCompleted(Object taskLastAllocated, ContainerStatus containerStatus) {
            ++this.invocations;
            this.real.containerCompleted(taskLastAllocated, containerStatus);
        }

        public void containerBeingReleased(ContainerId containerId) {
            ++this.invocations;
            this.real.containerBeingReleased(containerId);
        }

        public void nodesUpdated(List<NodeReport> updatedNodes) {
            ++this.invocations;
            this.real.nodesUpdated(updatedNodes);
        }

        public void appShutdownRequested() {
            ++this.invocations;
            this.real.appShutdownRequested();
        }

        public void setApplicationRegistrationData(Resource maxContainerCapability, Map<ApplicationAccessType, String> appAcls, ByteBuffer key, String queueName) {
            ++this.invocations;
            this.real.setApplicationRegistrationData(maxContainerCapability, appAcls, key, queueName);
        }

        public void reportError(@Nonnull ServicePluginError servicePluginError, String message, DagInfo dagInfo) {
            ++this.invocations;
            this.real.reportError(servicePluginError, message, dagInfo);
        }

        public float getProgress() {
            ++this.invocations;
            return this.real.getProgress();
        }

        public TaskSchedulerContext.AppFinalStatus getFinalAppStatus() {
            ++this.invocations;
            return this.real.getFinalAppStatus();
        }

        public UserPayload getInitialUserPayload() {
            return this.real.getInitialUserPayload();
        }

        public String getAppTrackingUrl() {
            return this.real.getAppTrackingUrl();
        }

        public long getCustomClusterIdentifier() {
            return this.real.getCustomClusterIdentifier();
        }

        public ContainerSignatureMatcher getContainerSignatureMatcher() {
            return this.real.getContainerSignatureMatcher();
        }

        public ApplicationAttemptId getApplicationAttemptId() {
            return this.real.getApplicationAttemptId();
        }

        @Nullable
        public DagInfo getCurrentDagInfo() {
            return this.real.getCurrentDagInfo();
        }

        public String getAppHostName() {
            return this.real.getAppHostName();
        }

        public int getAppClientPort() {
            return this.real.getAppClientPort();
        }

        public boolean isSession() {
            return this.real.isSession();
        }

        public TaskSchedulerContext.AMState getAMState() {
            return this.real.getAMState();
        }

        public int getVertexIndexForTask(Object task) {
            return this.real.getVertexIndexForTask(task);
        }

        public void preemptContainer(ContainerId cId) {
            ++this.invocations;
            this.real.preemptContainer(cId);
        }

        public void drain() throws InterruptedException, ExecutionException {
            while (this.completedEvents < this.invocations) {
                Future f = this.countingExecutorService.completionService.poll(5000L, TimeUnit.MILLISECONDS);
                if (f != null) {
                    ++this.completedEvents;
                    continue;
                }
                Assert.fail((String)"Timed out while trying to drain queue");
            }
        }
    }

    static class TaskSchedulerWithDrainableContext
    extends YarnTaskSchedulerService {
        public TaskSchedulerWithDrainableContext(TaskSchedulerContextDrainable appClient, TezAMRMClientAsync<YarnTaskSchedulerService.CookieContainerRequest> client) {
            super((TaskSchedulerContext)appClient, client);
            this.shouldUnregister.set(true);
        }

        public TaskSchedulerContextDrainable getDrainableAppCallback() {
            return (TaskSchedulerContextDrainable)this.getContext();
        }
    }

    static class CapturingEventHandler
    implements EventHandler {
        private final Queue<Event> events = new ConcurrentLinkedQueue<Event>();

        CapturingEventHandler() {
        }

        public void handle(Event event) {
            this.events.add(event);
        }

        public void reset() {
            this.events.clear();
        }

        public void verifyNoInvocations(Class<? extends Event> eventClass) {
            for (Event e : this.events) {
                Assert.assertNotEquals((Object)e.getClass().getName(), (Object)eventClass.getName());
            }
        }

        public Event verifyInvocation(Class<? extends Event> eventClass) {
            for (Event e : this.events) {
                if (!e.getClass().getName().equals(eventClass.getName())) continue;
                return e;
            }
            Assert.fail((String)("Expected Event: " + eventClass.getName() + " not sent"));
            return null;
        }

        public int getEventSize() {
            return this.events.size();
        }
    }

    static class TaskSchedulerManagerForTest
    extends TaskSchedulerManager {
        private final TezAMRMClientAsync<YarnTaskSchedulerService.CookieContainerRequest> amrmClientAsync;
        private final UserPayload defaultPayload;

        public TaskSchedulerManagerForTest(AppContext appContext, EventHandler eventHandler, TezAMRMClientAsync<YarnTaskSchedulerService.CookieContainerRequest> amrmClientAsync, ContainerSignatureMatcher containerSignatureMatcher, UserPayload defaultPayload) {
            super(appContext, null, eventHandler, containerSignatureMatcher, null, (List)Lists.newArrayList((Object[])new NamedEntityDescriptor[]{new NamedEntityDescriptor("FakeScheduler", null)}), false, new HadoopShimsLoader(appContext.getAMConf()).getHadoopShim());
            this.amrmClientAsync = amrmClientAsync;
            this.defaultPayload = defaultPayload;
        }

        TaskSchedulerManagerForTest(AppContext appContext, EventHandler eventHandler, TezAMRMClientAsync<YarnTaskSchedulerService.CookieContainerRequest> amrmClientAsync, ContainerSignatureMatcher containerSignatureMatcher, UserPayload defaultPayload, List<NamedEntityDescriptor> descriptors) {
            super(appContext, null, eventHandler, containerSignatureMatcher, null, descriptors, false, new HadoopShimsLoader(appContext.getAMConf()).getHadoopShim());
            this.amrmClientAsync = amrmClientAsync;
            this.defaultPayload = defaultPayload;
        }

        public void instantiateSchedulers(String host, int port, String trackingUrl, AppContext appContext) {
            TaskSchedulerContextImpl taskSchedulerContext = new TaskSchedulerContextImpl((TaskSchedulerManager)this, appContext, 0, trackingUrl, 1000L, host, port, this.defaultPayload);
            TaskSchedulerContextImplWrapper wrapper = new TaskSchedulerContextImplWrapper((TaskSchedulerContext)taskSchedulerContext, (ExecutorService)new CountingExecutorService(this.appCallbackExecutor));
            TaskSchedulerContextDrainable drainable = new TaskSchedulerContextDrainable(wrapper);
            this.taskSchedulers[0] = new TaskSchedulerWrapper((TaskScheduler)Mockito.spy((Object)((Object)new TaskSchedulerWithDrainableContext(drainable, this.amrmClientAsync))));
            this.taskSchedulerServiceWrappers[0] = new ServicePluginLifecycleAbstractService((ServicePluginLifecycle)this.taskSchedulers[0].getTaskScheduler());
        }

        public TaskScheduler getSpyTaskScheduler() {
            return this.taskSchedulers[0].getTaskScheduler();
        }

        public void serviceStart() {
            this.instantiateSchedulers("host", 0, "", this.appContext);
            this.taskSchedulerServiceWrappers[0].init(this.getConfig());
            this.taskSchedulerServiceWrappers[0].start();
        }

        public void serviceStop() {
        }
    }

    static class AMRMClientAsyncForTest
    extends TezAMRMClientAsync<YarnTaskSchedulerService.CookieContainerRequest> {
        private RegisterApplicationMasterResponse mockRegResponse;

        public AMRMClientAsyncForTest(AMRMClient<YarnTaskSchedulerService.CookieContainerRequest> client, int intervalMs) {
            super(client, intervalMs, null);
        }

        public RegisterApplicationMasterResponse registerApplicationMaster(String appHostName, int appHostPort, String appTrackingUrl) {
            this.mockRegResponse = (RegisterApplicationMasterResponse)Mockito.mock(RegisterApplicationMasterResponse.class);
            Resource mockMaxResource = (Resource)Mockito.mock(Resource.class);
            Map mockAcls = (Map)Mockito.mock(Map.class);
            Mockito.when((Object)this.mockRegResponse.getMaximumResourceCapability()).thenReturn((Object)mockMaxResource);
            Mockito.when((Object)this.mockRegResponse.getApplicationACLs()).thenReturn((Object)mockAcls);
            return this.mockRegResponse;
        }

        public void unregisterApplicationMaster(FinalApplicationStatus appStatus, String appMessage, String appTrackingUrl) {
        }

        protected void serviceStart() {
        }

        protected void serviceStop() {
        }

        RegisterApplicationMasterResponse getRegistrationResponse() {
            return this.mockRegResponse;
        }
    }

    static class AMRMClientForTest
    extends AMRMClientImpl<YarnTaskSchedulerService.CookieContainerRequest> {
        AMRMClientForTest() {
            this.clusterAvailableResources = Resource.newInstance((int)4000, (int)4);
            this.clusterNodeCount = 5;
        }

        protected void serviceStart() {
        }

        protected void serviceStop() {
        }
    }
}

