/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm;

import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.tez.common.ContainerSignatureMatcher;
import org.apache.tez.common.MockDNSToSwitchMapping;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.app.dag.TaskAttempt;
import org.apache.tez.dag.app.rm.TaskSchedulerContextImplWrapper;
import org.apache.tez.dag.app.rm.TestTaskSchedulerHelpers;
import org.apache.tez.dag.app.rm.TezAMRMClientAsync;
import org.apache.tez.dag.app.rm.YarnTaskSchedulerService;
import org.apache.tez.dag.app.rm.YarnTaskSchedulerServiceError;
import org.apache.tez.serviceplugins.api.DagInfo;
import org.apache.tez.serviceplugins.api.ServicePluginError;
import org.apache.tez.serviceplugins.api.TaskSchedulerContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestTaskScheduler {
    static ContainerSignatureMatcher containerSignatureMatcher = new TestTaskSchedulerHelpers.AlwaysMatchesContainerMatcher();
    private ExecutorService contextCallbackExecutor;
    private static final String DEFAULT_APP_HOST = "host";
    private static final String DEFAULT_APP_URL = "url";
    private static final String SUCCEED_APP_MESSAGE = "success";
    private static final int DEFAULT_APP_PORT = 0;

    @BeforeClass
    public static void beforeClass() {
        MockDNSToSwitchMapping.initializeMockRackResolver();
    }

    @Before
    public void preTest() {
        this.contextCallbackExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("TaskSchedulerAppCallbackExecutor #%d").setDaemon(true).build());
    }

    @After
    public void postTest() {
        this.contextCallbackExecutor.shutdownNow();
    }

    private TestTaskSchedulerHelpers.TaskSchedulerContextDrainable createDrainableContext(TaskSchedulerContext taskSchedulerContext) {
        TaskSchedulerContextImplWrapper wrapper = new TaskSchedulerContextImplWrapper(taskSchedulerContext, (ExecutorService)TestTaskSchedulerHelpers.createCountingExecutingService(this.contextCallbackExecutor));
        return new TestTaskSchedulerHelpers.TaskSchedulerContextDrainable(wrapper);
    }

    @Test(timeout=10000L)
    public void testTaskSchedulerNoReuse() throws Exception {
        TestTaskSchedulerHelpers.AMRMClientAsyncForTest mockRMClient = (TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.spy((Object)((Object)new TestTaskSchedulerHelpers.AMRMClientAsyncForTest((AMRMClient<YarnTaskSchedulerService.CookieContainerRequest>)new TestTaskSchedulerHelpers.AMRMClientForTest(), 100))));
        Configuration conf = new Configuration();
        conf.setBoolean("tez.am.container.reuse.enabled", false);
        int interval = 100;
        conf.setInt("tez.am.am-rm.heartbeat.interval-ms.max", interval);
        TaskSchedulerContext mockApp = TestTaskSchedulerHelpers.setupMockTaskSchedulerContext(DEFAULT_APP_HOST, 0, DEFAULT_APP_URL, conf);
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback = this.createDrainableContext(mockApp);
        TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext scheduler = new TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext(drainableAppCallback, mockRMClient);
        scheduler.initialize();
        drainableAppCallback.drain();
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).setHeartbeatInterval(interval);
        scheduler.start();
        drainableAppCallback.drain();
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).start();
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).registerApplicationMaster(DEFAULT_APP_HOST, 0, DEFAULT_APP_URL);
        RegisterApplicationMasterResponse regResponse = mockRMClient.getRegistrationResponse();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).setApplicationRegistrationData(regResponse.getMaximumResourceCapability(), regResponse.getApplicationACLs(), regResponse.getClientToAMTokenMasterKey(), regResponse.getQueue());
        Assert.assertEquals((long)scheduler.getClusterNodeCount(), (long)mockRMClient.getClusterNodeCount());
        MockTask mockTask1 = new MockTask("task1");
        Object mockCookie1 = new Object();
        Resource mockCapability = Resource.newInstance((int)1024, (int)1);
        String[] hosts = new String[]{"host1", "host5"};
        String[] racks = new String[]{"/default-rack", "/default-rack"};
        Priority mockPriority = Priority.newInstance((int)1);
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(YarnTaskSchedulerService.CookieContainerRequest.class);
        scheduler.allocateTask(mockTask1, mockCapability, hosts, racks, mockPriority, null, mockCookie1);
        drainableAppCallback.drain();
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)1)))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)Mockito.any()));
        Assert.assertFalse((boolean)scheduler.deallocateTask(mockTask1, true, null, null));
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)0))).containerBeingReleased((ContainerId)Mockito.any());
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)1)))).removeContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)Mockito.any()));
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)0)))).releaseAssignedContainer((ContainerId)Mockito.any());
        Assert.assertFalse((boolean)scheduler.deallocateTask(mockTask1, true, null, null));
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)0))).containerBeingReleased((ContainerId)Mockito.any());
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)1)))).removeContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)Mockito.any()));
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)0)))).releaseAssignedContainer((ContainerId)Mockito.any());
        MockTask mockTask2 = new MockTask("task2");
        Object mockCookie2 = new Object();
        MockTask mockTask3 = new MockTask("task3");
        Object mockCookie3 = new Object();
        scheduler.allocateTask(mockTask1, mockCapability, hosts, racks, mockPriority, null, mockCookie1);
        drainableAppCallback.drain();
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)2)))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.capture()));
        YarnTaskSchedulerService.CookieContainerRequest request1 = (YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.getValue();
        scheduler.allocateTask(mockTask2, mockCapability, hosts, racks, mockPriority, null, mockCookie2);
        drainableAppCallback.drain();
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)3)))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.capture()));
        YarnTaskSchedulerService.CookieContainerRequest request2 = (YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.getValue();
        scheduler.allocateTask(mockTask3, mockCapability, hosts, racks, mockPriority, null, mockCookie3);
        drainableAppCallback.drain();
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)4)))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.capture()));
        YarnTaskSchedulerService.CookieContainerRequest request3 = (YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.getValue();
        NodeId host1 = NodeId.newInstance((String)"host1", (int)1);
        NodeId host2 = NodeId.newInstance((String)"host2", (int)2);
        NodeId host3 = NodeId.newInstance((String)"host3", (int)3);
        NodeId host4 = NodeId.newInstance((String)"host4", (int)4);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1);
        ContainerId mockCId1 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L);
        Container mockContainer1 = Container.newInstance((ContainerId)mockCId1, (NodeId)host1, null, (Resource)mockCapability, (Priority)mockPriority, null);
        ContainerId mockCId2 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)2L);
        Container mockContainer2 = Container.newInstance((ContainerId)mockCId2, (NodeId)host2, null, (Resource)mockCapability, (Priority)mockPriority, null);
        ContainerId mockCId3 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)3L);
        Container mockContainer3 = Container.newInstance((ContainerId)mockCId3, (NodeId)host3, null, (Resource)mockCapability, (Priority)mockPriority, null);
        ContainerId mockCId4 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)4L);
        Container mockContainer4 = Container.newInstance((ContainerId)mockCId4, (NodeId)host4, null, (Resource)mockCapability, (Priority)mockPriority, null);
        ArrayList<Container> containers = new ArrayList<Container>();
        containers.add(mockContainer1);
        containers.add(mockContainer2);
        containers.add(mockContainer3);
        containers.add(mockContainer4);
        scheduler.onContainersAllocated(containers);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)mockTask1, mockCookie1, mockContainer1);
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)mockTask2, mockCookie2, mockContainer2);
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)mockTask3, mockCookie3, mockContainer3);
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)3))).taskAllocated(Mockito.any(), Mockito.any(), (Container)Mockito.any());
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)request1);
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)request2);
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)request3);
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).releaseAssignedContainer(mockCId4);
        Assert.assertTrue((boolean)scheduler.deallocateTask(mockTask1, true, null, null));
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).containerBeingReleased(mockCId1);
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).releaseAssignedContainer(mockCId1);
        Assert.assertEquals((Object)mockTask2, (Object)scheduler.deallocateContainer(mockCId2));
        drainableAppCallback.drain();
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).releaseAssignedContainer(mockCId2);
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)3)))).releaseAssignedContainer((ContainerId)Mockito.any());
        ArrayList<ContainerStatus> statuses = new ArrayList<ContainerStatus>();
        ContainerStatus mockStatus1 = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        Mockito.when((Object)mockStatus1.getContainerId()).thenReturn((Object)mockCId1);
        statuses.add(mockStatus1);
        ContainerStatus mockStatus2 = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        Mockito.when((Object)mockStatus2.getContainerId()).thenReturn((Object)mockCId2);
        statuses.add(mockStatus2);
        ContainerStatus mockStatus3 = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        Mockito.when((Object)mockStatus3.getContainerId()).thenReturn((Object)mockCId3);
        statuses.add(mockStatus3);
        ContainerStatus mockStatus4 = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        Mockito.when((Object)mockStatus4.getContainerId()).thenReturn((Object)mockCId4);
        statuses.add(mockStatus4);
        scheduler.onContainersCompleted(statuses);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).containerCompleted((Object)mockTask1, mockStatus1);
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).containerCompleted((Object)mockTask2, mockStatus2);
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).containerCompleted((Object)mockTask3, mockStatus3);
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)3))).containerCompleted(Mockito.any(), (ContainerStatus)Mockito.any());
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)3)))).releaseAssignedContainer((ContainerId)Mockito.any());
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)0)))).addNodeToBlacklist((NodeId)Mockito.any());
        String badHost = "host6";
        NodeId badNodeId = NodeId.newInstance((String)badHost, (int)1);
        scheduler.blacklistNode(badNodeId);
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)1)))).addNodeToBlacklist(badNodeId);
        MockTask mockTask4 = new MockTask("task4");
        Object mockCookie4 = new Object();
        scheduler.allocateTask(mockTask4, mockCapability, null, null, mockPriority, null, mockCookie4);
        drainableAppCallback.drain();
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)5)))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.capture()));
        ContainerId mockCId5 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)5L);
        Container mockContainer5 = Container.newInstance((ContainerId)mockCId5, (NodeId)badNodeId, null, (Resource)mockCapability, (Priority)mockPriority, null);
        containers.clear();
        containers.add(mockContainer5);
        scheduler.onContainersAllocated(containers);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)3))).taskAllocated(Mockito.any(), Mockito.any(), (Container)Mockito.any());
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).releaseAssignedContainer(mockCId5);
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)4)))).releaseAssignedContainer((ContainerId)Mockito.any());
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)6)))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.capture()));
        ContainerId mockCId6 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)6L);
        NodeId host7 = NodeId.newInstance((String)"host7", (int)7);
        Container mockContainer6 = Container.newInstance((ContainerId)mockCId6, (NodeId)host7, null, (Resource)mockCapability, (Priority)mockPriority, null);
        containers.clear();
        containers.add(mockContainer6);
        scheduler.onContainersAllocated(containers);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)4))).taskAllocated(Mockito.any(), Mockito.any(), (Container)Mockito.any());
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)mockTask4, mockCookie4, mockContainer6);
        Assert.assertTrue((boolean)scheduler.deallocateTask(mockTask4, true, null, null));
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).containerBeingReleased(mockCId6);
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).releaseAssignedContainer(mockCId6);
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)5)))).releaseAssignedContainer((ContainerId)Mockito.any());
        scheduler.unblacklistNode(badNodeId);
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)1)))).removeNodeFromBlacklist(badNodeId);
        Assert.assertEquals((long)0L, (long)scheduler.blacklistedNodes.size());
        float progress = 0.5f;
        Mockito.when((Object)Float.valueOf(mockApp.getProgress())).thenReturn((Object)Float.valueOf(progress));
        Assert.assertEquals((float)progress, (float)scheduler.getProgress(), (float)0.0f);
        scheduler.allocateTask(mockTask1, mockCapability, hosts, racks, mockPriority, null, mockCookie1);
        drainableAppCallback.drain();
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)7)))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)Mockito.any()));
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)6)))).removeContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)Mockito.any()));
        scheduler.allocateTask(mockTask1, mockCapability, hosts, racks, mockPriority, null, mockCookie1);
        drainableAppCallback.drain();
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)7)))).removeContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)Mockito.any()));
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)8)))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)Mockito.any()));
        Assert.assertFalse((boolean)scheduler.deallocateTask(mockTask1, true, null, null));
        String speculativeNode = "host8";
        NodeId speculativeNodeId = (NodeId)Mockito.mock(NodeId.class);
        Mockito.when((Object)speculativeNodeId.getHost()).thenReturn((Object)speculativeNode);
        TaskAttempt mockTask5 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        Task task = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)mockTask5.getTask()).thenReturn((Object)task);
        Mockito.when((Object)task.getNodesWithRunningAttempts()).thenReturn((Object)Sets.newHashSet((Object[])new NodeId[]{speculativeNodeId}));
        Object mockCookie5 = new Object();
        scheduler.allocateTask(mockTask5, mockCapability, hosts, racks, mockPriority, null, mockCookie5);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)4))).taskAllocated(Mockito.any(), Mockito.any(), (Container)Mockito.any());
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)5)))).releaseAssignedContainer((ContainerId)Mockito.any());
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)9)))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.capture()));
        List mockUpdatedNodes = (List)Mockito.mock(List.class);
        scheduler.onNodesUpdated(mockUpdatedNodes);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).nodesUpdated(mockUpdatedNodes);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(String.class);
        IOException mockException = new IOException("mockexception");
        scheduler.onError(mockException);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).reportError((ServicePluginError)Mockito.eq((Object)YarnTaskSchedulerServiceError.RESOURCEMANAGER_ERROR), (String)argumentCaptor.capture(), (DagInfo)Mockito.any());
        Assert.assertTrue((boolean)((String)argumentCaptor.getValue()).contains("mockexception"));
        scheduler.onShutdownRequest();
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).appShutdownRequested();
        TaskSchedulerContext.AppFinalStatus finalStatus = new TaskSchedulerContext.AppFinalStatus(FinalApplicationStatus.SUCCEEDED, SUCCEED_APP_MESSAGE, DEFAULT_APP_URL);
        Mockito.when((Object)mockApp.getFinalAppStatus()).thenReturn((Object)finalStatus);
        scheduler.shutdown();
        drainableAppCallback.drain();
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).unregisterApplicationMaster(FinalApplicationStatus.SUCCEEDED, SUCCEED_APP_MESSAGE, DEFAULT_APP_URL);
        ((TestTaskSchedulerHelpers.AMRMClientAsyncForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).stop();
    }

    @Test(timeout=10000L)
    public void testTaskSchedulerInitiateStop() throws Exception {
        AtomicBoolean drainNotifier;
        Configuration conf = new Configuration();
        conf.setLong("tez.am.container.reuse.locality.delay-allocation-millis", 0L);
        conf.setLong("tez.am.container.idle.release-timeout-min.millis", 10000L);
        conf.setLong("tez.am.container.idle.release-timeout-max.millis", 10000L);
        TaskSchedulerContext mockApp = TestTaskSchedulerHelpers.setupMockTaskSchedulerContext(DEFAULT_APP_HOST, 0, DEFAULT_APP_URL, conf);
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback = this.createDrainableContext(mockApp);
        TezAMRMClientAsync mockRMClient = (TezAMRMClientAsync)Mockito.spy((Object)((Object)new TestTaskSchedulerHelpers.AMRMClientAsyncForTest((AMRMClient<YarnTaskSchedulerService.CookieContainerRequest>)new TestTaskSchedulerHelpers.AMRMClientForTest(), 100)));
        TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext scheduler = new TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext(drainableAppCallback, (TezAMRMClientAsync<YarnTaskSchedulerService.CookieContainerRequest>)mockRMClient);
        scheduler.initialize();
        drainableAppCallback.drain();
        scheduler.start();
        drainableAppCallback.drain();
        MockTask mockTask1 = new MockTask("task1");
        Object mockCookie1 = new Object();
        Resource mockCapability = Resource.newInstance((int)1024, (int)1);
        String[] hosts = new String[]{"host1", "host5"};
        String[] racks = new String[]{"/default-rack", "/default-rack"};
        Priority mockPriority1 = Priority.newInstance((int)1);
        Priority mockPriority2 = Priority.newInstance((int)2);
        Priority mockPriority3 = Priority.newInstance((int)3);
        Priority mockPriority = Priority.newInstance((int)1);
        MockTask mockTask2 = new MockTask("task2");
        Object mockCookie2 = new Object();
        MockTask mockTask3 = new MockTask("task3");
        Object mockCookie3 = new Object();
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(YarnTaskSchedulerService.CookieContainerRequest.class);
        scheduler.allocateTask(mockTask1, mockCapability, hosts, racks, mockPriority1, null, mockCookie1);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)1))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.capture()));
        YarnTaskSchedulerService.CookieContainerRequest request1 = (YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.getValue();
        scheduler.allocateTask(mockTask2, mockCapability, hosts, racks, mockPriority2, null, mockCookie2);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)2))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.capture()));
        YarnTaskSchedulerService.CookieContainerRequest request2 = (YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.getValue();
        scheduler.allocateTask(mockTask3, mockCapability, hosts, racks, mockPriority3, null, mockCookie3);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)3))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.capture()));
        YarnTaskSchedulerService.CookieContainerRequest request3 = (YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.getValue();
        ArrayList<Container> containers = new ArrayList<Container>();
        NodeId host1 = NodeId.newInstance((String)"host1", (int)1);
        NodeId host2 = NodeId.newInstance((String)"host2", (int)2);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1);
        ContainerId mockCId1 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L);
        Container mockContainer1 = Container.newInstance((ContainerId)mockCId1, (NodeId)host1, null, (Resource)mockCapability, (Priority)mockPriority, null);
        ContainerId mockCId2 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)2L);
        Container mockContainer2 = Container.newInstance((ContainerId)mockCId2, (NodeId)host2, null, (Resource)mockCapability, (Priority)mockPriority, null);
        containers.add(mockContainer1);
        containers.add(mockContainer2);
        ArrayList<YarnTaskSchedulerService.CookieContainerRequest> hostContainers = new ArrayList<YarnTaskSchedulerService.CookieContainerRequest>();
        hostContainers.add(request1);
        ArrayList<YarnTaskSchedulerService.CookieContainerRequest> rackContainers = new ArrayList<YarnTaskSchedulerService.CookieContainerRequest>();
        rackContainers.add(request2);
        ArrayList<YarnTaskSchedulerService.CookieContainerRequest> anyContainers = new ArrayList<YarnTaskSchedulerService.CookieContainerRequest>();
        anyContainers.add(request3);
        scheduler.delayedContainerManager.drainedDelayedContainersForTest = drainNotifier = new AtomicBoolean(false);
        scheduler.onContainersAllocated(containers);
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        drainableAppCallback.drain();
        Assert.assertEquals((long)2L, (long)scheduler.heldContainers.size());
        Assert.assertEquals((long)1L, (long)scheduler.taskRequests.size());
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).removeContainerRequest((AMRMClient.ContainerRequest)request1);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).removeContainerRequest((AMRMClient.ContainerRequest)request2);
        scheduler.initiateStop();
        Assert.assertEquals((long)0L, (long)scheduler.heldContainers.size());
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).releaseAssignedContainer(mockCId1);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).releaseAssignedContainer(mockCId2);
        Assert.assertEquals((long)0L, (long)scheduler.taskRequests.size());
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).removeContainerRequest((AMRMClient.ContainerRequest)request3);
    }

    @Test(timeout=10000L)
    public void testTaskSchedulerWithReuse() throws Exception {
        AtomicBoolean drainNotifier;
        TezAMRMClientAsync mockRMClient = (TezAMRMClientAsync)Mockito.spy((Object)((Object)new TestTaskSchedulerHelpers.AMRMClientAsyncForTest((AMRMClient<YarnTaskSchedulerService.CookieContainerRequest>)new TestTaskSchedulerHelpers.AMRMClientForTest(), 100)));
        Configuration conf = new Configuration();
        conf.setLong("tez.am.container.reuse.locality.delay-allocation-millis", 0L);
        conf.setLong("tez.am.container.idle.release-timeout-min.millis", 0L);
        conf.setLong("tez.am.container.idle.release-timeout-max.millis", 0L);
        TaskSchedulerContext mockApp = TestTaskSchedulerHelpers.setupMockTaskSchedulerContext(DEFAULT_APP_HOST, 0, DEFAULT_APP_URL, conf);
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback = this.createDrainableContext(mockApp);
        TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext scheduler = new TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext(drainableAppCallback, (TezAMRMClientAsync<YarnTaskSchedulerService.CookieContainerRequest>)mockRMClient);
        scheduler.initialize();
        drainableAppCallback.drain();
        scheduler.start();
        drainableAppCallback.drain();
        MockTask mockTask1 = new MockTask("task1");
        Object mockCookie1 = new Object();
        Resource mockCapability = Resource.newInstance((int)1024, (int)1);
        String[] hosts = new String[]{"host1", "host5"};
        String[] racks = new String[]{"/default-rack", "/default-rack"};
        Priority mockPriority1 = Priority.newInstance((int)1);
        Priority mockPriority2 = Priority.newInstance((int)2);
        Priority mockPriority3 = Priority.newInstance((int)3);
        Priority mockPriority4 = Priority.newInstance((int)4);
        Priority mockPriority5 = Priority.newInstance((int)5);
        MockTask mockTask2 = new MockTask("task2");
        Object mockCookie2 = new Object();
        MockTask mockTask3 = new MockTask("task3");
        Object mockCookie3 = new Object();
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(YarnTaskSchedulerService.CookieContainerRequest.class);
        scheduler.allocateTask(mockTask1, mockCapability, hosts, racks, mockPriority1, null, mockCookie1);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)1))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.capture()));
        YarnTaskSchedulerService.CookieContainerRequest request1 = (YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.getValue();
        scheduler.allocateTask(mockTask2, mockCapability, hosts, racks, mockPriority2, null, mockCookie2);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)2))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.capture()));
        YarnTaskSchedulerService.CookieContainerRequest request2 = (YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.getValue();
        scheduler.allocateTask(mockTask3, mockCapability, hosts, racks, mockPriority3, null, mockCookie3);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)3))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.capture()));
        YarnTaskSchedulerService.CookieContainerRequest request3 = (YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.getValue();
        NodeId host1 = NodeId.newInstance((String)"host1", (int)1);
        NodeId host2 = NodeId.newInstance((String)"host2", (int)2);
        NodeId host3 = NodeId.newInstance((String)"host3", (int)3);
        NodeId host4 = NodeId.newInstance((String)"host4", (int)4);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1);
        ContainerId mockCId1 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L);
        Container mockContainer1 = Container.newInstance((ContainerId)mockCId1, (NodeId)host1, null, (Resource)mockCapability, (Priority)mockPriority1, null);
        ContainerId mockCId2 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)2L);
        Container mockContainer2 = Container.newInstance((ContainerId)mockCId2, (NodeId)host2, null, (Resource)mockCapability, (Priority)mockPriority2, null);
        ContainerId mockCId3 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)3L);
        Container mockContainer3 = Container.newInstance((ContainerId)mockCId3, (NodeId)host3, null, (Resource)mockCapability, (Priority)mockPriority3, null);
        ContainerId mockCId4 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)4L);
        Container mockContainer4 = Container.newInstance((ContainerId)mockCId4, (NodeId)host4, null, (Resource)mockCapability, (Priority)mockPriority4, null);
        ArrayList<Container> containers = new ArrayList<Container>();
        containers.add(mockContainer4);
        containers.add(mockContainer1);
        containers.add(mockContainer2);
        containers.add(mockContainer3);
        scheduler.delayedContainerManager.drainedDelayedContainersForTest = drainNotifier = new AtomicBoolean(false);
        scheduler.onContainersAllocated(containers);
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)3))).taskAllocated(Mockito.any(), Mockito.any(), (Container)Mockito.any());
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)mockTask1, mockCookie1, mockContainer1);
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)mockTask2, mockCookie2, mockContainer2);
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)mockTask3, mockCookie3, mockContainer3);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).removeContainerRequest((AMRMClient.ContainerRequest)request1);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).removeContainerRequest((AMRMClient.ContainerRequest)request2);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).removeContainerRequest((AMRMClient.ContainerRequest)request3);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).releaseAssignedContainer(mockCId4);
        Assert.assertTrue((boolean)scheduler.deallocateTask(mockTask1, true, null, null));
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).containerBeingReleased(mockCId1);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).releaseAssignedContainer(mockCId1);
        Assert.assertEquals((Object)mockTask2, (Object)scheduler.deallocateContainer(mockCId2));
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).releaseAssignedContainer(mockCId2);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)3))).releaseAssignedContainer((ContainerId)Mockito.any());
        ArrayList<ContainerStatus> statuses = new ArrayList<ContainerStatus>();
        ContainerStatus mockStatus1 = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        Mockito.when((Object)mockStatus1.getContainerId()).thenReturn((Object)mockCId1);
        statuses.add(mockStatus1);
        ContainerStatus mockStatus2 = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        Mockito.when((Object)mockStatus2.getContainerId()).thenReturn((Object)mockCId2);
        statuses.add(mockStatus2);
        ContainerStatus mockStatus3 = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        Mockito.when((Object)mockStatus3.getContainerId()).thenReturn((Object)mockCId3);
        statuses.add(mockStatus3);
        ContainerStatus mockStatus4 = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        Mockito.when((Object)mockStatus4.getContainerId()).thenReturn((Object)mockCId4);
        statuses.add(mockStatus4);
        scheduler.onContainersCompleted(statuses);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).containerCompleted((Object)mockTask1, mockStatus1);
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).containerCompleted((Object)mockTask2, mockStatus2);
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).containerCompleted((Object)mockTask3, mockStatus3);
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)3))).containerCompleted(Mockito.any(), (ContainerStatus)Mockito.any());
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)3))).releaseAssignedContainer((ContainerId)Mockito.any());
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)0))).addNodeToBlacklist((NodeId)Mockito.any());
        String badHost = "host6";
        NodeId badNodeId = NodeId.newInstance((String)badHost, (int)1);
        scheduler.blacklistNode(badNodeId);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)1))).addNodeToBlacklist(badNodeId);
        MockTask mockTask4 = new MockTask("task4");
        Object mockCookie4 = new Object();
        scheduler.allocateTask(mockTask4, mockCapability, null, null, mockPriority4, null, mockCookie4);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)4))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.capture()));
        ContainerId mockCId5 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)5L);
        Container mockContainer5 = Container.newInstance((ContainerId)mockCId5, (NodeId)badNodeId, null, (Resource)mockCapability, (Priority)mockPriority4, null);
        containers.clear();
        containers.add(mockContainer5);
        drainNotifier.set(false);
        scheduler.onContainersAllocated(containers);
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)3))).taskAllocated(Mockito.any(), Mockito.any(), (Container)Mockito.any());
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).releaseAssignedContainer(mockCId5);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)4))).releaseAssignedContainer((ContainerId)Mockito.any());
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)5))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.capture()));
        NodeId host7 = NodeId.newInstance((String)"host7", (int)7);
        ContainerId mockCId6 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)6L);
        Container mockContainer6 = Container.newInstance((ContainerId)mockCId6, (NodeId)host7, null, (Resource)mockCapability, (Priority)mockPriority4, null);
        containers.clear();
        containers.add(mockContainer6);
        drainNotifier.set(false);
        scheduler.onContainersAllocated(containers);
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)4))).taskAllocated(Mockito.any(), Mockito.any(), (Container)Mockito.any());
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)mockTask4, mockCookie4, mockContainer6);
        Assert.assertTrue((boolean)scheduler.deallocateTask(mockTask4, true, null, null));
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).containerBeingReleased(mockCId6);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).releaseAssignedContainer(mockCId6);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)5))).releaseAssignedContainer((ContainerId)Mockito.any());
        scheduler.unblacklistNode(badNodeId);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)1))).removeNodeFromBlacklist(badNodeId);
        Assert.assertEquals((long)0L, (long)scheduler.blacklistedNodes.size());
        MockTask mockTask5 = new MockTask("task5");
        Object mockCookie5 = new Object();
        scheduler.allocateTask(mockTask5, mockCapability, hosts, racks, mockPriority5, null, mockCookie5);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)6))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.capture()));
        drainableAppCallback.drain();
        containers.clear();
        NodeId host5 = NodeId.newInstance((String)"host5", (int)5);
        ContainerId mockCId7 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)7L);
        Container mockContainer7 = Container.newInstance((ContainerId)mockCId7, (NodeId)host5, null, (Resource)mockCapability, (Priority)mockPriority5, null);
        containers.add(mockContainer7);
        ContainerId mockCId8 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)8L);
        Container mockContainer8 = Container.newInstance((ContainerId)mockCId8, (NodeId)host5, null, (Resource)mockCapability, (Priority)mockPriority5, null);
        containers.add(mockContainer8);
        drainNotifier.set(false);
        scheduler.onContainersAllocated(containers);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)5))).releaseAssignedContainer((ContainerId)Mockito.any());
        MockTask mockTask6 = new MockTask("task6");
        Object mockCookie6 = new Object();
        scheduler.allocateTask(mockTask6, mockCapability, mockCId7, mockPriority5, null, mockCookie6);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)7))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.capture()));
        TestTaskSchedulerHelpers.waitForDelayedDrainNotify(drainNotifier);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)6))).taskAllocated(Mockito.any(), Mockito.any(), (Container)Mockito.any());
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)mockTask6, mockCookie6, mockContainer7);
        Assert.assertTrue((boolean)scheduler.deallocateTask(mockTask5, true, null, null));
        Assert.assertTrue((boolean)scheduler.deallocateTask(mockTask6, true, null, null));
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).containerBeingReleased(mockCId7);
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).containerBeingReleased(mockCId8);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).releaseAssignedContainer(mockCId7);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).releaseAssignedContainer(mockCId8);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)7))).releaseAssignedContainer((ContainerId)Mockito.any());
        float progress = 0.5f;
        Mockito.when((Object)Float.valueOf(mockApp.getProgress())).thenReturn((Object)Float.valueOf(progress));
        Assert.assertEquals((float)progress, (float)scheduler.getProgress(), (float)0.0f);
        List mockUpdatedNodes = (List)Mockito.mock(List.class);
        scheduler.onNodesUpdated(mockUpdatedNodes);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).nodesUpdated(mockUpdatedNodes);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(String.class);
        IOException mockException = new IOException("mockexception");
        scheduler.onError(mockException);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).reportError((ServicePluginError)Mockito.eq((Object)YarnTaskSchedulerServiceError.RESOURCEMANAGER_ERROR), (String)argumentCaptor.capture(), (DagInfo)Mockito.any());
        Assert.assertTrue((boolean)((String)argumentCaptor.getValue()).contains("mockexception"));
        scheduler.onShutdownRequest();
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).appShutdownRequested();
        TaskSchedulerContext.AppFinalStatus finalStatus = new TaskSchedulerContext.AppFinalStatus(FinalApplicationStatus.SUCCEEDED, SUCCEED_APP_MESSAGE, DEFAULT_APP_URL);
        Mockito.when((Object)mockApp.getFinalAppStatus()).thenReturn((Object)finalStatus);
        scheduler.shutdown();
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).unregisterApplicationMaster(FinalApplicationStatus.SUCCEEDED, SUCCEED_APP_MESSAGE, DEFAULT_APP_URL);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient)).stop();
    }

    @Test(timeout=5000L)
    public void testTaskSchedulerDetermineMinHeldContainers() throws Exception {
        TezAMRMClientAsync mockRMClient = (TezAMRMClientAsync)Mockito.spy((Object)((Object)new TestTaskSchedulerHelpers.AMRMClientAsyncForTest((AMRMClient<YarnTaskSchedulerService.CookieContainerRequest>)new TestTaskSchedulerHelpers.AMRMClientForTest(), 100)));
        TaskSchedulerContext mockApp = TestTaskSchedulerHelpers.setupMockTaskSchedulerContext(DEFAULT_APP_HOST, 0, DEFAULT_APP_URL, true, new Configuration());
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback = this.createDrainableContext(mockApp);
        TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext scheduler = new TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext(drainableAppCallback, (TezAMRMClientAsync<YarnTaskSchedulerService.CookieContainerRequest>)mockRMClient);
        scheduler.initialize();
        scheduler.start();
        String rack1 = "r1";
        String rack2 = "r2";
        String rack3 = "r3";
        String node1Rack1 = "n1r1";
        String node2Rack1 = "n2r1";
        String node1Rack2 = "n1r2";
        String node2Rack2 = "n2r2";
        String node1Rack3 = "n1r3";
        ApplicationAttemptId appId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)0), (int)0);
        NodeId emptyHost = NodeId.newInstance((String)"", (int)1);
        Resource r = Resource.newInstance((int)0, (int)0);
        ContainerId mockCId1 = ContainerId.newInstance((ApplicationAttemptId)appId, (int)0);
        Container c1 = Container.newInstance((ContainerId)mockCId1, (NodeId)emptyHost, null, (Resource)r, null, null);
        YarnTaskSchedulerService.HeldContainer hc1 = (YarnTaskSchedulerService.HeldContainer)Mockito.spy((Object)new YarnTaskSchedulerService.HeldContainer(c1, 0L, 0L, null, containerSignatureMatcher));
        Mockito.when((Object)hc1.getNode()).thenReturn((Object)node1Rack1);
        Mockito.when((Object)hc1.getRack()).thenReturn((Object)rack1);
        Mockito.when((Object)hc1.getContainer()).thenReturn((Object)c1);
        ContainerId mockCId2 = ContainerId.newInstance((ApplicationAttemptId)appId, (int)1);
        Container c2 = Container.newInstance((ContainerId)mockCId2, (NodeId)emptyHost, null, (Resource)r, null, null);
        YarnTaskSchedulerService.HeldContainer hc2 = (YarnTaskSchedulerService.HeldContainer)Mockito.spy((Object)new YarnTaskSchedulerService.HeldContainer(c2, 0L, 0L, null, containerSignatureMatcher));
        Mockito.when((Object)hc2.getNode()).thenReturn((Object)node2Rack1);
        Mockito.when((Object)hc2.getRack()).thenReturn((Object)rack1);
        Mockito.when((Object)hc2.getContainer()).thenReturn((Object)c2);
        ContainerId mockCId3 = ContainerId.newInstance((ApplicationAttemptId)appId, (int)2);
        Container c3 = Container.newInstance((ContainerId)mockCId3, (NodeId)emptyHost, null, (Resource)r, null, null);
        YarnTaskSchedulerService.HeldContainer hc3 = (YarnTaskSchedulerService.HeldContainer)Mockito.spy((Object)new YarnTaskSchedulerService.HeldContainer(c3, 0L, 0L, null, containerSignatureMatcher));
        Mockito.when((Object)hc3.getNode()).thenReturn((Object)node1Rack1);
        Mockito.when((Object)hc3.getRack()).thenReturn((Object)rack1);
        Mockito.when((Object)hc3.getContainer()).thenReturn((Object)c3);
        ContainerId mockCId4 = ContainerId.newInstance((ApplicationAttemptId)appId, (int)3);
        Container c4 = Container.newInstance((ContainerId)mockCId4, (NodeId)emptyHost, null, (Resource)r, null, null);
        YarnTaskSchedulerService.HeldContainer hc4 = (YarnTaskSchedulerService.HeldContainer)Mockito.spy((Object)new YarnTaskSchedulerService.HeldContainer(c4, 0L, 0L, null, containerSignatureMatcher));
        Mockito.when((Object)hc4.getNode()).thenReturn((Object)node2Rack1);
        Mockito.when((Object)hc4.getRack()).thenReturn((Object)rack1);
        Mockito.when((Object)hc4.getContainer()).thenReturn((Object)c4);
        ContainerId mockCId5 = ContainerId.newInstance((ApplicationAttemptId)appId, (int)4);
        Container c5 = Container.newInstance((ContainerId)mockCId5, (NodeId)emptyHost, null, (Resource)r, null, null);
        YarnTaskSchedulerService.HeldContainer hc5 = (YarnTaskSchedulerService.HeldContainer)Mockito.spy((Object)new YarnTaskSchedulerService.HeldContainer(c5, 0L, 0L, null, containerSignatureMatcher));
        Mockito.when((Object)hc5.getNode()).thenReturn((Object)node1Rack2);
        Mockito.when((Object)hc5.getRack()).thenReturn((Object)rack2);
        Mockito.when((Object)hc5.getContainer()).thenReturn((Object)c5);
        ContainerId mockCId6 = ContainerId.newInstance((ApplicationAttemptId)appId, (int)5);
        Container c6 = Container.newInstance((ContainerId)mockCId6, (NodeId)emptyHost, null, (Resource)r, null, null);
        YarnTaskSchedulerService.HeldContainer hc6 = (YarnTaskSchedulerService.HeldContainer)Mockito.spy((Object)new YarnTaskSchedulerService.HeldContainer(c6, 0L, 0L, null, containerSignatureMatcher));
        Mockito.when((Object)hc6.getNode()).thenReturn((Object)node2Rack2);
        Mockito.when((Object)hc6.getRack()).thenReturn((Object)rack2);
        Mockito.when((Object)hc6.getContainer()).thenReturn((Object)c6);
        ContainerId mockCId7 = ContainerId.newInstance((ApplicationAttemptId)appId, (int)6);
        Container c7 = Container.newInstance((ContainerId)mockCId7, (NodeId)emptyHost, null, (Resource)r, null, null);
        YarnTaskSchedulerService.HeldContainer hc7 = (YarnTaskSchedulerService.HeldContainer)Mockito.spy((Object)new YarnTaskSchedulerService.HeldContainer(c7, 0L, 0L, null, containerSignatureMatcher));
        Mockito.when((Object)hc7.getNode()).thenReturn((Object)node1Rack3);
        Mockito.when((Object)hc7.getRack()).thenReturn((Object)rack3);
        Mockito.when((Object)hc7.getContainer()).thenReturn((Object)c7);
        scheduler.heldContainers.put(mockCId1, hc1);
        scheduler.heldContainers.put(mockCId2, hc2);
        scheduler.heldContainers.put(mockCId3, hc3);
        scheduler.heldContainers.put(mockCId4, hc4);
        scheduler.heldContainers.put(mockCId5, hc5);
        scheduler.heldContainers.put(mockCId6, hc6);
        scheduler.heldContainers.put(mockCId7, hc7);
        scheduler.sessionNumMinHeldContainers = 0;
        scheduler.determineMinHeldContainers();
        Assert.assertEquals((long)0L, (long)scheduler.sessionMinHeldContainers.size());
        scheduler.sessionNumMinHeldContainers = 7;
        scheduler.determineMinHeldContainers();
        Assert.assertEquals((long)7L, (long)scheduler.sessionMinHeldContainers.size());
        scheduler.sessionNumMinHeldContainers = 5;
        scheduler.determineMinHeldContainers();
        Assert.assertEquals((long)5L, (long)scheduler.sessionMinHeldContainers.size());
        HashSet heldContainers = Sets.newHashSet();
        for (ContainerId cId : scheduler.sessionMinHeldContainers) {
            heldContainers.add((YarnTaskSchedulerService.HeldContainer)scheduler.heldContainers.get(cId));
        }
        HashSet racks = Sets.newHashSet();
        HashSet nodes = Sets.newHashSet();
        for (YarnTaskSchedulerService.HeldContainer hc : heldContainers) {
            nodes.add(hc.getNode());
            racks.add(hc.getRack());
        }
        Assert.assertEquals((long)5L, (long)nodes.size());
        Assert.assertTrue((nodes.contains(node1Rack1) && nodes.contains(node2Rack1) && nodes.contains(node1Rack2) && nodes.contains(node2Rack2) && nodes.contains(node1Rack3) ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)racks.size());
        Assert.assertTrue((racks.contains(rack1) && racks.contains(rack2) && racks.contains(rack3) ? 1 : 0) != 0);
        long currTime = System.currentTimeMillis();
        heldContainers.clear();
        heldContainers.addAll(scheduler.heldContainers.values());
        for (YarnTaskSchedulerService.HeldContainer hc : heldContainers) {
            Mockito.when((Object)hc.isNew()).thenReturn((Object)true);
            scheduler.delayedContainerManager.addDelayedContainer(hc.getContainer(), currTime);
        }
        Thread.sleep(1000L);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)2))).releaseAssignedContainer((ContainerId)Mockito.any());
        Assert.assertEquals((long)5L, (long)scheduler.heldContainers.size());
        TaskSchedulerContext.AppFinalStatus finalStatus = new TaskSchedulerContext.AppFinalStatus(FinalApplicationStatus.SUCCEEDED, SUCCEED_APP_MESSAGE, DEFAULT_APP_URL);
        Mockito.when((Object)mockApp.getFinalAppStatus()).thenReturn((Object)finalStatus);
        scheduler.shutdown();
    }

    @Test(timeout=3000L)
    public void testTaskSchedulerHeldContainersReleaseAfterExpired() throws Exception {
        TezAMRMClientAsync mockRMClient = (TezAMRMClientAsync)Mockito.spy((Object)((Object)new TestTaskSchedulerHelpers.AMRMClientAsyncForTest((AMRMClient<YarnTaskSchedulerService.CookieContainerRequest>)new TestTaskSchedulerHelpers.AMRMClientForTest(), 100)));
        TaskSchedulerContext mockApp = TestTaskSchedulerHelpers.setupMockTaskSchedulerContext(DEFAULT_APP_HOST, 0, DEFAULT_APP_URL, true, new Configuration());
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback = this.createDrainableContext(mockApp);
        TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext scheduler = new TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext(drainableAppCallback, (TezAMRMClientAsync<YarnTaskSchedulerService.CookieContainerRequest>)mockRMClient);
        scheduler.initialize();
        scheduler.start();
        Resource mockCapability = Resource.newInstance((int)1024, (int)1);
        NodeId emptyHost = NodeId.newInstance((String)"", (int)1);
        ApplicationAttemptId appId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)0), (int)0);
        ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)appId, (int)0);
        Container c1 = Container.newInstance((ContainerId)containerId, (NodeId)emptyHost, null, (Resource)mockCapability, null, null);
        YarnTaskSchedulerService.HeldContainer hc1 = new YarnTaskSchedulerService.HeldContainer(c1, -1L, -1L, null, containerSignatureMatcher);
        scheduler.heldContainers.put(containerId, hc1);
        long currTime = System.currentTimeMillis();
        scheduler.delayedContainerManager.addDelayedContainer(hc1.getContainer(), currTime);
        Thread.sleep(1000L);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)1))).releaseAssignedContainer((ContainerId)Mockito.any());
        Assert.assertEquals((long)0L, (long)scheduler.heldContainers.size());
        TaskSchedulerContext.AppFinalStatus finalStatus = new TaskSchedulerContext.AppFinalStatus(FinalApplicationStatus.SUCCEEDED, SUCCEED_APP_MESSAGE, DEFAULT_APP_URL);
        Mockito.when((Object)mockApp.getFinalAppStatus()).thenReturn((Object)finalStatus);
        scheduler.shutdown();
    }

    @Test(timeout=5000L)
    public void testTaskSchedulerRandomReuseExpireTime() throws Exception {
        TezAMRMClientAsync mockRMClient = (TezAMRMClientAsync)Mockito.spy((Object)((Object)new TestTaskSchedulerHelpers.AMRMClientAsyncForTest((AMRMClient<YarnTaskSchedulerService.CookieContainerRequest>)new TestTaskSchedulerHelpers.AMRMClientForTest(), 100)));
        long minTime = 1000L;
        long maxTime = 100000L;
        Configuration conf1 = new Configuration();
        conf1.setLong("tez.am.container.idle.release-timeout-min.millis", minTime);
        conf1.setLong("tez.am.container.idle.release-timeout-max.millis", minTime);
        Configuration conf2 = new Configuration();
        conf2.setLong("tez.am.container.idle.release-timeout-min.millis", minTime);
        conf2.setLong("tez.am.container.idle.release-timeout-max.millis", maxTime);
        TaskSchedulerContext mockApp1 = TestTaskSchedulerHelpers.setupMockTaskSchedulerContext(DEFAULT_APP_HOST, 0, DEFAULT_APP_URL, conf1);
        TaskSchedulerContext mockApp2 = TestTaskSchedulerHelpers.setupMockTaskSchedulerContext(DEFAULT_APP_HOST, 0, DEFAULT_APP_URL, conf2);
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback1 = this.createDrainableContext(mockApp1);
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback2 = this.createDrainableContext(mockApp2);
        TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext scheduler1 = new TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext(drainableAppCallback1, (TezAMRMClientAsync<YarnTaskSchedulerService.CookieContainerRequest>)mockRMClient);
        TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext scheduler2 = new TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext(drainableAppCallback2, (TezAMRMClientAsync<YarnTaskSchedulerService.CookieContainerRequest>)mockRMClient);
        scheduler1.initialize();
        scheduler2.initialize();
        scheduler1.start();
        scheduler2.start();
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)minTime, (long)scheduler1.getHeldContainerExpireTime(0L));
        }
        long lastExpireTime = 0L;
        for (int i = 0; i < 10; ++i) {
            long currExpireTime = scheduler2.getHeldContainerExpireTime(0L);
            Assert.assertTrue((String)("min: " + minTime + " curr: " + currExpireTime + " max: " + maxTime), (minTime <= currExpireTime && currExpireTime <= maxTime ? 1 : 0) != 0);
            Assert.assertNotEquals((long)lastExpireTime, (long)currExpireTime);
            lastExpireTime = currExpireTime;
        }
        TaskSchedulerContext.AppFinalStatus finalStatus = new TaskSchedulerContext.AppFinalStatus(FinalApplicationStatus.SUCCEEDED, SUCCEED_APP_MESSAGE, DEFAULT_APP_URL);
        Mockito.when((Object)mockApp1.getFinalAppStatus()).thenReturn((Object)finalStatus);
        Mockito.when((Object)mockApp2.getFinalAppStatus()).thenReturn((Object)finalStatus);
        scheduler1.shutdown();
        scheduler2.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testTaskSchedulerPreemptionWithLowAndHighPriorityRequests() throws Exception {
        TezAMRMClientAsync mockRMClient = (TezAMRMClientAsync)Mockito.spy((Object)((Object)new TestTaskSchedulerHelpers.AMRMClientAsyncForTest((AMRMClient<YarnTaskSchedulerService.CookieContainerRequest>)new TestTaskSchedulerHelpers.AMRMClientForTest(), 100)));
        Configuration conf = new Configuration();
        conf.setInt("tez.am.preemption.percentage", 50);
        TaskSchedulerContext mockApp = TestTaskSchedulerHelpers.setupMockTaskSchedulerContext(DEFAULT_APP_HOST, 0, DEFAULT_APP_URL, false, null, null, new TestTaskSchedulerHelpers.PreemptionMatcher(), conf);
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback = this.createDrainableContext(mockApp);
        TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext scheduler = new TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext(drainableAppCallback, (TezAMRMClientAsync<YarnTaskSchedulerService.CookieContainerRequest>)mockRMClient);
        scheduler.initialize();
        scheduler.start();
        int initialRmCapacity = 4;
        int lowPriorityTasks = 5;
        int highPriorityTasks = 6;
        Resource taskAsk = Resource.newInstance((int)1000, (int)1);
        Resource totalResource = Resource.newInstance((int)4000, (int)4);
        Mockito.when((Object)mockRMClient.getAvailableResources()).thenReturn((Object)totalResource);
        Priority lowPriority = Priority.newInstance((int)74);
        for (int i = 0; i < lowPriorityTasks; ++i) {
            Object low = new Object();
            TaskAttempt ta = (TaskAttempt)Mockito.mock(TaskAttempt.class);
            scheduler.allocateTask(ta, taskAsk, null, null, lowPriority, low, null);
        }
        scheduler.getProgress();
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)5))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)Mockito.any(YarnTaskSchedulerService.CookieContainerRequest.class)));
        ArrayList<Container> lowPriorityContainers = new ArrayList<Container>();
        for (int i = 0; i < initialRmCapacity; ++i) {
            ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1), (long)i);
            NodeId nodeId = NodeId.newInstance((String)("host-" + i), (int)8041);
            Container container = Container.newInstance((ContainerId)containerId, (NodeId)nodeId, (String)("host-" + i), (Resource)taskAsk, (Priority)lowPriority, null);
            lowPriorityContainers.add(container);
        }
        totalResource = Resource.newInstance((int)0, (int)0);
        Mockito.when((Object)mockRMClient.getAvailableResources()).thenReturn((Object)totalResource);
        YarnTaskSchedulerService.DelayedContainerManager i = scheduler.delayedContainerManager;
        synchronized (i) {
            scheduler.onContainersAllocated(lowPriorityContainers);
            drainableAppCallback.drain();
            for (YarnTaskSchedulerService.HeldContainer container : scheduler.delayedContainerManager.delayedContainers) {
                container.setNextScheduleTime(System.currentTimeMillis() + 10000L);
                container.incrementAssignmentAttempts();
                container.incrementAssignmentAttempts();
                container.incrementAssignmentAttempts();
            }
        }
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Mockito.any());
        Priority highPriority = Priority.newInstance((int)71);
        for (int i2 = 0; i2 < highPriorityTasks; ++i2) {
            Object high = new Object();
            TaskAttempt ta = (TaskAttempt)Mockito.mock(TaskAttempt.class);
            scheduler.allocateTask(ta, taskAsk, null, null, highPriority, high, null);
        }
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)11))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)Mockito.any(YarnTaskSchedulerService.CookieContainerRequest.class)));
        scheduler.getProgress();
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)3))).releaseAssignedContainer((ContainerId)Mockito.any());
        scheduler.getProgress();
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)4))).releaseAssignedContainer((ContainerId)Mockito.any());
        TaskSchedulerContext.AppFinalStatus finalStatus = new TaskSchedulerContext.AppFinalStatus(FinalApplicationStatus.SUCCEEDED, "", DEFAULT_APP_URL);
        Mockito.when((Object)mockApp.getFinalAppStatus()).thenReturn((Object)finalStatus);
        scheduler.shutdown();
        drainableAppCallback.drain();
    }

    @Test(timeout=5000L)
    public void testTaskSchedulerPreemption() throws Exception {
        TezAMRMClientAsync mockRMClient = (TezAMRMClientAsync)Mockito.mock(TezAMRMClientAsync.class);
        Configuration conf = new Configuration();
        conf.setBoolean("tez.am.container.reuse.enabled", false);
        conf.setInt("tez.am.preemption.heartbeats-between-preemptions", 3);
        TaskSchedulerContext mockApp = TestTaskSchedulerHelpers.setupMockTaskSchedulerContext(DEFAULT_APP_HOST, 0, DEFAULT_APP_URL, false, null, null, new TestTaskSchedulerHelpers.PreemptionMatcher(), conf);
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback = this.createDrainableContext(mockApp);
        final TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext scheduler = new TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext(drainableAppCallback, (TezAMRMClientAsync<YarnTaskSchedulerService.CookieContainerRequest>)mockRMClient);
        scheduler.initialize();
        RegisterApplicationMasterResponse mockRegResponse = (RegisterApplicationMasterResponse)Mockito.mock(RegisterApplicationMasterResponse.class);
        Mockito.when((Object)mockRMClient.registerApplicationMaster(Mockito.anyString(), Mockito.anyInt(), Mockito.anyString())).thenReturn((Object)mockRegResponse);
        scheduler.start();
        Resource totalResource = Resource.newInstance((int)4000, (int)4);
        Mockito.when((Object)mockRMClient.getAvailableResources()).thenReturn((Object)totalResource);
        scheduler.getProgress();
        drainableAppCallback.drain();
        Assert.assertEquals((Object)totalResource, (Object)scheduler.getTotalResources());
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Mockito.any());
        MockTask mockTask1 = new MockTask("task1");
        MockTask mockTask2 = new MockTask("task2");
        MockTask mockTask3 = new MockTask("task3");
        MockTask mockTask3Wait = new MockTask("task3Wait");
        MockTask mockTask3Retry = new MockTask("task3Retry");
        MockTask mockTask3KillA = new MockTask("task3KillA");
        MockTask mockTask3KillB = new MockTask("task3KillB");
        MockTask mockTaskPri8 = new MockTask("taskPri8");
        Object obj3 = new Object();
        Priority pri2 = Priority.newInstance((int)2);
        Priority pri4 = Priority.newInstance((int)4);
        Priority pri5 = Priority.newInstance((int)5);
        Priority pri6 = Priority.newInstance((int)6);
        Priority pri8 = Priority.newInstance((int)8);
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(YarnTaskSchedulerService.CookieContainerRequest.class);
        final ArrayList<YarnTaskSchedulerService.CookieContainerRequest> anyContainers = new ArrayList<YarnTaskSchedulerService.CookieContainerRequest>();
        Resource taskAsk = Resource.newInstance((int)1024, (int)1);
        scheduler.allocateTask(mockTask1, taskAsk, null, null, pri2, null, null);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)1))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.capture()));
        anyContainers.add((YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.getValue());
        scheduler.allocateTask(mockTask3, taskAsk, null, null, pri6, obj3, null);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)2))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.capture()));
        anyContainers.add((YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.getValue());
        scheduler.allocateTask(mockTask3KillA, taskAsk, null, null, pri6, obj3, null);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)3))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.capture()));
        anyContainers.add((YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.getValue());
        scheduler.allocateTask(mockTask3KillB, taskAsk, null, null, pri6, obj3, null);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)4))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.capture()));
        anyContainers.add((YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.getValue());
        Resource freeResource = Resource.newInstance((int)500, (int)0);
        Mockito.when((Object)mockRMClient.getAvailableResources()).thenReturn((Object)freeResource);
        scheduler.getProgress();
        drainableAppCallback.drain();
        Assert.assertEquals((Object)totalResource, (Object)scheduler.getTotalResources());
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Mockito.any());
        final LinkedList<ArrayList<YarnTaskSchedulerService.CookieContainerRequest>> anyList = new LinkedList<ArrayList<YarnTaskSchedulerService.CookieContainerRequest>>();
        final LinkedList emptyList = new LinkedList();
        anyList.add(anyContainers);
        NodeId host1 = NodeId.newInstance((String)"host1", (int)1);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1);
        ContainerId mockCId1 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L);
        Container mockContainer1 = Container.newInstance((ContainerId)mockCId1, (NodeId)host1, null, (Resource)taskAsk, (Priority)pri2, null);
        ContainerId mockCId2 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)2L);
        Container mockContainer2 = Container.newInstance((ContainerId)mockCId2, (NodeId)host1, null, (Resource)taskAsk, (Priority)pri6, null);
        ContainerId mockCId3 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)3L);
        Container mockContainer3 = Container.newInstance((ContainerId)mockCId3, (NodeId)host1, null, (Resource)taskAsk, (Priority)pri6, null);
        ContainerId mockCId4 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)4L);
        Container mockContainer4 = Container.newInstance((ContainerId)mockCId4, (NodeId)host1, null, (Resource)taskAsk, (Priority)pri2, null);
        ArrayList<Container> containers = new ArrayList<Container>();
        containers.add(mockContainer1);
        containers.add(mockContainer2);
        containers.add(mockContainer3);
        containers.add(mockContainer4);
        Mockito.when((Object)mockRMClient.getMatchingRequests((Priority)Mockito.any(), (String)Mockito.eq((Object)"host1"), (Resource)Mockito.any())).thenAnswer((Answer)new Answer<List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>>>(){

            public List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>> answer(InvocationOnMock invocation) throws Throwable {
                return emptyList;
            }
        });
        Mockito.when((Object)mockRMClient.getMatchingRequests((Priority)Mockito.any(), (String)Mockito.eq((Object)"/default-rack"), (Resource)Mockito.any())).thenAnswer((Answer)new Answer<List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>>>(){

            public List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>> answer(InvocationOnMock invocation) throws Throwable {
                return emptyList;
            }
        });
        Mockito.when((Object)mockRMClient.getMatchingRequests((Priority)Mockito.any(), (String)Mockito.eq((Object)"*"), (Resource)Mockito.any())).thenAnswer((Answer)new Answer<List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>>>(){
            int calls = 0;

            public List<? extends Collection<YarnTaskSchedulerService.CookieContainerRequest>> answer(InvocationOnMock invocation) throws Throwable {
                if (this.calls > 0) {
                    anyContainers.remove(0);
                }
                ++this.calls;
                return anyList;
            }
        });
        ((TaskSchedulerContext)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                ContainerId cId = (ContainerId)args[0];
                scheduler.deallocateContainer(cId);
                return null;
            }
        }).when((Object)mockApp)).preemptContainer((ContainerId)Mockito.any());
        scheduler.onContainersAllocated(containers);
        drainableAppCallback.drain();
        Assert.assertEquals((long)4L, (long)scheduler.taskAllocations.size());
        Assert.assertEquals((long)4096L, (long)scheduler.allocatedResources.getMemory());
        Assert.assertEquals((Object)mockCId1, (Object)((Container)scheduler.taskAllocations.get(mockTask1)).getId());
        Assert.assertEquals((Object)mockCId2, (Object)((Container)scheduler.taskAllocations.get(mockTask3)).getId());
        Assert.assertEquals((Object)mockCId3, (Object)((Container)scheduler.taskAllocations.get(mockTask3KillA)).getId());
        Assert.assertEquals((Object)mockCId4, (Object)((Container)scheduler.taskAllocations.get(mockTask3KillB)).getId());
        scheduler.getProgress();
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Mockito.any());
        Assert.assertEquals((long)scheduler.numHeartbeats, (long)scheduler.heartbeatAtLastPreemption);
        Object mockTask3WaitCookie = new Object();
        scheduler.allocateTask(mockTask3Wait, taskAsk, null, null, pri6, obj3, mockTask3WaitCookie);
        Object mockTaskPri8Cookie = new Object();
        scheduler.allocateTask(mockTaskPri8, taskAsk, null, null, pri8, obj3, mockTaskPri8Cookie);
        scheduler.getProgress();
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)6))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.capture()));
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Mockito.any());
        ContainerId mockCId5 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)5L);
        Container mockContainer5 = Container.newInstance((ContainerId)mockCId5, (NodeId)host1, null, (Resource)taskAsk, (Priority)pri8, null);
        containers.clear();
        containers.add(mockContainer5);
        YarnTaskSchedulerService.HeldContainer heldContainer = new YarnTaskSchedulerService.HeldContainer(mockContainer5, -1L, -1L, null, containerSignatureMatcher);
        scheduler.delayedContainerManager.delayedContainers.add(heldContainer);
        scheduler.getProgress();
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Mockito.any());
        Assert.assertEquals((long)scheduler.numHeartbeats, (long)scheduler.heartbeatAtLastPreemption);
        heldContainer.incrementAssignmentAttempts();
        scheduler.getProgress();
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Mockito.any());
        heldContainer.incrementAssignmentAttempts();
        heldContainer.incrementAssignmentAttempts();
        scheduler.getProgress();
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)1))).releaseAssignedContainer((ContainerId)Mockito.any());
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)1))).releaseAssignedContainer(mockCId5);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)7))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.capture()));
        YarnTaskSchedulerService.CookieContainerRequest reAdded = (YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.getValue();
        Assert.assertEquals((Object)pri8, (Object)reAdded.getPriority());
        Assert.assertEquals((Object)taskAsk, (Object)reAdded.getCapability());
        Assert.assertEquals((Object)mockTaskPri8Cookie, (Object)reAdded.getCookie().getAppCookie());
        scheduler.delayedContainerManager.delayedContainers.clear();
        Assert.assertEquals((long)scheduler.numHeartbeats, (long)scheduler.heartbeatAtLastPreemption);
        scheduler.allocateTask(mockTask3Retry, taskAsk, null, null, pri5, obj3, null);
        scheduler.getProgress();
        drainableAppCallback.drain();
        Assert.assertEquals((long)scheduler.numHeartbeats, (long)scheduler.heartbeatAtLastPreemption);
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)1))).releaseAssignedContainer((ContainerId)Mockito.any());
        for (int i = 0; i < 11; ++i) {
            scheduler.allocateTask(mockTask2, taskAsk, null, null, pri4, null, null);
        }
        drainableAppCallback.drain();
        scheduler.getProgress();
        Assert.assertTrue((scheduler.numHeartbeats > scheduler.heartbeatAtLastPreemption ? 1 : 0) != 0);
        drainableAppCallback.drain();
        scheduler.getProgress();
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)1))).releaseAssignedContainer((ContainerId)Mockito.any());
        scheduler.getProgress();
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)2))).releaseAssignedContainer((ContainerId)Mockito.any());
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)1))).releaseAssignedContainer(mockCId4);
        Assert.assertEquals((long)scheduler.numHeartbeats, (long)scheduler.heartbeatAtLastPreemption);
        scheduler.getProgress();
        scheduler.getProgress();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)2))).releaseAssignedContainer((ContainerId)Mockito.any());
        scheduler.getProgress();
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)3))).releaseAssignedContainer((ContainerId)Mockito.any());
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)1))).releaseAssignedContainer(mockCId3);
        TaskSchedulerContext.AppFinalStatus finalStatus = new TaskSchedulerContext.AppFinalStatus(FinalApplicationStatus.SUCCEEDED, "", DEFAULT_APP_URL);
        Mockito.when((Object)mockApp.getFinalAppStatus()).thenReturn((Object)finalStatus);
        scheduler.shutdown();
        drainableAppCallback.drain();
    }

    @Test(timeout=5000L)
    public void testTaskSchedulerPreemption2() throws Exception {
        TezAMRMClientAsync mockRMClient = (TezAMRMClientAsync)Mockito.spy((Object)((Object)new TestTaskSchedulerHelpers.AMRMClientAsyncForTest((AMRMClient<YarnTaskSchedulerService.CookieContainerRequest>)new TestTaskSchedulerHelpers.AMRMClientForTest(), 100)));
        int waitTime = 1000;
        Configuration conf = new Configuration();
        conf.setBoolean("tez.am.container.reuse.enabled", false);
        conf.setInt("tez.am.preemption.heartbeats-between-preemptions", 2);
        conf.setInt("tez.am.preemption.max.wait-time-ms", waitTime);
        TaskSchedulerContext mockApp = TestTaskSchedulerHelpers.setupMockTaskSchedulerContext(DEFAULT_APP_HOST, 0, DEFAULT_APP_URL, false, null, null, new TestTaskSchedulerHelpers.PreemptionMatcher(), conf);
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback = this.createDrainableContext(mockApp);
        final TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext scheduler = new TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext(drainableAppCallback, (TezAMRMClientAsync<YarnTaskSchedulerService.CookieContainerRequest>)mockRMClient);
        scheduler.initialize();
        scheduler.start();
        scheduler.getProgress();
        drainableAppCallback.drain();
        Resource totalResource = mockRMClient.getAvailableResources();
        Assert.assertEquals((Object)totalResource, (Object)scheduler.getTotalResources());
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Mockito.any());
        MockTask mockTask1 = new MockTask("task1");
        MockTask mockTask2 = new MockTask("task2");
        MockTask mockTask3 = new MockTask("task3");
        Object obj3 = new Object();
        Priority pri2 = Priority.newInstance((int)2);
        Priority pri4 = Priority.newInstance((int)4);
        Priority pri6 = Priority.newInstance((int)6);
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(YarnTaskSchedulerService.CookieContainerRequest.class);
        ArrayList<YarnTaskSchedulerService.CookieContainerRequest> anyContainers = new ArrayList<YarnTaskSchedulerService.CookieContainerRequest>();
        Resource taskAsk = Resource.newInstance((int)1024, (int)1);
        scheduler.allocateTask(mockTask1, taskAsk, null, null, pri4, null, null);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)1))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.capture()));
        anyContainers.add((YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.getValue());
        scheduler.getProgress();
        drainableAppCallback.drain();
        Assert.assertEquals((Object)totalResource, (Object)scheduler.getTotalResources());
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Mockito.any());
        NodeId host1 = NodeId.newInstance((String)"host1", (int)1);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1);
        ContainerId mockCId1 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L);
        Container mockContainer1 = Container.newInstance((ContainerId)mockCId1, (NodeId)host1, null, (Resource)taskAsk, (Priority)pri4, null);
        ArrayList<Container> containers = new ArrayList<Container>();
        containers.add(mockContainer1);
        ((TaskSchedulerContext)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                ContainerId cId = (ContainerId)args[0];
                scheduler.deallocateContainer(cId);
                return null;
            }
        }).when((Object)mockApp)).preemptContainer((ContainerId)Mockito.any());
        scheduler.onContainersAllocated(containers);
        drainableAppCallback.drain();
        Assert.assertEquals((long)1L, (long)scheduler.taskAllocations.size());
        Assert.assertEquals((Object)mockCId1, (Object)((Container)scheduler.taskAllocations.get(mockTask1)).getId());
        scheduler.getProgress();
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Mockito.any());
        Assert.assertEquals((long)scheduler.numHeartbeats, (long)scheduler.heartbeatAtLastPreemption);
        Object mockTask2Cookie = new Object();
        scheduler.allocateTask(mockTask2, taskAsk, null, null, pri2, obj3, mockTask2Cookie);
        Object mockTask3Cookie = new Object();
        scheduler.allocateTask(mockTask3, taskAsk, null, null, pri6, obj3, mockTask3Cookie);
        Assert.assertNull((Object)scheduler.highestWaitingRequestPriority);
        Assert.assertEquals((long)0L, (long)scheduler.highestWaitingRequestWaitStartTime);
        long currTime = System.currentTimeMillis();
        scheduler.getProgress();
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Mockito.any());
        Assert.assertEquals((Object)pri2, (Object)scheduler.highestWaitingRequestPriority);
        Assert.assertTrue((scheduler.highestWaitingRequestWaitStartTime >= currTime ? 1 : 0) != 0);
        Assert.assertEquals((long)scheduler.numHeartbeats, (long)scheduler.heartbeatAtLastPreemption);
        Thread.sleep(waitTime + 10);
        long oldStartWaitTime = scheduler.highestWaitingRequestWaitStartTime;
        scheduler.getProgress();
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)0))).releaseAssignedContainer((ContainerId)Mockito.any());
        Assert.assertEquals((Object)pri2, (Object)scheduler.highestWaitingRequestPriority);
        Assert.assertEquals((long)oldStartWaitTime, (long)scheduler.highestWaitingRequestWaitStartTime);
        Assert.assertTrue((scheduler.numHeartbeats > scheduler.heartbeatAtLastPreemption ? 1 : 0) != 0);
        scheduler.getProgress();
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)1))).releaseAssignedContainer((ContainerId)Mockito.any());
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)1))).releaseAssignedContainer(mockCId1);
        Assert.assertEquals((long)scheduler.numHeartbeats, (long)scheduler.heartbeatAtLastPreemption);
        Assert.assertEquals((Object)pri2, (Object)scheduler.highestWaitingRequestPriority);
        Assert.assertEquals((long)oldStartWaitTime, (long)scheduler.highestWaitingRequestWaitStartTime);
        scheduler.deallocateTask(mockTask2, false, null, null);
        scheduler.getProgress();
        Assert.assertEquals((Object)pri6, (Object)scheduler.highestWaitingRequestPriority);
        Assert.assertTrue((oldStartWaitTime < scheduler.highestWaitingRequestWaitStartTime ? 1 : 0) != 0);
        Thread.sleep(waitTime + 10);
        scheduler.getProgress();
        drainableAppCallback.drain();
        Assert.assertNull((Object)scheduler.highestWaitingRequestPriority);
        Assert.assertEquals((long)0L, (long)scheduler.highestWaitingRequestWaitStartTime);
        scheduler.getProgress();
        drainableAppCallback.drain();
        Assert.assertEquals((Object)pri6, (Object)scheduler.highestWaitingRequestPriority);
        Assert.assertTrue((oldStartWaitTime < scheduler.highestWaitingRequestWaitStartTime ? 1 : 0) != 0);
        TaskSchedulerContext.AppFinalStatus finalStatus = new TaskSchedulerContext.AppFinalStatus(FinalApplicationStatus.SUCCEEDED, "", DEFAULT_APP_URL);
        Mockito.when((Object)mockApp.getFinalAppStatus()).thenReturn((Object)finalStatus);
        scheduler.shutdown();
        drainableAppCallback.drain();
    }

    @Test(timeout=5000L)
    public void testLocalityMatching() throws Exception {
        TezAMRMClientAsync amrmClient = (TezAMRMClientAsync)Mockito.spy((Object)((Object)new TestTaskSchedulerHelpers.AMRMClientAsyncForTest((AMRMClient<YarnTaskSchedulerService.CookieContainerRequest>)new TestTaskSchedulerHelpers.AMRMClientForTest(), 100)));
        Configuration conf = new Configuration();
        conf.setBoolean("tez.am.container.reuse.enabled", false);
        TaskSchedulerContext appClient = TestTaskSchedulerHelpers.setupMockTaskSchedulerContext(DEFAULT_APP_HOST, 0, "", conf);
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback = this.createDrainableContext(appClient);
        TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext taskScheduler = new TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext(drainableAppCallback, (TezAMRMClientAsync<YarnTaskSchedulerService.CookieContainerRequest>)amrmClient);
        taskScheduler.initialize();
        taskScheduler.start();
        Resource resource = Resource.newInstance((int)1024, (int)1);
        Priority priority = Priority.newInstance((int)1);
        String[] hostsTask1 = new String[]{"host1"};
        String[] hostsTask2 = new String[]{"non-allocated-host"};
        String[] defaultRack = new String[]{"/default-rack"};
        String[] otherRack = new String[]{"/other-rack"};
        MockTask mockTask1 = new MockTask("task1");
        YarnTaskSchedulerService.CookieContainerRequest mockCookie1 = (YarnTaskSchedulerService.CookieContainerRequest)Mockito.mock(YarnTaskSchedulerService.CookieContainerRequest.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockCookie1.getCookie().getTask()).thenReturn((Object)mockTask1);
        MockTask mockTask2 = new MockTask("task2");
        YarnTaskSchedulerService.CookieContainerRequest mockCookie2 = (YarnTaskSchedulerService.CookieContainerRequest)Mockito.mock(YarnTaskSchedulerService.CookieContainerRequest.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockCookie2.getCookie().getTask()).thenReturn((Object)mockTask2);
        Container containerHost1 = this.createContainer(1, "host1", resource, priority);
        Container containerHost3 = this.createContainer(2, "host3", resource, priority);
        LinkedList<Container> allocatedContainers = new LinkedList<Container>();
        allocatedContainers.add(containerHost3);
        allocatedContainers.add(containerHost1);
        taskScheduler.allocateTask(mockTask1, resource, hostsTask1, defaultRack, priority, null, mockCookie1);
        drainableAppCallback.drain();
        ArrayList<YarnTaskSchedulerService.CookieContainerRequest> host1List = new ArrayList<YarnTaskSchedulerService.CookieContainerRequest>();
        host1List.add(mockCookie1);
        ArrayList<YarnTaskSchedulerService.CookieContainerRequest> defaultRackList = new ArrayList<YarnTaskSchedulerService.CookieContainerRequest>();
        defaultRackList.add(mockCookie1);
        ArrayList<YarnTaskSchedulerService.CookieContainerRequest> nonAllocatedHostList = new ArrayList<YarnTaskSchedulerService.CookieContainerRequest>();
        nonAllocatedHostList.add(mockCookie2);
        ArrayList<YarnTaskSchedulerService.CookieContainerRequest> otherRackList = new ArrayList<YarnTaskSchedulerService.CookieContainerRequest>();
        otherRackList.add(mockCookie2);
        taskScheduler.allocateTask(mockTask2, resource, hostsTask2, otherRack, priority, null, mockCookie2);
        drainableAppCallback.drain();
        LinkedList<YarnTaskSchedulerService.CookieContainerRequest> anyList = new LinkedList<YarnTaskSchedulerService.CookieContainerRequest>();
        anyList.add(mockCookie1);
        anyList.add(mockCookie2);
        taskScheduler.onContainersAllocated(allocatedContainers);
        drainableAppCallback.drain();
        ArgumentCaptor taskCaptor = ArgumentCaptor.forClass(Object.class);
        ArgumentCaptor containerCaptor = ArgumentCaptor.forClass(Container.class);
        ((TaskSchedulerContext)Mockito.verify((Object)appClient, (VerificationMode)Mockito.times((int)2))).taskAllocated(taskCaptor.capture(), Mockito.any(), (Container)containerCaptor.capture());
        List assignedContainers = containerCaptor.getAllValues();
        int container1Pos = assignedContainers.indexOf(containerHost1);
        Assert.assertTrue((String)("Container: " + containerHost1 + " was not assigned"), (container1Pos != -1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Task 1 was not allocated to containerHost1", (Object)mockTask1, taskCaptor.getAllValues().get(container1Pos));
        int container2Pos = assignedContainers.indexOf(containerHost3);
        Assert.assertTrue((String)("Container: " + containerHost3 + " was not assigned"), (container2Pos != -1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Task 2 was not allocated to containerHost3", (Object)mockTask2, taskCaptor.getAllValues().get(container2Pos));
        TaskSchedulerContext.AppFinalStatus finalStatus = new TaskSchedulerContext.AppFinalStatus(FinalApplicationStatus.SUCCEEDED, "", "");
        Mockito.when((Object)appClient.getFinalAppStatus()).thenReturn((Object)finalStatus);
        taskScheduler.shutdown();
    }

    @Test(timeout=5000L)
    public void testScaleDownPercentage() {
        Assert.assertEquals((long)100L, (long)YarnTaskSchedulerService.scaleDownByPreemptionPercentage((int)100, (int)100));
        Assert.assertEquals((long)70L, (long)YarnTaskSchedulerService.scaleDownByPreemptionPercentage((int)100, (int)70));
        Assert.assertEquals((long)50L, (long)YarnTaskSchedulerService.scaleDownByPreemptionPercentage((int)100, (int)50));
        Assert.assertEquals((long)10L, (long)YarnTaskSchedulerService.scaleDownByPreemptionPercentage((int)100, (int)10));
        Assert.assertEquals((long)5L, (long)YarnTaskSchedulerService.scaleDownByPreemptionPercentage((int)100, (int)5));
        Assert.assertEquals((long)1L, (long)YarnTaskSchedulerService.scaleDownByPreemptionPercentage((int)100, (int)1));
        Assert.assertEquals((long)1L, (long)YarnTaskSchedulerService.scaleDownByPreemptionPercentage((int)5, (int)5));
        Assert.assertEquals((long)1L, (long)YarnTaskSchedulerService.scaleDownByPreemptionPercentage((int)1, (int)10));
        Assert.assertEquals((long)1L, (long)YarnTaskSchedulerService.scaleDownByPreemptionPercentage((int)1, (int)70));
        Assert.assertEquals((long)1L, (long)YarnTaskSchedulerService.scaleDownByPreemptionPercentage((int)1, (int)1));
    }

    @Test
    public void testContainerExpired() throws Exception {
        TezAMRMClientAsync mockRMClient = (TezAMRMClientAsync)Mockito.spy((Object)((Object)new TestTaskSchedulerHelpers.AMRMClientAsyncForTest((AMRMClient<YarnTaskSchedulerService.CookieContainerRequest>)new TestTaskSchedulerHelpers.AMRMClientForTest(), 100)));
        Configuration conf = new Configuration();
        conf.setLong("tez.am.container.reuse.locality.delay-allocation-millis", 0L);
        conf.setLong("tez.am.container.idle.release-timeout-min.millis", 0L);
        conf.setLong("tez.am.container.idle.release-timeout-max.millis", 0L);
        TaskSchedulerContext mockApp = TestTaskSchedulerHelpers.setupMockTaskSchedulerContext(DEFAULT_APP_HOST, 0, DEFAULT_APP_URL, conf);
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback = this.createDrainableContext(mockApp);
        TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext scheduler = new TestTaskSchedulerHelpers.TaskSchedulerWithDrainableContext(drainableAppCallback, (TezAMRMClientAsync<YarnTaskSchedulerService.CookieContainerRequest>)mockRMClient);
        scheduler.initialize();
        scheduler.start();
        drainableAppCallback.drain();
        MockTask mockTask1 = new MockTask("task1");
        Object mockCookie1 = new Object();
        Resource mockCapability = Resource.newInstance((int)1024, (int)1);
        String[] hosts = new String[]{"host1", "host5"};
        String[] racks = new String[]{"/default-rack", "/default-rack"};
        Priority mockPriority1 = Priority.newInstance((int)1);
        Priority mockPriority2 = Priority.newInstance((int)2);
        MockTask mockTask2 = new MockTask("task2");
        Object mockCookie2 = new Object();
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(YarnTaskSchedulerService.CookieContainerRequest.class);
        scheduler.allocateTask(mockTask2, mockCapability, hosts, racks, mockPriority2, null, mockCookie2);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)1))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.capture()));
        YarnTaskSchedulerService.CookieContainerRequest request2 = (YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.getValue();
        scheduler.allocateTask(mockTask1, mockCapability, hosts, racks, mockPriority1, null, mockCookie1);
        drainableAppCallback.drain();
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)2))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.capture()));
        ArrayList<Container> containers = new ArrayList<Container>();
        NodeId host2 = NodeId.newInstance((String)"host2", (int)2);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1);
        ContainerId mockCId2 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)2L);
        Container mockContainer2 = Container.newInstance((ContainerId)mockCId2, (NodeId)host2, null, (Resource)mockCapability, (Priority)mockPriority2, null);
        containers.add(mockContainer2);
        scheduler.onContainersAllocated(containers);
        ArrayList<ContainerStatus> statuses = new ArrayList<ContainerStatus>();
        ContainerStatus mockStatus2 = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        Mockito.when((Object)mockStatus2.getContainerId()).thenReturn((Object)mockCId2);
        statuses.add(mockStatus2);
        scheduler.onContainersCompleted(statuses);
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)0))).taskAllocated(Mockito.any(), Mockito.any(), (Container)Mockito.any());
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)3))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.capture()));
        YarnTaskSchedulerService.CookieContainerRequest resubmitRequest = (YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.getValue();
        Assert.assertEquals((Object)request2.getCookie().getTask(), (Object)resubmitRequest.getCookie().getTask());
        Assert.assertEquals((Object)request2.getCookie().getAppCookie(), (Object)resubmitRequest.getCookie().getAppCookie());
        Assert.assertEquals((Object)request2.getCookie().getContainerSignature(), (Object)resubmitRequest.getCookie().getContainerSignature());
        Assert.assertEquals((Object)request2.getCapability(), (Object)resubmitRequest.getCapability());
        Assert.assertEquals((Object)request2.getPriority(), (Object)resubmitRequest.getPriority());
        Assert.assertFalse((boolean)scheduler.deallocateTask(mockTask2, true, null, null));
        scheduler.onContainersAllocated(containers);
        scheduler.onContainersCompleted(statuses);
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)0))).taskAllocated(Mockito.any(), Mockito.any(), (Container)Mockito.any());
        ((TezAMRMClientAsync)Mockito.verify((Object)mockRMClient, (VerificationMode)Mockito.times((int)3))).addContainerRequest((AMRMClient.ContainerRequest)((YarnTaskSchedulerService.CookieContainerRequest)requestCaptor.capture()));
    }

    private Container createContainer(int id, String host, Resource resource, Priority priority) {
        ContainerId containerID = ContainerId.newInstance((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1), (int)id);
        NodeId nodeID = NodeId.newInstance((String)host, (int)0);
        Container container = Container.newInstance((ContainerId)containerID, (NodeId)nodeID, (String)(host + ":0"), (Resource)resource, (Priority)priority, null);
        return container;
    }

    static class MockTask {
        final String name;

        MockTask(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

