/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm;

import java.util.BitSet;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.app.rm.LocalTaskSchedulerService;
import org.apache.tez.dag.app.rm.TestTaskSchedulerHelpers;
import org.apache.tez.serviceplugins.api.DagInfo;
import org.apache.tez.serviceplugins.api.TaskSchedulerContext;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestLocalTaskSchedulerService {
    LocalTaskSchedulerService ltss;
    int core = 10;

    @Test(timeout=5000L)
    public void testCreateResource() {
        long value = 0x400000L;
        Resource resource = LocalTaskSchedulerService.createResource((long)value, (int)this.core);
        Assert.assertEquals((long)((int)(value / 0x100000L)), (long)resource.getMemory());
    }

    @Test(timeout=5000L)
    public void testCreateResourceLargerThanIntMax() {
        try {
            LocalTaskSchedulerService.createResource((long)Long.MAX_VALUE, (int)this.core);
            Assert.fail((String)"No exception thrown.");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof IllegalArgumentException));
            Assert.assertTrue((boolean)ex.getMessage().contains("Out of range:"));
        }
    }

    @Test(timeout=5000L)
    public void testCreateResourceWithNegativeValue() {
        try {
            LocalTaskSchedulerService.createResource((long)-1048576L, (int)this.core);
            Assert.fail((String)"No exception thrown.");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof IllegalArgumentException));
            Assert.assertTrue((boolean)ex.getMessage().contains("Negative Memory or Core provided!"));
        }
    }

    @Test(timeout=5000L)
    public void testDeallocationBeforeAllocation() throws InterruptedException {
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)10000L, (int)1), (int)1);
        TaskSchedulerContext mockContext = TestTaskSchedulerHelpers.setupMockTaskSchedulerContext("", 0, "", false, appAttemptId, 10000L, null, new Configuration());
        MockLocalTaskSchedulerSerivce taskSchedulerService = new MockLocalTaskSchedulerSerivce(mockContext);
        taskSchedulerService.initialize();
        taskSchedulerService.start();
        Task dummy_task = (Task)Mockito.mock(Task.class);
        taskSchedulerService.allocateTask(dummy_task, Resource.newInstance((int)1024, (int)1), null, null, Priority.newInstance((int)1), null, null);
        Task task = (Task)Mockito.mock(Task.class);
        taskSchedulerService.allocateTask(task, Resource.newInstance((int)1024, (int)1), null, null, Priority.newInstance((int)1), null, null);
        taskSchedulerService.deallocateTask(task, false, null, null);
        taskSchedulerService.startRequestHandlerThread();
        MockLocalTaskSchedulerSerivce.MockAsyncDelegateRequestHandler requestHandler = taskSchedulerService.getRequestHandler();
        requestHandler.drainRequest(3);
        Assert.assertEquals((long)1L, (long)requestHandler.deallocateCount);
        Assert.assertEquals((long)1L, (long)requestHandler.allocateCount);
        taskSchedulerService.shutdown();
    }

    @Test(timeout=5000L)
    public void testDeallocationAfterAllocation() throws InterruptedException {
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)10000L, (int)1), (int)1);
        TaskSchedulerContext mockContext = TestTaskSchedulerHelpers.setupMockTaskSchedulerContext("", 0, "", false, appAttemptId, 10000L, null, new Configuration());
        MockLocalTaskSchedulerSerivce taskSchedulerService = new MockLocalTaskSchedulerSerivce(mockContext);
        taskSchedulerService.initialize();
        taskSchedulerService.start();
        Task task = (Task)Mockito.mock(Task.class);
        taskSchedulerService.allocateTask(task, Resource.newInstance((int)1024, (int)1), null, null, Priority.newInstance((int)1), null, null);
        taskSchedulerService.startRequestHandlerThread();
        MockLocalTaskSchedulerSerivce.MockAsyncDelegateRequestHandler requestHandler = taskSchedulerService.getRequestHandler();
        requestHandler.drainRequest(1);
        taskSchedulerService.deallocateTask(task, false, null, null);
        requestHandler.drainRequest(2);
        Assert.assertEquals((long)1L, (long)requestHandler.deallocateCount);
        Assert.assertEquals((long)1L, (long)requestHandler.allocateCount);
        taskSchedulerService.shutdown();
    }

    @Test
    public void preemptDescendantsOnly() {
        int MAX_TASKS = 2;
        TezConfiguration tezConf = new TezConfiguration();
        tezConf.setInt("tez.am.inline.task.execution.max-tasks", 2);
        ApplicationId appId = ApplicationId.newInstance((long)2000L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        Long parentTask1 = new Long(1L);
        Long parentTask2 = new Long(2L);
        Long childTask1 = new Long(3L);
        Long grandchildTask1 = new Long(4L);
        TaskSchedulerContext mockContext = TestTaskSchedulerHelpers.setupMockTaskSchedulerContext("", 0, "", true, appAttemptId, 1000L, null, (Configuration)tezConf);
        Mockito.when((Object)mockContext.getVertexIndexForTask((Object)parentTask1)).thenReturn((Object)0);
        Mockito.when((Object)mockContext.getVertexIndexForTask((Object)parentTask2)).thenReturn((Object)0);
        Mockito.when((Object)mockContext.getVertexIndexForTask((Object)childTask1)).thenReturn((Object)1);
        Mockito.when((Object)mockContext.getVertexIndexForTask((Object)grandchildTask1)).thenReturn((Object)2);
        DagInfo mockDagInfo = (DagInfo)Mockito.mock(DagInfo.class);
        Mockito.when((Object)mockDagInfo.getTotalVertices()).thenReturn((Object)3);
        BitSet vertex1Descendants = new BitSet();
        vertex1Descendants.set(1);
        vertex1Descendants.set(2);
        BitSet vertex2Descendants = new BitSet();
        vertex2Descendants.set(2);
        BitSet vertex3Descendants = new BitSet();
        Mockito.when((Object)mockDagInfo.getVertexDescendants(0)).thenReturn((Object)vertex1Descendants);
        Mockito.when((Object)mockDagInfo.getVertexDescendants(1)).thenReturn((Object)vertex2Descendants);
        Mockito.when((Object)mockDagInfo.getVertexDescendants(2)).thenReturn((Object)vertex3Descendants);
        Mockito.when((Object)mockContext.getCurrentDagInfo()).thenReturn((Object)mockDagInfo);
        Priority priority1 = Priority.newInstance((int)1);
        Priority priority2 = Priority.newInstance((int)2);
        Priority priority3 = Priority.newInstance((int)3);
        Priority priority4 = Priority.newInstance((int)4);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        final MockLocalTaskSchedulerSerivce taskSchedulerService = new MockLocalTaskSchedulerSerivce(mockContext);
        Answer<Void> answer = new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                ContainerId containerId = (ContainerId)invocation.getArgument(0, ContainerId.class);
                taskSchedulerService.deallocateContainer(containerId);
                return null;
            }
        };
        ((TaskSchedulerContext)Mockito.doAnswer((Answer)answer).when((Object)mockContext)).preemptContainer((ContainerId)Mockito.any());
        taskSchedulerService.initialize();
        taskSchedulerService.start();
        taskSchedulerService.startRequestHandlerThread();
        MockLocalTaskSchedulerSerivce.MockAsyncDelegateRequestHandler requestHandler = taskSchedulerService.getRequestHandler();
        taskSchedulerService.allocateTask(parentTask1, resource, null, null, priority1, null, null);
        taskSchedulerService.allocateTask(childTask1, resource, null, null, priority3, null, null);
        taskSchedulerService.allocateTask(grandchildTask1, resource, null, null, priority4, null, null);
        requestHandler.drainRequest(3);
        Assert.assertEquals((String)"Wrong number of allocate tasks", (long)2L, (long)requestHandler.allocateCount);
        Assert.assertTrue((String)"Another allocation should not fit", (!requestHandler.shouldProcess() ? 1 : 0) != 0);
        taskSchedulerService.allocateTask(parentTask2, Resource.newInstance((int)1024, (int)1), null, null, priority2, null, null);
        requestHandler.drainRequest(5);
        Assert.assertEquals((String)"Wrong number of preempted tasks", (long)1L, (long)requestHandler.preemptCount);
    }

    static class MockLocalTaskSchedulerSerivce
    extends LocalTaskSchedulerService {
        private MockAsyncDelegateRequestHandler requestHandler;

        public MockLocalTaskSchedulerSerivce(TaskSchedulerContext appClient) {
            super(appClient);
        }

        public LocalTaskSchedulerService.AsyncDelegateRequestHandler createRequestHandler(Configuration conf) {
            this.requestHandler = new MockAsyncDelegateRequestHandler(this.taskRequestQueue, new LocalTaskSchedulerService.LocalContainerFactory(this.getContext().getApplicationAttemptId(), this.customContainerAppId), this.taskAllocations, this.getContext(), conf);
            return this.requestHandler;
        }

        public void start() {
        }

        public void startRequestHandlerThread() {
            this.asyncDelegateRequestThread.start();
        }

        public MockAsyncDelegateRequestHandler getRequestHandler() {
            return this.requestHandler;
        }

        static class MockAsyncDelegateRequestHandler
        extends LocalTaskSchedulerService.AsyncDelegateRequestHandler {
            public int allocateCount = 0;
            public int deallocateCount = 0;
            public int preemptCount = 0;
            public int dispatchCount = 0;

            MockAsyncDelegateRequestHandler(LinkedBlockingQueue<LocalTaskSchedulerService.SchedulerRequest> taskRequestQueue, LocalTaskSchedulerService.LocalContainerFactory localContainerFactory, HashMap<Object, LocalTaskSchedulerService.AllocatedTask> taskAllocations, TaskSchedulerContext appClientDelegate, Configuration conf) {
                super(taskRequestQueue, localContainerFactory, taskAllocations, appClientDelegate, conf);
            }

            void dispatchRequest() {
                super.dispatchRequest();
                ++this.dispatchCount;
            }

            void allocateTask() {
                super.allocateTask();
                ++this.allocateCount;
            }

            public void drainRequest(int count) {
                while (this.dispatchCount != count || !this.clientRequestQueue.isEmpty()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }

            void deallocateTask(LocalTaskSchedulerService.DeallocateTaskRequest request) {
                super.deallocateTask(request);
                ++this.deallocateCount;
            }

            void preemptTask(LocalTaskSchedulerService.DeallocateContainerRequest request) {
                super.preemptTask(request);
                ++this.preemptCount;
            }
        }
    }
}

