/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm;

import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.hadoop.yarn.client.api.impl.AMRMClientImpl;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.tez.common.MockDNSToSwitchMapping;
import org.apache.tez.dag.app.MockClock;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.app.dag.TaskAttempt;
import org.apache.tez.dag.app.rm.DagAwareYarnTaskScheduler;
import org.apache.tez.dag.app.rm.TaskSchedulerContextImplWrapper;
import org.apache.tez.dag.app.rm.TestTaskSchedulerHelpers;
import org.apache.tez.dag.app.rm.YarnTaskSchedulerServiceError;
import org.apache.tez.serviceplugins.api.DagInfo;
import org.apache.tez.serviceplugins.api.ServicePluginError;
import org.apache.tez.serviceplugins.api.TaskScheduler;
import org.apache.tez.serviceplugins.api.TaskSchedulerContext;
import org.apache.tez.test.ControlledScheduledExecutorService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestDagAwareYarnTaskScheduler {
    private ExecutorService contextCallbackExecutor;

    @BeforeClass
    public static void beforeClass() {
        MockDNSToSwitchMapping.initializeMockRackResolver();
    }

    @Before
    public void preTest() {
        this.contextCallbackExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("TaskSchedulerAppCallbackExecutor #%d").setDaemon(true).build());
    }

    @After
    public void postTest() {
        this.contextCallbackExecutor.shutdownNow();
    }

    private TestTaskSchedulerHelpers.TaskSchedulerContextDrainable createDrainableContext(TaskSchedulerContext taskSchedulerContext) {
        TaskSchedulerContextImplWrapper wrapper = new TaskSchedulerContextImplWrapper(taskSchedulerContext, (ExecutorService)TestTaskSchedulerHelpers.createCountingExecutingService(this.contextCallbackExecutor));
        return new TestTaskSchedulerHelpers.TaskSchedulerContextDrainable(wrapper);
    }

    @Test(timeout=30000L)
    public void testNoReuse() throws Exception {
        AMRMClientAsyncWrapperForTest mockRMClient = (AMRMClientAsyncWrapperForTest)((Object)Mockito.spy((Object)((Object)new AMRMClientAsyncWrapperForTest())));
        String appHost = "host";
        int appPort = 0;
        String appUrl = "url";
        Configuration conf = new Configuration();
        conf.setBoolean("tez.am.container.reuse.enabled", false);
        conf.setInt("tez.am.am-rm.heartbeat.interval-ms.max", 100);
        DagInfo mockDagInfo = (DagInfo)Mockito.mock(DagInfo.class);
        Mockito.when((Object)mockDagInfo.getTotalVertices()).thenReturn((Object)10);
        Mockito.when((Object)mockDagInfo.getVertexDescendants(Mockito.anyInt())).thenReturn((Object)new BitSet());
        TaskSchedulerContext mockApp = TestTaskSchedulerHelpers.setupMockTaskSchedulerContext(appHost, appPort, appUrl, conf);
        Mockito.when((Object)mockApp.getCurrentDagInfo()).thenReturn((Object)mockDagInfo);
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback = this.createDrainableContext(mockApp);
        MockClock clock = new MockClock(1000L);
        NewTaskSchedulerForTest scheduler = new NewTaskSchedulerForTest(drainableAppCallback, mockRMClient, clock);
        scheduler.initialize();
        drainableAppCallback.drain();
        scheduler.start();
        drainableAppCallback.drain();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).start();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).registerApplicationMaster(appHost, appPort, appUrl);
        RegisterApplicationMasterResponse regResponse = mockRMClient.getRegistrationResponse();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).setApplicationRegistrationData(regResponse.getMaximumResourceCapability(), regResponse.getApplicationACLs(), regResponse.getClientToAMTokenMasterKey(), regResponse.getQueue());
        Assert.assertEquals((long)scheduler.getClusterNodeCount(), (long)mockRMClient.getClusterNodeCount());
        MockTask mockTask1 = new MockTask("task1");
        Object mockCookie1 = new Object();
        Resource mockCapability = Resources.createResource((int)1024, (int)1);
        String[] hosts = new String[]{"host1", "host5"};
        String[] racks = new String[]{"/default-rack", "/default-rack"};
        Priority mockPriority = Priority.newInstance((int)1);
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(DagAwareYarnTaskScheduler.TaskRequest.class);
        scheduler.allocateTask(mockTask1, mockCapability, hosts, racks, mockPriority, null, mockCookie1);
        drainableAppCallback.drain();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)1)))).addContainerRequest((AMRMClient.ContainerRequest)((DagAwareYarnTaskScheduler.TaskRequest)Mockito.any()));
        Assert.assertFalse((boolean)scheduler.deallocateTask(mockTask1, true, null, null));
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)0))).containerBeingReleased((ContainerId)Mockito.any());
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)1)))).removeContainerRequest((AMRMClient.ContainerRequest)((DagAwareYarnTaskScheduler.TaskRequest)Mockito.any()));
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)0)))).releaseAssignedContainer((ContainerId)Mockito.any());
        Assert.assertFalse((boolean)scheduler.deallocateTask(mockTask1, true, null, null));
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)0))).containerBeingReleased((ContainerId)Mockito.any());
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)1)))).removeContainerRequest((AMRMClient.ContainerRequest)((DagAwareYarnTaskScheduler.TaskRequest)Mockito.any()));
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)0)))).releaseAssignedContainer((ContainerId)Mockito.any());
        MockTask mockTask2 = new MockTask("task2");
        Object mockCookie2 = new Object();
        MockTask mockTask3 = new MockTask("task3");
        Object mockCookie3 = new Object();
        scheduler.allocateTask(mockTask1, mockCapability, hosts, racks, mockPriority, null, mockCookie1);
        drainableAppCallback.drain();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)2)))).addContainerRequest((AMRMClient.ContainerRequest)((DagAwareYarnTaskScheduler.TaskRequest)requestCaptor.capture()));
        DagAwareYarnTaskScheduler.TaskRequest request1 = (DagAwareYarnTaskScheduler.TaskRequest)requestCaptor.getValue();
        scheduler.allocateTask(mockTask2, mockCapability, hosts, racks, mockPriority, null, mockCookie2);
        drainableAppCallback.drain();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)3)))).addContainerRequest((AMRMClient.ContainerRequest)((DagAwareYarnTaskScheduler.TaskRequest)requestCaptor.capture()));
        DagAwareYarnTaskScheduler.TaskRequest request2 = (DagAwareYarnTaskScheduler.TaskRequest)requestCaptor.getValue();
        scheduler.allocateTask(mockTask3, mockCapability, hosts, racks, mockPriority, null, mockCookie3);
        drainableAppCallback.drain();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)4)))).addContainerRequest((AMRMClient.ContainerRequest)((DagAwareYarnTaskScheduler.TaskRequest)requestCaptor.capture()));
        DagAwareYarnTaskScheduler.TaskRequest request3 = (DagAwareYarnTaskScheduler.TaskRequest)requestCaptor.getValue();
        NodeId host1 = NodeId.newInstance((String)"host1", (int)1);
        NodeId host2 = NodeId.newInstance((String)"host2", (int)2);
        NodeId host3 = NodeId.newInstance((String)"host3", (int)3);
        NodeId host4 = NodeId.newInstance((String)"host4", (int)4);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1);
        ContainerId mockCId1 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L);
        Container mockContainer1 = Container.newInstance((ContainerId)mockCId1, (NodeId)host1, null, (Resource)mockCapability, (Priority)mockPriority, null);
        ContainerId mockCId2 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)2L);
        Container mockContainer2 = Container.newInstance((ContainerId)mockCId2, (NodeId)host2, null, (Resource)mockCapability, (Priority)mockPriority, null);
        ContainerId mockCId3 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)3L);
        Container mockContainer3 = Container.newInstance((ContainerId)mockCId3, (NodeId)host3, null, (Resource)mockCapability, (Priority)mockPriority, null);
        ContainerId mockCId4 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)4L);
        Container mockContainer4 = Container.newInstance((ContainerId)mockCId4, (NodeId)host4, null, (Resource)mockCapability, (Priority)mockPriority, null);
        ArrayList<Container> containers = new ArrayList<Container>();
        containers.add(mockContainer1);
        containers.add(mockContainer2);
        containers.add(mockContainer3);
        containers.add(mockContainer4);
        scheduler.onContainersAllocated(containers);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)mockTask1, mockCookie1, mockContainer1);
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)mockTask2, mockCookie2, mockContainer2);
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)mockTask3, mockCookie3, mockContainer3);
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)3))).taskAllocated(Mockito.any(), Mockito.any(), (Container)Mockito.any());
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)request1);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)request2);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)request3);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).releaseAssignedContainer(mockCId4);
        Assert.assertTrue((boolean)scheduler.deallocateTask(mockTask1, true, null, null));
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).containerBeingReleased(mockCId1);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).releaseAssignedContainer(mockCId1);
        Assert.assertEquals((Object)mockTask2, (Object)scheduler.deallocateContainer(mockCId2));
        drainableAppCallback.drain();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).releaseAssignedContainer(mockCId2);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)3)))).releaseAssignedContainer((ContainerId)Mockito.any());
        ArrayList<ContainerStatus> statuses = new ArrayList<ContainerStatus>();
        ContainerStatus mockStatus1 = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        Mockito.when((Object)mockStatus1.getContainerId()).thenReturn((Object)mockCId1);
        statuses.add(mockStatus1);
        ContainerStatus mockStatus2 = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        Mockito.when((Object)mockStatus2.getContainerId()).thenReturn((Object)mockCId2);
        statuses.add(mockStatus2);
        ContainerStatus mockStatus3 = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        Mockito.when((Object)mockStatus3.getContainerId()).thenReturn((Object)mockCId3);
        statuses.add(mockStatus3);
        ContainerStatus mockStatus4 = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        Mockito.when((Object)mockStatus4.getContainerId()).thenReturn((Object)mockCId4);
        statuses.add(mockStatus4);
        scheduler.onContainersCompleted(statuses);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).containerCompleted((Object)mockTask1, mockStatus1);
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).containerCompleted((Object)mockTask2, mockStatus2);
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).containerCompleted((Object)mockTask3, mockStatus3);
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)3))).containerCompleted(Mockito.any(), (ContainerStatus)Mockito.any());
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)3)))).releaseAssignedContainer((ContainerId)Mockito.any());
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)0)))).updateBlacklist(Mockito.anyList(), Mockito.anyList());
        String badHost = "host6";
        NodeId badNodeId = NodeId.newInstance((String)badHost, (int)1);
        scheduler.blacklistNode(badNodeId);
        List<String> badNodeList = Collections.singletonList(badHost);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)1)))).updateBlacklist((List)Mockito.eq(badNodeList), (List)Mockito.isNull());
        MockTask mockTask4 = new MockTask("task4");
        Object mockCookie4 = new Object();
        scheduler.allocateTask(mockTask4, mockCapability, null, null, mockPriority, null, mockCookie4);
        drainableAppCallback.drain();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)5)))).addContainerRequest((AMRMClient.ContainerRequest)((DagAwareYarnTaskScheduler.TaskRequest)requestCaptor.capture()));
        ContainerId mockCId5 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)5L);
        Container mockContainer5 = Container.newInstance((ContainerId)mockCId5, (NodeId)badNodeId, null, (Resource)mockCapability, (Priority)mockPriority, null);
        containers.clear();
        containers.add(mockContainer5);
        scheduler.onContainersAllocated(containers);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)3))).taskAllocated(Mockito.any(), Mockito.any(), (Container)Mockito.any());
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).releaseAssignedContainer(mockCId5);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)4)))).releaseAssignedContainer((ContainerId)Mockito.any());
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)6)))).addContainerRequest((AMRMClient.ContainerRequest)((DagAwareYarnTaskScheduler.TaskRequest)requestCaptor.capture()));
        NodeId host6 = NodeId.newInstance((String)"host6", (int)6);
        ContainerId mockCId6 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)6L);
        Container mockContainer6 = Container.newInstance((ContainerId)mockCId6, (NodeId)host6, null, (Resource)mockCapability, (Priority)mockPriority, null);
        containers.clear();
        containers.add(mockContainer6);
        scheduler.onContainersAllocated(containers);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)4))).taskAllocated(Mockito.any(), Mockito.any(), (Container)Mockito.any());
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)mockTask4, mockCookie4, mockContainer6);
        Assert.assertTrue((boolean)scheduler.deallocateTask(mockTask4, true, null, null));
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).containerBeingReleased(mockCId6);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).releaseAssignedContainer(mockCId6);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)5)))).releaseAssignedContainer((ContainerId)Mockito.any());
        scheduler.unblacklistNode(badNodeId);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)1)))).updateBlacklist((List)Mockito.isNull(), (List)Mockito.eq(badNodeList));
        Assert.assertEquals((long)0L, (long)scheduler.getNumBlacklistedNodes());
        float progress = 0.5f;
        Mockito.when((Object)Float.valueOf(mockApp.getProgress())).thenReturn((Object)Float.valueOf(progress));
        Assert.assertEquals((float)progress, (float)scheduler.getProgress(), (float)0.0f);
        scheduler.allocateTask(mockTask1, mockCapability, hosts, racks, mockPriority, null, mockCookie1);
        drainableAppCallback.drain();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)7)))).addContainerRequest((AMRMClient.ContainerRequest)((DagAwareYarnTaskScheduler.TaskRequest)Mockito.any()));
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)6)))).removeContainerRequest((AMRMClient.ContainerRequest)((DagAwareYarnTaskScheduler.TaskRequest)Mockito.any()));
        scheduler.allocateTask(mockTask1, mockCapability, hosts, racks, mockPriority, null, mockCookie1);
        drainableAppCallback.drain();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)7)))).removeContainerRequest((AMRMClient.ContainerRequest)((DagAwareYarnTaskScheduler.TaskRequest)Mockito.any()));
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)8)))).addContainerRequest((AMRMClient.ContainerRequest)((DagAwareYarnTaskScheduler.TaskRequest)Mockito.any()));
        Assert.assertFalse((boolean)scheduler.deallocateTask(mockTask1, true, null, null));
        String speculativeNode = "host8";
        NodeId speculativeNodeId = (NodeId)Mockito.mock(NodeId.class);
        Mockito.when((Object)speculativeNodeId.getHost()).thenReturn((Object)speculativeNode);
        TaskAttempt mockTask5 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        Task task = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)mockTask5.getTask()).thenReturn((Object)task);
        Mockito.when((Object)task.getNodesWithRunningAttempts()).thenReturn((Object)Sets.newHashSet((Object[])new NodeId[]{speculativeNodeId}));
        Object mockCookie5 = new Object();
        scheduler.allocateTask(mockTask5, mockCapability, hosts, racks, mockPriority, null, mockCookie5);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)4))).taskAllocated(Mockito.any(), Mockito.any(), (Container)Mockito.any());
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)5)))).releaseAssignedContainer((ContainerId)Mockito.any());
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)9)))).addContainerRequest((AMRMClient.ContainerRequest)((DagAwareYarnTaskScheduler.TaskRequest)requestCaptor.capture()));
        List mockUpdatedNodes = (List)Mockito.mock(List.class);
        scheduler.onNodesUpdated(mockUpdatedNodes);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).nodesUpdated(mockUpdatedNodes);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(String.class);
        IOException mockException = new IOException("mockexception");
        scheduler.onError(mockException);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).reportError((ServicePluginError)Mockito.eq((Object)YarnTaskSchedulerServiceError.RESOURCEMANAGER_ERROR), (String)argumentCaptor.capture(), (DagInfo)Mockito.any());
        Assert.assertTrue((boolean)((String)argumentCaptor.getValue()).contains("mockexception"));
        scheduler.onShutdownRequest();
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).appShutdownRequested();
        String appMsg = "success";
        TaskSchedulerContext.AppFinalStatus finalStatus = new TaskSchedulerContext.AppFinalStatus(FinalApplicationStatus.SUCCEEDED, appMsg, appUrl);
        Mockito.when((Object)mockApp.getFinalAppStatus()).thenReturn((Object)finalStatus);
        scheduler.shutdown();
        drainableAppCallback.drain();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).unregisterApplicationMaster(FinalApplicationStatus.SUCCEEDED, appMsg, appUrl);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).stop();
    }

    @Test(timeout=30000L)
    public void testSimpleReuseLocalMatching() throws Exception {
        AMRMClientAsyncWrapperForTest mockRMClient = (AMRMClientAsyncWrapperForTest)((Object)Mockito.spy((Object)((Object)new AMRMClientAsyncWrapperForTest())));
        String appHost = "host";
        int appPort = 0;
        String appUrl = "url";
        Configuration conf = new Configuration();
        conf.setBoolean("tez.am.container.reuse.enabled", true);
        conf.setInt("tez.am.container.reuse.locality.delay-allocation-millis", 100);
        conf.setBoolean("tez.am.container.reuse.rack-fallback.enabled", false);
        conf.setBoolean("tez.am.container.reuse.non-local-fallback.enabled", false);
        conf.setInt("tez.am.am-rm.heartbeat.interval-ms.max", 100);
        DagInfo mockDagInfo = (DagInfo)Mockito.mock(DagInfo.class);
        Mockito.when((Object)mockDagInfo.getTotalVertices()).thenReturn((Object)10);
        Mockito.when((Object)mockDagInfo.getVertexDescendants(Mockito.anyInt())).thenReturn((Object)new BitSet());
        TaskSchedulerContext mockApp = TestTaskSchedulerHelpers.setupMockTaskSchedulerContext(appHost, appPort, appUrl, conf);
        Mockito.when((Object)mockApp.getCurrentDagInfo()).thenReturn((Object)mockDagInfo);
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback = this.createDrainableContext(mockApp);
        MockClock clock = new MockClock(1000L);
        NewTaskSchedulerForTest scheduler = new NewTaskSchedulerForTest(drainableAppCallback, mockRMClient, clock);
        scheduler.initialize();
        drainableAppCallback.drain();
        scheduler.start();
        drainableAppCallback.drain();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).start();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).registerApplicationMaster(appHost, appPort, appUrl);
        RegisterApplicationMasterResponse regResponse = mockRMClient.getRegistrationResponse();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).setApplicationRegistrationData(regResponse.getMaximumResourceCapability(), regResponse.getApplicationACLs(), regResponse.getClientToAMTokenMasterKey(), regResponse.getQueue());
        Assert.assertEquals((long)scheduler.getClusterNodeCount(), (long)mockRMClient.getClusterNodeCount());
        Priority priorityv0 = Priority.newInstance((int)1);
        Priority priorityv1 = Priority.newInstance((int)2);
        String[] hostsv0t0 = new String[]{"host1", "host2"};
        MockTaskInfo taskv0t0 = new MockTaskInfo("taskv0t0", priorityv0, hostsv0t0);
        MockTaskInfo taskv0t1 = new MockTaskInfo("taskv0t1", priorityv0, "host3");
        MockTaskInfo taskv0t2 = new MockTaskInfo("taskv0t2", priorityv0, hostsv0t0);
        MockTaskInfo taskv1t0 = new MockTaskInfo("taskv1t0", priorityv1, hostsv0t0);
        MockTaskInfo taskv1t1 = new MockTaskInfo("taskv1t1", priorityv1, hostsv0t0);
        TaskRequestCaptor taskRequestCaptor = new TaskRequestCaptor((AMRMClientAsync<DagAwareYarnTaskScheduler.TaskRequest>)mockRMClient, (TaskScheduler)scheduler, drainableAppCallback);
        DagAwareYarnTaskScheduler.TaskRequest reqv0t0 = taskRequestCaptor.scheduleTask(taskv0t0);
        taskRequestCaptor.scheduleTask(taskv0t1);
        DagAwareYarnTaskScheduler.TaskRequest reqv0t2 = taskRequestCaptor.scheduleTask(taskv0t2);
        DagAwareYarnTaskScheduler.TaskRequest reqv1t0 = taskRequestCaptor.scheduleTask(taskv1t0);
        taskRequestCaptor.scheduleTask(taskv1t1);
        NodeId host1 = NodeId.newInstance((String)"host1", (int)1);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1);
        ContainerId cid1 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L);
        Container container1 = Container.newInstance((ContainerId)cid1, (NodeId)host1, null, (Resource)taskv0t0.capability, (Priority)priorityv0, null);
        scheduler.onContainersAllocated(Collections.singletonList(container1));
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)taskv0t0.task, taskv0t0.cookie, container1);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)reqv0t0);
        Assert.assertTrue((boolean)scheduler.deallocateTask(taskv0t0.task, true, null, null));
        clock.incrementTime(10000L);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.never())).containerBeingReleased((ContainerId)Mockito.any());
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.never()))).releaseAssignedContainer((ContainerId)Mockito.any());
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)taskv0t2.task, taskv0t2.cookie, container1);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)reqv0t2);
        Assert.assertTrue((boolean)scheduler.deallocateTask(taskv0t2.task, true, null, null));
        clock.incrementTime(10000L);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.never())).containerBeingReleased((ContainerId)Mockito.any());
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.never()))).releaseAssignedContainer((ContainerId)Mockito.any());
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)taskv1t0.task, taskv1t0.cookie, container1);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)reqv1t0);
        Assert.assertTrue((boolean)scheduler.deallocateTask(taskv1t0.task, false, null, null));
        clock.incrementTime(10000L);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).containerBeingReleased(cid1);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).releaseAssignedContainer(cid1);
        String appMsg = "success";
        TaskSchedulerContext.AppFinalStatus finalStatus = new TaskSchedulerContext.AppFinalStatus(FinalApplicationStatus.SUCCEEDED, appMsg, appUrl);
        Mockito.when((Object)mockApp.getFinalAppStatus()).thenReturn((Object)finalStatus);
        scheduler.shutdown();
        drainableAppCallback.drain();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).unregisterApplicationMaster(FinalApplicationStatus.SUCCEEDED, appMsg, appUrl);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).stop();
    }

    @Test(timeout=30000L)
    public void testSimpleReuseRackMatching() throws Exception {
        AMRMClientAsyncWrapperForTest mockRMClient = (AMRMClientAsyncWrapperForTest)((Object)Mockito.spy((Object)((Object)new AMRMClientAsyncWrapperForTest())));
        String appHost = "host";
        int appPort = 0;
        String appUrl = "url";
        Configuration conf = new Configuration();
        conf.setBoolean("tez.am.container.reuse.enabled", true);
        conf.setInt("tez.am.container.reuse.locality.delay-allocation-millis", 100);
        conf.setBoolean("tez.am.container.reuse.rack-fallback.enabled", true);
        conf.setBoolean("tez.am.container.reuse.non-local-fallback.enabled", false);
        conf.setInt("tez.am.am-rm.heartbeat.interval-ms.max", 100);
        DagInfo mockDagInfo = (DagInfo)Mockito.mock(DagInfo.class);
        Mockito.when((Object)mockDagInfo.getTotalVertices()).thenReturn((Object)10);
        Mockito.when((Object)mockDagInfo.getVertexDescendants(Mockito.anyInt())).thenReturn((Object)new BitSet());
        TaskSchedulerContext mockApp = TestTaskSchedulerHelpers.setupMockTaskSchedulerContext(appHost, appPort, appUrl, conf);
        Mockito.when((Object)mockApp.getCurrentDagInfo()).thenReturn((Object)mockDagInfo);
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback = this.createDrainableContext(mockApp);
        MockClock clock = new MockClock(1000L);
        NewTaskSchedulerForTest scheduler = new NewTaskSchedulerForTest(drainableAppCallback, mockRMClient, clock);
        scheduler.initialize();
        drainableAppCallback.drain();
        scheduler.start();
        drainableAppCallback.drain();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).start();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).registerApplicationMaster(appHost, appPort, appUrl);
        RegisterApplicationMasterResponse regResponse = mockRMClient.getRegistrationResponse();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).setApplicationRegistrationData(regResponse.getMaximumResourceCapability(), regResponse.getApplicationACLs(), regResponse.getClientToAMTokenMasterKey(), regResponse.getQueue());
        Assert.assertEquals((long)scheduler.getClusterNodeCount(), (long)mockRMClient.getClusterNodeCount());
        Priority priorityv0 = Priority.newInstance((int)1);
        Priority priorityv1 = Priority.newInstance((int)2);
        String[] hostsv0t0 = new String[]{"host1", "host2"};
        MockTaskInfo taskv0t0 = new MockTaskInfo("taskv0t0", priorityv0, hostsv0t0);
        MockTaskInfo taskv0t1 = new MockTaskInfo("taskv0t1", priorityv0, "host2");
        MockTaskInfo taskv0t2 = new MockTaskInfo("taskv0t2", priorityv0, "host4", "/somerack");
        MockTaskInfo taskv1t0 = new MockTaskInfo("taskv1t0", priorityv1, "host1");
        MockTaskInfo taskv1t1 = new MockTaskInfo("taskv1t1", priorityv1, "host5");
        TaskRequestCaptor taskRequestCaptor = new TaskRequestCaptor((AMRMClientAsync<DagAwareYarnTaskScheduler.TaskRequest>)mockRMClient, (TaskScheduler)scheduler, drainableAppCallback);
        DagAwareYarnTaskScheduler.TaskRequest reqv0t0 = taskRequestCaptor.scheduleTask(taskv0t0);
        DagAwareYarnTaskScheduler.TaskRequest reqv0t1 = taskRequestCaptor.scheduleTask(taskv0t1);
        taskRequestCaptor.scheduleTask(taskv0t2);
        DagAwareYarnTaskScheduler.TaskRequest reqv1t0 = taskRequestCaptor.scheduleTask(taskv1t0);
        taskRequestCaptor.scheduleTask(taskv1t1);
        NodeId host1 = NodeId.newInstance((String)"host1", (int)1);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1);
        ContainerId cid1 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L);
        Container container1 = Container.newInstance((ContainerId)cid1, (NodeId)host1, null, (Resource)taskv0t0.capability, (Priority)priorityv0, null);
        scheduler.onContainersAllocated(Collections.singletonList(container1));
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)taskv0t0.task, taskv0t0.cookie, container1);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)reqv0t0);
        Assert.assertTrue((boolean)scheduler.deallocateTask(taskv0t0.task, true, null, null));
        clock.incrementTime(10000L);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.never())).containerBeingReleased((ContainerId)Mockito.any());
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.never()))).releaseAssignedContainer((ContainerId)Mockito.any());
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)taskv1t0.task, taskv1t0.cookie, container1);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)reqv1t0);
        Assert.assertTrue((boolean)scheduler.deallocateTask(taskv1t0.task, true, null, null));
        clock.incrementTime(10000L);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.never())).containerBeingReleased((ContainerId)Mockito.any());
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.never()))).releaseAssignedContainer((ContainerId)Mockito.any());
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)taskv0t1.task, taskv0t1.cookie, container1);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)reqv0t1);
        Assert.assertTrue((boolean)scheduler.deallocateTask(taskv0t1.task, false, null, null));
        clock.incrementTime(10000L);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).containerBeingReleased(cid1);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).releaseAssignedContainer(cid1);
        String appMsg = "success";
        TaskSchedulerContext.AppFinalStatus finalStatus = new TaskSchedulerContext.AppFinalStatus(FinalApplicationStatus.SUCCEEDED, appMsg, appUrl);
        Mockito.when((Object)mockApp.getFinalAppStatus()).thenReturn((Object)finalStatus);
        scheduler.shutdown();
        drainableAppCallback.drain();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).unregisterApplicationMaster(FinalApplicationStatus.SUCCEEDED, appMsg, appUrl);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).stop();
    }

    @Test(timeout=30000L)
    public void testSimpleReuseAnyMatching() throws Exception {
        AMRMClientAsyncWrapperForTest mockRMClient = (AMRMClientAsyncWrapperForTest)((Object)Mockito.spy((Object)((Object)new AMRMClientAsyncWrapperForTest())));
        String appHost = "host";
        int appPort = 0;
        String appUrl = "url";
        Configuration conf = new Configuration();
        conf.setBoolean("tez.am.container.reuse.enabled", true);
        conf.setInt("tez.am.container.reuse.locality.delay-allocation-millis", 100);
        conf.setBoolean("tez.am.container.reuse.rack-fallback.enabled", true);
        conf.setBoolean("tez.am.container.reuse.non-local-fallback.enabled", true);
        conf.setInt("tez.am.am-rm.heartbeat.interval-ms.max", 100);
        DagInfo mockDagInfo = (DagInfo)Mockito.mock(DagInfo.class);
        Mockito.when((Object)mockDagInfo.getTotalVertices()).thenReturn((Object)10);
        Mockito.when((Object)mockDagInfo.getVertexDescendants(Mockito.anyInt())).thenReturn((Object)new BitSet());
        TaskSchedulerContext mockApp = TestTaskSchedulerHelpers.setupMockTaskSchedulerContext(appHost, appPort, appUrl, conf);
        Mockito.when((Object)mockApp.getCurrentDagInfo()).thenReturn((Object)mockDagInfo);
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback = this.createDrainableContext(mockApp);
        MockClock clock = new MockClock(1000L);
        NewTaskSchedulerForTest scheduler = new NewTaskSchedulerForTest(drainableAppCallback, mockRMClient, clock);
        scheduler.initialize();
        drainableAppCallback.drain();
        scheduler.start();
        drainableAppCallback.drain();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).start();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).registerApplicationMaster(appHost, appPort, appUrl);
        RegisterApplicationMasterResponse regResponse = mockRMClient.getRegistrationResponse();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).setApplicationRegistrationData(regResponse.getMaximumResourceCapability(), regResponse.getApplicationACLs(), regResponse.getClientToAMTokenMasterKey(), regResponse.getQueue());
        Assert.assertEquals((long)scheduler.getClusterNodeCount(), (long)mockRMClient.getClusterNodeCount());
        Priority priorityv0 = Priority.newInstance((int)1);
        Priority priorityv1 = Priority.newInstance((int)2);
        String[] hostsv0t0 = new String[]{"host1", "host2"};
        MockTaskInfo taskv0t0 = new MockTaskInfo("taskv0t0", priorityv0, hostsv0t0);
        MockTaskInfo taskv0t1 = new MockTaskInfo("taskv0t1", priorityv0, "host2");
        MockTaskInfo taskv0t2 = new MockTaskInfo("taskv0t2", priorityv0, "host4", "/rack4");
        MockTaskInfo taskv1t0 = new MockTaskInfo("taskv1t0", priorityv1, "host1");
        MockTaskInfo taskv1t1 = new MockTaskInfo("taskv1t1", priorityv1, "host6", "/rack6");
        TaskRequestCaptor taskRequestCaptor = new TaskRequestCaptor((AMRMClientAsync<DagAwareYarnTaskScheduler.TaskRequest>)mockRMClient, (TaskScheduler)scheduler, drainableAppCallback);
        DagAwareYarnTaskScheduler.TaskRequest reqv0t0 = taskRequestCaptor.scheduleTask(taskv0t0);
        DagAwareYarnTaskScheduler.TaskRequest reqv0t1 = taskRequestCaptor.scheduleTask(taskv0t1);
        DagAwareYarnTaskScheduler.TaskRequest reqv0t2 = taskRequestCaptor.scheduleTask(taskv0t2);
        DagAwareYarnTaskScheduler.TaskRequest reqv1t0 = taskRequestCaptor.scheduleTask(taskv1t0);
        taskRequestCaptor.scheduleTask(taskv1t1);
        NodeId host1 = NodeId.newInstance((String)"host1", (int)1);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1);
        ContainerId cid1 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L);
        Container container1 = Container.newInstance((ContainerId)cid1, (NodeId)host1, null, (Resource)taskv0t0.capability, (Priority)priorityv0, null);
        scheduler.onContainersAllocated(Collections.singletonList(container1));
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)taskv0t0.task, taskv0t0.cookie, container1);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)reqv0t0);
        Assert.assertTrue((boolean)scheduler.deallocateTask(taskv0t0.task, true, null, null));
        clock.incrementTime(10000L);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.never())).containerBeingReleased((ContainerId)Mockito.any());
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.never()))).releaseAssignedContainer((ContainerId)Mockito.any());
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)taskv1t0.task, taskv1t0.cookie, container1);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)reqv1t0);
        Assert.assertTrue((boolean)scheduler.deallocateTask(taskv1t0.task, true, null, null));
        clock.incrementTime(10000L);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.never())).containerBeingReleased((ContainerId)Mockito.any());
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.never()))).releaseAssignedContainer((ContainerId)Mockito.any());
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)taskv0t1.task, taskv0t1.cookie, container1);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)reqv0t1);
        Assert.assertTrue((boolean)scheduler.deallocateTask(taskv0t1.task, true, null, null));
        clock.incrementTime(10000L);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.never())).containerBeingReleased((ContainerId)Mockito.any());
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.never()))).releaseAssignedContainer((ContainerId)Mockito.any());
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)taskv0t2.task, taskv0t2.cookie, container1);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)reqv0t2);
        Assert.assertTrue((boolean)scheduler.deallocateTask(taskv0t2.task, false, null, null));
        clock.incrementTime(10000L);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).containerBeingReleased(cid1);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).releaseAssignedContainer(cid1);
        String appMsg = "success";
        TaskSchedulerContext.AppFinalStatus finalStatus = new TaskSchedulerContext.AppFinalStatus(FinalApplicationStatus.SUCCEEDED, appMsg, appUrl);
        Mockito.when((Object)mockApp.getFinalAppStatus()).thenReturn((Object)finalStatus);
        scheduler.shutdown();
        drainableAppCallback.drain();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).unregisterApplicationMaster(FinalApplicationStatus.SUCCEEDED, appMsg, appUrl);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).stop();
    }

    @Test(timeout=30000L)
    public void testReuseWithAffinity() throws Exception {
        AMRMClientAsyncWrapperForTest mockRMClient = (AMRMClientAsyncWrapperForTest)((Object)Mockito.spy((Object)((Object)new AMRMClientAsyncWrapperForTest())));
        String appHost = "host";
        int appPort = 0;
        String appUrl = "url";
        Configuration conf = new Configuration();
        conf.setBoolean("tez.am.container.reuse.enabled", true);
        conf.setInt("tez.am.container.reuse.locality.delay-allocation-millis", 100);
        conf.setBoolean("tez.am.container.reuse.rack-fallback.enabled", true);
        conf.setBoolean("tez.am.container.reuse.non-local-fallback.enabled", false);
        conf.setInt("tez.am.am-rm.heartbeat.interval-ms.max", 100);
        DagInfo mockDagInfo = (DagInfo)Mockito.mock(DagInfo.class);
        Mockito.when((Object)mockDagInfo.getTotalVertices()).thenReturn((Object)10);
        Mockito.when((Object)mockDagInfo.getVertexDescendants(Mockito.anyInt())).thenReturn((Object)new BitSet());
        TaskSchedulerContext mockApp = TestTaskSchedulerHelpers.setupMockTaskSchedulerContext(appHost, appPort, appUrl, conf);
        Mockito.when((Object)mockApp.getCurrentDagInfo()).thenReturn((Object)mockDagInfo);
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback = this.createDrainableContext(mockApp);
        MockClock clock = new MockClock(1000L);
        NewTaskSchedulerForTest scheduler = new NewTaskSchedulerForTest(drainableAppCallback, mockRMClient, clock);
        scheduler.initialize();
        drainableAppCallback.drain();
        scheduler.start();
        drainableAppCallback.drain();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).start();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).registerApplicationMaster(appHost, appPort, appUrl);
        RegisterApplicationMasterResponse regResponse = mockRMClient.getRegistrationResponse();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).setApplicationRegistrationData(regResponse.getMaximumResourceCapability(), regResponse.getApplicationACLs(), regResponse.getClientToAMTokenMasterKey(), regResponse.getQueue());
        Assert.assertEquals((long)scheduler.getClusterNodeCount(), (long)mockRMClient.getClusterNodeCount());
        Priority priorityv0 = Priority.newInstance((int)1);
        Priority priorityv1 = Priority.newInstance((int)2);
        String[] hostsv0t0 = new String[]{"host1", "host2"};
        MockTaskInfo taskv0t0 = new MockTaskInfo("taskv0t0", priorityv0, hostsv0t0);
        MockTaskInfo taskv0t1 = new MockTaskInfo("taskv0t1", priorityv0, hostsv0t0);
        TaskRequestCaptor taskRequestCaptor = new TaskRequestCaptor((AMRMClientAsync<DagAwareYarnTaskScheduler.TaskRequest>)mockRMClient, (TaskScheduler)scheduler, drainableAppCallback);
        DagAwareYarnTaskScheduler.TaskRequest reqv0t0 = taskRequestCaptor.scheduleTask(taskv0t0);
        taskRequestCaptor.scheduleTask(taskv0t1);
        NodeId host1 = NodeId.newInstance((String)"host1", (int)1);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1);
        ContainerId cid1 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L);
        Container container1 = Container.newInstance((ContainerId)cid1, (NodeId)host1, null, (Resource)taskv0t0.capability, (Priority)priorityv0, null);
        scheduler.onContainersAllocated(Collections.singletonList(container1));
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)taskv0t0.task, taskv0t0.cookie, container1);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)reqv0t0);
        MockTaskInfo taskv1t0 = new MockTaskInfo("taskv1t0", priorityv1, "host1");
        DagAwareYarnTaskScheduler.TaskRequest reqv1t0 = taskRequestCaptor.scheduleTask(taskv1t0, cid1);
        Assert.assertTrue((boolean)scheduler.deallocateTask(taskv0t0.task, true, null, null));
        clock.incrementTime(10000L);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.never())).containerBeingReleased((ContainerId)Mockito.any());
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.never()))).releaseAssignedContainer((ContainerId)Mockito.any());
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)taskv1t0.task, taskv1t0.cookie, container1);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)reqv1t0);
        String appMsg = "success";
        TaskSchedulerContext.AppFinalStatus finalStatus = new TaskSchedulerContext.AppFinalStatus(FinalApplicationStatus.SUCCEEDED, appMsg, appUrl);
        Mockito.when((Object)mockApp.getFinalAppStatus()).thenReturn((Object)finalStatus);
        scheduler.shutdown();
        drainableAppCallback.drain();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).unregisterApplicationMaster(FinalApplicationStatus.SUCCEEDED, appMsg, appUrl);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).stop();
    }

    @Test(timeout=30000L)
    public void testReuseVertexDescendants() throws Exception {
        AMRMClientAsyncWrapperForTest mockRMClient = (AMRMClientAsyncWrapperForTest)((Object)Mockito.spy((Object)((Object)new AMRMClientAsyncWrapperForTest())));
        String appHost = "host";
        int appPort = 0;
        String appUrl = "url";
        Configuration conf = new Configuration();
        conf.setBoolean("tez.am.container.reuse.enabled", true);
        conf.setInt("tez.am.container.reuse.locality.delay-allocation-millis", 100);
        conf.setBoolean("tez.am.container.reuse.rack-fallback.enabled", true);
        conf.setBoolean("tez.am.container.reuse.non-local-fallback.enabled", false);
        conf.setInt("tez.am.am-rm.heartbeat.interval-ms.max", 100);
        DagInfo mockDagInfo = (DagInfo)Mockito.mock(DagInfo.class);
        Mockito.when((Object)mockDagInfo.getTotalVertices()).thenReturn((Object)3);
        Mockito.when((Object)mockDagInfo.getVertexDescendants(0)).thenReturn((Object)BitSet.valueOf(new long[]{2L}));
        Mockito.when((Object)mockDagInfo.getVertexDescendants(1)).thenReturn((Object)new BitSet());
        Mockito.when((Object)mockDagInfo.getVertexDescendants(2)).thenReturn((Object)new BitSet());
        TaskSchedulerContext mockApp = TestTaskSchedulerHelpers.setupMockTaskSchedulerContext(appHost, appPort, appUrl, conf);
        Mockito.when((Object)mockApp.getCurrentDagInfo()).thenReturn((Object)mockDagInfo);
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback = this.createDrainableContext(mockApp);
        MockClock clock = new MockClock(1000L);
        NewTaskSchedulerForTest scheduler = new NewTaskSchedulerForTest(drainableAppCallback, mockRMClient, clock);
        scheduler.initialize();
        drainableAppCallback.drain();
        scheduler.start();
        drainableAppCallback.drain();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).start();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).registerApplicationMaster(appHost, appPort, appUrl);
        RegisterApplicationMasterResponse regResponse = mockRMClient.getRegistrationResponse();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).setApplicationRegistrationData(regResponse.getMaximumResourceCapability(), regResponse.getApplicationACLs(), regResponse.getClientToAMTokenMasterKey(), regResponse.getQueue());
        Assert.assertEquals((long)scheduler.getClusterNodeCount(), (long)mockRMClient.getClusterNodeCount());
        Priority priorityv0 = Priority.newInstance((int)1);
        Priority priorityv1 = Priority.newInstance((int)2);
        Priority priorityv2 = Priority.newInstance((int)3);
        String[] hostsv0t0 = new String[]{"host1", "host2"};
        MockTaskInfo taskv0t0 = new MockTaskInfo("taskv0t0", priorityv0, hostsv0t0);
        Mockito.when((Object)mockApp.getVertexIndexForTask((Object)taskv0t0.task)).thenReturn((Object)0);
        MockTaskInfo taskv0t1 = new MockTaskInfo("taskv0t1", priorityv0, "host3");
        Mockito.when((Object)mockApp.getVertexIndexForTask((Object)taskv0t1.task)).thenReturn((Object)0);
        MockTaskInfo taskv1t0 = new MockTaskInfo("taskv1t0", priorityv1, hostsv0t0);
        Mockito.when((Object)mockApp.getVertexIndexForTask((Object)taskv1t0.task)).thenReturn((Object)1);
        MockTaskInfo taskv2t0 = new MockTaskInfo("taskv2t0", priorityv2, hostsv0t0);
        Mockito.when((Object)mockApp.getVertexIndexForTask((Object)taskv2t0.task)).thenReturn((Object)2);
        MockTaskInfo taskv2t1 = new MockTaskInfo("taskv2t1", priorityv2, "host3");
        Mockito.when((Object)mockApp.getVertexIndexForTask((Object)taskv2t1.task)).thenReturn((Object)2);
        TaskRequestCaptor taskRequestCaptor = new TaskRequestCaptor((AMRMClientAsync<DagAwareYarnTaskScheduler.TaskRequest>)mockRMClient, (TaskScheduler)scheduler, drainableAppCallback);
        DagAwareYarnTaskScheduler.TaskRequest reqv0t0 = taskRequestCaptor.scheduleTask(taskv0t0);
        DagAwareYarnTaskScheduler.TaskRequest reqv0t1 = taskRequestCaptor.scheduleTask(taskv0t1);
        DagAwareYarnTaskScheduler.TaskRequest reqv1t0 = taskRequestCaptor.scheduleTask(taskv1t0);
        DagAwareYarnTaskScheduler.TaskRequest reqv2t0 = taskRequestCaptor.scheduleTask(taskv2t0);
        taskRequestCaptor.scheduleTask(taskv2t1);
        NodeId host1 = NodeId.newInstance((String)"host1", (int)1);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1);
        ContainerId cid1 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L);
        Container container1 = Container.newInstance((ContainerId)cid1, (NodeId)host1, null, (Resource)taskv0t0.capability, (Priority)priorityv0, null);
        scheduler.onContainersAllocated(Collections.singletonList(container1));
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)taskv0t0.task, taskv0t0.cookie, container1);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)reqv0t0);
        Assert.assertTrue((boolean)scheduler.deallocateTask(taskv0t0.task, true, null, null));
        clock.incrementTime(10000L);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.never())).containerBeingReleased((ContainerId)Mockito.any());
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.never()))).releaseAssignedContainer((ContainerId)Mockito.any());
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)taskv2t0.task, taskv2t0.cookie, container1);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)reqv2t0);
        Assert.assertTrue((boolean)scheduler.deallocateTask(taskv2t0.task, true, null, null));
        clock.incrementTime(10000L);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.never())).containerBeingReleased((ContainerId)Mockito.any());
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.never()))).releaseAssignedContainer((ContainerId)Mockito.any());
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)taskv0t1.task, taskv0t1.cookie, container1);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)reqv0t1);
        Assert.assertTrue((boolean)scheduler.deallocateTask(taskv0t1.task, true, null, null));
        clock.incrementTime(10000L);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.never())).containerBeingReleased((ContainerId)Mockito.any());
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.never()))).releaseAssignedContainer((ContainerId)Mockito.any());
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)taskv1t0.task, taskv1t0.cookie, container1);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)reqv1t0);
        Assert.assertTrue((boolean)scheduler.deallocateTask(taskv1t0.task, false, null, null));
        clock.incrementTime(10000L);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).containerBeingReleased(cid1);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).releaseAssignedContainer(cid1);
        String appMsg = "success";
        TaskSchedulerContext.AppFinalStatus finalStatus = new TaskSchedulerContext.AppFinalStatus(FinalApplicationStatus.SUCCEEDED, appMsg, appUrl);
        Mockito.when((Object)mockApp.getFinalAppStatus()).thenReturn((Object)finalStatus);
        scheduler.shutdown();
        drainableAppCallback.drain();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).unregisterApplicationMaster(FinalApplicationStatus.SUCCEEDED, appMsg, appUrl);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).stop();
    }

    @Test(timeout=30000L)
    public void testSessionContainers() throws Exception {
        AMRMClientAsyncWrapperForTest mockRMClient = (AMRMClientAsyncWrapperForTest)((Object)Mockito.spy((Object)((Object)new AMRMClientAsyncWrapperForTest())));
        String appHost = "host";
        int appPort = 0;
        String appUrl = "url";
        Configuration conf = new Configuration();
        conf.setBoolean("tez.am.container.reuse.enabled", true);
        conf.setInt("tez.am.container.reuse.locality.delay-allocation-millis", 100);
        conf.setBoolean("tez.am.container.reuse.rack-fallback.enabled", true);
        conf.setBoolean("tez.am.container.reuse.non-local-fallback.enabled", false);
        conf.setInt("tez.am.am-rm.heartbeat.interval-ms.max", 100);
        conf.setInt("tez.am.container.idle.release-timeout-min.millis", 4000);
        conf.setInt("tez.am.container.idle.release-timeout-max.millis", 5000);
        conf.setInt("tez.am.session.min.held-containers", 5);
        DagInfo mockDagInfo = (DagInfo)Mockito.mock(DagInfo.class);
        Mockito.when((Object)mockDagInfo.getTotalVertices()).thenReturn((Object)10);
        Mockito.when((Object)mockDagInfo.getVertexDescendants(Mockito.anyInt())).thenReturn((Object)new BitSet());
        TaskSchedulerContext mockApp = TestTaskSchedulerHelpers.setupMockTaskSchedulerContext(appHost, appPort, appUrl, conf);
        Mockito.when((Object)mockApp.getCurrentDagInfo()).thenReturn((Object)mockDagInfo);
        Mockito.when((Object)mockApp.isSession()).thenReturn((Object)true);
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback = this.createDrainableContext(mockApp);
        MockClock clock = new MockClock(1000L);
        NewTaskSchedulerForTest scheduler = new NewTaskSchedulerForTest(drainableAppCallback, mockRMClient, clock);
        scheduler.initialize();
        drainableAppCallback.drain();
        scheduler.start();
        drainableAppCallback.drain();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).start();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).registerApplicationMaster(appHost, appPort, appUrl);
        RegisterApplicationMasterResponse regResponse = mockRMClient.getRegistrationResponse();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).setApplicationRegistrationData(regResponse.getMaximumResourceCapability(), regResponse.getApplicationACLs(), regResponse.getClientToAMTokenMasterKey(), regResponse.getQueue());
        Assert.assertEquals((long)scheduler.getClusterNodeCount(), (long)mockRMClient.getClusterNodeCount());
        String rack1 = "/r1";
        String rack2 = "/r2";
        String rack3 = "/r3";
        String node1Rack1 = "n1r1";
        String node2Rack1 = "n2r1";
        String node1Rack2 = "n1r2";
        String node2Rack2 = "n2r2";
        String node1Rack3 = "n1r3";
        MockDNSToSwitchMapping.addRackMapping((String)"n1r1", (String)"/r1");
        MockDNSToSwitchMapping.addRackMapping((String)"n2r1", (String)"/r1");
        MockDNSToSwitchMapping.addRackMapping((String)"n1r2", (String)"/r2");
        MockDNSToSwitchMapping.addRackMapping((String)"n2r2", (String)"/r2");
        MockDNSToSwitchMapping.addRackMapping((String)"n1r3", (String)"/r3");
        Priority priorityv0 = Priority.newInstance((int)1);
        MockTaskInfo taskv0t0 = new MockTaskInfo("taskv0t0", priorityv0, "n1r1", "/r1");
        MockTaskInfo taskv0t1 = new MockTaskInfo("taskv0t1", priorityv0, "n2r1", "/r1");
        MockTaskInfo taskv0t2 = new MockTaskInfo("taskv0t2", priorityv0, "n1r1", "/r1");
        MockTaskInfo taskv0t3 = new MockTaskInfo("taskv0t3", priorityv0, "n2r1", "/r1");
        MockTaskInfo taskv0t4 = new MockTaskInfo("taskv0t4", priorityv0, "n1r2", "/r2");
        MockTaskInfo taskv0t5 = new MockTaskInfo("taskv0t5", priorityv0, "n2r2", "/r2");
        MockTaskInfo taskv0t6 = new MockTaskInfo("taskv0t6", priorityv0, "n1r3", "/r3");
        TaskRequestCaptor taskRequestCaptor = new TaskRequestCaptor((AMRMClientAsync<DagAwareYarnTaskScheduler.TaskRequest>)mockRMClient, (TaskScheduler)scheduler, drainableAppCallback);
        DagAwareYarnTaskScheduler.TaskRequest reqv0t0 = taskRequestCaptor.scheduleTask(taskv0t0);
        DagAwareYarnTaskScheduler.TaskRequest reqv0t1 = taskRequestCaptor.scheduleTask(taskv0t1);
        DagAwareYarnTaskScheduler.TaskRequest reqv0t2 = taskRequestCaptor.scheduleTask(taskv0t2);
        DagAwareYarnTaskScheduler.TaskRequest reqv0t3 = taskRequestCaptor.scheduleTask(taskv0t3);
        DagAwareYarnTaskScheduler.TaskRequest reqv0t4 = taskRequestCaptor.scheduleTask(taskv0t4);
        DagAwareYarnTaskScheduler.TaskRequest reqv0t5 = taskRequestCaptor.scheduleTask(taskv0t5);
        DagAwareYarnTaskScheduler.TaskRequest reqv0t6 = taskRequestCaptor.scheduleTask(taskv0t6);
        ArrayList<Container> containers = new ArrayList<Container>();
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1);
        ContainerId cid1 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L);
        NodeId n1r1 = NodeId.newInstance((String)"n1r1", (int)1);
        Container container1 = Container.newInstance((ContainerId)cid1, (NodeId)n1r1, null, (Resource)taskv0t0.capability, (Priority)priorityv0, null);
        containers.add(container1);
        ContainerId cid2 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)2L);
        NodeId n2r1 = NodeId.newInstance((String)"n2r1", (int)1);
        Container container2 = Container.newInstance((ContainerId)cid2, (NodeId)n2r1, null, (Resource)taskv0t1.capability, (Priority)priorityv0, null);
        containers.add(container2);
        ContainerId cid3 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)3L);
        Container container3 = Container.newInstance((ContainerId)cid3, (NodeId)n1r1, null, (Resource)taskv0t2.capability, (Priority)priorityv0, null);
        containers.add(container3);
        ContainerId cid4 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)4L);
        Container container4 = Container.newInstance((ContainerId)cid4, (NodeId)n2r1, null, (Resource)taskv0t3.capability, (Priority)priorityv0, null);
        containers.add(container4);
        ContainerId cid5 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)5L);
        NodeId n1r2 = NodeId.newInstance((String)"n1r2", (int)1);
        Container container5 = Container.newInstance((ContainerId)cid5, (NodeId)n1r2, null, (Resource)taskv0t4.capability, (Priority)priorityv0, null);
        containers.add(container5);
        ContainerId cid6 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)6L);
        NodeId n2r2 = NodeId.newInstance((String)"n2r2", (int)1);
        Container container6 = Container.newInstance((ContainerId)cid6, (NodeId)n2r2, null, (Resource)taskv0t5.capability, (Priority)priorityv0, null);
        containers.add(container6);
        ContainerId cid7 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)7L);
        NodeId n1r3 = NodeId.newInstance((String)"n1r3", (int)1);
        Container container7 = Container.newInstance((ContainerId)cid7, (NodeId)n1r3, null, (Resource)taskv0t6.capability, (Priority)priorityv0, null);
        containers.add(container7);
        scheduler.onContainersAllocated(containers);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)taskv0t0.task, taskv0t0.cookie, container1);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)reqv0t0);
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)taskv0t1.task, taskv0t1.cookie, container2);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)reqv0t1);
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)taskv0t2.task, taskv0t2.cookie, container3);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)reqv0t2);
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)taskv0t3.task, taskv0t3.cookie, container4);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)reqv0t3);
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)taskv0t4.task, taskv0t4.cookie, container5);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)reqv0t4);
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)taskv0t5.task, taskv0t5.cookie, container6);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)reqv0t5);
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)taskv0t6.task, taskv0t6.cookie, container7);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)reqv0t6);
        clock.incrementTime(10000L);
        drainableAppCallback.drain();
        Assert.assertTrue((boolean)scheduler.deallocateTask(taskv0t0.task, true, null, null));
        Assert.assertTrue((boolean)scheduler.deallocateTask(taskv0t1.task, true, null, null));
        Assert.assertTrue((boolean)scheduler.deallocateTask(taskv0t2.task, true, null, null));
        Assert.assertTrue((boolean)scheduler.deallocateTask(taskv0t3.task, true, null, null));
        Assert.assertTrue((boolean)scheduler.deallocateTask(taskv0t4.task, true, null, null));
        Assert.assertTrue((boolean)scheduler.deallocateTask(taskv0t5.task, true, null, null));
        Assert.assertTrue((boolean)scheduler.deallocateTask(taskv0t6.task, true, null, null));
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.never())).containerBeingReleased((ContainerId)Mockito.any());
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.never()))).releaseAssignedContainer((ContainerId)Mockito.any());
        clock.incrementTime(5000L);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)2))).containerBeingReleased((ContainerId)Mockito.any());
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.times((int)2)))).releaseAssignedContainer((ContainerId)Mockito.any());
        HashSet<String> hosts = new HashSet<String>();
        HashSet<String> racks = new HashSet<String>();
        for (DagAwareYarnTaskScheduler.HeldContainer hc : scheduler.getSessionContainers()) {
            hosts.add(hc.getHost());
            racks.add(hc.getRack());
        }
        Assert.assertEquals((long)5L, (long)hosts.size());
        Assert.assertEquals((long)3L, (long)racks.size());
        Assert.assertTrue((boolean)hosts.contains("n1r1"));
        Assert.assertTrue((boolean)hosts.contains("n2r1"));
        Assert.assertTrue((boolean)hosts.contains("n1r2"));
        Assert.assertTrue((boolean)hosts.contains("n2r2"));
        Assert.assertTrue((boolean)hosts.contains("n1r3"));
        Assert.assertTrue((boolean)racks.contains("/r1"));
        Assert.assertTrue((boolean)racks.contains("/r2"));
        Assert.assertTrue((boolean)racks.contains("/r3"));
        String appMsg = "success";
        TaskSchedulerContext.AppFinalStatus finalStatus = new TaskSchedulerContext.AppFinalStatus(FinalApplicationStatus.SUCCEEDED, appMsg, appUrl);
        Mockito.when((Object)mockApp.getFinalAppStatus()).thenReturn((Object)finalStatus);
        scheduler.shutdown();
        drainableAppCallback.drain();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).unregisterApplicationMaster(FinalApplicationStatus.SUCCEEDED, appMsg, appUrl);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).stop();
    }

    @Test(timeout=50000L)
    public void testPreemptionNoHeadroom() throws Exception {
        AMRMClientAsyncWrapperForTest mockRMClient = (AMRMClientAsyncWrapperForTest)((Object)Mockito.spy((Object)((Object)new AMRMClientAsyncWrapperForTest())));
        String appHost = "host";
        int appPort = 0;
        String appUrl = "url";
        Configuration conf = new Configuration();
        conf.setBoolean("tez.am.container.reuse.enabled", true);
        conf.setInt("tez.am.container.reuse.locality.delay-allocation-millis", 100);
        conf.setBoolean("tez.am.container.reuse.rack-fallback.enabled", true);
        conf.setBoolean("tez.am.container.reuse.non-local-fallback.enabled", false);
        conf.setInt("tez.am.am-rm.heartbeat.interval-ms.max", 100);
        conf.setInt("tez.am.preemption.percentage", 10);
        conf.setInt("tez.am.preemption.heartbeats-between-preemptions", 3);
        conf.setInt("tez.am.preemption.max.wait-time-ms", 60000);
        DagInfo mockDagInfo = (DagInfo)Mockito.mock(DagInfo.class);
        Mockito.when((Object)mockDagInfo.getTotalVertices()).thenReturn((Object)3);
        Mockito.when((Object)mockDagInfo.getVertexDescendants(0)).thenReturn((Object)BitSet.valueOf(new long[]{2L}));
        Mockito.when((Object)mockDagInfo.getVertexDescendants(1)).thenReturn((Object)new BitSet());
        Mockito.when((Object)mockDagInfo.getVertexDescendants(2)).thenReturn((Object)new BitSet());
        TaskSchedulerContext mockApp = TestTaskSchedulerHelpers.setupMockTaskSchedulerContext(appHost, appPort, appUrl, conf);
        Mockito.when((Object)mockApp.getCurrentDagInfo()).thenReturn((Object)mockDagInfo);
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback = this.createDrainableContext(mockApp);
        MockClock clock = new MockClock(1000L);
        NewTaskSchedulerForTest scheduler = new NewTaskSchedulerForTest(drainableAppCallback, mockRMClient, clock);
        scheduler.initialize();
        drainableAppCallback.drain();
        scheduler.start();
        drainableAppCallback.drain();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).start();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).registerApplicationMaster(appHost, appPort, appUrl);
        RegisterApplicationMasterResponse regResponse = mockRMClient.getRegistrationResponse();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).setApplicationRegistrationData(regResponse.getMaximumResourceCapability(), regResponse.getApplicationACLs(), regResponse.getClientToAMTokenMasterKey(), regResponse.getQueue());
        Assert.assertEquals((long)scheduler.getClusterNodeCount(), (long)mockRMClient.getClusterNodeCount());
        Priority priorityv0 = Priority.newInstance((int)1);
        Priority priorityv1 = Priority.newInstance((int)2);
        Priority priorityv2 = Priority.newInstance((int)3);
        String[] hostsv0t0 = new String[]{"host1", "host2"};
        MockTaskInfo taskv0t0 = new MockTaskInfo("taskv0t0", priorityv0, hostsv0t0);
        Mockito.when((Object)mockApp.getVertexIndexForTask((Object)taskv0t0.task)).thenReturn((Object)0);
        MockTaskInfo taskv0t1 = new MockTaskInfo("taskv0t1", priorityv0, hostsv0t0);
        Mockito.when((Object)mockApp.getVertexIndexForTask((Object)taskv0t1.task)).thenReturn((Object)0);
        MockTaskInfo taskv1t0 = new MockTaskInfo("taskv1t0", priorityv1, hostsv0t0);
        Mockito.when((Object)mockApp.getVertexIndexForTask((Object)taskv1t0.task)).thenReturn((Object)1);
        MockTaskInfo taskv1t1 = new MockTaskInfo("taskv1t1", priorityv1, hostsv0t0);
        Mockito.when((Object)mockApp.getVertexIndexForTask((Object)taskv1t1.task)).thenReturn((Object)1);
        MockTaskInfo taskv2t0 = new MockTaskInfo("taskv2t0", priorityv2, hostsv0t0);
        Mockito.when((Object)mockApp.getVertexIndexForTask((Object)taskv2t0.task)).thenReturn((Object)2);
        TaskRequestCaptor taskRequestCaptor = new TaskRequestCaptor((AMRMClientAsync<DagAwareYarnTaskScheduler.TaskRequest>)mockRMClient, (TaskScheduler)scheduler, drainableAppCallback);
        DagAwareYarnTaskScheduler.TaskRequest reqv1t0 = taskRequestCaptor.scheduleTask(taskv1t0);
        DagAwareYarnTaskScheduler.TaskRequest reqv1t1 = taskRequestCaptor.scheduleTask(taskv1t1);
        NodeId host1 = NodeId.newInstance((String)"host1", (int)1);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1);
        ContainerId cid1 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L);
        Container container1 = Container.newInstance((ContainerId)cid1, (NodeId)host1, null, (Resource)taskv1t0.capability, (Priority)priorityv1, null);
        scheduler.onContainersAllocated(Collections.singletonList(container1));
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)taskv1t0.task, taskv1t0.cookie, container1);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)reqv1t0);
        clock.incrementTime(1000L);
        ContainerId cid2 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)2L);
        Container container2 = Container.newInstance((ContainerId)cid2, (NodeId)host1, null, (Resource)taskv1t0.capability, (Priority)priorityv1, null);
        scheduler.onContainersAllocated(Collections.singletonList(container2));
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)taskv1t1.task, taskv1t1.cookie, container2);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)reqv1t1);
        Mockito.when((Object)mockRMClient.getAvailableResources()).thenReturn((Object)Resources.none());
        DagAwareYarnTaskScheduler.TaskRequest reqv0t0 = taskRequestCaptor.scheduleTask(taskv0t0);
        scheduler.getProgress();
        scheduler.getProgress();
        scheduler.getProgress();
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)1))).preemptContainer((ContainerId)Mockito.any());
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).preemptContainer(cid2);
        Assert.assertEquals((Object)taskv1t1.task, (Object)scheduler.deallocateContainer(cid2));
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).containerBeingReleased(cid2);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).releaseAssignedContainer(cid2);
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.never())).containerBeingReleased(cid1);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.never()))).releaseAssignedContainer(cid1);
        clock.incrementTime(1000L);
        taskRequestCaptor.scheduleTask(taskv2t0);
        ContainerId cid3 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)3L);
        Container container3 = Container.newInstance((ContainerId)cid3, (NodeId)host1, null, (Resource)taskv0t0.capability, (Priority)priorityv0, null);
        scheduler.onContainersAllocated(Collections.singletonList(container3));
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)taskv0t0.task, taskv0t0.cookie, container3);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)reqv0t0);
        scheduler.getProgress();
        scheduler.getProgress();
        scheduler.getProgress();
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)1))).preemptContainer((ContainerId)Mockito.any());
        taskRequestCaptor.scheduleTask(taskv0t1);
        scheduler.getProgress();
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)2))).preemptContainer((ContainerId)Mockito.any());
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).preemptContainer(cid1);
        Assert.assertEquals((Object)taskv1t0.task, (Object)scheduler.deallocateContainer(cid1));
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).containerBeingReleased(cid1);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).releaseAssignedContainer(cid1);
        String appMsg = "success";
        TaskSchedulerContext.AppFinalStatus finalStatus = new TaskSchedulerContext.AppFinalStatus(FinalApplicationStatus.SUCCEEDED, appMsg, appUrl);
        Mockito.when((Object)mockApp.getFinalAppStatus()).thenReturn((Object)finalStatus);
        scheduler.shutdown();
        drainableAppCallback.drain();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).unregisterApplicationMaster(FinalApplicationStatus.SUCCEEDED, appMsg, appUrl);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).stop();
    }

    @Test(timeout=50000L)
    public void testPreemptionWhenBlocked() throws Exception {
        AMRMClientAsyncWrapperForTest mockRMClient = (AMRMClientAsyncWrapperForTest)((Object)Mockito.spy((Object)((Object)new AMRMClientAsyncWrapperForTest())));
        String appHost = "host";
        int appPort = 0;
        String appUrl = "url";
        Configuration conf = new Configuration();
        conf.setBoolean("tez.am.container.reuse.enabled", true);
        conf.setInt("tez.am.container.reuse.locality.delay-allocation-millis", 100);
        conf.setBoolean("tez.am.container.reuse.rack-fallback.enabled", true);
        conf.setBoolean("tez.am.container.reuse.non-local-fallback.enabled", false);
        conf.setInt("tez.am.am-rm.heartbeat.interval-ms.max", 100);
        conf.setInt("tez.am.preemption.percentage", 10);
        conf.setInt("tez.am.preemption.heartbeats-between-preemptions", 3);
        conf.setInt("tez.am.preemption.max.wait-time-ms", 60000);
        DagInfo mockDagInfo = (DagInfo)Mockito.mock(DagInfo.class);
        Mockito.when((Object)mockDagInfo.getTotalVertices()).thenReturn((Object)3);
        Mockito.when((Object)mockDagInfo.getVertexDescendants(0)).thenReturn((Object)BitSet.valueOf(new long[]{6L}));
        Mockito.when((Object)mockDagInfo.getVertexDescendants(1)).thenReturn((Object)BitSet.valueOf(new long[]{2L}));
        Mockito.when((Object)mockDagInfo.getVertexDescendants(2)).thenReturn((Object)new BitSet());
        TaskSchedulerContext mockApp = TestTaskSchedulerHelpers.setupMockTaskSchedulerContext(appHost, appPort, appUrl, conf);
        Mockito.when((Object)mockApp.getCurrentDagInfo()).thenReturn((Object)mockDagInfo);
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback = this.createDrainableContext(mockApp);
        MockClock clock = new MockClock(1000L);
        NewTaskSchedulerForTest scheduler = new NewTaskSchedulerForTest(drainableAppCallback, mockRMClient, clock);
        scheduler.initialize();
        drainableAppCallback.drain();
        scheduler.start();
        drainableAppCallback.drain();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).start();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).registerApplicationMaster(appHost, appPort, appUrl);
        RegisterApplicationMasterResponse regResponse = mockRMClient.getRegistrationResponse();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).setApplicationRegistrationData(regResponse.getMaximumResourceCapability(), regResponse.getApplicationACLs(), regResponse.getClientToAMTokenMasterKey(), regResponse.getQueue());
        Assert.assertEquals((long)scheduler.getClusterNodeCount(), (long)mockRMClient.getClusterNodeCount());
        Priority priorityv0 = Priority.newInstance((int)1);
        Priority priorityv2 = Priority.newInstance((int)3);
        String[] hostsv0t0 = new String[]{"host1", "host2"};
        MockTaskInfo taskv0t0 = new MockTaskInfo("taskv0t0", priorityv0, hostsv0t0);
        Mockito.when((Object)mockApp.getVertexIndexForTask((Object)taskv0t0.task)).thenReturn((Object)0);
        MockTaskInfo taskv0t1 = new MockTaskInfo("taskv0t1", priorityv0, hostsv0t0);
        Mockito.when((Object)mockApp.getVertexIndexForTask((Object)taskv0t1.task)).thenReturn((Object)0);
        MockTaskInfo taskv2t0 = new MockTaskInfo("taskv2t0", priorityv2, hostsv0t0);
        Mockito.when((Object)mockApp.getVertexIndexForTask((Object)taskv2t0.task)).thenReturn((Object)2);
        MockTaskInfo taskv2t1 = new MockTaskInfo("taskv2t1", priorityv2, hostsv0t0);
        Mockito.when((Object)mockApp.getVertexIndexForTask((Object)taskv2t1.task)).thenReturn((Object)2);
        Mockito.when((Object)mockApp.getVertexIndexForTask((Object)taskv2t0.task)).thenReturn((Object)2);
        TaskRequestCaptor taskRequestCaptor = new TaskRequestCaptor((AMRMClientAsync<DagAwareYarnTaskScheduler.TaskRequest>)mockRMClient, (TaskScheduler)scheduler, drainableAppCallback);
        DagAwareYarnTaskScheduler.TaskRequest reqv2t0 = taskRequestCaptor.scheduleTask(taskv2t0);
        NodeId host1 = NodeId.newInstance((String)"host1", (int)1);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1);
        ContainerId cid1 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L);
        Container container1 = Container.newInstance((ContainerId)cid1, (NodeId)host1, null, (Resource)taskv2t0.capability, (Priority)priorityv2, null);
        scheduler.onContainersAllocated(Collections.singletonList(container1));
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)taskv2t0.task, taskv2t0.cookie, container1);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)reqv2t0);
        clock.incrementTime(1000L);
        Mockito.when((Object)mockRMClient.getAvailableResources()).thenReturn((Object)Resources.none());
        scheduler.getProgress();
        scheduler.getProgress();
        scheduler.getProgress();
        drainableAppCallback.drain();
        DagAwareYarnTaskScheduler.TaskRequest reqv2t1 = taskRequestCaptor.scheduleTask(taskv2t1);
        scheduler.getProgress();
        scheduler.getProgress();
        scheduler.getProgress();
        drainableAppCallback.drain();
        clock.incrementTime(1000L);
        Mockito.when((Object)mockRMClient.getAvailableResources()).thenReturn((Object)Resources.none());
        DagAwareYarnTaskScheduler.TaskRequest reqv0t0 = taskRequestCaptor.scheduleTask(taskv0t0);
        scheduler.getProgress();
        scheduler.getProgress();
        scheduler.getProgress();
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.times((int)1))).preemptContainer((ContainerId)Mockito.any());
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).preemptContainer(cid1);
        String appMsg = "success";
        TaskSchedulerContext.AppFinalStatus finalStatus = new TaskSchedulerContext.AppFinalStatus(FinalApplicationStatus.SUCCEEDED, appMsg, appUrl);
        Mockito.when((Object)mockApp.getFinalAppStatus()).thenReturn((Object)finalStatus);
        scheduler.shutdown();
        drainableAppCallback.drain();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).unregisterApplicationMaster(FinalApplicationStatus.SUCCEEDED, appMsg, appUrl);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).stop();
    }

    @Test(timeout=50000L)
    public void testContainerAssignmentReleaseNewContainers() throws Exception {
        AMRMClientAsyncWrapperForTest mockRMClient = (AMRMClientAsyncWrapperForTest)((Object)Mockito.spy((Object)((Object)new AMRMClientAsyncWrapperForTest())));
        String appHost = "host";
        int appPort = 0;
        String appUrl = "url";
        Configuration conf = new Configuration();
        conf.setBoolean("tez.am.container.reuse.enabled", true);
        conf.setInt("tez.am.container.reuse.locality.delay-allocation-millis", 100);
        conf.setBoolean("tez.am.container.reuse.rack-fallback.enabled", false);
        conf.setBoolean("tez.am.container.reuse.non-local-fallback.enabled", false);
        conf.setBoolean("tez.am.container.reuse.new-containers.enabled", false);
        conf.setInt("tez.am.am-rm.heartbeat.interval-ms.max", 100);
        conf.setInt("tez.am.container.idle.release-timeout-min.millis", 4000);
        conf.setInt("tez.am.container.idle.release-timeout-max.millis", 5000);
        conf.setInt("tez.am.session.min.held-containers", 5);
        DagInfo mockDagInfo = (DagInfo)Mockito.mock(DagInfo.class);
        Mockito.when((Object)mockDagInfo.getTotalVertices()).thenReturn((Object)10);
        Mockito.when((Object)mockDagInfo.getVertexDescendants(Mockito.anyInt())).thenReturn((Object)new BitSet());
        TaskSchedulerContext mockApp = TestTaskSchedulerHelpers.setupMockTaskSchedulerContext(appHost, appPort, appUrl, conf);
        Mockito.when((Object)mockApp.getCurrentDagInfo()).thenReturn((Object)mockDagInfo);
        Mockito.when((Object)mockApp.isSession()).thenReturn((Object)true);
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback = this.createDrainableContext(mockApp);
        MockClock clock = new MockClock(1000L);
        NewTaskSchedulerForTest scheduler = new NewTaskSchedulerForTest(drainableAppCallback, mockRMClient, clock);
        scheduler.initialize();
        drainableAppCallback.drain();
        scheduler.start();
        drainableAppCallback.drain();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).start();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).registerApplicationMaster(appHost, appPort, appUrl);
        RegisterApplicationMasterResponse regResponse = mockRMClient.getRegistrationResponse();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).setApplicationRegistrationData(regResponse.getMaximumResourceCapability(), regResponse.getApplicationACLs(), regResponse.getClientToAMTokenMasterKey(), regResponse.getQueue());
        Assert.assertEquals((long)scheduler.getClusterNodeCount(), (long)mockRMClient.getClusterNodeCount());
        String rack1 = "/r1";
        String rack2 = "/r2";
        String node1Rack1 = "n1r1";
        String node2Rack1 = "n2r1";
        String node1Rack2 = "n1r2";
        MockDNSToSwitchMapping.addRackMapping((String)"n1r1", (String)"/r1");
        MockDNSToSwitchMapping.addRackMapping((String)"n2r1", (String)"/r1");
        MockDNSToSwitchMapping.addRackMapping((String)"n1r2", (String)"/r2");
        Priority priorityv0 = Priority.newInstance((int)1);
        MockTaskInfo taskv0t0 = new MockTaskInfo("taskv0t0", priorityv0, "n1r1", "/r1");
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1);
        ContainerId cid1 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L);
        NodeId n2r1 = NodeId.newInstance((String)"n2r1", (int)1);
        Container container1 = Container.newInstance((ContainerId)cid1, (NodeId)n2r1, null, (Resource)taskv0t0.capability, (Priority)priorityv0, null);
        scheduler.onContainersAllocated(Collections.singletonList(container1));
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.never())).containerBeingReleased(cid1);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).releaseAssignedContainer((ContainerId)Mockito.eq((Object)cid1));
    }

    @Test(timeout=50000L)
    public void testIdleContainerAssignmentReuseNewContainers() throws Exception {
        AMRMClientAsyncWrapperForTest mockRMClient = (AMRMClientAsyncWrapperForTest)((Object)Mockito.spy((Object)((Object)new AMRMClientAsyncWrapperForTest())));
        String appHost = "host";
        int appPort = 0;
        String appUrl = "url";
        Configuration conf = new Configuration();
        conf.setBoolean("tez.am.container.reuse.enabled", true);
        conf.setInt("tez.am.container.reuse.locality.delay-allocation-millis", 100);
        conf.setBoolean("tez.am.container.reuse.rack-fallback.enabled", false);
        conf.setBoolean("tez.am.container.reuse.non-local-fallback.enabled", false);
        conf.setBoolean("tez.am.container.reuse.new-containers.enabled", true);
        conf.setInt("tez.am.am-rm.heartbeat.interval-ms.max", 100);
        conf.setInt("tez.am.container.idle.release-timeout-min.millis", 4000);
        conf.setInt("tez.am.container.idle.release-timeout-max.millis", 5000);
        conf.setInt("tez.am.session.min.held-containers", 5);
        DagInfo mockDagInfo = (DagInfo)Mockito.mock(DagInfo.class);
        Mockito.when((Object)mockDagInfo.getTotalVertices()).thenReturn((Object)10);
        Mockito.when((Object)mockDagInfo.getVertexDescendants(Mockito.anyInt())).thenReturn((Object)new BitSet());
        TaskSchedulerContext mockApp = TestTaskSchedulerHelpers.setupMockTaskSchedulerContext(appHost, appPort, appUrl, conf);
        Mockito.when((Object)mockApp.getCurrentDagInfo()).thenReturn((Object)mockDagInfo);
        Mockito.when((Object)mockApp.isSession()).thenReturn((Object)true);
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback = this.createDrainableContext(mockApp);
        MockClock clock = new MockClock(1000L);
        NewTaskSchedulerForTest scheduler = new NewTaskSchedulerForTest(drainableAppCallback, mockRMClient, clock);
        scheduler.initialize();
        drainableAppCallback.drain();
        scheduler.start();
        drainableAppCallback.drain();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).start();
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).registerApplicationMaster(appHost, appPort, appUrl);
        RegisterApplicationMasterResponse regResponse = mockRMClient.getRegistrationResponse();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).setApplicationRegistrationData(regResponse.getMaximumResourceCapability(), regResponse.getApplicationACLs(), regResponse.getClientToAMTokenMasterKey(), regResponse.getQueue());
        Assert.assertEquals((long)scheduler.getClusterNodeCount(), (long)mockRMClient.getClusterNodeCount());
        String rack1 = "/r1";
        String rack2 = "/r2";
        String node1Rack1 = "n1r1";
        String node2Rack1 = "n2r1";
        String node1Rack2 = "n1r2";
        MockDNSToSwitchMapping.addRackMapping((String)"n1r1", (String)"/r1");
        MockDNSToSwitchMapping.addRackMapping((String)"n2r1", (String)"/r1");
        MockDNSToSwitchMapping.addRackMapping((String)"n1r2", (String)"/r2");
        Priority priorityv0 = Priority.newInstance((int)1);
        MockTaskInfo taskv0t0 = new MockTaskInfo("taskv0t0", priorityv0, "n1r1", "/r1");
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1);
        ContainerId cid1 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L);
        NodeId n2r1 = NodeId.newInstance((String)"n2r1", (int)1);
        Container container1 = Container.newInstance((ContainerId)cid1, (NodeId)n2r1, null, (Resource)taskv0t0.capability, (Priority)priorityv0, null);
        scheduler.onContainersAllocated(Collections.singletonList(container1));
        clock.incrementTime(2000L);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.never())).containerBeingReleased(cid1);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.never()))).releaseAssignedContainer(cid1);
        TaskRequestCaptor taskRequestCaptor = new TaskRequestCaptor((AMRMClientAsync<DagAwareYarnTaskScheduler.TaskRequest>)mockRMClient, (TaskScheduler)scheduler, drainableAppCallback);
        DagAwareYarnTaskScheduler.TaskRequest reqv0t0 = taskRequestCaptor.scheduleTask(taskv0t0);
        clock.incrementTime(10000L);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.never())).taskAllocated((Object)taskv0t0.task, taskv0t0.cookie, container1);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.never()))).removeContainerRequest((AMRMClient.ContainerRequest)reqv0t0);
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.never())).containerBeingReleased(cid1);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).releaseAssignedContainer(cid1);
        Assert.assertFalse((boolean)scheduler.deallocateTask(taskv0t0.task, false, null, null));
        ContainerId cid2 = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)2L);
        NodeId n1r1 = NodeId.newInstance((String)"n1r1", (int)1);
        Container container2 = Container.newInstance((ContainerId)cid2, (NodeId)n1r1, null, (Resource)taskv0t0.capability, (Priority)priorityv0, null);
        scheduler.onContainersAllocated(Collections.singletonList(container2));
        clock.incrementTime(2000L);
        drainableAppCallback.drain();
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp, (VerificationMode)Mockito.never())).containerBeingReleased(cid2);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient), (VerificationMode)Mockito.never()))).releaseAssignedContainer(cid2);
        reqv0t0 = taskRequestCaptor.scheduleTask(taskv0t0, false);
        ((TaskSchedulerContext)Mockito.verify((Object)mockApp)).taskAllocated((Object)taskv0t0.task, taskv0t0.cookie, container2);
        ((AMRMClientAsyncWrapperForTest)((Object)Mockito.verify((Object)((Object)mockRMClient)))).removeContainerRequest((AMRMClient.ContainerRequest)reqv0t0);
    }

    @Test
    public void testMinMaxContainerIdleMillisAreEqual() throws Exception {
        AMRMClientAsyncWrapperForTest mockRMClient = new AMRMClientAsyncWrapperForTest();
        Configuration conf = new Configuration();
        conf.setLong("tez.am.container.idle.release-timeout-min.millis", 10000L);
        conf.setLong("tez.am.container.idle.release-timeout-max.millis", 10000L);
        TaskSchedulerContext mockApp = TestTaskSchedulerHelpers.setupMockTaskSchedulerContext("host", 0, "url", conf);
        TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback = this.createDrainableContext(mockApp);
        MockClock clock = new MockClock(1000L);
        NewTaskSchedulerForTest scheduler = new NewTaskSchedulerForTest(drainableAppCallback, mockRMClient, clock);
        scheduler.initialize();
        NodeId host1 = NodeId.newInstance((String)"host1", (int)1);
        Container container1 = Container.newInstance(null, (NodeId)host1, null, null, null, null);
        NewTaskSchedulerForTest newTaskSchedulerForTest = scheduler;
        Objects.requireNonNull(newTaskSchedulerForTest);
        DagAwareYarnTaskScheduler.HeldContainer heldContainer = new DagAwareYarnTaskScheduler.HeldContainer((DagAwareYarnTaskScheduler)newTaskSchedulerForTest, container1);
        long now = clock.getTime();
        Assert.assertEquals((long)(now + 10000L), (long)heldContainer.getIdleExpirationTimestamp(now));
    }

    static class AMRMClientAsyncWrapperForTest
    extends DagAwareYarnTaskScheduler.AMRMClientAsyncWrapper {
        AMRMClientAsyncWrapperForTest() {
            super((AMRMClient)new MockAMRMClient(), 10000, null);
        }

        RegisterApplicationMasterResponse getRegistrationResponse() {
            return ((MockAMRMClient)this.client).getRegistrationResponse();
        }

        public RegisterApplicationMasterResponse registerApplicationMaster(String appHostName, int appHostPort, String appTrackingUrl) throws YarnException, IOException {
            return this.client.registerApplicationMaster(appHostName, appHostPort, appTrackingUrl);
        }

        protected void serviceStart() {
        }

        protected void serviceStop() {
        }
    }

    static class NewTaskSchedulerForTest
    extends DagAwareYarnTaskScheduler {
        final DagAwareYarnTaskScheduler.AMRMClientAsyncWrapper mockClient;
        final MockClock clock;

        NewTaskSchedulerForTest(TestTaskSchedulerHelpers.TaskSchedulerContextDrainable appClient, DagAwareYarnTaskScheduler.AMRMClientAsyncWrapper client, MockClock clock) {
            super((TaskSchedulerContext)appClient);
            this.mockClient = client;
            this.clock = clock;
            this.setShouldUnregister();
        }

        public void initialize() throws Exception {
            this.initialize(this.mockClient);
        }

        protected ScheduledExecutorService createExecutor() {
            return new ControlledScheduledExecutorService(this.clock);
        }

        protected long now() {
            return this.clock.getTime();
        }
    }

    static class MockTask {
        final String name;

        MockTask(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    static class MockTaskInfo {
        static final Object DEFAULT_SIGNATURE = new Object();
        final MockTask task;
        final Object cookie;
        final Object signature;
        final String[] hosts;
        final String[] racks;
        final Priority priority;
        final Resource capability;

        MockTaskInfo(String name, Priority priority, String host) {
            String[] stringArray;
            if (host == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = host;
            }
            this(name, priority, stringArray);
        }

        MockTaskInfo(String name, Priority priority, String[] hosts) {
            this(name, priority, hosts, MockTaskInfo.buildDefaultRacks(hosts));
        }

        MockTaskInfo(String name, Priority priority, String host, String rack) {
            String[] stringArray;
            String[] stringArray2;
            if (host == null) {
                stringArray2 = null;
            } else {
                String[] stringArray3 = new String[1];
                stringArray2 = stringArray3;
                stringArray3[0] = host;
            }
            if (rack == null) {
                stringArray = null;
            } else {
                String[] stringArray4 = new String[1];
                stringArray = stringArray4;
                stringArray4[0] = rack;
            }
            this(name, priority, stringArray2, stringArray);
        }

        MockTaskInfo(String name, Priority priority, String[] hosts, String[] racks) {
            this.cookie = new Object();
            this.signature = DEFAULT_SIGNATURE;
            this.task = new MockTask(name);
            this.hosts = hosts;
            this.racks = racks;
            this.priority = priority;
            this.capability = Resource.newInstance((int)1024, (int)1);
        }

        static String[] buildDefaultRacks(String[] hosts) {
            if (hosts == null) {
                return null;
            }
            Object[] racks = new String[hosts.length];
            Arrays.fill(racks, "/default-rack");
            return racks;
        }
    }

    static class TaskRequestCaptor {
        final AMRMClientAsync<DagAwareYarnTaskScheduler.TaskRequest> client;
        final TaskScheduler scheduler;
        final TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback;
        final ArgumentCaptor<DagAwareYarnTaskScheduler.TaskRequest> captor = ArgumentCaptor.forClass(DagAwareYarnTaskScheduler.TaskRequest.class);
        int invocationCount = 0;

        TaskRequestCaptor(AMRMClientAsync<DagAwareYarnTaskScheduler.TaskRequest> client, TaskScheduler scheduler, TestTaskSchedulerHelpers.TaskSchedulerContextDrainable drainableAppCallback) {
            this.client = client;
            this.scheduler = scheduler;
            this.drainableAppCallback = drainableAppCallback;
        }

        DagAwareYarnTaskScheduler.TaskRequest scheduleTask(MockTaskInfo taskInfo) throws Exception {
            return this.scheduleTask(taskInfo, true);
        }

        DagAwareYarnTaskScheduler.TaskRequest scheduleTask(MockTaskInfo taskInfo, boolean expectContainerRequest) throws Exception {
            this.scheduler.allocateTask((Object)taskInfo.task, taskInfo.capability, taskInfo.hosts, taskInfo.racks, taskInfo.priority, taskInfo.signature, taskInfo.cookie);
            this.drainableAppCallback.drain();
            if (expectContainerRequest) {
                ++this.invocationCount;
            }
            ((AMRMClientAsync)Mockito.verify(this.client, (VerificationMode)Mockito.times((int)this.invocationCount))).addContainerRequest((AMRMClient.ContainerRequest)((DagAwareYarnTaskScheduler.TaskRequest)this.captor.capture()));
            DagAwareYarnTaskScheduler.TaskRequest request = (DagAwareYarnTaskScheduler.TaskRequest)this.captor.getValue();
            Assert.assertEquals((Object)request.getTask(), (Object)taskInfo.task);
            Assert.assertEquals((Object)request.getCookie(), (Object)taskInfo.cookie);
            return request;
        }

        DagAwareYarnTaskScheduler.TaskRequest scheduleTask(MockTaskInfo taskInfo, ContainerId affinity) throws Exception {
            this.scheduler.allocateTask((Object)taskInfo.task, taskInfo.capability, affinity, taskInfo.priority, taskInfo.signature, taskInfo.cookie);
            this.drainableAppCallback.drain();
            ((AMRMClientAsync)Mockito.verify(this.client, (VerificationMode)Mockito.times((int)(++this.invocationCount)))).addContainerRequest((AMRMClient.ContainerRequest)((DagAwareYarnTaskScheduler.TaskRequest)this.captor.capture()));
            DagAwareYarnTaskScheduler.TaskRequest request = (DagAwareYarnTaskScheduler.TaskRequest)this.captor.getValue();
            Assert.assertEquals((Object)request.getTask(), (Object)taskInfo.task);
            Assert.assertEquals((Object)request.getCookie(), (Object)taskInfo.cookie);
            return request;
        }
    }

    static class MockAMRMClient
    extends AMRMClientImpl<DagAwareYarnTaskScheduler.TaskRequest> {
        private RegisterApplicationMasterResponse mockRegResponse;

        MockAMRMClient() {
            this.clusterAvailableResources = Resource.newInstance((int)4000, (int)4);
            this.clusterNodeCount = 5;
        }

        protected void serviceStart() {
        }

        protected void serviceStop() {
        }

        public RegisterApplicationMasterResponse registerApplicationMaster(String appHostName, int appHostPort, String appTrackingUrl) {
            this.mockRegResponse = (RegisterApplicationMasterResponse)Mockito.mock(RegisterApplicationMasterResponse.class);
            Resource mockMaxResource = Resources.createResource((int)0x100000, (int)1024);
            Map mockAcls = Collections.emptyMap();
            Mockito.when((Object)this.mockRegResponse.getMaximumResourceCapability()).thenReturn((Object)mockMaxResource);
            Mockito.when((Object)this.mockRegResponse.getApplicationACLs()).thenReturn(mockAcls);
            Mockito.when((Object)this.mockRegResponse.getSchedulerResourceTypes()).thenReturn(EnumSet.of(YarnServiceProtos.SchedulerResourceTypes.MEMORY, YarnServiceProtos.SchedulerResourceTypes.CPU));
            return this.mockRegResponse;
        }

        public void unregisterApplicationMaster(FinalApplicationStatus appStatus, String appMessage, String appTrackingUrl) {
        }

        RegisterApplicationMasterResponse getRegistrationResponse() {
            return this.mockRegResponse;
        }
    }
}

