/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ContainerContext;
import org.apache.tez.dag.app.DAGAppMaster;
import org.apache.tez.dag.app.TaskCommunicatorManagerInterface;
import org.apache.tez.dag.app.TaskHeartbeatHandler;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.StateChangeNotifier;
import org.apache.tez.dag.app.dag.impl.VertexImpl;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.dag.utils.TaskSpecificLaunchCmdOption;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestVertexImpl2 {
    @Test(timeout=5000L)
    public void testTaskLoggingOptsPerLogger() {
        TezConfiguration conf = new TezConfiguration();
        conf.set("tez.task.log.level", "DEBUG;org.apache.hadoop.ipc=INFO;org.apache.hadoop.server=INFO");
        LogTestInfoHolder testInfo = new LogTestInfoHolder();
        VertexWrapper vertexWrapper = this.createVertexWrapperForLogTests(testInfo, (Configuration)conf);
        LinkedList<String> expectedCommands = new LinkedList<String>();
        expectedCommands.add("-Dlog4j.configuratorClass=org.apache.tez.common.TezLog4jConfigurator");
        expectedCommands.add("-Dlog4j.configuration=tez-container-log4j.properties");
        expectedCommands.add("-Dyarn.app.container.log.dir=<LOG_DIR>");
        expectedCommands.add("-Dtez.root.logger=DEBUG,CLA");
        for (int i = 0; i < testInfo.numTasks; ++i) {
            ContainerContext containerContext = vertexWrapper.vertex.getContainerContext(i);
            String javaOpts = containerContext.getJavaOpts();
            Assert.assertTrue((boolean)javaOpts.contains(testInfo.initialJavaOpts));
            for (String expectedCmd : expectedCommands) {
                Assert.assertTrue((boolean)javaOpts.contains(expectedCmd));
            }
            Map env = containerContext.getEnvironment();
            String val = (String)env.get(testInfo.envKey);
            Assert.assertEquals((Object)testInfo.envVal, (Object)val);
            String logEnvVal = (String)env.get("TEZ_CONTAINER_LOG_PARAMS");
            Assert.assertEquals((Object)"org.apache.hadoop.ipc=INFO;org.apache.hadoop.server=INFO", (Object)logEnvVal);
        }
    }

    @Test(timeout=5000L)
    public void testTaskLoggingOptsSimple() {
        TezConfiguration conf = new TezConfiguration();
        conf.set("tez.task.log.level", "DEBUG");
        LogTestInfoHolder testInfo = new LogTestInfoHolder();
        VertexWrapper vertexWrapper = this.createVertexWrapperForLogTests(testInfo, (Configuration)conf);
        LinkedList<String> expectedCommands = new LinkedList<String>();
        expectedCommands.add("-Dlog4j.configuratorClass=org.apache.tez.common.TezLog4jConfigurator");
        expectedCommands.add("-Dlog4j.configuration=tez-container-log4j.properties");
        expectedCommands.add("-Dyarn.app.container.log.dir=<LOG_DIR>");
        expectedCommands.add("-Dtez.root.logger=DEBUG,CLA");
        for (int i = 0; i < testInfo.numTasks; ++i) {
            ContainerContext containerContext = vertexWrapper.vertex.getContainerContext(i);
            String javaOpts = containerContext.getJavaOpts();
            Assert.assertTrue((boolean)javaOpts.contains(testInfo.initialJavaOpts));
            for (String expectedCmd : expectedCommands) {
                Assert.assertTrue((boolean)javaOpts.contains(expectedCmd));
            }
            Map env = containerContext.getEnvironment();
            String val = (String)env.get(testInfo.envKey);
            Assert.assertEquals((Object)testInfo.envVal, (Object)val);
            String logEnvVal = (String)env.get("TEZ_CONTAINER_LOG_PARAMS");
            Assert.assertNull((Object)logEnvVal);
        }
    }

    @Test(timeout=5000L)
    public void testTaskSpecificLoggingOpts() {
        String logEnvVal;
        String val;
        Object env;
        String javaOpts;
        ContainerContext containerContext;
        int i;
        String vertexName = "testvertex";
        String customJavaOpts = "-Xmx128m";
        TezConfiguration conf = new TezConfiguration();
        conf.set("tez.task.log.level", "INFO");
        conf.set("tez.task-specific.launch.cmd-opts.list", vertexName + "[0,1,2]");
        conf.set("tez.task-specific.log.level", "DEBUG;org.apache.tez=INFO");
        conf.set("tez.task-specific.launch.cmd-opts", customJavaOpts);
        LogTestInfoHolder testInfo = new LogTestInfoHolder();
        VertexWrapper vertexWrapper = this.createVertexWrapperForLogTests(testInfo, (Configuration)conf);
        LinkedList<String> expectedCommands = new LinkedList<String>();
        expectedCommands.add("-Dlog4j.configuratorClass=org.apache.tez.common.TezLog4jConfigurator");
        expectedCommands.add("-Dlog4j.configuration=tez-container-log4j.properties");
        expectedCommands.add("-Dyarn.app.container.log.dir=<LOG_DIR>");
        expectedCommands.add("-Dtez.root.logger=INFO,CLA");
        for (i = 3; i < testInfo.numTasks; ++i) {
            containerContext = vertexWrapper.vertex.getContainerContext(i);
            javaOpts = containerContext.getJavaOpts();
            Assert.assertTrue((boolean)javaOpts.contains(testInfo.initialJavaOpts));
            for (String expectedCmd : expectedCommands) {
                Assert.assertTrue((boolean)javaOpts.contains(expectedCmd));
            }
            env = containerContext.getEnvironment();
            val = (String)env.get(testInfo.envKey);
            Assert.assertEquals((Object)testInfo.envVal, (Object)val);
            logEnvVal = (String)env.get("TEZ_CONTAINER_LOG_PARAMS");
            Assert.assertNull((Object)logEnvVal);
        }
        expectedCommands = new LinkedList();
        expectedCommands.add("-Dlog4j.configuratorClass=org.apache.tez.common.TezLog4jConfigurator");
        expectedCommands.add("-Dlog4j.configuration=tez-container-log4j.properties");
        expectedCommands.add("-Dyarn.app.container.log.dir=<LOG_DIR>");
        expectedCommands.add("-Dtez.root.logger=DEBUG,CLA");
        for (i = 0; i < 3; ++i) {
            containerContext = vertexWrapper.vertex.getContainerContext(i);
            javaOpts = containerContext.getJavaOpts();
            Assert.assertTrue((boolean)javaOpts.contains(testInfo.initialJavaOpts));
            for (String expectedCmd : expectedCommands) {
                Assert.assertTrue((boolean)javaOpts.contains(expectedCmd));
            }
            env = containerContext.getEnvironment();
            val = (String)env.get(testInfo.envKey);
            Assert.assertEquals((Object)testInfo.envVal, (Object)val);
            logEnvVal = (String)env.get("TEZ_CONTAINER_LOG_PARAMS");
            Assert.assertEquals((Object)"org.apache.tez=INFO", (Object)logEnvVal);
        }
    }

    @Test(timeout=5000L)
    public void testTaskSpecificLoggingOpts2() {
        String logEnvVal;
        String val;
        Object env;
        String javaOpts;
        ContainerContext containerContext;
        int i;
        String vertexName = "testvertex";
        String customJavaOpts = "-Xmx128m";
        TezConfiguration conf = new TezConfiguration();
        conf.set("tez.task.log.level", "WARN;org.apache.tez=INFO");
        conf.set("tez.task-specific.launch.cmd-opts.list", vertexName + "[0,1,2]");
        conf.set("tez.task-specific.log.level", "DEBUG");
        conf.set("tez.task-specific.launch.cmd-opts", customJavaOpts);
        LogTestInfoHolder testInfo = new LogTestInfoHolder();
        VertexWrapper vertexWrapper = this.createVertexWrapperForLogTests(testInfo, (Configuration)conf);
        LinkedList<String> expectedCommands = new LinkedList<String>();
        expectedCommands.add("-Dlog4j.configuratorClass=org.apache.tez.common.TezLog4jConfigurator");
        expectedCommands.add("-Dlog4j.configuration=tez-container-log4j.properties");
        expectedCommands.add("-Dyarn.app.container.log.dir=<LOG_DIR>");
        expectedCommands.add("-Dtez.root.logger=WARN,CLA");
        for (i = 3; i < testInfo.numTasks; ++i) {
            containerContext = vertexWrapper.vertex.getContainerContext(i);
            javaOpts = containerContext.getJavaOpts();
            Assert.assertTrue((boolean)javaOpts.contains(testInfo.initialJavaOpts));
            for (String expectedCmd : expectedCommands) {
                Assert.assertTrue((boolean)javaOpts.contains(expectedCmd));
            }
            env = containerContext.getEnvironment();
            val = (String)env.get(testInfo.envKey);
            Assert.assertEquals((Object)testInfo.envVal, (Object)val);
            logEnvVal = (String)env.get("TEZ_CONTAINER_LOG_PARAMS");
            Assert.assertEquals((Object)"org.apache.tez=INFO", (Object)logEnvVal);
        }
        expectedCommands = new LinkedList();
        expectedCommands.add("-Dlog4j.configuratorClass=org.apache.tez.common.TezLog4jConfigurator");
        expectedCommands.add("-Dlog4j.configuration=tez-container-log4j.properties");
        expectedCommands.add("-Dyarn.app.container.log.dir=<LOG_DIR>");
        expectedCommands.add("-Dtez.root.logger=DEBUG,CLA");
        for (i = 0; i < 3; ++i) {
            containerContext = vertexWrapper.vertex.getContainerContext(i);
            javaOpts = containerContext.getJavaOpts();
            Assert.assertTrue((boolean)javaOpts.contains(testInfo.initialJavaOpts));
            for (String expectedCmd : expectedCommands) {
                Assert.assertTrue((boolean)javaOpts.contains(expectedCmd));
            }
            env = containerContext.getEnvironment();
            val = (String)env.get(testInfo.envKey);
            Assert.assertEquals((Object)testInfo.envVal, (Object)val);
            logEnvVal = (String)env.get("TEZ_CONTAINER_LOG_PARAMS");
            Assert.assertNull((Object)logEnvVal);
        }
    }

    @Test(timeout=5000L)
    public void testNullExecutionContexts() {
        ExecutionContextTestInfoHolder info = new ExecutionContextTestInfoHolder(null, null);
        VertexWrapper vertexWrapper = this.createVertexWrapperForExecutionContextTest(info);
        Assert.assertEquals((long)0L, (long)vertexWrapper.vertex.taskSchedulerIdentifier);
        Assert.assertEquals((long)0L, (long)vertexWrapper.vertex.containerLauncherIdentifier);
        Assert.assertEquals((long)0L, (long)vertexWrapper.vertex.taskCommunicatorIdentifier);
    }

    @Test(timeout=5000L)
    public void testDefaultExecContextViaDag() {
        Vertex.VertexExecutionContext defaultExecContext = Vertex.VertexExecutionContext.create((String)ExecutionContextTestInfoHolder.append("TASK_SCHEDULER", 0), (String)ExecutionContextTestInfoHolder.append("CONTAINER_LAUNCHER", 2), (String)ExecutionContextTestInfoHolder.append("TASK_COMMUNICATOR", 2));
        ExecutionContextTestInfoHolder info = new ExecutionContextTestInfoHolder(null, defaultExecContext, 3);
        VertexWrapper vertexWrapper = this.createVertexWrapperForExecutionContextTest(info);
        Assert.assertEquals((long)0L, (long)vertexWrapper.vertex.taskSchedulerIdentifier);
        Assert.assertEquals((long)2L, (long)vertexWrapper.vertex.containerLauncherIdentifier);
        Assert.assertEquals((long)2L, (long)vertexWrapper.vertex.taskCommunicatorIdentifier);
    }

    @Test(timeout=5000L)
    public void testVertexExecutionContextOnly() {
        Vertex.VertexExecutionContext vertexExecutionContext = Vertex.VertexExecutionContext.create((String)ExecutionContextTestInfoHolder.append("TASK_SCHEDULER", 1), (String)ExecutionContextTestInfoHolder.append("CONTAINER_LAUNCHER", 1), (String)ExecutionContextTestInfoHolder.append("TASK_COMMUNICATOR", 1));
        ExecutionContextTestInfoHolder info = new ExecutionContextTestInfoHolder(vertexExecutionContext, null, 3);
        VertexWrapper vertexWrapper = this.createVertexWrapperForExecutionContextTest(info);
        Assert.assertEquals((long)1L, (long)vertexWrapper.vertex.taskSchedulerIdentifier);
        Assert.assertEquals((long)1L, (long)vertexWrapper.vertex.containerLauncherIdentifier);
        Assert.assertEquals((long)1L, (long)vertexWrapper.vertex.taskCommunicatorIdentifier);
    }

    @Test(timeout=5000L)
    public void testVertexExecutionContextOverride() {
        Vertex.VertexExecutionContext defaultExecContext = Vertex.VertexExecutionContext.create((String)ExecutionContextTestInfoHolder.append("TASK_SCHEDULER", 0), (String)ExecutionContextTestInfoHolder.append("CONTAINER_LAUNCHER", 2), (String)ExecutionContextTestInfoHolder.append("TASK_COMMUNICATOR", 2));
        Vertex.VertexExecutionContext vertexExecutionContext = Vertex.VertexExecutionContext.create((String)ExecutionContextTestInfoHolder.append("TASK_SCHEDULER", 1), (String)ExecutionContextTestInfoHolder.append("CONTAINER_LAUNCHER", 1), (String)ExecutionContextTestInfoHolder.append("TASK_COMMUNICATOR", 1));
        ExecutionContextTestInfoHolder info = new ExecutionContextTestInfoHolder(vertexExecutionContext, defaultExecContext, 3);
        VertexWrapper vertexWrapper = this.createVertexWrapperForExecutionContextTest(info);
        Assert.assertEquals((long)1L, (long)vertexWrapper.vertex.taskSchedulerIdentifier);
        Assert.assertEquals((long)1L, (long)vertexWrapper.vertex.containerLauncherIdentifier);
        Assert.assertEquals((long)1L, (long)vertexWrapper.vertex.taskCommunicatorIdentifier);
    }

    private VertexWrapper createVertexWrapperForExecutionContextTest(ExecutionContextTestInfoHolder vertexInfo) {
        DAGProtos.VertexPlan vertexPlan = this.createVertexPlanForExeuctionContextTests(vertexInfo);
        VertexWrapper vertexWrapper = new VertexWrapper(vertexInfo.appContext, vertexPlan, new Configuration(false), true);
        return vertexWrapper;
    }

    private DAGProtos.VertexPlan createVertexPlanForExeuctionContextTests(ExecutionContextTestInfoHolder info) {
        DAGProtos.ConfigurationProto confProto = DAGProtos.ConfigurationProto.newBuilder().addConfKeyValues(DAGProtos.PlanKeyValuePair.newBuilder().setKey("foo").setValue("bar").build()).addConfKeyValues(DAGProtos.PlanKeyValuePair.newBuilder().setKey("foo1").setValue("bar2").build()).build();
        DAGProtos.VertexPlan.Builder vertexPlanBuilder = DAGProtos.VertexPlan.newBuilder().setName(info.vertexName).setVertexConf(confProto).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(10).setJavaOpts("dontcare").setMemoryMb(1024).setVirtualCores(1).setTaskModule("taskmodule").build()).setType(DAGProtos.PlanVertexType.NORMAL);
        if (info.vertexExecutionContext != null) {
            vertexPlanBuilder.setExecutionContext(DagTypeConverters.convertToProto((Vertex.VertexExecutionContext)info.vertexExecutionContext));
        }
        return vertexPlanBuilder.build();
    }

    private VertexWrapper createVertexWrapperForLogTests(LogTestInfoHolder logTestInfoHolder, Configuration conf) {
        DAGProtos.VertexPlan vertexPlan = this.createVertexPlanForLogTests(logTestInfoHolder);
        VertexWrapper vertexWrapper = new VertexWrapper(vertexPlan, conf);
        return vertexWrapper;
    }

    private DAGProtos.VertexPlan createVertexPlanForLogTests(LogTestInfoHolder logTestInfoHolder) {
        DAGProtos.VertexPlan vertexPlan = DAGProtos.VertexPlan.newBuilder().setName(logTestInfoHolder.vertexName).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setJavaOpts(logTestInfoHolder.initialJavaOpts).setNumTasks(logTestInfoHolder.numTasks).setMemoryMb(1024).setVirtualCores(1).setTaskModule("taskmodule").addEnvironmentSetting(DAGProtos.PlanKeyValuePair.newBuilder().setKey(logTestInfoHolder.envKey).setValue(logTestInfoHolder.envVal).build()).build()).setType(DAGProtos.PlanVertexType.NORMAL).build();
        return vertexPlan;
    }

    private static AppContext createDefaultMockAppContext() {
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        DAG mockDag = (DAG)Mockito.mock(DAG.class);
        ((DAG)Mockito.doReturn((Object)new Credentials()).when((Object)mockDag)).getCredentials();
        ((AppContext)Mockito.doReturn((Object)mockDag).when((Object)appContext)).getCurrentDAG();
        return appContext;
    }

    private static class LogTestInfoHolder {
        final int numTasks = 10;
        final String initialJavaOpts = "initialJavaOpts";
        final String envKey = "key1";
        final String envVal = "val1";
        final String vertexName;

        public LogTestInfoHolder() {
            this("testvertex");
        }

        public LogTestInfoHolder(String vertexName) {
            this.vertexName = vertexName;
        }
    }

    private static class VertexWrapper {
        final AppContext mockAppContext;
        final VertexImpl vertex;
        final DAGProtos.VertexPlan vertexPlan;

        VertexWrapper(AppContext appContext, DAGProtos.VertexPlan vertexPlan, Configuration conf, boolean checkVertexOnlyConf) {
            if (appContext == null) {
                this.mockAppContext = TestVertexImpl2.createDefaultMockAppContext();
                DAG mockDag = (DAG)Mockito.mock(DAG.class);
                ((DAG)Mockito.doReturn((Object)new Credentials()).when((Object)mockDag)).getCredentials();
                ((AppContext)Mockito.doReturn((Object)mockDag).when((Object)this.mockAppContext)).getCurrentDAG();
            } else {
                this.mockAppContext = appContext;
            }
            Configuration dagConf = new Configuration(false);
            dagConf.set("abc1", "xyz1");
            dagConf.set("foo1", "bar1");
            this.vertexPlan = vertexPlan;
            this.vertex = new VertexImpl(TezVertexID.fromString((String)"vertex_1418197758681_0001_1_00"), vertexPlan, "testvertex", conf, (EventHandler)Mockito.mock(EventHandler.class), (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), (Clock)Mockito.mock(Clock.class), (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), false, this.mockAppContext, VertexLocationHint.create(new LinkedList()), null, new TaskSpecificLaunchCmdOption(conf), (StateChangeNotifier)Mockito.mock(StateChangeNotifier.class), dagConf);
            if (checkVertexOnlyConf) {
                Assert.assertEquals((Object)"xyz1", (Object)this.vertex.vertexOnlyConf.get("abc1"));
                Assert.assertEquals((Object)"bar2", (Object)this.vertex.vertexOnlyConf.get("foo1"));
                Assert.assertEquals((Object)"bar", (Object)this.vertex.vertexOnlyConf.get("foo"));
            }
        }

        VertexWrapper(DAGProtos.VertexPlan vertexPlan, Configuration conf) {
            this(null, vertexPlan, conf, false);
        }
    }

    private static class ExecutionContextTestInfoHolder {
        static final String TASK_SCHEDULER_NAME_BASE = "TASK_SCHEDULER";
        static final String CONTAINER_LAUNCHER_NAME_BASE = "CONTAINER_LAUNCHER";
        static final String TASK_COMM_NAME_BASE = "TASK_COMMUNICATOR";
        final String vertexName;
        final Vertex.VertexExecutionContext defaultExecutionContext;
        final Vertex.VertexExecutionContext vertexExecutionContext;
        final BiMap<String, Integer> taskSchedulers = HashBiMap.create();
        final BiMap<String, Integer> containerLaunchers = HashBiMap.create();
        final BiMap<String, Integer> taskComms = HashBiMap.create();
        final AppContext appContext;

        static String append(String base, int index) {
            return base + index;
        }

        public ExecutionContextTestInfoHolder(Vertex.VertexExecutionContext vertexExecutionContext, Vertex.VertexExecutionContext defaultDagExecutionContext) {
            this(vertexExecutionContext, defaultDagExecutionContext, 0);
        }

        public ExecutionContextTestInfoHolder(Vertex.VertexExecutionContext vertexExecutionContext, Vertex.VertexExecutionContext defaultDagExecitionContext, int numPlugins) {
            this.vertexName = "testvertex";
            this.vertexExecutionContext = vertexExecutionContext;
            this.defaultExecutionContext = defaultDagExecitionContext;
            if (numPlugins == 0) {
                UserPayload defaultPayload;
                try {
                    defaultPayload = TezUtils.createUserPayloadFromConf((Configuration)new Configuration(false));
                }
                catch (IOException e) {
                    throw new TezUncheckedException((Throwable)e);
                }
                DAGAppMaster.parsePlugin((List)Lists.newLinkedList(), this.taskSchedulers, null, (boolean)true, (boolean)false, (UserPayload)defaultPayload);
                DAGAppMaster.parsePlugin((List)Lists.newLinkedList(), this.containerLaunchers, null, (boolean)true, (boolean)false, (UserPayload)defaultPayload);
                DAGAppMaster.parsePlugin((List)Lists.newLinkedList(), this.taskComms, null, (boolean)true, (boolean)false, (UserPayload)defaultPayload);
            } else {
                LinkedList<DAGProtos.TezNamedEntityDescriptorProto> schedulerList = new LinkedList<DAGProtos.TezNamedEntityDescriptorProto>();
                LinkedList<DAGProtos.TezNamedEntityDescriptorProto> launcherList = new LinkedList<DAGProtos.TezNamedEntityDescriptorProto>();
                LinkedList<DAGProtos.TezNamedEntityDescriptorProto> taskCommList = new LinkedList<DAGProtos.TezNamedEntityDescriptorProto>();
                for (int i = 0; i < numPlugins; ++i) {
                    schedulerList.add(DAGProtos.TezNamedEntityDescriptorProto.newBuilder().setName(ExecutionContextTestInfoHolder.append(TASK_SCHEDULER_NAME_BASE, i)).setEntityDescriptor(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName(ExecutionContextTestInfoHolder.append(TASK_SCHEDULER_NAME_BASE, i))).build());
                    launcherList.add(DAGProtos.TezNamedEntityDescriptorProto.newBuilder().setName(ExecutionContextTestInfoHolder.append(CONTAINER_LAUNCHER_NAME_BASE, i)).setEntityDescriptor(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName(ExecutionContextTestInfoHolder.append(CONTAINER_LAUNCHER_NAME_BASE, i))).build());
                    taskCommList.add(DAGProtos.TezNamedEntityDescriptorProto.newBuilder().setName(ExecutionContextTestInfoHolder.append(TASK_COMM_NAME_BASE, i)).setEntityDescriptor(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName(ExecutionContextTestInfoHolder.append(TASK_COMM_NAME_BASE, i))).build());
                }
                DAGAppMaster.parsePlugin((List)Lists.newLinkedList(), this.taskSchedulers, schedulerList, (boolean)false, (boolean)false, null);
                DAGAppMaster.parsePlugin((List)Lists.newLinkedList(), this.containerLaunchers, launcherList, (boolean)false, (boolean)false, null);
                DAGAppMaster.parsePlugin((List)Lists.newLinkedList(), this.taskComms, taskCommList, (boolean)false, (boolean)false, null);
            }
            this.appContext = TestVertexImpl2.createDefaultMockAppContext();
            DAG dag = this.appContext.getCurrentDAG();
            ((DAG)Mockito.doReturn((Object)defaultDagExecitionContext).when((Object)dag)).getDefaultExecutionContext();
            for (Map.Entry entry : this.taskSchedulers.entrySet()) {
                ((AppContext)Mockito.doReturn(entry.getKey()).when((Object)this.appContext)).getTaskSchedulerName(((Integer)entry.getValue()).intValue());
                ((AppContext)Mockito.doReturn(entry.getValue()).when((Object)this.appContext)).getTaskScheduerIdentifier((String)entry.getKey());
            }
            for (Map.Entry entry : this.containerLaunchers.entrySet()) {
                ((AppContext)Mockito.doReturn(entry.getKey()).when((Object)this.appContext)).getContainerLauncherName(((Integer)entry.getValue()).intValue());
                ((AppContext)Mockito.doReturn(entry.getValue()).when((Object)this.appContext)).getContainerLauncherIdentifier((String)entry.getKey());
            }
            for (Map.Entry entry : this.taskComms.entrySet()) {
                ((AppContext)Mockito.doReturn(entry.getKey()).when((Object)this.appContext)).getTaskCommunicatorName(((Integer)entry.getValue()).intValue());
                ((AppContext)Mockito.doReturn(entry.getValue()).when((Object)this.appContext)).getTaskCommunicatorIdentifier((String)entry.getKey());
            }
        }
    }
}

