/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.MonotonicClock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.tez.common.ContainerSignatureMatcher;
import org.apache.tez.common.MockDNSToSwitchMapping;
import org.apache.tez.common.counters.DAGCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.TaskLocationHint;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezConstants;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ClusterInfo;
import org.apache.tez.dag.app.ContainerContext;
import org.apache.tez.dag.app.ContainerHeartbeatHandler;
import org.apache.tez.dag.app.MockClock;
import org.apache.tez.dag.app.TaskCommunicatorManagerInterface;
import org.apache.tez.dag.app.TaskCommunicatorWrapper;
import org.apache.tez.dag.app.TaskHeartbeatHandler;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.app.dag.TaskAttemptStateInternal;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.event.DAGEvent;
import org.apache.tez.dag.app.dag.event.DAGEventCounterUpdate;
import org.apache.tez.dag.app.dag.event.DAGEventType;
import org.apache.tez.dag.app.dag.event.SpeculatorEventTaskAttemptStatusUpdate;
import org.apache.tez.dag.app.dag.event.TaskAttemptEvent;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventAttemptFailed;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventContainerTerminated;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventContainerTerminating;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventKillRequest;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventNodeFailed;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventOutputFailed;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventSchedule;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventStartedRemotely;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventStatusUpdate;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventSubmitted;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventTezEventUpdate;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventType;
import org.apache.tez.dag.app.dag.event.TaskEvent;
import org.apache.tez.dag.app.dag.event.TaskEventTAFailed;
import org.apache.tez.dag.app.dag.event.TaskEventTAKilled;
import org.apache.tez.dag.app.dag.event.TaskEventTASucceeded;
import org.apache.tez.dag.app.dag.event.TaskEventTAUpdate;
import org.apache.tez.dag.app.dag.event.TaskEventType;
import org.apache.tez.dag.app.dag.impl.DAGImpl;
import org.apache.tez.dag.app.dag.impl.ServicePluginInfo;
import org.apache.tez.dag.app.dag.impl.TaskAttemptImpl;
import org.apache.tez.dag.app.dag.impl.TezContainer;
import org.apache.tez.dag.app.dag.impl.VertexImpl;
import org.apache.tez.dag.app.rm.AMSchedulerEventTAEnded;
import org.apache.tez.dag.app.rm.AMSchedulerEventTALaunchRequest;
import org.apache.tez.dag.app.rm.container.AMContainerMap;
import org.apache.tez.dag.app.rm.container.ContainerContextMatcher;
import org.apache.tez.dag.app.rm.node.AMNodeTracker;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.HistoryEventHandler;
import org.apache.tez.dag.history.events.TaskAttemptFinishedEvent;
import org.apache.tez.dag.records.TaskAttemptTerminationCause;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.dag.utils.TezBuilderUtils;
import org.apache.tez.runtime.api.TaskFailureType;
import org.apache.tez.runtime.api.events.InputReadErrorEvent;
import org.apache.tez.runtime.api.events.TaskStatusUpdateEvent;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.serviceplugins.api.ServicePluginException;
import org.apache.tez.serviceplugins.api.TaskCommunicator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestTaskAttempt {
    AppContext appCtx;
    TezConfiguration vertexConf = new TezConfiguration();
    TaskLocationHint locationHint;
    Vertex mockVertex;
    Task mockTask;
    ServicePluginInfo servicePluginInfo = new ServicePluginInfo().setContainerLauncherName(TezConstants.getTezYarnServicePluginName());

    @BeforeClass
    public static void setup() {
        MockDNSToSwitchMapping.initializeMockRackResolver();
    }

    @Before
    public void setupTest() {
        this.appCtx = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)this.appCtx.getAMConf()).thenReturn((Object)new Configuration());
        Mockito.when((Object)this.appCtx.getContainerLauncherName(Mockito.anyInt())).thenReturn((Object)TezConstants.getTezYarnServicePluginName());
        this.createMockVertex((Configuration)this.vertexConf);
        this.mockTask = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)this.mockTask.getVertex()).thenReturn((Object)this.mockVertex);
        HistoryEventHandler mockHistHandler = (HistoryEventHandler)Mockito.mock(HistoryEventHandler.class);
        ((AppContext)Mockito.doReturn((Object)mockHistHandler).when((Object)this.appCtx)).getHistoryHandler();
        LogManager.getRootLogger().setLevel(Level.DEBUG);
    }

    private void createMockVertex(Configuration conf) {
        this.mockVertex = (Vertex)Mockito.mock(Vertex.class);
        Mockito.when((Object)this.mockVertex.getDownstreamBlamingHosts()).thenReturn((Object)Maps.newHashMap());
        Mockito.when((Object)this.mockVertex.getServicePluginInfo()).thenReturn((Object)this.servicePluginInfo);
        Mockito.when((Object)this.mockVertex.getVertexConfig()).thenReturn((Object)new VertexImpl.VertexConfigImpl(conf));
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)appContext.getTaskScheduerIdentifier(Mockito.anyString())).thenReturn((Object)0);
        Mockito.when((Object)this.mockVertex.getAppContext()).thenReturn((Object)appContext);
        AMNodeTracker nodeTracker = (AMNodeTracker)Mockito.mock(AMNodeTracker.class);
        Mockito.when((Object)nodeTracker.getNumNodes(Mockito.anyInt())).thenReturn((Object)10);
        Mockito.when((Object)nodeTracker.getNumActiveNodes(Mockito.anyInt())).thenReturn((Object)8);
        Mockito.when((Object)appContext.getNodeTracker()).thenReturn((Object)nodeTracker);
    }

    @Test(timeout=5000L)
    public void testLocalityRequest() {
        TaskAttemptImpl.ScheduleTaskattemptTransition sta = new TaskAttemptImpl.ScheduleTaskattemptTransition();
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        TreeSet<String> hosts = new TreeSet<String>();
        hosts.add("host1");
        hosts.add("host2");
        hosts.add("host3");
        this.locationHint = TaskLocationHint.createTaskLocationHint(hosts, null);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((String)"1", (int)1, (int)1), (int)1), (int)1);
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), new Configuration(), (Clock)new SystemClock(), (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), this.appCtx, false, Resource.newInstance((int)1024, (int)1), TestTaskAttempt.createFakeContainerContext(), false);
        TaskAttemptEventSchedule sEvent = (TaskAttemptEventSchedule)Mockito.mock(TaskAttemptEventSchedule.class);
        sta.transition((TaskAttemptImpl)taImpl, (TaskAttemptEvent)sEvent);
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)1))).handle((Event)arg.capture());
        if (!(arg.getAllValues().get(0) instanceof AMSchedulerEventTALaunchRequest)) {
            Assert.fail((String)("Second event not of type " + AMSchedulerEventTALaunchRequest.class.getName()));
        }
        Set requestedRacks = taImpl.taskRacks;
        Assert.assertEquals((long)1L, (long)requestedRacks.size());
        Assert.assertEquals((long)3L, (long)taImpl.taskHosts.size());
        for (int i = 0; i < 3; ++i) {
            String host = "host" + (i + 1);
            Assert.assertEquals((String)host, (Object)true, (Object)taImpl.taskHosts.contains(host));
        }
    }

    @Test(timeout=5000L)
    public void testRetriesAtSamePriorityConfig() {
        TezConfiguration vertexConf = new TezConfiguration();
        vertexConf.setBoolean("tez.am.task.reschedule.higher.priority", false);
        vertexConf.setBoolean("tez.am.task.reschedule.relaxed.locality", true);
        Mockito.when((Object)this.mockVertex.getVertexConfig()).thenReturn((Object)new VertexImpl.VertexConfigImpl((Configuration)vertexConf));
        TreeSet<String> hosts = new TreeSet<String>();
        hosts.add("host1");
        this.locationHint = TaskLocationHint.createTaskLocationHint(hosts, null);
        TaskAttemptImpl.ScheduleTaskattemptTransition sta = new TaskAttemptImpl.ScheduleTaskattemptTransition();
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((String)"1", (int)1, (int)1), (int)1), (int)1);
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), new Configuration(), (Clock)new SystemClock(), (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), this.appCtx, false, Resource.newInstance((int)1024, (int)1), TestTaskAttempt.createFakeContainerContext(), false);
        MockTaskAttemptImpl taImplReScheduled = new MockTaskAttemptImpl(taskID, 1, eventHandler, (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), new Configuration(), (Clock)new SystemClock(), (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), this.appCtx, true, Resource.newInstance((int)1024, (int)1), TestTaskAttempt.createFakeContainerContext(), false);
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        TaskAttemptEventSchedule sEvent = (TaskAttemptEventSchedule)Mockito.mock(TaskAttemptEventSchedule.class);
        Mockito.when((Object)sEvent.getPriorityLowLimit()).thenReturn((Object)3);
        Mockito.when((Object)sEvent.getPriorityHighLimit()).thenReturn((Object)1);
        sta.transition((TaskAttemptImpl)taImpl, (TaskAttemptEvent)sEvent);
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)1))).handle((Event)arg.capture());
        AMSchedulerEventTALaunchRequest launchEvent = (AMSchedulerEventTALaunchRequest)arg.getValue();
        Assert.assertEquals((long)2L, (long)launchEvent.getPriority());
        Assert.assertEquals((long)1L, (long)launchEvent.getLocationHint().getHosts().size());
        Assert.assertTrue((boolean)launchEvent.getLocationHint().getHosts().contains("host1"));
        sta.transition((TaskAttemptImpl)taImplReScheduled, (TaskAttemptEvent)sEvent);
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)2))).handle((Event)arg.capture());
        launchEvent = (AMSchedulerEventTALaunchRequest)arg.getValue();
        Assert.assertEquals((long)2L, (long)launchEvent.getPriority());
        Assert.assertNull((Object)launchEvent.getLocationHint());
    }

    @Test(timeout=5000L)
    public void testPriority() {
        TaskAttemptImpl.ScheduleTaskattemptTransition sta = new TaskAttemptImpl.ScheduleTaskattemptTransition();
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((String)"1", (int)1, (int)1), (int)1), (int)1);
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), new Configuration(), (Clock)new SystemClock(), (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), this.appCtx, false, Resource.newInstance((int)1024, (int)1), TestTaskAttempt.createFakeContainerContext(), false);
        MockTaskAttemptImpl taImplReScheduled = new MockTaskAttemptImpl(taskID, 1, eventHandler, (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), new Configuration(), (Clock)new SystemClock(), (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), this.appCtx, true, Resource.newInstance((int)1024, (int)1), TestTaskAttempt.createFakeContainerContext(), false);
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        TaskAttemptEventSchedule sEvent = (TaskAttemptEventSchedule)Mockito.mock(TaskAttemptEventSchedule.class);
        Mockito.when((Object)sEvent.getPriorityLowLimit()).thenReturn((Object)3);
        Mockito.when((Object)sEvent.getPriorityHighLimit()).thenReturn((Object)1);
        sta.transition((TaskAttemptImpl)taImpl, (TaskAttemptEvent)sEvent);
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)1))).handle((Event)arg.capture());
        AMSchedulerEventTALaunchRequest launchEvent = (AMSchedulerEventTALaunchRequest)arg.getValue();
        Assert.assertEquals((long)2L, (long)launchEvent.getPriority());
        sta.transition((TaskAttemptImpl)taImplReScheduled, (TaskAttemptEvent)sEvent);
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)2))).handle((Event)arg.capture());
        launchEvent = (AMSchedulerEventTALaunchRequest)arg.getValue();
        Assert.assertEquals((long)1L, (long)launchEvent.getPriority());
        Mockito.when((Object)sEvent.getPriorityLowLimit()).thenReturn((Object)6);
        Mockito.when((Object)sEvent.getPriorityHighLimit()).thenReturn((Object)4);
        sta.transition((TaskAttemptImpl)taImpl, (TaskAttemptEvent)sEvent);
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)3))).handle((Event)arg.capture());
        launchEvent = (AMSchedulerEventTALaunchRequest)arg.getValue();
        Assert.assertEquals((long)5L, (long)launchEvent.getPriority());
        sta.transition((TaskAttemptImpl)taImplReScheduled, (TaskAttemptEvent)sEvent);
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)4))).handle((Event)arg.capture());
        launchEvent = (AMSchedulerEventTALaunchRequest)arg.getValue();
        Assert.assertEquals((long)4L, (long)launchEvent.getPriority());
        Mockito.when((Object)sEvent.getPriorityLowLimit()).thenReturn((Object)5);
        Mockito.when((Object)sEvent.getPriorityHighLimit()).thenReturn((Object)5);
        sta.transition((TaskAttemptImpl)taImpl, (TaskAttemptEvent)sEvent);
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)5))).handle((Event)arg.capture());
        launchEvent = (AMSchedulerEventTALaunchRequest)arg.getValue();
        Assert.assertEquals((long)5L, (long)launchEvent.getPriority());
        sta.transition((TaskAttemptImpl)taImplReScheduled, (TaskAttemptEvent)sEvent);
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)6))).handle((Event)arg.capture());
        launchEvent = (AMSchedulerEventTALaunchRequest)arg.getValue();
        Assert.assertEquals((long)5L, (long)launchEvent.getPriority());
    }

    @Test(timeout=5000L)
    public void testHostResolveAttempt() throws Exception {
        TaskAttemptImpl.ScheduleTaskattemptTransition sta = new TaskAttemptImpl.ScheduleTaskattemptTransition();
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        String[] hosts = new String[]{"127.0.0.1", "host2", "host3"};
        TreeSet<String> resolved = new TreeSet<String>(Arrays.asList("host1", "host2", "host3"));
        this.locationHint = TaskLocationHint.createTaskLocationHint(new TreeSet<String>(Arrays.asList(hosts)), null);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((String)"1", (int)1, (int)1), (int)1), (int)1);
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), new Configuration(), (Clock)new SystemClock(), (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), this.appCtx, false, Resource.newInstance((int)1024, (int)1), TestTaskAttempt.createFakeContainerContext(), false);
        TaskAttemptImpl spyTa = (TaskAttemptImpl)Mockito.spy((Object)((Object)taImpl));
        Mockito.when((Object)spyTa.resolveHosts(hosts)).thenReturn((Object)resolved.toArray(new String[3]));
        TaskAttemptEventSchedule mockTAEvent = (TaskAttemptEventSchedule)Mockito.mock(TaskAttemptEventSchedule.class);
        sta.transition(spyTa, (TaskAttemptEvent)mockTAEvent);
        ((TaskAttemptImpl)Mockito.verify((Object)spyTa)).resolveHosts(hosts);
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)1))).handle((Event)arg.capture());
        if (!(arg.getAllValues().get(0) instanceof AMSchedulerEventTALaunchRequest)) {
            Assert.fail((String)"Second Event not of type ContainerRequestEvent");
        }
        HashMap<String, Boolean> expected = new HashMap<String, Boolean>();
        expected.put("host1", true);
        expected.put("host2", true);
        expected.put("host3", true);
        Set requestedHosts = spyTa.taskHosts;
        for (String h : requestedHosts) {
            expected.remove(h);
        }
        Assert.assertEquals((long)0L, (long)expected.size());
    }

    @Test(timeout=5000L)
    public void testLaunchFailedWhileKilling() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        TezTaskAttemptID taskAttemptID = TezTaskAttemptID.getInstance((TezTaskID)taskID, (int)0);
        MockEventHandler eventHandler = new MockEventHandler();
        TaskCommunicatorManagerInterface taListener = this.createMockTaskAttemptListener();
        Configuration taskConf = new Configuration();
        taskConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        taskConf.setBoolean("fs.file.impl.disable.cache", true);
        this.locationHint = TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList("127.0.0.1")), null);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        AppContext mockAppContext = this.appCtx;
        ((AppContext)Mockito.doReturn((Object)new ClusterInfo()).when((Object)mockAppContext)).getClusterInfo();
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, taListener, taskConf, (Clock)new SystemClock(), (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), mockAppContext, false, resource, TestTaskAttempt.createFakeContainerContext(), false);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(taskAttemptID, 0, 0));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventKillRequest(taskAttemptID, null, TaskAttemptTerminationCause.TERMINATED_BY_CLIENT));
        Assert.assertEquals((Object)TaskAttemptStateInternal.KILL_IN_PROGRESS, (Object)taImpl.getInternalState());
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventTezEventUpdate(taImpl.getTaskAttemptID(), Collections.EMPTY_LIST));
        Assert.assertFalse((String)"InternalError occurred trying to handle TA_TEZ_EVENT_UPDATE in KILL_IN_PROGRESS state", (boolean)eventHandler.internalError);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventKillRequest(taskAttemptID, null, TaskAttemptTerminationCause.TERMINATED_BY_CLIENT));
        Assert.assertFalse((boolean)eventHandler.internalError);
    }

    @Test(timeout=5000L)
    public void testContainerTerminationWhileRunning() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        MockEventHandler eventHandler = (MockEventHandler)Mockito.spy((Object)new MockEventHandler());
        TaskCommunicatorManagerInterface taListener = this.createMockTaskAttemptListener();
        Configuration taskConf = new Configuration();
        taskConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        taskConf.setBoolean("fs.file.impl.disable.cache", true);
        this.locationHint = TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList("127.0.0.1")), null);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        AMContainerMap containers = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), this.appCtx);
        containers.addContainerIfNew(container, 0, 0, 0);
        ((AppContext)Mockito.doReturn((Object)new ClusterInfo()).when((Object)this.appCtx)).getClusterInfo();
        ((AppContext)Mockito.doReturn((Object)containers).when((Object)this.appCtx)).getAllContainers();
        TaskHeartbeatHandler mockHeartbeatHandler = (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class);
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, taListener, taskConf, (Clock)new SystemClock(), mockHeartbeatHandler, this.appCtx, false, resource, TestTaskAttempt.createFakeContainerContext(), false);
        TezTaskAttemptID taskAttemptID = taImpl.getTaskAttemptID();
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(taskAttemptID, 0, 0));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSubmitted(taskAttemptID, contId));
        Assert.assertEquals((String)"Task attempt is not in the STARTING state", (Object)taImpl.getState(), (Object)TaskAttemptState.STARTING);
        Assert.assertEquals((String)"Task attempt internal state is not at SUBMITTED", (Object)taImpl.getInternalState(), (Object)TaskAttemptStateInternal.SUBMITTED);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(taskAttemptID));
        Assert.assertEquals((String)"Task attempt is not in the RUNNING state", (Object)taImpl.getState(), (Object)TaskAttemptState.RUNNING);
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler)).register((Object)taskAttemptID);
        int expectedEventsAtRunning = 5;
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsAtRunning))).handle((Event)arg.capture());
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventContainerTerminating(taskAttemptID, "Terminating", TaskAttemptTerminationCause.APPLICATION_ERROR));
        Assert.assertFalse((String)"InternalError occurred trying to handle TA_CONTAINER_TERMINATING", (boolean)eventHandler.internalError);
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler)).unregister((Object)taskAttemptID);
        Assert.assertEquals((String)"Task attempt is not in the  FAILED state", (Object)taImpl.getState(), (Object)TaskAttemptState.FAILED);
        Assert.assertEquals((long)1L, (long)taImpl.getDiagnostics().size());
        Assert.assertEquals((Object)"Terminating", taImpl.getDiagnostics().get(0));
        Assert.assertEquals((Object)TaskAttemptTerminationCause.APPLICATION_ERROR, (Object)taImpl.getTerminationCause());
        int expectedEventsAfterTerminating = expectedEventsAtRunning + 3;
        arg = ArgumentCaptor.forClass(Event.class);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsAfterTerminating))).handle((Event)arg.capture());
        Event event = this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), TaskEventTAFailed.class, 1);
        TaskEventTAFailed failedEvent = (TaskEventTAFailed)event;
        Assert.assertEquals((Object)TaskFailureType.NON_FATAL, (Object)failedEvent.getTaskFailureType());
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), AMSchedulerEventTAEnded.class, 1);
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), DAGEventCounterUpdate.class, 1);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventContainerTerminated(contId, taskAttemptID, "Terminated", TaskAttemptTerminationCause.CONTAINER_EXITED));
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler, (VerificationMode)Mockito.times((int)1))).unregister((Object)taskAttemptID);
        int expectedEventAfterTerminated = expectedEventsAfterTerminating + 0;
        arg = ArgumentCaptor.forClass(Event.class);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventAfterTerminated))).handle((Event)arg.capture());
        Assert.assertEquals((long)2L, (long)taImpl.getDiagnostics().size());
        Assert.assertEquals((Object)"Terminated", taImpl.getDiagnostics().get(1));
        Assert.assertEquals((Object)TaskAttemptTerminationCause.APPLICATION_ERROR, (Object)taImpl.getTerminationCause());
    }

    @Test(timeout=5000L)
    public void testContainerTerminatedWhileRunning() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        MockEventHandler eventHandler = (MockEventHandler)Mockito.spy((Object)new MockEventHandler());
        TaskCommunicatorManagerInterface taListener = this.createMockTaskAttemptListener();
        Configuration taskConf = new Configuration();
        taskConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        taskConf.setBoolean("fs.file.impl.disable.cache", true);
        this.locationHint = TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList("127.0.0.1")), null);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        AMContainerMap containers = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), this.appCtx);
        containers.addContainerIfNew(container, 0, 0, 0);
        ((AppContext)Mockito.doReturn((Object)new ClusterInfo()).when((Object)this.appCtx)).getClusterInfo();
        ((AppContext)Mockito.doReturn((Object)containers).when((Object)this.appCtx)).getAllContainers();
        TaskHeartbeatHandler mockHeartbeatHandler = (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class);
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, taListener, taskConf, (Clock)new SystemClock(), mockHeartbeatHandler, this.appCtx, false, resource, TestTaskAttempt.createFakeContainerContext(), false);
        TezTaskAttemptID taskAttemptID = taImpl.getTaskAttemptID();
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(taskAttemptID, 0, 0));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSubmitted(taskAttemptID, contId));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(taskAttemptID));
        int expectedEventsAtRunning = 5;
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsAtRunning))).handle((Event)arg.capture());
        Assert.assertEquals((String)"Task attempt is not in running state", (Object)taImpl.getState(), (Object)TaskAttemptState.RUNNING);
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler)).register((Object)taskAttemptID);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventContainerTerminated(contId, taskAttemptID, "Terminated", TaskAttemptTerminationCause.CONTAINER_EXITED));
        Assert.assertFalse((String)"InternalError occurred trying to handle TA_CONTAINER_TERMINATED", (boolean)eventHandler.internalError);
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler)).unregister((Object)taskAttemptID);
        Assert.assertEquals((Object)"Terminated", taImpl.getDiagnostics().get(0));
        Assert.assertEquals((Object)TaskAttemptTerminationCause.CONTAINER_EXITED, (Object)taImpl.getTerminationCause());
        int expectedEventsAfterTerminating = expectedEventsAtRunning + 3;
        arg = ArgumentCaptor.forClass(Event.class);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsAfterTerminating))).handle((Event)arg.capture());
        Event event = this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), TaskEventTAFailed.class, 1);
        TaskEventTAFailed failedEvent = (TaskEventTAFailed)event;
        Assert.assertEquals((Object)TaskFailureType.NON_FATAL, (Object)failedEvent.getTaskFailureType());
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), AMSchedulerEventTAEnded.class, 1);
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), DAGEventCounterUpdate.class, 1);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventContainerTerminated(contId, taskAttemptID, "Terminated", TaskAttemptTerminationCause.CONTAINER_EXITED));
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler, (VerificationMode)Mockito.times((int)1))).unregister((Object)taskAttemptID);
        int expectedEventAfterTerminated = expectedEventsAfterTerminating + 0;
        arg = ArgumentCaptor.forClass(Event.class);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventAfterTerminated))).handle((Event)arg.capture());
    }

    @Test(timeout=5000L)
    public void testContainerTerminatedAfterSuccess() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        MockEventHandler eventHandler = (MockEventHandler)Mockito.spy((Object)new MockEventHandler());
        TaskCommunicatorManagerInterface taListener = this.createMockTaskAttemptListener();
        Configuration taskConf = new Configuration();
        taskConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        taskConf.setBoolean("fs.file.impl.disable.cache", true);
        this.locationHint = TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList("127.0.0.1")), null);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        AMContainerMap containers = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), this.appCtx);
        containers.addContainerIfNew(container, 0, 0, 0);
        ((AppContext)Mockito.doReturn((Object)new ClusterInfo()).when((Object)this.appCtx)).getClusterInfo();
        ((AppContext)Mockito.doReturn((Object)containers).when((Object)this.appCtx)).getAllContainers();
        TaskHeartbeatHandler mockHeartbeatHandler = (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class);
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, taListener, taskConf, (Clock)new SystemClock(), mockHeartbeatHandler, this.appCtx, false, resource, TestTaskAttempt.createFakeContainerContext(), false);
        TezTaskAttemptID taskAttemptID = taImpl.getTaskAttemptID();
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(taskAttemptID, 0, 0));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSubmitted(taskAttemptID, contId));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(taskAttemptID));
        Assert.assertEquals((String)"Task attempt is not in the RUNNING state", (Object)taImpl.getState(), (Object)TaskAttemptState.RUNNING);
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler)).register((Object)taskAttemptID);
        int expectedEventsAtRunning = 5;
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsAtRunning))).handle((Event)arg.capture());
        taImpl.handle(new TaskAttemptEvent(taskAttemptID, TaskAttemptEventType.TA_DONE));
        Assert.assertEquals((String)"Task attempt is not in the  SUCCEEDED state", (Object)taImpl.getState(), (Object)TaskAttemptState.SUCCEEDED);
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler)).unregister((Object)taskAttemptID);
        Assert.assertEquals((long)0L, (long)taImpl.getDiagnostics().size());
        int expectedEventsAfterTerminating = expectedEventsAtRunning + 3;
        arg = ArgumentCaptor.forClass(Event.class);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsAfterTerminating))).handle((Event)arg.capture());
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), TaskEventTASucceeded.class, 1);
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), AMSchedulerEventTAEnded.class, 1);
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), DAGEventCounterUpdate.class, 1);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventContainerTerminated(contId, taskAttemptID, "Terminated", TaskAttemptTerminationCause.CONTAINER_EXITED));
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler, (VerificationMode)Mockito.times((int)1))).unregister((Object)taskAttemptID);
        int expectedEventAfterTerminated = expectedEventsAfterTerminating + 0;
        arg = ArgumentCaptor.forClass(Event.class);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventAfterTerminated))).handle((Event)arg.capture());
        Assert.assertEquals((long)0L, (long)taImpl.getDiagnostics().size());
        Assert.assertEquals((Object)TaskAttemptTerminationCause.UNKNOWN_ERROR, (Object)taImpl.getTerminationCause());
    }

    @Test(timeout=5000L)
    public void testLastDataEventRecording() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        MockEventHandler eventHandler = (MockEventHandler)Mockito.spy((Object)new MockEventHandler());
        TaskCommunicatorManagerInterface taListener = this.createMockTaskAttemptListener();
        Configuration taskConf = new Configuration();
        taskConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        taskConf.setBoolean("fs.file.impl.disable.cache", true);
        taskConf.setBoolean("tez.am.speculation.enabled", true);
        this.locationHint = TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList("127.0.0.1")), null);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        AMContainerMap containers = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), this.appCtx);
        containers.addContainerIfNew(container, 0, 0, 0);
        ((AppContext)Mockito.doReturn((Object)new ClusterInfo()).when((Object)this.appCtx)).getClusterInfo();
        ((AppContext)Mockito.doReturn((Object)containers).when((Object)this.appCtx)).getAllContainers();
        TaskHeartbeatHandler mockHeartbeatHandler = (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class);
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, taListener, taskConf, (Clock)new SystemClock(), mockHeartbeatHandler, this.appCtx, false, resource, TestTaskAttempt.createFakeContainerContext(), false);
        TezTaskAttemptID taskAttemptID = taImpl.getTaskAttemptID();
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(taskAttemptID, 0, 0));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSubmitted(taskAttemptID, contId));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(taskAttemptID));
        Assert.assertEquals((String)"Task attempt is not in the RUNNING state", (Object)taImpl.getState(), (Object)TaskAttemptState.RUNNING);
        long ts1 = 1024L;
        long ts2 = 2048L;
        TezTaskAttemptID mockId1 = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        TezTaskAttemptID mockId2 = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        TezEvent mockTezEvent1 = (TezEvent)Mockito.mock(TezEvent.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockTezEvent1.getEventReceivedTime()).thenReturn((Object)ts1);
        Mockito.when((Object)mockTezEvent1.getSourceInfo().getTaskAttemptID()).thenReturn((Object)mockId1);
        TezEvent mockTezEvent2 = (TezEvent)Mockito.mock(TezEvent.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockTezEvent2.getEventReceivedTime()).thenReturn((Object)ts2);
        Mockito.when((Object)mockTezEvent2.getSourceInfo().getTaskAttemptID()).thenReturn((Object)mockId2);
        TaskAttemptEventStatusUpdate statusEvent = new TaskAttemptEventStatusUpdate(taskAttemptID, new TaskStatusUpdateEvent(null, 0.1f, null, false));
        Assert.assertEquals((long)0L, (long)taImpl.lastDataEvents.size());
        taImpl.setLastEventSent(mockTezEvent1);
        Assert.assertEquals((long)1L, (long)taImpl.lastDataEvents.size());
        Assert.assertEquals((long)ts1, (long)((TaskAttemptImpl.DataEventDependencyInfo)taImpl.lastDataEvents.get(0)).getTimestamp());
        Assert.assertEquals((Object)mockId1, (Object)((TaskAttemptImpl.DataEventDependencyInfo)taImpl.lastDataEvents.get(0)).getTaskAttemptId());
        taImpl.handle((TaskAttemptEvent)statusEvent);
        taImpl.setLastEventSent(mockTezEvent2);
        Assert.assertEquals((long)1L, (long)taImpl.lastDataEvents.size());
        Assert.assertEquals((long)ts2, (long)((TaskAttemptImpl.DataEventDependencyInfo)taImpl.lastDataEvents.get(0)).getTimestamp());
        Assert.assertEquals((Object)mockId2, (Object)((TaskAttemptImpl.DataEventDependencyInfo)taImpl.lastDataEvents.get(0)).getTaskAttemptId());
        statusEvent.setReadErrorReported(true);
        taImpl.handle((TaskAttemptEvent)statusEvent);
        taImpl.setLastEventSent(mockTezEvent1);
        Assert.assertEquals((long)2L, (long)taImpl.lastDataEvents.size());
        Assert.assertEquals((long)ts1, (long)((TaskAttemptImpl.DataEventDependencyInfo)taImpl.lastDataEvents.get(1)).getTimestamp());
        Assert.assertEquals((Object)mockId1, (Object)((TaskAttemptImpl.DataEventDependencyInfo)taImpl.lastDataEvents.get(1)).getTaskAttemptId());
        taImpl.setLastEventSent(mockTezEvent2);
        Assert.assertEquals((long)2L, (long)taImpl.lastDataEvents.size());
        Assert.assertEquals((long)ts2, (long)((TaskAttemptImpl.DataEventDependencyInfo)taImpl.lastDataEvents.get(1)).getTimestamp());
        Assert.assertEquals((Object)mockId2, (Object)((TaskAttemptImpl.DataEventDependencyInfo)taImpl.lastDataEvents.get(1)).getTaskAttemptId());
    }

    @Test(timeout=5000L)
    public void testFailure() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        MockEventHandler eventHandler = (MockEventHandler)Mockito.spy((Object)new MockEventHandler());
        TaskCommunicatorManagerInterface taListener = this.createMockTaskAttemptListener();
        Configuration taskConf = new Configuration();
        taskConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        taskConf.setBoolean("fs.file.impl.disable.cache", true);
        taskConf.setBoolean("tez.am.speculation.enabled", true);
        this.locationHint = TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList("127.0.0.1")), null);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        AMContainerMap containers = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), this.appCtx);
        containers.addContainerIfNew(container, 0, 0, 0);
        ((AppContext)Mockito.doReturn((Object)new ClusterInfo()).when((Object)this.appCtx)).getClusterInfo();
        ((AppContext)Mockito.doReturn((Object)containers).when((Object)this.appCtx)).getAllContainers();
        TaskHeartbeatHandler mockHeartbeatHandler = (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class);
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, taListener, taskConf, (Clock)new SystemClock(), mockHeartbeatHandler, this.appCtx, false, resource, TestTaskAttempt.createFakeContainerContext(), false);
        TezTaskAttemptID taskAttemptID = taImpl.getTaskAttemptID();
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(taskAttemptID, 0, 0));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSubmitted(taskAttemptID, contId));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(taskAttemptID));
        Assert.assertEquals((String)"Task attempt is not in the RUNNING state", (Object)taImpl.getState(), (Object)TaskAttemptState.RUNNING);
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler)).register((Object)taskAttemptID);
        int expectedEventsAtRunning = 6;
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsAtRunning))).handle((Event)arg.capture());
        this.verifyEventType(arg.getAllValues().subList(0, expectedEventsAtRunning), SpeculatorEventTaskAttemptStatusUpdate.class, 1);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStatusUpdate(taskAttemptID, new TaskStatusUpdateEvent(null, 0.1f, null, false)));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventAttemptFailed(taskAttemptID, TaskAttemptEventType.TA_FAILED, TaskFailureType.NON_FATAL, "0", TaskAttemptTerminationCause.APPLICATION_ERROR));
        Assert.assertEquals((String)"Task attempt is not in the  FAIL_IN_PROGRESS state", (Object)taImpl.getInternalState(), (Object)TaskAttemptStateInternal.FAIL_IN_PROGRESS);
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler)).unregister((Object)taskAttemptID);
        Assert.assertEquals((long)1L, (long)taImpl.getDiagnostics().size());
        Assert.assertEquals((Object)"0", taImpl.getDiagnostics().get(0));
        Assert.assertEquals((Object)TaskAttemptTerminationCause.APPLICATION_ERROR, (Object)taImpl.getTerminationCause());
        Assert.assertEquals((Object)TaskAttemptStateInternal.FAIL_IN_PROGRESS, (Object)taImpl.getInternalState());
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventTezEventUpdate(taImpl.getTaskAttemptID(), Collections.EMPTY_LIST));
        Assert.assertFalse((String)"InternalError occurred trying to handle TA_TEZ_EVENT_UPDATE in FAIL_IN_PROGRESS state", (boolean)eventHandler.internalError);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventContainerTerminated(contId, taskAttemptID, "1", TaskAttemptTerminationCause.CONTAINER_EXITED));
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler, (VerificationMode)Mockito.times((int)1))).unregister((Object)taskAttemptID);
        Assert.assertEquals((long)2L, (long)taImpl.getDiagnostics().size());
        Assert.assertEquals((Object)"1", taImpl.getDiagnostics().get(1));
        Assert.assertEquals((Object)TaskAttemptTerminationCause.APPLICATION_ERROR, (Object)taImpl.getTerminationCause());
        int expectedEventsAfterTerminating = expectedEventsAtRunning + 5;
        arg = ArgumentCaptor.forClass(Event.class);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsAfterTerminating))).handle((Event)arg.capture());
        Event e = this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), TaskEventTAFailed.class, 1);
        TaskEventTAFailed failedEvent = (TaskEventTAFailed)e;
        Assert.assertEquals((Object)TaskFailureType.NON_FATAL, (Object)failedEvent.getTaskFailureType());
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), AMSchedulerEventTAEnded.class, 1);
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), DAGEventCounterUpdate.class, 1);
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), SpeculatorEventTaskAttemptStatusUpdate.class, 2);
    }

    @Test(timeout=5000L)
    public void testFailureFatalError() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        MockEventHandler eventHandler = (MockEventHandler)Mockito.spy((Object)new MockEventHandler());
        TaskCommunicatorManagerInterface taListener = this.createMockTaskAttemptListener();
        Configuration taskConf = new Configuration();
        taskConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        taskConf.setBoolean("fs.file.impl.disable.cache", true);
        taskConf.setBoolean("tez.am.speculation.enabled", true);
        this.locationHint = TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList("127.0.0.1")), null);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        AMContainerMap containers = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), this.appCtx);
        containers.addContainerIfNew(container, 0, 0, 0);
        ((AppContext)Mockito.doReturn((Object)new ClusterInfo()).when((Object)this.appCtx)).getClusterInfo();
        ((AppContext)Mockito.doReturn((Object)containers).when((Object)this.appCtx)).getAllContainers();
        TaskHeartbeatHandler mockHeartbeatHandler = (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class);
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, taListener, taskConf, (Clock)new SystemClock(), mockHeartbeatHandler, this.appCtx, false, resource, TestTaskAttempt.createFakeContainerContext(), false);
        TezTaskAttemptID taskAttemptID = taImpl.getTaskAttemptID();
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(taskAttemptID, 0, 0));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSubmitted(taskAttemptID, contId));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(taskAttemptID));
        Assert.assertEquals((String)"Task attempt is not in the RUNNING state", (Object)taImpl.getState(), (Object)TaskAttemptState.RUNNING);
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler)).register((Object)taskAttemptID);
        int expectedEventsAtRunning = 6;
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsAtRunning))).handle((Event)arg.capture());
        this.verifyEventType(arg.getAllValues().subList(0, expectedEventsAtRunning), SpeculatorEventTaskAttemptStatusUpdate.class, 1);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStatusUpdate(taskAttemptID, new TaskStatusUpdateEvent(null, 0.1f, null, false)));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventAttemptFailed(taskAttemptID, TaskAttemptEventType.TA_FAILED, TaskFailureType.FATAL, "0", TaskAttemptTerminationCause.APPLICATION_ERROR));
        Assert.assertEquals((String)"Task attempt is not in the  FAIL_IN_PROGRESS state", (Object)taImpl.getInternalState(), (Object)TaskAttemptStateInternal.FAIL_IN_PROGRESS);
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler)).unregister((Object)taskAttemptID);
        Assert.assertEquals((long)1L, (long)taImpl.getDiagnostics().size());
        Assert.assertEquals((Object)"0", taImpl.getDiagnostics().get(0));
        Assert.assertEquals((Object)TaskAttemptTerminationCause.APPLICATION_ERROR, (Object)taImpl.getTerminationCause());
        Assert.assertEquals((Object)TaskAttemptStateInternal.FAIL_IN_PROGRESS, (Object)taImpl.getInternalState());
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventTezEventUpdate(taImpl.getTaskAttemptID(), Collections.EMPTY_LIST));
        Assert.assertFalse((String)"InternalError occurred trying to handle TA_TEZ_EVENT_UPDATE in FAIL_IN_PROGRESS state", (boolean)eventHandler.internalError);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventContainerTerminated(contId, taskAttemptID, "1", TaskAttemptTerminationCause.CONTAINER_EXITED));
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler, (VerificationMode)Mockito.times((int)1))).unregister((Object)taskAttemptID);
        Assert.assertEquals((long)2L, (long)taImpl.getDiagnostics().size());
        Assert.assertEquals((Object)"1", taImpl.getDiagnostics().get(1));
        Assert.assertEquals((Object)TaskAttemptTerminationCause.APPLICATION_ERROR, (Object)taImpl.getTerminationCause());
        int expectedEventsAfterTerminating = expectedEventsAtRunning + 5;
        arg = ArgumentCaptor.forClass(Event.class);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsAfterTerminating))).handle((Event)arg.capture());
        Event e = this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), TaskEventTAFailed.class, 1);
        TaskEventTAFailed failedEvent = (TaskEventTAFailed)e;
        Assert.assertEquals((Object)TaskFailureType.FATAL, (Object)failedEvent.getTaskFailureType());
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), AMSchedulerEventTAEnded.class, 1);
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), DAGEventCounterUpdate.class, 1);
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), SpeculatorEventTaskAttemptStatusUpdate.class, 2);
    }

    @Test
    public void testProgressTimeStampUpdate() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        MockEventHandler eventHandler = (MockEventHandler)Mockito.spy((Object)new MockEventHandler());
        TaskCommunicatorManagerInterface taListener = this.createMockTaskAttemptListener();
        Configuration taskConf = new Configuration();
        taskConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        taskConf.setBoolean("fs.file.impl.disable.cache", true);
        taskConf.setLong("tez.task.progress.stuck.interval-ms", 75L);
        this.locationHint = TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList("127.0.0.1")), null);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        AMContainerMap containers = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), this.appCtx);
        containers.addContainerIfNew(container, 0, 0, 0);
        ((AppContext)Mockito.doReturn((Object)new ClusterInfo()).when((Object)this.appCtx)).getClusterInfo();
        ((AppContext)Mockito.doReturn((Object)containers).when((Object)this.appCtx)).getAllContainers();
        TaskHeartbeatHandler mockHeartbeatHandler = (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class);
        Clock mockClock = (Clock)Mockito.mock(Clock.class);
        Mockito.when((Object)mockClock.getTime()).thenReturn((Object)50L);
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, taListener, taskConf, mockClock, mockHeartbeatHandler, this.appCtx, false, resource, TestTaskAttempt.createFakeContainerContext(), false);
        TezTaskAttemptID taskAttemptID = taImpl.getTaskAttemptID();
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(taskAttemptID, 0, 0));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSubmitted(taskAttemptID, contId));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(taskAttemptID));
        Assert.assertEquals((String)"Task attempt is not in the RUNNING state", (Object)taImpl.getState(), (Object)TaskAttemptState.RUNNING);
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler)).register((Object)taskAttemptID);
        Mockito.when((Object)mockClock.getTime()).thenReturn((Object)100L);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStatusUpdate(taskAttemptID, new TaskStatusUpdateEvent(null, 0.1f, null, false)));
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.atLeast((int)1))).handle((Event)arg.capture());
        if (arg.getValue() instanceof TaskAttemptEventAttemptFailed) {
            TaskAttemptEventAttemptFailed fEvent = (TaskAttemptEventAttemptFailed)arg.getValue();
            Assert.assertEquals((Object)taImpl.getTaskAttemptID(), (Object)fEvent.getTaskAttemptID());
            Assert.assertEquals((Object)TaskAttemptTerminationCause.NO_PROGRESS, (Object)fEvent.getTerminationCause());
            taImpl.handle((TaskAttemptEvent)fEvent);
            Assert.fail((String)"Should not fail since the timestamps do not differ by progress interval config");
        } else {
            Assert.assertEquals((String)"Task Attempt's internal state should be RUNNING!", (Object)taImpl.getInternalState(), (Object)TaskAttemptStateInternal.RUNNING);
        }
        Mockito.when((Object)mockClock.getTime()).thenReturn((Object)200L);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStatusUpdate(taskAttemptID, new TaskStatusUpdateEvent(null, 0.1f, null, false)));
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.atLeast((int)1))).handle((Event)arg.capture());
        Assert.assertTrue((String)"This should have been an attempt failed event!", (boolean)(arg.getValue() instanceof TaskAttemptEventAttemptFailed));
    }

    @Test
    public void testStatusUpdateWithNullCounters() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        MockEventHandler eventHandler = (MockEventHandler)Mockito.spy((Object)new MockEventHandler());
        TaskCommunicatorManagerInterface taListener = this.createMockTaskAttemptListener();
        Configuration taskConf = new Configuration();
        taskConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        taskConf.setBoolean("fs.file.impl.disable.cache", true);
        this.locationHint = TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList("127.0.0.1")), null);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)3L);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        AMContainerMap containers = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), this.appCtx);
        containers.addContainerIfNew(container, 0, 0, 0);
        ((AppContext)Mockito.doReturn((Object)new ClusterInfo()).when((Object)this.appCtx)).getClusterInfo();
        ((AppContext)Mockito.doReturn((Object)containers).when((Object)this.appCtx)).getAllContainers();
        TaskHeartbeatHandler mockHeartbeatHandler = (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class);
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, taListener, taskConf, (Clock)new SystemClock(), mockHeartbeatHandler, this.appCtx, false, resource, TestTaskAttempt.createFakeContainerContext(), false);
        TezTaskAttemptID taskAttemptID = taImpl.getTaskAttemptID();
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(taskAttemptID, 0, 0));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSubmitted(taskAttemptID, contId));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(taskAttemptID));
        Assert.assertEquals((String)"Task attempt is not in the RUNNING state", (Object)taImpl.getState(), (Object)TaskAttemptState.RUNNING);
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler)).register((Object)taskAttemptID);
        TezCounters counters = new TezCounters();
        counters.findCounter("group", "counter").increment(1L);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStatusUpdate(taskAttemptID, new TaskStatusUpdateEvent(counters, 0.1f, null, false)));
        Assert.assertEquals((long)1L, (long)taImpl.getCounters().findCounter("group", "counter").getValue());
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStatusUpdate(taskAttemptID, new TaskStatusUpdateEvent(null, 0.1f, null, false)));
        Assert.assertEquals((long)1L, (long)taImpl.getCounters().findCounter("group", "counter").getValue());
        counters.findCounter("group", "counter").increment(1L);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStatusUpdate(taskAttemptID, new TaskStatusUpdateEvent(counters, 0.1f, null, false)));
        Assert.assertEquals((long)2L, (long)taImpl.getCounters().findCounter("group", "counter").getValue());
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStatusUpdate(taskAttemptID, new TaskStatusUpdateEvent(null, 0.1f, null, false)));
        Assert.assertEquals((long)2L, (long)taImpl.getCounters().findCounter("group", "counter").getValue());
    }

    @Test(timeout=60000L)
    public void testProgressAfterSubmit() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        MockEventHandler eventHandler = (MockEventHandler)Mockito.spy((Object)new MockEventHandler());
        TaskCommunicatorManagerInterface taListener = this.createMockTaskAttemptListener();
        Configuration taskConf = new Configuration();
        taskConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        taskConf.setBoolean("fs.file.impl.disable.cache", true);
        taskConf.setLong("tez.task.progress.stuck.interval-ms", 50L);
        this.locationHint = TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList("127.0.0.1")), null);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        AMContainerMap containers = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), this.appCtx);
        containers.addContainerIfNew(container, 0, 0, 0);
        ((AppContext)Mockito.doReturn((Object)new ClusterInfo()).when((Object)this.appCtx)).getClusterInfo();
        ((AppContext)Mockito.doReturn((Object)containers).when((Object)this.appCtx)).getAllContainers();
        TaskHeartbeatHandler mockHeartbeatHandler = (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class);
        MockClock mockClock = new MockClock();
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, taListener, taskConf, mockClock, mockHeartbeatHandler, this.appCtx, false, resource, TestTaskAttempt.createFakeContainerContext(), false);
        TezTaskAttemptID taskAttemptID = taImpl.getTaskAttemptID();
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        mockClock.incrementTime(20L);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(taskAttemptID, 0, 0));
        mockClock.incrementTime(55L);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSubmitted(taskAttemptID, contId));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStatusUpdate(taskAttemptID, new TaskStatusUpdateEvent(null, 0.1f, null, false)));
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.atLeast((int)1))).handle((Event)arg.capture());
        if (arg.getValue() instanceof TaskAttemptEvent) {
            taImpl.handle((TaskAttemptEvent)arg.getValue());
        }
        Assert.assertEquals((String)"Task Attempt's internal state should be SUBMITTED!", (Object)taImpl.getInternalState(), (Object)TaskAttemptStateInternal.SUBMITTED);
    }

    @Test(timeout=5000L)
    public void testNoProgressFail() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        MockEventHandler eventHandler = (MockEventHandler)Mockito.spy((Object)new MockEventHandler());
        TaskCommunicatorManagerInterface taListener = this.createMockTaskAttemptListener();
        Configuration taskConf = new Configuration();
        taskConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        taskConf.setBoolean("fs.file.impl.disable.cache", true);
        taskConf.setLong("tez.task.progress.stuck.interval-ms", 75L);
        this.locationHint = TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList("127.0.0.1")), null);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        AMContainerMap containers = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), this.appCtx);
        containers.addContainerIfNew(container, 0, 0, 0);
        ((AppContext)Mockito.doReturn((Object)new ClusterInfo()).when((Object)this.appCtx)).getClusterInfo();
        ((AppContext)Mockito.doReturn((Object)containers).when((Object)this.appCtx)).getAllContainers();
        TaskHeartbeatHandler mockHeartbeatHandler = (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class);
        Clock mockClock = (Clock)Mockito.mock(Clock.class);
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, taListener, taskConf, mockClock, mockHeartbeatHandler, this.appCtx, false, resource, TestTaskAttempt.createFakeContainerContext(), false);
        TezTaskAttemptID taskAttemptID = taImpl.getTaskAttemptID();
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(taskAttemptID, 0, 0));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSubmitted(taskAttemptID, contId));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(taskAttemptID));
        Assert.assertEquals((String)"Task attempt is not in the RUNNING state", (Object)taImpl.getState(), (Object)TaskAttemptState.RUNNING);
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler)).register((Object)taskAttemptID);
        Mockito.when((Object)mockClock.getTime()).thenReturn((Object)100L);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStatusUpdate(taskAttemptID, new TaskStatusUpdateEvent(null, 0.1f, null, true)));
        Assert.assertEquals((long)100L, (long)taImpl.lastNotifyProgressTimestamp);
        Mockito.when((Object)mockClock.getTime()).thenReturn((Object)150L);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStatusUpdate(taskAttemptID, new TaskStatusUpdateEvent(null, 0.1f, null, true)));
        Assert.assertEquals((long)150L, (long)taImpl.lastNotifyProgressTimestamp);
        Mockito.when((Object)mockClock.getTime()).thenReturn((Object)200L);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStatusUpdate(taskAttemptID, new TaskStatusUpdateEvent(null, 0.1f, null, false)));
        Assert.assertEquals((long)150L, (long)taImpl.lastNotifyProgressTimestamp);
        Mockito.when((Object)mockClock.getTime()).thenReturn((Object)250L);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStatusUpdate(taskAttemptID, new TaskStatusUpdateEvent(null, 0.1f, null, false)));
        Assert.assertEquals((long)150L, (long)taImpl.lastNotifyProgressTimestamp);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.atLeast((int)1))).handle((Event)arg.capture());
        TaskAttemptEventAttemptFailed fEvent = (TaskAttemptEventAttemptFailed)arg.getValue();
        Assert.assertEquals((Object)taImpl.getTaskAttemptID(), (Object)fEvent.getTaskAttemptID());
        Assert.assertEquals((Object)TaskAttemptTerminationCause.NO_PROGRESS, (Object)fEvent.getTerminationCause());
        Assert.assertEquals((Object)TaskFailureType.NON_FATAL, (Object)fEvent.getTaskFailureType());
        taImpl.handle((TaskAttemptEvent)fEvent);
        Assert.assertEquals((String)"Task attempt is not in the  FAIL_IN_PROGRESS state", (Object)taImpl.getInternalState(), (Object)TaskAttemptStateInternal.FAIL_IN_PROGRESS);
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler)).unregister((Object)taskAttemptID);
        Assert.assertEquals((long)1L, (long)taImpl.getDiagnostics().size());
        Assert.assertEquals((Object)TaskAttemptTerminationCause.NO_PROGRESS, (Object)taImpl.getTerminationCause());
    }

    @Test(timeout=5000L)
    public void testEventSerializingHash() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskID taskID1 = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        TezTaskID taskID2 = TezTaskID.getInstance((TezVertexID)vertexID, (int)2);
        TezTaskAttemptID taID11 = TezTaskAttemptID.getInstance((TezTaskID)taskID1, (int)0);
        TezTaskAttemptID taID12 = TezTaskAttemptID.getInstance((TezTaskID)taskID1, (int)1);
        TezTaskAttemptID taID21 = TezTaskAttemptID.getInstance((TezTaskID)taskID2, (int)1);
        TaskAttemptEvent taEventFail11 = new TaskAttemptEvent(taID11, TaskAttemptEventType.TA_FAILED);
        TaskAttemptEvent taEventKill11 = new TaskAttemptEvent(taID11, TaskAttemptEventType.TA_KILL_REQUEST);
        TaskAttemptEvent taEventKill12 = new TaskAttemptEvent(taID12, TaskAttemptEventType.TA_KILL_REQUEST);
        TaskAttemptEvent taEventKill21 = new TaskAttemptEvent(taID21, TaskAttemptEventType.TA_KILL_REQUEST);
        TaskEvent tEventKill1 = new TaskEvent(taskID1, TaskEventType.T_ATTEMPT_KILLED);
        TaskEvent tEventFail1 = new TaskEvent(taskID1, TaskEventType.T_ATTEMPT_FAILED);
        TaskEvent tEventFail2 = new TaskEvent(taskID2, TaskEventType.T_ATTEMPT_FAILED);
        Assert.assertEquals((long)taEventFail11.getSerializingHash(), (long)taEventKill11.getSerializingHash());
        Assert.assertEquals((long)taEventKill11.getSerializingHash(), (long)taEventKill12.getSerializingHash());
        Assert.assertEquals((long)tEventFail1.getSerializingHash(), (long)tEventKill1.getSerializingHash());
        Assert.assertEquals((long)taEventFail11.getSerializingHash(), (long)tEventKill1.getSerializingHash());
        Assert.assertEquals((long)taEventKill21.getSerializingHash(), (long)tEventFail2.getSerializingHash());
        Assert.assertFalse((tEventFail1.getSerializingHash() == tEventFail2.getSerializingHash() ? 1 : 0) != 0);
    }

    @Test(timeout=5000L)
    public void testCompletedAtSubmitted() throws ServicePluginException {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        MockEventHandler eventHandler = (MockEventHandler)Mockito.spy((Object)new MockEventHandler());
        TaskCommunicatorManagerInterface taListener = this.createMockTaskAttemptListener();
        Configuration taskConf = new Configuration();
        taskConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        taskConf.setBoolean("fs.file.impl.disable.cache", true);
        this.locationHint = TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList("127.0.0.1")), null);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        AMContainerMap containers = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), this.appCtx);
        containers.addContainerIfNew(container, 0, 0, 0);
        ((AppContext)Mockito.doReturn((Object)new ClusterInfo()).when((Object)this.appCtx)).getClusterInfo();
        ((AppContext)Mockito.doReturn((Object)containers).when((Object)this.appCtx)).getAllContainers();
        TaskHeartbeatHandler mockHeartbeatHandler = (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class);
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, taListener, taskConf, (Clock)new SystemClock(), mockHeartbeatHandler, this.appCtx, false, resource, TestTaskAttempt.createFakeContainerContext(), false);
        TezTaskAttemptID taskAttemptID = taImpl.getTaskAttemptID();
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(taskAttemptID, 0, 0));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSubmitted(taskAttemptID, contId));
        Assert.assertEquals((String)"Task attempt is not in the RUNNING state", (Object)taImpl.getState(), (Object)TaskAttemptState.STARTING);
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler)).register((Object)taskAttemptID);
        int expectedEventsAtStarting = 4;
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsAtStarting))).handle((Event)arg.capture());
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStatusUpdate(taskAttemptID, new TaskStatusUpdateEvent(null, 0.1f, null, false)));
        taImpl.handle(new TaskAttemptEvent(taskAttemptID, TaskAttemptEventType.TA_DONE));
        Assert.assertEquals((String)"Task attempt is not in the  SUCCEEDED state", (Object)taImpl.getState(), (Object)TaskAttemptState.SUCCEEDED);
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler)).unregister((Object)taskAttemptID);
        Assert.assertEquals((long)0L, (long)taImpl.getDiagnostics().size());
        int expectedEventsAfterTerminating = expectedEventsAtStarting + 3;
        arg = ArgumentCaptor.forClass(Event.class);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsAfterTerminating))).handle((Event)arg.capture());
        Event e = this.verifyEventType(arg.getAllValues().subList(expectedEventsAtStarting, expectedEventsAfterTerminating), TaskEventTASucceeded.class, 1);
        Assert.assertEquals((Object)TaskEventType.T_ATTEMPT_SUCCEEDED, (Object)e.getType());
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtStarting, expectedEventsAfterTerminating), AMSchedulerEventTAEnded.class, 1);
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtStarting, expectedEventsAfterTerminating), DAGEventCounterUpdate.class, 1);
    }

    @Test(timeout=5000L)
    public void testSuccess() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        MockEventHandler eventHandler = (MockEventHandler)Mockito.spy((Object)new MockEventHandler());
        TaskCommunicatorManagerInterface taListener = this.createMockTaskAttemptListener();
        Configuration taskConf = new Configuration();
        taskConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        taskConf.setBoolean("fs.file.impl.disable.cache", true);
        taskConf.setBoolean("tez.am.speculation.enabled", true);
        this.locationHint = TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList("127.0.0.1")), null);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        AMContainerMap containers = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), this.appCtx);
        containers.addContainerIfNew(container, 0, 0, 0);
        ((AppContext)Mockito.doReturn((Object)new ClusterInfo()).when((Object)this.appCtx)).getClusterInfo();
        ((AppContext)Mockito.doReturn((Object)containers).when((Object)this.appCtx)).getAllContainers();
        TaskHeartbeatHandler mockHeartbeatHandler = (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class);
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, taListener, taskConf, (Clock)new SystemClock(), mockHeartbeatHandler, this.appCtx, false, resource, TestTaskAttempt.createFakeContainerContext(), false);
        TezTaskAttemptID taskAttemptID = taImpl.getTaskAttemptID();
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(taskAttemptID, 0, 0));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSubmitted(taskAttemptID, contId));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(taskAttemptID));
        Assert.assertEquals((String)"Task attempt is not in the RUNNING state", (Object)taImpl.getState(), (Object)TaskAttemptState.RUNNING);
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler)).register((Object)taskAttemptID);
        int expectedEventsAtRunning = 6;
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsAtRunning))).handle((Event)arg.capture());
        this.verifyEventType(arg.getAllValues().subList(0, expectedEventsAtRunning), SpeculatorEventTaskAttemptStatusUpdate.class, 1);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStatusUpdate(taskAttemptID, new TaskStatusUpdateEvent(null, 0.1f, null, false)));
        taImpl.handle(new TaskAttemptEvent(taskAttemptID, TaskAttemptEventType.TA_DONE));
        Assert.assertEquals((String)"Task attempt is not in the  SUCCEEDED state", (Object)taImpl.getState(), (Object)TaskAttemptState.SUCCEEDED);
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler)).unregister((Object)taskAttemptID);
        Assert.assertEquals((long)0L, (long)taImpl.getDiagnostics().size());
        int expectedEventsAfterTerminating = expectedEventsAtRunning + 5;
        arg = ArgumentCaptor.forClass(Event.class);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsAfterTerminating))).handle((Event)arg.capture());
        Event e = this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), TaskEventTASucceeded.class, 1);
        Assert.assertEquals((Object)TaskEventType.T_ATTEMPT_SUCCEEDED, (Object)e.getType());
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), AMSchedulerEventTAEnded.class, 1);
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), DAGEventCounterUpdate.class, 1);
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), SpeculatorEventTaskAttemptStatusUpdate.class, 2);
    }

    @Test(timeout=5000L)
    public void testContainerPreemptedAfterSuccess() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        MockEventHandler eventHandler = (MockEventHandler)Mockito.spy((Object)new MockEventHandler());
        TaskCommunicatorManagerInterface taListener = this.createMockTaskAttemptListener();
        Configuration taskConf = new Configuration();
        taskConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        taskConf.setBoolean("fs.file.impl.disable.cache", true);
        this.locationHint = TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList("127.0.0.1")), null);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        AMContainerMap containers = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), this.appCtx);
        containers.addContainerIfNew(container, 0, 0, 0);
        ((AppContext)Mockito.doReturn((Object)new ClusterInfo()).when((Object)this.appCtx)).getClusterInfo();
        ((AppContext)Mockito.doReturn((Object)containers).when((Object)this.appCtx)).getAllContainers();
        TaskHeartbeatHandler mockHeartbeatHandler = (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class);
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, taListener, taskConf, (Clock)new SystemClock(), mockHeartbeatHandler, this.appCtx, false, resource, TestTaskAttempt.createFakeContainerContext(), false);
        TezTaskAttemptID taskAttemptID = taImpl.getTaskAttemptID();
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(taskAttemptID, 0, 0));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSubmitted(taskAttemptID, contId));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(taskAttemptID));
        Assert.assertEquals((String)"Task attempt is not in the RUNNING state", (Object)taImpl.getState(), (Object)TaskAttemptState.RUNNING);
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler)).register((Object)taskAttemptID);
        int expectedEventsAtRunning = 5;
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsAtRunning))).handle((Event)arg.capture());
        taImpl.handle(new TaskAttemptEvent(taskAttemptID, TaskAttemptEventType.TA_DONE));
        Assert.assertEquals((String)"Task attempt is not in the  SUCCEEDED state", (Object)taImpl.getState(), (Object)TaskAttemptState.SUCCEEDED);
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler)).unregister((Object)taskAttemptID);
        Assert.assertEquals((long)0L, (long)taImpl.getDiagnostics().size());
        int expectedEventsAfterTerminating = expectedEventsAtRunning + 3;
        arg = ArgumentCaptor.forClass(Event.class);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsAfterTerminating))).handle((Event)arg.capture());
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), TaskEventTASucceeded.class, 1);
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), AMSchedulerEventTAEnded.class, 1);
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), DAGEventCounterUpdate.class, 1);
        taImpl.handle(new TaskAttemptEvent(taskAttemptID, TaskAttemptEventType.TA_CONTAINER_TERMINATED_BY_SYSTEM));
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler, (VerificationMode)Mockito.times((int)1))).unregister((Object)taskAttemptID);
        int expectedEventAfterTerminated = expectedEventsAfterTerminating + 0;
        arg = ArgumentCaptor.forClass(Event.class);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventAfterTerminated))).handle((Event)arg.capture());
        Assert.assertEquals((long)0L, (long)taImpl.getDiagnostics().size());
        Assert.assertEquals((Object)TaskAttemptTerminationCause.UNKNOWN_ERROR, (Object)taImpl.getTerminationCause());
    }

    @Test(timeout=5000L)
    public void testNodeFailedNonLeafVertex() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        MockEventHandler eventHandler = (MockEventHandler)Mockito.spy((Object)new MockEventHandler());
        TaskCommunicatorManagerInterface taListener = this.createMockTaskAttemptListener();
        Configuration taskConf = new Configuration();
        taskConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        taskConf.setBoolean("fs.file.impl.disable.cache", true);
        this.locationHint = TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList("127.0.0.1")), null);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        AMContainerMap containers = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), this.appCtx);
        containers.addContainerIfNew(container, 0, 0, 0);
        ((AppContext)Mockito.doReturn((Object)new ClusterInfo()).when((Object)this.appCtx)).getClusterInfo();
        ((AppContext)Mockito.doReturn((Object)containers).when((Object)this.appCtx)).getAllContainers();
        TaskHeartbeatHandler mockHeartbeatHandler = (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class);
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, taListener, taskConf, (Clock)new SystemClock(), mockHeartbeatHandler, this.appCtx, false, resource, TestTaskAttempt.createFakeContainerContext(), false);
        TezTaskAttemptID taskAttemptID = taImpl.getTaskAttemptID();
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(taskAttemptID, 0, 0));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSubmitted(taskAttemptID, contId));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(taskAttemptID));
        Assert.assertEquals((String)"Task attempt is not in the RUNNING state", (Object)TaskAttemptState.RUNNING, (Object)taImpl.getState());
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler)).register((Object)taskAttemptID);
        int expectedEventsAtRunning = 5;
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsAtRunning))).handle((Event)arg.capture());
        taImpl.handle(new TaskAttemptEvent(taskAttemptID, TaskAttemptEventType.TA_DONE));
        Assert.assertEquals((String)"Task attempt is not in the  SUCCEEDED state", (Object)TaskAttemptState.SUCCEEDED, (Object)taImpl.getState());
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler)).unregister((Object)taskAttemptID);
        Assert.assertEquals((long)0L, (long)taImpl.getDiagnostics().size());
        int expectedEventsAfterTerminating = expectedEventsAtRunning + 3;
        arg = ArgumentCaptor.forClass(Event.class);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsAfterTerminating))).handle((Event)arg.capture());
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), TaskEventTASucceeded.class, 1);
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), AMSchedulerEventTAEnded.class, 1);
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), DAGEventCounterUpdate.class, 1);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventNodeFailed(taskAttemptID, "NodeDecomissioned", TaskAttemptTerminationCause.NODE_FAILED));
        Assert.assertEquals((String)"Task attempt is not in the  KILLED state", (Object)TaskAttemptState.KILLED, (Object)taImpl.getState());
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler, (VerificationMode)Mockito.times((int)1))).unregister((Object)taskAttemptID);
        Assert.assertEquals((Object)true, (Object)taImpl.inputFailedReported);
        int expectedEventsNodeFailure = expectedEventsAfterTerminating + 2;
        arg = ArgumentCaptor.forClass(Event.class);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsNodeFailure))).handle((Event)arg.capture());
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAfterTerminating, expectedEventsNodeFailure), TaskEventTAKilled.class, 1);
        Assert.assertEquals((String)"Task attempt is not in the  KILLED state", (Object)TaskAttemptState.KILLED, (Object)taImpl.getState());
        Assert.assertEquals((Object)TaskAttemptTerminationCause.NODE_FAILED, (Object)taImpl.getTerminationCause());
        Assert.assertEquals((Object)TaskAttemptStateInternal.KILLED, (Object)taImpl.getInternalState());
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventTezEventUpdate(taImpl.getTaskAttemptID(), Collections.EMPTY_LIST));
        Assert.assertFalse((String)"InternalError occurred trying to handle TA_TEZ_EVENT_UPDATE in KILLED state", (boolean)eventHandler.internalError);
    }

    @Test(timeout=5000L)
    public void testNodeFailedLeafVertex() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        MockEventHandler eventHandler = (MockEventHandler)Mockito.spy((Object)new MockEventHandler());
        TaskCommunicatorManagerInterface taListener = this.createMockTaskAttemptListener();
        Configuration taskConf = new Configuration();
        taskConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        taskConf.setBoolean("fs.file.impl.disable.cache", true);
        this.locationHint = TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList("127.0.0.1")), null);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        AMContainerMap containers = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), this.appCtx);
        containers.addContainerIfNew(container, 0, 0, 0);
        ((AppContext)Mockito.doReturn((Object)new ClusterInfo()).when((Object)this.appCtx)).getClusterInfo();
        ((AppContext)Mockito.doReturn((Object)containers).when((Object)this.appCtx)).getAllContainers();
        TaskHeartbeatHandler mockHeartbeatHandler = (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class);
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, taListener, taskConf, (Clock)new SystemClock(), mockHeartbeatHandler, this.appCtx, false, resource, TestTaskAttempt.createFakeContainerContext(), true);
        TezTaskAttemptID taskAttemptID = taImpl.getTaskAttemptID();
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(taskAttemptID, 0, 0));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSubmitted(taskAttemptID, contId));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(taskAttemptID));
        Assert.assertEquals((String)"Task attempt is not in the RUNNING state", (Object)TaskAttemptState.RUNNING, (Object)taImpl.getState());
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler)).register((Object)taskAttemptID);
        int expectedEventsAtRunning = 5;
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsAtRunning))).handle((Event)arg.capture());
        taImpl.handle(new TaskAttemptEvent(taskAttemptID, TaskAttemptEventType.TA_DONE));
        Assert.assertEquals((String)"Task attempt is not in the  SUCCEEDED state", (Object)TaskAttemptState.SUCCEEDED, (Object)taImpl.getState());
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler)).unregister((Object)taskAttemptID);
        Assert.assertEquals((long)0L, (long)taImpl.getDiagnostics().size());
        int expectedEventsAfterTerminating = expectedEventsAtRunning + 3;
        arg = ArgumentCaptor.forClass(Event.class);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsAfterTerminating))).handle((Event)arg.capture());
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), TaskEventTASucceeded.class, 1);
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), AMSchedulerEventTAEnded.class, 1);
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), DAGEventCounterUpdate.class, 1);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventNodeFailed(taskAttemptID, "NodeDecomissioned", TaskAttemptTerminationCause.NODE_FAILED));
        int expectedEventsNodeFailure = expectedEventsAfterTerminating + 0;
        arg = ArgumentCaptor.forClass(Event.class);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsNodeFailure))).handle((Event)arg.capture());
        Assert.assertEquals((String)"Task attempt is not in the  SUCCEEDED state", (Object)TaskAttemptState.SUCCEEDED, (Object)taImpl.getState());
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler, (VerificationMode)Mockito.times((int)1))).unregister((Object)taskAttemptID);
        Assert.assertEquals((Object)TaskAttemptTerminationCause.UNKNOWN_ERROR, (Object)taImpl.getTerminationCause());
    }

    @Test(timeout=5000L)
    public void testMultipleOutputFailed() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        MockEventHandler mockEh = new MockEventHandler();
        MockEventHandler eventHandler = (MockEventHandler)Mockito.spy((Object)mockEh);
        TaskCommunicatorManagerInterface taListener = this.createMockTaskAttemptListener();
        Configuration taskConf = new Configuration();
        taskConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        taskConf.setBoolean("fs.file.impl.disable.cache", true);
        this.locationHint = TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList("127.0.0.1")), null);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        AMContainerMap containers = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), this.appCtx);
        containers.addContainerIfNew(container, 0, 0, 0);
        ((AppContext)Mockito.doReturn((Object)new ClusterInfo()).when((Object)this.appCtx)).getClusterInfo();
        ((AppContext)Mockito.doReturn((Object)containers).when((Object)this.appCtx)).getAllContainers();
        HistoryEventHandler mockHistHandler = (HistoryEventHandler)Mockito.mock(HistoryEventHandler.class);
        ((AppContext)Mockito.doReturn((Object)mockHistHandler).when((Object)this.appCtx)).getHistoryHandler();
        DAGImpl mockDAG = (DAGImpl)Mockito.mock(DAGImpl.class);
        TaskHeartbeatHandler mockHeartbeatHandler = (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class);
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, taListener, taskConf, (Clock)new SystemClock(), mockHeartbeatHandler, this.appCtx, false, resource, TestTaskAttempt.createFakeContainerContext(), false);
        TezTaskAttemptID taskAttemptID = taImpl.getTaskAttemptID();
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(taskAttemptID, 0, 0));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSubmitted(taskAttemptID, contId));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(taskAttemptID));
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler)).register((Object)taskAttemptID);
        taImpl.handle(new TaskAttemptEvent(taskAttemptID, TaskAttemptEventType.TA_DONE));
        Assert.assertEquals((String)"Task attempt is not in succeeded state", (Object)taImpl.getState(), (Object)TaskAttemptState.SUCCEEDED);
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler)).unregister((Object)taskAttemptID);
        int expectedEventsTillSucceeded = 8;
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        ArgumentCaptor histArg = ArgumentCaptor.forClass(DAGHistoryEvent.class);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsTillSucceeded))).handle((Event)arg.capture());
        ((HistoryEventHandler)Mockito.verify((Object)mockHistHandler, (VerificationMode)Mockito.times((int)2))).handle((DAGHistoryEvent)histArg.capture());
        DAGHistoryEvent histEvent = (DAGHistoryEvent)histArg.getValue();
        TaskAttemptFinishedEvent finishEvent = (TaskAttemptFinishedEvent)histEvent.getHistoryEvent();
        long finishTime = finishEvent.getFinishTime();
        this.verifyEventType(arg.getAllValues(), TaskEventTAUpdate.class, 2);
        InputReadErrorEvent mockReEvent = InputReadErrorEvent.create((String)"", (int)0, (int)1);
        EventMetaData mockMeta = (EventMetaData)Mockito.mock(EventMetaData.class);
        TezTaskAttemptID mockDestId1 = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        Mockito.when((Object)mockMeta.getTaskAttemptID()).thenReturn((Object)mockDestId1);
        TezTaskID destTaskID = (TezTaskID)Mockito.mock(TezTaskID.class);
        TezVertexID destVertexID = (TezVertexID)Mockito.mock(TezVertexID.class);
        Mockito.when((Object)mockDestId1.getTaskID()).thenReturn((Object)destTaskID);
        Mockito.when((Object)mockDestId1.getVertexID()).thenReturn((Object)destVertexID);
        Mockito.when((Object)destTaskID.getVertexID()).thenReturn((Object)destVertexID);
        Vertex destVertex = (Vertex)Mockito.mock(VertexImpl.class);
        Mockito.when((Object)destVertex.getRunningTasks()).thenReturn((Object)11);
        Mockito.when((Object)mockDAG.getVertex(destVertexID)).thenReturn((Object)destVertex);
        Mockito.when((Object)this.appCtx.getCurrentDAG()).thenReturn((Object)mockDAG);
        TezEvent tzEvent = new TezEvent((org.apache.tez.runtime.api.Event)mockReEvent, mockMeta);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventOutputFailed(taskAttemptID, tzEvent, 11));
        Assert.assertEquals((String)"Task attempt is not in succeeded state", (Object)taImpl.getState(), (Object)TaskAttemptState.SUCCEEDED);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventOutputFailed(taskAttemptID, tzEvent, 11));
        Assert.assertEquals((String)"Task attempt is not in succeeded state", (Object)taImpl.getState(), (Object)TaskAttemptState.SUCCEEDED);
        Assert.assertEquals((Object)TaskAttemptTerminationCause.UNKNOWN_ERROR, (Object)taImpl.getTerminationCause());
        TezTaskAttemptID mockDestId2 = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        Mockito.when((Object)mockMeta.getTaskAttemptID()).thenReturn((Object)mockDestId2);
        destTaskID = (TezTaskID)Mockito.mock(TezTaskID.class);
        destVertexID = (TezVertexID)Mockito.mock(TezVertexID.class);
        Mockito.when((Object)mockDestId2.getTaskID()).thenReturn((Object)destTaskID);
        Mockito.when((Object)mockDestId2.getVertexID()).thenReturn((Object)destVertexID);
        Mockito.when((Object)destTaskID.getVertexID()).thenReturn((Object)destVertexID);
        destVertex = (Vertex)Mockito.mock(VertexImpl.class);
        Mockito.when((Object)destVertex.getRunningTasks()).thenReturn((Object)11);
        Mockito.when((Object)mockDAG.getVertex(destVertexID)).thenReturn((Object)destVertex);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventOutputFailed(taskAttemptID, tzEvent, 11));
        Assert.assertEquals((String)"Task attempt is not in FAILED state", (Object)TaskAttemptState.FAILED, (Object)taImpl.getState());
        Assert.assertEquals((Object)TaskAttemptTerminationCause.OUTPUT_LOST, (Object)taImpl.getTerminationCause());
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler, (VerificationMode)Mockito.times((int)1))).unregister((Object)taskAttemptID);
        ((HistoryEventHandler)Mockito.verify((Object)mockHistHandler, (VerificationMode)Mockito.times((int)3))).handle((DAGHistoryEvent)histArg.capture());
        histEvent = (DAGHistoryEvent)histArg.getValue();
        finishEvent = (TaskAttemptFinishedEvent)histEvent.getHistoryEvent();
        Assert.assertEquals((Object)TaskFailureType.NON_FATAL, (Object)finishEvent.getTaskFailureType());
        long newFinishTime = finishEvent.getFinishTime();
        Assert.assertEquals((long)finishTime, (long)newFinishTime);
        Assert.assertEquals((Object)true, (Object)taImpl.inputFailedReported);
        int expectedEventsAfterFetchFailure = expectedEventsTillSucceeded + 2;
        arg = ArgumentCaptor.forClass(Event.class);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsAfterFetchFailure))).handle((Event)arg.capture());
        Event e = this.verifyEventType(arg.getAllValues().subList(expectedEventsTillSucceeded, expectedEventsAfterFetchFailure), TaskEventTAFailed.class, 1);
        TaskEventTAFailed failedEvent = (TaskEventTAFailed)e;
        Assert.assertEquals((Object)TaskFailureType.NON_FATAL, (Object)failedEvent.getTaskFailureType());
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventOutputFailed(taskAttemptID, tzEvent, 1));
        Assert.assertEquals((String)"Task attempt is not in FAILED state, still", (Object)taImpl.getState(), (Object)TaskAttemptState.FAILED);
        Assert.assertFalse((String)"InternalError occurred trying to handle TA_TOO_MANY_FETCH_FAILURES", (boolean)eventHandler.internalError);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsAfterFetchFailure))).handle((Event)arg.capture());
        Configuration newVertexConf = new Configuration((Configuration)this.vertexConf);
        newVertexConf.setInt("tez.task.max.allowed.output.failures", 1);
        this.createMockVertex(newVertexConf);
        TezTaskID taskID2 = TezTaskID.getInstance((TezVertexID)vertexID, (int)2);
        MockTaskAttemptImpl taImpl2 = new MockTaskAttemptImpl(taskID2, 1, eventHandler, taListener, taskConf, (Clock)new SystemClock(), mockHeartbeatHandler, this.appCtx, false, resource, TestTaskAttempt.createFakeContainerContext(), false);
        TezTaskAttemptID taskAttemptID2 = taImpl2.getTaskAttemptID();
        taImpl2.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(taskAttemptID2, 0, 0));
        taImpl2.handle((TaskAttemptEvent)new TaskAttemptEventSubmitted(taskAttemptID2, contId));
        taImpl2.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(taskAttemptID2));
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler)).register((Object)taskAttemptID2);
        taImpl2.handle(new TaskAttemptEvent(taskAttemptID2, TaskAttemptEventType.TA_DONE));
        Assert.assertEquals((String)"Task attempt is not in succeeded state", (Object)taImpl2.getState(), (Object)TaskAttemptState.SUCCEEDED);
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler)).unregister((Object)taskAttemptID2);
        mockReEvent = InputReadErrorEvent.create((String)"", (int)1, (int)1);
        mockMeta = (EventMetaData)Mockito.mock(EventMetaData.class);
        mockDestId1 = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        Mockito.when((Object)mockDestId1.getTaskID()).thenReturn((Object)destTaskID);
        Mockito.when((Object)mockDestId1.getVertexID()).thenReturn((Object)destVertexID);
        Mockito.when((Object)mockMeta.getTaskAttemptID()).thenReturn((Object)mockDestId1);
        tzEvent = new TezEvent((org.apache.tez.runtime.api.Event)mockReEvent, mockMeta);
        taImpl2.handle((TaskAttemptEvent)new TaskAttemptEventOutputFailed(taskAttemptID2, tzEvent, 8));
        Assert.assertEquals((String)"Task attempt is not in failed state", (Object)taImpl2.getState(), (Object)TaskAttemptState.FAILED);
        Assert.assertEquals((Object)TaskAttemptTerminationCause.OUTPUT_LOST, (Object)taImpl2.getTerminationCause());
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler, (VerificationMode)Mockito.times((int)1))).unregister((Object)taskAttemptID2);
        Clock mockClock = (Clock)Mockito.mock(Clock.class);
        int readErrorTimespanSec = 1;
        newVertexConf = new Configuration((Configuration)this.vertexConf);
        newVertexConf.setInt("tez.task.max.allowed.output.failures", 10);
        newVertexConf.setInt("tez.am.max.allowed.time-sec.for-read-error", readErrorTimespanSec);
        this.createMockVertex(newVertexConf);
        TezTaskID taskID3 = TezTaskID.getInstance((TezVertexID)vertexID, (int)3);
        MockTaskAttemptImpl taImpl3 = new MockTaskAttemptImpl(taskID3, 1, eventHandler, taListener, taskConf, mockClock, mockHeartbeatHandler, this.appCtx, false, resource, TestTaskAttempt.createFakeContainerContext(), false);
        TezTaskAttemptID taskAttemptID3 = taImpl3.getTaskAttemptID();
        taImpl3.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(taskAttemptID3, 0, 0));
        taImpl3.handle((TaskAttemptEvent)new TaskAttemptEventSubmitted(taskAttemptID3, contId));
        taImpl3.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(taskAttemptID3));
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler)).register((Object)taskAttemptID3);
        taImpl3.handle(new TaskAttemptEvent(taskAttemptID3, TaskAttemptEventType.TA_DONE));
        Assert.assertEquals((String)"Task attempt is not in succeeded state", (Object)taImpl3.getState(), (Object)TaskAttemptState.SUCCEEDED);
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler)).unregister((Object)taskAttemptID3);
        mockReEvent = InputReadErrorEvent.create((String)"", (int)1, (int)1);
        mockMeta = (EventMetaData)Mockito.mock(EventMetaData.class);
        mockDestId1 = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        Mockito.when((Object)mockDestId1.getTaskID()).thenReturn((Object)destTaskID);
        Mockito.when((Object)mockDestId1.getVertexID()).thenReturn((Object)destVertexID);
        Mockito.when((Object)mockMeta.getTaskAttemptID()).thenReturn((Object)mockDestId1);
        tzEvent = new TezEvent((org.apache.tez.runtime.api.Event)mockReEvent, mockMeta);
        Mockito.when((Object)mockClock.getTime()).thenReturn((Object)1000L);
        Mockito.when((Object)destVertex.getRunningTasks()).thenReturn((Object)1000);
        taImpl3.handle((TaskAttemptEvent)new TaskAttemptEventOutputFailed(taskAttemptID3, tzEvent, 1000));
        Assert.assertEquals((String)"Task attempt is not in succeeded state", (Object)taImpl3.getState(), (Object)TaskAttemptState.SUCCEEDED);
        Mockito.when((Object)mockClock.getTime()).thenReturn((Object)1500L);
        taImpl3.handle((TaskAttemptEvent)new TaskAttemptEventOutputFailed(taskAttemptID3, tzEvent, 1000));
        Assert.assertEquals((String)"Task attempt is not in succeeded state", (Object)taImpl3.getState(), (Object)TaskAttemptState.SUCCEEDED);
        Mockito.when((Object)mockClock.getTime()).thenReturn((Object)2001L);
        taImpl3.handle((TaskAttemptEvent)new TaskAttemptEventOutputFailed(taskAttemptID3, tzEvent, 1000));
        Assert.assertEquals((String)"Task attempt is not in FAILED state", (Object)taImpl3.getState(), (Object)TaskAttemptState.FAILED);
        Assert.assertEquals((Object)TaskAttemptTerminationCause.OUTPUT_LOST, (Object)taImpl3.getTerminationCause());
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler, (VerificationMode)Mockito.times((int)1))).unregister((Object)taskAttemptID3);
    }

    @Test(timeout=60000L)
    public void testTAFailureBasedOnRunningTasks() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        MockEventHandler mockEh = new MockEventHandler();
        MockEventHandler eventHandler = (MockEventHandler)Mockito.spy((Object)mockEh);
        TaskCommunicatorManagerInterface taListener = this.createMockTaskAttemptListener();
        Configuration taskConf = new Configuration();
        taskConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        taskConf.setBoolean("fs.file.impl.disable.cache", true);
        this.locationHint = TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList("127.0.0.1")), null);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        AMContainerMap containers = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), this.appCtx);
        containers.addContainerIfNew(container, 0, 0, 0);
        ((AppContext)Mockito.doReturn((Object)new ClusterInfo()).when((Object)this.appCtx)).getClusterInfo();
        ((AppContext)Mockito.doReturn((Object)containers).when((Object)this.appCtx)).getAllContainers();
        HistoryEventHandler mockHistHandler = (HistoryEventHandler)Mockito.mock(HistoryEventHandler.class);
        ((AppContext)Mockito.doReturn((Object)mockHistHandler).when((Object)this.appCtx)).getHistoryHandler();
        DAGImpl mockDAG = (DAGImpl)Mockito.mock(DAGImpl.class);
        TaskHeartbeatHandler mockHeartbeatHandler = (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class);
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, taListener, taskConf, (Clock)new SystemClock(), mockHeartbeatHandler, this.appCtx, false, resource, TestTaskAttempt.createFakeContainerContext(), false);
        TezTaskAttemptID taskAttemptID = taImpl.getTaskAttemptID();
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(taskAttemptID, 0, 0));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSubmitted(taskAttemptID, contId));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(taskAttemptID));
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler)).register((Object)taskAttemptID);
        taImpl.handle(new TaskAttemptEvent(taskAttemptID, TaskAttemptEventType.TA_DONE));
        Assert.assertEquals((String)"Task attempt is not in succeeded state", (Object)taImpl.getState(), (Object)TaskAttemptState.SUCCEEDED);
        ((TaskHeartbeatHandler)Mockito.verify((Object)mockHeartbeatHandler)).unregister((Object)taskAttemptID);
        int expectedEventsTillSucceeded = 8;
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        ArgumentCaptor histArg = ArgumentCaptor.forClass(DAGHistoryEvent.class);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsTillSucceeded))).handle((Event)arg.capture());
        ((HistoryEventHandler)Mockito.verify((Object)mockHistHandler, (VerificationMode)Mockito.times((int)2))).handle((DAGHistoryEvent)histArg.capture());
        DAGHistoryEvent histEvent = (DAGHistoryEvent)histArg.getValue();
        TaskAttemptFinishedEvent finishEvent = (TaskAttemptFinishedEvent)histEvent.getHistoryEvent();
        long finishTime = finishEvent.getFinishTime();
        this.verifyEventType(arg.getAllValues(), TaskEventTAUpdate.class, 2);
        InputReadErrorEvent mockReEvent = InputReadErrorEvent.create((String)"", (int)0, (int)1);
        EventMetaData mockMeta = (EventMetaData)Mockito.mock(EventMetaData.class);
        TezTaskAttemptID mockDestId1 = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        Mockito.when((Object)mockMeta.getTaskAttemptID()).thenReturn((Object)mockDestId1);
        TezTaskID destTaskID = (TezTaskID)Mockito.mock(TezTaskID.class);
        TezVertexID destVertexID = (TezVertexID)Mockito.mock(TezVertexID.class);
        Mockito.when((Object)mockDestId1.getTaskID()).thenReturn((Object)destTaskID);
        Mockito.when((Object)mockDestId1.getVertexID()).thenReturn((Object)destVertexID);
        Mockito.when((Object)destTaskID.getVertexID()).thenReturn((Object)destVertexID);
        Vertex destVertex = (Vertex)Mockito.mock(VertexImpl.class);
        Mockito.when((Object)destVertex.getRunningTasks()).thenReturn((Object)5);
        Mockito.when((Object)mockDAG.getVertex(destVertexID)).thenReturn((Object)destVertex);
        Mockito.when((Object)this.appCtx.getCurrentDAG()).thenReturn((Object)mockDAG);
        TezEvent tzEvent = new TezEvent((org.apache.tez.runtime.api.Event)mockReEvent, mockMeta);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventOutputFailed(taskAttemptID, tzEvent, 11));
        Assert.assertEquals((String)"Task attempt is not in FAILED state", (Object)TaskAttemptState.FAILED, (Object)taImpl.getState());
    }

    @Test(timeout=5000L)
    public void testKilledInNew() throws ServicePluginException {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        MockEventHandler eventHandler = (MockEventHandler)Mockito.spy((Object)new MockEventHandler());
        TaskCommunicatorManagerInterface taListener = this.createMockTaskAttemptListener();
        Configuration taskConf = new Configuration();
        taskConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        taskConf.setBoolean("fs.file.impl.disable.cache", true);
        this.locationHint = TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList("127.0.0.1")), null);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        AMContainerMap containers = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), this.appCtx);
        containers.addContainerIfNew(container, 0, 0, 0);
        ((AppContext)Mockito.doReturn((Object)new ClusterInfo()).when((Object)this.appCtx)).getClusterInfo();
        ((AppContext)Mockito.doReturn((Object)containers).when((Object)this.appCtx)).getAllContainers();
        TaskHeartbeatHandler mockHeartbeatHandler = (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class);
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, taListener, taskConf, (Clock)new SystemClock(), mockHeartbeatHandler, this.appCtx, false, resource, TestTaskAttempt.createFakeContainerContext(), true);
        Assert.assertEquals((Object)TaskAttemptStateInternal.NEW, (Object)taImpl.getInternalState());
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventKillRequest(taImpl.getTaskAttemptID(), "kill it", TaskAttemptTerminationCause.TERMINATED_BY_CLIENT));
        Assert.assertEquals((Object)TaskAttemptStateInternal.KILLED, (Object)taImpl.getInternalState());
        Assert.assertEquals((long)0L, (long)taImpl.taskAttemptStartedEventLogged);
        Assert.assertEquals((long)1L, (long)taImpl.taskAttemptFinishedEventLogged);
    }

    @Test
    public void testMapTaskIsBlamedImmediatelyOnLocalFetchFailure() throws ServicePluginException {
        this.testMapTaskFailingForFetchFailureType(true, true, TaskAttemptStateInternal.FAIL_IN_PROGRESS);
        this.testMapTaskFailingForFetchFailureType(true, false, TaskAttemptStateInternal.FAIL_IN_PROGRESS);
        this.testMapTaskFailingForFetchFailureType(false, true, TaskAttemptStateInternal.FAIL_IN_PROGRESS);
        this.testMapTaskFailingForFetchFailureType(false, false, TaskAttemptStateInternal.NEW);
    }

    private void testMapTaskFailingForFetchFailureType(boolean isLocalFetch, boolean isDiskErrorAtSource, TaskAttemptStateInternal expectedState) {
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((String)"1", (int)1, (int)1), (int)1), (int)1);
        MockTaskAttemptImpl sourceAttempt = new MockTaskAttemptImpl(taskID, 1, eventHandler, null, new Configuration(), (Clock)SystemClock.getInstance(), (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), this.appCtx, false, null, null, false).setNodeId(NodeId.newInstance((String)"somehost", (int)0));
        InputReadErrorEvent inputReadErrorEvent = InputReadErrorEvent.create((String)"", (int)0, (int)1, (int)1, (boolean)isLocalFetch, (boolean)isDiskErrorAtSource, null);
        TezTaskAttemptID destTaskAttemptId = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        Mockito.when((Object)destTaskAttemptId.getTaskID()).thenReturn((Object)((TezTaskID)Mockito.mock(TezTaskID.class)));
        Mockito.when((Object)destTaskAttemptId.getVertexID()).thenReturn((Object)((TezVertexID)Mockito.mock(TezVertexID.class)));
        Mockito.when((Object)this.appCtx.getCurrentDAG()).thenReturn((Object)((DAG)Mockito.mock(DAG.class)));
        Mockito.when((Object)this.appCtx.getCurrentDAG().getVertex((TezVertexID)Mockito.any(TezVertexID.class))).thenReturn((Object)((Vertex)Mockito.mock(Vertex.class)));
        Mockito.when((Object)((Vertex)Mockito.mock(Vertex.class)).getRunningTasks()).thenReturn((Object)100);
        EventMetaData mockMeta = (EventMetaData)Mockito.mock(EventMetaData.class);
        Mockito.when((Object)mockMeta.getTaskAttemptID()).thenReturn((Object)destTaskAttemptId);
        TezEvent tezEvent = new TezEvent((org.apache.tez.runtime.api.Event)inputReadErrorEvent, mockMeta);
        TaskAttemptEventOutputFailed outputFailedEvent = new TaskAttemptEventOutputFailed(sourceAttempt.getTaskAttemptID(), tezEvent, 11);
        Assert.assertEquals((Object)TaskAttemptStateInternal.NEW, (Object)sourceAttempt.getInternalState());
        TaskAttemptStateInternal resultState = new TaskAttemptImpl.OutputReportedFailedTransition().transition((TaskAttemptImpl)sourceAttempt, (TaskAttemptEvent)outputFailedEvent);
        Assert.assertEquals((Object)expectedState, (Object)resultState);
    }

    @Test
    public void testMapTaskIsBlamedByDownstreamAttemptsFromDifferentHosts() {
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((String)"1", (int)1, (int)1), (int)1), (int)1);
        MockTaskAttemptImpl sourceAttempt = new MockTaskAttemptImpl(taskID, 1, eventHandler, null, new Configuration(), (Clock)SystemClock.getInstance(), (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), this.appCtx, false, null, null, false).setNodeId(NodeId.newInstance((String)"somehost", (int)0));
        InputReadErrorEvent inputReadErrorEvent1 = InputReadErrorEvent.create((String)"", (int)0, (int)1, (int)1, (boolean)false, (boolean)false, (String)"downstream_host_1");
        InputReadErrorEvent inputReadErrorEvent2 = InputReadErrorEvent.create((String)"", (int)1, (int)1, (int)1, (boolean)false, (boolean)false, (String)"downstream_host_2");
        TezTaskAttemptID destTaskAttemptId = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)destTaskAttemptId.getTaskID()).thenReturn((Object)((TezTaskID)Mockito.mock(TezTaskID.class)));
        Mockito.when((Object)destTaskAttemptId.getTaskID().getVertexID()).thenReturn((Object)((TezVertexID)Mockito.mock(TezVertexID.class)));
        Mockito.when((Object)this.appCtx.getCurrentDAG()).thenReturn((Object)((DAG)Mockito.mock(DAG.class)));
        Mockito.when((Object)this.appCtx.getCurrentDAG().getVertex((TezVertexID)Mockito.any(TezVertexID.class))).thenReturn((Object)((Vertex)Mockito.mock(Vertex.class)));
        Mockito.when((Object)((Vertex)Mockito.mock(Vertex.class)).getRunningTasks()).thenReturn((Object)100);
        EventMetaData mockMeta = (EventMetaData)Mockito.mock(EventMetaData.class);
        Mockito.when((Object)mockMeta.getTaskAttemptID()).thenReturn((Object)destTaskAttemptId);
        sourceAttempt.handle(new TaskAttemptEvent(sourceAttempt.getTaskAttemptID(), TaskAttemptEventType.TA_DONE));
        Assert.assertEquals((Object)TaskAttemptStateInternal.SUCCEEDED, (Object)sourceAttempt.getInternalState());
        TezEvent tezEvent = new TezEvent((org.apache.tez.runtime.api.Event)inputReadErrorEvent1, mockMeta);
        TaskAttemptEventOutputFailed outputFailedEvent = new TaskAttemptEventOutputFailed(sourceAttempt.getTaskAttemptID(), tezEvent, 11);
        TaskAttemptStateInternal resultState = new TaskAttemptImpl.OutputReportedFailedTransition().transition((TaskAttemptImpl)sourceAttempt, (TaskAttemptEvent)outputFailedEvent);
        Assert.assertEquals((Object)TaskAttemptStateInternal.SUCCEEDED, (Object)resultState);
        TezEvent tezEvent2 = new TezEvent((org.apache.tez.runtime.api.Event)inputReadErrorEvent2, mockMeta);
        TaskAttemptEventOutputFailed outputFailedEvent2 = new TaskAttemptEventOutputFailed(sourceAttempt.getTaskAttemptID(), tezEvent2, 11);
        TaskAttemptStateInternal resultState2 = new TaskAttemptImpl.OutputReportedFailedTransition().transition((TaskAttemptImpl)sourceAttempt, (TaskAttemptEvent)outputFailedEvent2);
        Assert.assertEquals((Object)TaskAttemptStateInternal.FAILED, (Object)resultState2);
    }

    @Test
    public void testDAGCounterUpdateEvent() {
        TaskAttemptImpl taImpl = this.getMockTaskAttempt();
        DAGEventCounterUpdate counterUpdateSucceeded = TaskAttemptImpl.createDAGCounterUpdateEventTAFinished((TaskAttemptImpl)taImpl, (TaskAttemptState)TaskAttemptState.SUCCEEDED);
        List succeededUpdates = counterUpdateSucceeded.getCounterUpdates();
        this.assertCounterIncrementalUpdate(succeededUpdates, DAGCounter.NUM_SUCCEEDED_TASKS, 1);
        this.assertCounterIncrementalUpdate(succeededUpdates, DAGCounter.DURATION_SUCCEEDED_TASKS_MILLIS, 1000);
        this.assertCounterIncrementalUpdate(succeededUpdates, DAGCounter.WALL_CLOCK_MILLIS, 1000);
        this.assertCounterIncrementalUpdateNotFound(succeededUpdates, DAGCounter.NUM_FAILED_TASKS);
        this.assertCounterIncrementalUpdateNotFound(succeededUpdates, DAGCounter.NUM_KILLED_TASKS);
        this.assertCounterIncrementalUpdateNotFound(succeededUpdates, DAGCounter.DURATION_FAILED_TASKS_MILLIS);
        this.assertCounterIncrementalUpdateNotFound(succeededUpdates, DAGCounter.DURATION_KILLED_TASKS_MILLIS);
        DAGEventCounterUpdate counterUpdateFailed = TaskAttemptImpl.createDAGCounterUpdateEventTAFinished((TaskAttemptImpl)taImpl, (TaskAttemptState)TaskAttemptState.FAILED);
        List failedUpdates = counterUpdateFailed.getCounterUpdates();
        this.assertCounterIncrementalUpdate(failedUpdates, DAGCounter.NUM_FAILED_TASKS, 1);
        this.assertCounterIncrementalUpdate(failedUpdates, DAGCounter.DURATION_FAILED_TASKS_MILLIS, 1000);
        this.assertCounterIncrementalUpdate(failedUpdates, DAGCounter.WALL_CLOCK_MILLIS, 1000);
        this.assertCounterIncrementalUpdateNotFound(failedUpdates, DAGCounter.NUM_SUCCEEDED_TASKS);
        this.assertCounterIncrementalUpdateNotFound(failedUpdates, DAGCounter.NUM_KILLED_TASKS);
        this.assertCounterIncrementalUpdateNotFound(failedUpdates, DAGCounter.DURATION_KILLED_TASKS_MILLIS);
        this.assertCounterIncrementalUpdateNotFound(failedUpdates, DAGCounter.DURATION_SUCCEEDED_TASKS_MILLIS);
        DAGEventCounterUpdate counterUpdateKilled = TaskAttemptImpl.createDAGCounterUpdateEventTAFinished((TaskAttemptImpl)taImpl, (TaskAttemptState)TaskAttemptState.KILLED);
        List killedUpdates = counterUpdateKilled.getCounterUpdates();
        this.assertCounterIncrementalUpdate(killedUpdates, DAGCounter.NUM_KILLED_TASKS, 1);
        this.assertCounterIncrementalUpdate(killedUpdates, DAGCounter.DURATION_KILLED_TASKS_MILLIS, 1000);
        this.assertCounterIncrementalUpdate(killedUpdates, DAGCounter.WALL_CLOCK_MILLIS, 1000);
        this.assertCounterIncrementalUpdateNotFound(killedUpdates, DAGCounter.NUM_SUCCEEDED_TASKS);
        this.assertCounterIncrementalUpdateNotFound(killedUpdates, DAGCounter.NUM_FAILED_TASKS);
        this.assertCounterIncrementalUpdateNotFound(killedUpdates, DAGCounter.DURATION_FAILED_TASKS_MILLIS);
        this.assertCounterIncrementalUpdateNotFound(failedUpdates, DAGCounter.DURATION_SUCCEEDED_TASKS_MILLIS);
    }

    private TaskAttemptImpl getMockTaskAttempt() {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        return new MockTaskAttemptImpl(taskID, 1, (EventHandler)Mockito.mock(EventHandler.class), (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), new Configuration(), (Clock)new MonotonicClock(), (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), (AppContext)Mockito.mock(AppContext.class), false, (Resource)Mockito.mock(Resource.class), (ContainerContext)Mockito.mock(ContainerContext.class), false);
    }

    private void assertCounterIncrementalUpdate(List<DAGEventCounterUpdate.CounterIncrementalUpdate> counterUpdates, DAGCounter counter, int expectedValue) {
        for (DAGEventCounterUpdate.CounterIncrementalUpdate update : counterUpdates) {
            if (!update.getCounterKey().equals(counter) || update.getIncrementValue() != (long)expectedValue) continue;
            return;
        }
        Assert.fail((String)String.format("Haven't found counter update %s=%d, instead seen: %s", counter, expectedValue, counterUpdates));
    }

    private void assertCounterIncrementalUpdateNotFound(List<DAGEventCounterUpdate.CounterIncrementalUpdate> counterUpdates, DAGCounter counter) {
        for (DAGEventCounterUpdate.CounterIncrementalUpdate update : counterUpdates) {
            if (!update.getCounterKey().equals(counter)) continue;
            Assert.fail((String)String.format("Found counter update %s=%d, which is not expected", counter, update.getIncrementValue()));
        }
    }

    private Event verifyEventType(List<Event> events, Class<? extends Event> eventClass, int expectedOccurences) {
        int count = 0;
        Event ret = null;
        for (Event e : events) {
            if (!eventClass.isInstance(e)) continue;
            ++count;
            ret = e;
        }
        Assert.assertEquals((String)("Mismatch in num occurences of event: " + eventClass.getCanonicalName()), (long)expectedOccurences, (long)count);
        return ret;
    }

    private static ContainerContext createFakeContainerContext() {
        return new ContainerContext(new HashMap(), new Credentials(), new HashMap(), "");
    }

    private TaskCommunicatorManagerInterface createMockTaskAttemptListener() throws ServicePluginException {
        TaskCommunicatorManagerInterface taListener = (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class);
        TaskCommunicator taskComm = (TaskCommunicator)Mockito.mock(TaskCommunicator.class);
        ((TaskCommunicator)Mockito.doReturn((Object)new InetSocketAddress("localhost", 0)).when((Object)taskComm)).getAddress();
        ((TaskCommunicatorManagerInterface)Mockito.doReturn((Object)new TaskCommunicatorWrapper(taskComm)).when((Object)taListener)).getTaskCommunicator(0);
        return taListener;
    }

    private class MockTaskAttemptImpl
    extends TaskAttemptImpl {
        public int taskAttemptStartedEventLogged;
        public int taskAttemptFinishedEventLogged;
        boolean inputFailedReported;

        public MockTaskAttemptImpl(TezTaskID taskId, int attemptNumber, EventHandler eventHandler, TaskCommunicatorManagerInterface tal, Configuration conf, Clock clock, TaskHeartbeatHandler taskHeartbeatHandler, AppContext appContext, boolean isRescheduled, Resource resource, ContainerContext containerContext, boolean leafVertex) {
            super(TezBuilderUtils.newTaskAttemptId((TezTaskID)taskId, (int)attemptNumber), eventHandler, tal, conf, clock, taskHeartbeatHandler, appContext, isRescheduled, resource, containerContext, leafVertex, TestTaskAttempt.this.mockTask, TestTaskAttempt.this.locationHint, null, null);
            this.taskAttemptStartedEventLogged = 0;
            this.taskAttemptFinishedEventLogged = 0;
            this.inputFailedReported = false;
        }

        public MockTaskAttemptImpl setNodeId(NodeId nodeId) {
            this.container = new TezContainer(Container.newInstance(null, (NodeId)nodeId, null, null, null, null));
            return this;
        }

        protected Vertex getVertex() {
            return TestTaskAttempt.this.mockVertex;
        }

        protected void logJobHistoryAttemptStarted() {
            ++this.taskAttemptStartedEventLogged;
            super.logJobHistoryAttemptStarted();
        }

        protected void logJobHistoryAttemptFinishedEvent(TaskAttemptStateInternal state) {
            ++this.taskAttemptFinishedEventLogged;
            super.logJobHistoryAttemptFinishedEvent(state);
        }

        protected void logJobHistoryAttemptUnsuccesfulCompletion(TaskAttemptState state, TaskFailureType taskFailureType) {
            ++this.taskAttemptFinishedEventLogged;
            super.logJobHistoryAttemptUnsuccesfulCompletion(state, taskFailureType);
        }

        protected void sendInputFailedToConsumers() {
            this.inputFailedReported = true;
        }

        public long getDurationNs() {
            return 1000000000L;
        }
    }

    public static class MockEventHandler
    implements EventHandler {
        public boolean internalError;

        public void handle(Event event) {
            DAGEvent je;
            if (event instanceof DAGEvent && DAGEventType.INTERNAL_ERROR == (je = (DAGEvent)event).getType()) {
                this.internalError = true;
            }
        }
    }

    public static class StubbedFS
    extends RawLocalFileSystem {
        public FileStatus getFileStatus(Path f) throws IOException {
            return new FileStatus(1L, false, 1, 1L, 1L, f);
        }
    }
}

